/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ClasspathComputer;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.SourceLocationManager;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.bundle.WorkspaceBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.imports.OverwriteProjectsSelectionDialog;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportHelper;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.ScmUrlImportDescription;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.importing.provisional.IBundleImporter;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;
import org.osgi.framework.BundleException;

public class PluginImportOperation
extends WorkspaceJob {
    public static final int IMPORT_BINARY = 1;
    public static final int IMPORT_BINARY_WITH_LINKS = 2;
    public static final int IMPORT_WITH_SOURCE = 3;
    public static final int IMPORT_FROM_REPOSITORY = 4;
    private static final String DEFAULT_SOURCE_DIR = "src";
    private static final String DEFAULT_LIBRARY_NAME = ".";
    private IPluginModelBase[] fModels;
    private int fImportType;
    private Hashtable<IProject, IClasspathEntry[]> fProjectClasspaths = new Hashtable();
    private Map<String, List<IWorkingSet>> fProjectWorkingSets = new HashMap<String, List<IWorkingSet>>();
    private boolean fForceAutobuild;
    private Map<IBundleImporter, ScmUrlImportDescription[]> fImportDescriptions;
    private SourceLocationManager fAlternateSource;
    private boolean fPluginsAreInUse = false;

    public PluginImportOperation(IPluginModelBase[] models, int importType, boolean forceAutobuild) {
        super(PDEUIMessages.ImportWizard_title);
        this.fModels = models;
        this.fImportType = importType;
        this.fForceAutobuild = forceAutobuild;
    }

    public void setPluginsInUse(boolean pluginsInUse) {
        this.fPluginsAreInUse = pluginsInUse;
    }

    public void setAlternateSource(SourceLocationManager alternate) {
        this.fAlternateSource = alternate;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("", this.fModels.length + 5);
            MultiStatus multiStatus = new MultiStatus(PDEPlugin.getPluginId(), 0, PDEUIMessages.ImportWizard_operation_multiProblem, null);
            this.deleteConflictingProjects(multiStatus, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            if (this.fImportType == 4) {
                final ArrayList<String> namesOfNotImportedProjects = new ArrayList<String>();
                for (Map.Entry<IBundleImporter, ScmUrlImportDescription[]> entry : this.fImportDescriptions.entrySet()) {
                    IProject[] importedProjects;
                    IBundleImporter importer = entry.getKey();
                    ScmUrlImportDescription[] descriptions = entry.getValue();
                    if (descriptions.length == 0 || (importedProjects = importer.performImport(descriptions, (IProgressMonitor)new SubProgressMonitor(monitor, descriptions.length))) != null && importedProjects.length == descriptions.length) continue;
                    ArrayList<String> namesOfImportedProjects = new ArrayList<String>(importedProjects.length);
                    int i = 0;
                    while (i < importedProjects.length) {
                        namesOfImportedProjects.add(importedProjects[i].getName());
                        ++i;
                    }
                    i = 0;
                    while (i < descriptions.length) {
                        String projectName = descriptions[i].getProject();
                        if (!namesOfImportedProjects.contains(projectName)) {
                            namesOfNotImportedProjects.add(projectName);
                        }
                        ++i;
                    }
                }
                if (namesOfNotImportedProjects.size() > 0) {
                    UIJob job = new UIJob(PDEUIMessages.PluginImportOperation_WarningDialogJob){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            String dialogMessage = namesOfNotImportedProjects.size() == 1 ? PDEUIMessages.PluginImportOperation_WarningDialogMessageSingular : PDEUIMessages.PluginImportOperation_WarningDialogMessagePlural;
                            NotImportedProjectsWarningDialog dialog = new NotImportedProjectsWarningDialog(dialogMessage, namesOfNotImportedProjects);
                            dialog.open();
                            return Status.OK_STATUS;
                        }
                    };
                    try {
                        job.schedule();
                        job.join();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } else {
                int i = 0;
                while (i < this.fModels.length) {
                    monitor.setTaskName(NLS.bind((String)PDEUIMessages.PluginImportOperation_Importing_plugin, (Object)this.fModels[i].getPluginBase().getId()));
                    try {
                        this.importPlugin(this.fModels[i], this.fImportType, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    catch (CoreException e) {
                        multiStatus.merge(e.getStatus());
                    }
                    if (monitor.isCanceled()) {
                        try {
                            this.setClasspaths((IProgressMonitor)new SubProgressMonitor(monitor, 3));
                        }
                        catch (JavaModelException javaModelException) {}
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    ++i;
                }
                monitor.setTaskName(PDEUIMessages.PluginImportOperation_Set_up_classpaths);
                try {
                    this.setClasspaths((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                catch (JavaModelException e) {
                    multiStatus.merge(e.getStatus());
                }
            }
            if (!ResourcesPlugin.getWorkspace().isAutoBuilding() && this.fForceAutobuild) {
                this.runBuildJob();
            }
            MultiStatus multiStatus2 = multiStatus;
            return multiStatus2;
        }
        finally {
            monitor.done();
        }
    }

    private void deleteConflictingProjects(MultiStatus status, IProgressMonitor monitor) {
        block22: {
            monitor.beginTask("", 5);
            try {
                String symbolicName;
                IPluginModelBase[] workspacePlugins = PluginRegistry.getWorkspaceModels();
                HashMap<String, ArrayList<IPluginModelBase>> workspacePluginMap = new HashMap<String, ArrayList<IPluginModelBase>>();
                int i = 0;
                while (i < workspacePlugins.length) {
                    IPluginModelBase plugin = workspacePlugins[i];
                    if (plugin.getBundleDescription() != null) {
                        symbolicName = plugin.getBundleDescription().getSymbolicName();
                        ArrayList<IPluginModelBase> pluginsWithSameSymbolicName = (ArrayList<IPluginModelBase>)workspacePluginMap.get(symbolicName);
                        if (pluginsWithSameSymbolicName == null) {
                            pluginsWithSameSymbolicName = new ArrayList<IPluginModelBase>();
                            workspacePluginMap.put(symbolicName, pluginsWithSameSymbolicName);
                        }
                        pluginsWithSameSymbolicName.add(plugin);
                    }
                    ++i;
                }
                monitor.worked(1);
                final ArrayList conflictingPlugins = new ArrayList();
                int i2 = 0;
                while (i2 < this.fModels.length) {
                    ArrayList plugins;
                    if (this.fModels[i2].getBundleDescription() != null && (plugins = (ArrayList)workspacePluginMap.get(symbolicName = this.fModels[i2].getBundleDescription().getSymbolicName())) != null && plugins.size() != 0 && !conflictingPlugins.containsAll(plugins)) {
                        conflictingPlugins.addAll(plugins);
                    }
                    ++i2;
                }
                monitor.worked(1);
                final ArrayList overwriteProjectList = new ArrayList();
                if (conflictingPlugins.size() > 0) {
                    UIJob job = new UIJob(PDEUIMessages.PluginImportOperation_OverwritePluginProjects){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            OverwriteProjectsSelectionDialog dialog = new OverwriteProjectsSelectionDialog(this.getDisplay().getActiveShell(), conflictingPlugins);
                            dialog.setBlockOnOpen(true);
                            if (dialog.open() == 0) {
                                overwriteProjectList.addAll(Arrays.asList(dialog.getResult()));
                                return Status.OK_STATUS;
                            }
                            return Status.CANCEL_STATUS;
                        }
                    };
                    try {
                        job.schedule();
                        job.join();
                    }
                    catch (InterruptedException interruptedException) {}
                    if (job.getResult() == null || !job.getResult().isOK()) {
                        monitor.setCanceled(true);
                        return;
                    }
                    monitor.worked(1);
                    IWorkingSetManager wsManager = PlatformUI.getWorkbench().getWorkingSetManager();
                    IWorkingSet[] sets = wsManager.getAllWorkingSets();
                    int i3 = 0;
                    while (i3 < sets.length) {
                        IAdaptable[] contents = sets[i3].getElements();
                        int j = 0;
                        while (j < contents.length) {
                            IResource resource = (IResource)contents[j].getAdapter(IResource.class);
                            if (resource instanceof IProject) {
                                String id = ((IProject)resource).getName();
                                List<IWorkingSet> workingSets = this.fProjectWorkingSets.get(id);
                                if (workingSets == null) {
                                    workingSets = new ArrayList<IWorkingSet>();
                                    this.fProjectWorkingSets.put(id, workingSets);
                                }
                                workingSets.add(sets[i3]);
                            }
                            ++j;
                        }
                        ++i3;
                    }
                    i3 = 0;
                    while (i3 < overwriteProjectList.size()) {
                        IPluginModelBase plugin = (IPluginModelBase)overwriteProjectList.get(i3);
                        monitor.setTaskName(NLS.bind((String)PDEUIMessages.PluginImportOperation_Importing_plugin, (Object)plugin.getPluginBase().getId()));
                        IProject project = plugin.getUnderlyingResource().getProject();
                        try {
                            if (RepositoryProvider.isShared((IProject)project)) {
                                RepositoryProvider.unmap((IProject)project);
                            }
                            if (!this.safeDeleteCheck(project, monitor)) {
                                status.add((IStatus)new Status(4, PDEPlugin.getPluginId(), NLS.bind((String)PDEUIMessages.PluginImportOperation_could_not_delete_project, (Object)project.getName())));
                            }
                            boolean deleteContent = project.getWorkspace().getRoot().getLocation().equals((Object)project.getLocation().removeLastSegments(1));
                            project.delete(deleteContent, true, monitor);
                        }
                        catch (CoreException ex) {
                            status.add((IStatus)new Status(4, PDEPlugin.getPluginId(), 0, NLS.bind((String)PDEUIMessages.PluginImportOperation_could_not_delete_project, (Object)project.getName()), (Throwable)ex));
                        }
                        ++i3;
                    }
                    monitor.worked(2);
                    break block22;
                }
                monitor.worked(3);
            }
            finally {
                monitor.done();
            }
        }
    }

    private void setClasspaths(IProgressMonitor monitor) throws JavaModelException {
        try {
            monitor.beginTask("", this.fProjectClasspaths.size());
            Enumeration<IProject> keys = this.fProjectClasspaths.keys();
            while (keys.hasMoreElements()) {
                IProject project = keys.nextElement();
                IClasspathEntry[] classpath = this.fProjectClasspaths.get(project);
                monitor.subTask(project.getName());
                JavaCore.create((IProject)project).setRawClasspath(classpath, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        finally {
            monitor.done();
        }
    }

    private void importPlugin(IPluginModelBase model, int importType, IProgressMonitor monitor) throws CoreException {
        try {
            File location;
            monitor.beginTask("", 5);
            IProject project = this.createProject(model, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (project == null) {
                return;
            }
            if (Platform.inDevelopmentMode() && (location = new File(model.getInstallLocation())).isDirectory()) {
                File classpathFile = new File(location, ".classpath");
                File projectFile = new File(location, ".project");
                if (classpathFile.exists() && classpathFile.isFile() && projectFile.exists() && projectFile.isFile()) {
                    PluginImportHelper.importContent(location, project.getFullPath(), (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, null, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
                    return;
                }
            }
            Map<String, IPath> sourceMap = null;
            if (importType == 1 || importType == 3 && !this.canFindSource(model)) {
                sourceMap = this.importAsBinary(project, model, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
            } else if (importType == 2) {
                sourceMap = this.importAsBinaryWithLinks(project, model, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
            } else if (importType == 3) {
                this.importAsSource(project, model, new SubProgressMonitor(monitor, 4));
            }
            this.setProjectNatures(project, model);
            if (project.hasNature("org.eclipse.jdt.core.javanature") && project.findMember(".classpath") == null) {
                this.fProjectClasspaths.put(project, ClasspathComputer.getClasspath((IProject)project, (IPluginModelBase)model, sourceMap, (boolean)true, (boolean)false));
            }
        }
        finally {
            monitor.done();
        }
    }

    private Map<String, IPath> importAsBinary(IProject project, IPluginModelBase model, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("", 4);
            File srcFile = new File(model.getInstallLocation());
            if (this.isJARd(model)) {
                PluginImportHelper.copyArchive(srcFile, project.getFile(srcFile.getName()), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                PluginImportHelper.importContent(new File(model.getInstallLocation()), project.getFullPath(), (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, null, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            Map<String, IPath> sourceMap = this.importSourceArchives(project, model, 1, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.importAdditionalSourceFiles(project, model, new SubProgressMonitor(monitor, 1));
            this.importRequiredPluginFiles(project, model, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.modifyBundleClasspathHeader(project, model);
            RepositoryProvider.map((IProject)project, (String)"org.eclipse.pde.core.BinaryRepositoryProvider");
            project.setPersistentProperty(PDECore.EXTERNAL_PROJECT_PROPERTY, "binary");
            Map<String, IPath> map = sourceMap;
            return map;
        }
        finally {
            monitor.done();
        }
    }

    private Map<String, IPath> importAsBinaryWithLinks(IProject project, IPluginModelBase model, IProgressMonitor monitor) throws CoreException {
        try {
            IFile dstFile;
            monitor.beginTask("", 3);
            File srcFile = new File(model.getInstallLocation());
            if (srcFile.isFile()) {
                dstFile = project.getFile((IPath)new Path(srcFile.getName()));
                dstFile.createLink(srcFile.toURI(), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                dstFile = project.getFolder((IPath)new Path(srcFile.getName()));
                dstFile.createLink(srcFile.toURI(), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            Map<String, IPath> sourceMap = this.importSourceArchives(project, model, 2, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.importAdditionalSourceFiles(project, model, new SubProgressMonitor(monitor, 1));
            this.importRequiredPluginFiles(project, model, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.modifyBundleClasspathHeader(project, model);
            RepositoryProvider.map((IProject)project, (String)"org.eclipse.pde.core.BinaryRepositoryProvider");
            project.setPersistentProperty(PDECore.EXTERNAL_PROJECT_PROPERTY, "binary");
            Map<String, IPath> map = sourceMap;
            return map;
        }
        finally {
            monitor.done();
        }
    }

    private void importAsSource(IProject project, IPluginModelBase model, SubProgressMonitor monitor) throws CoreException {
        try {
            try {
                monitor.beginTask("", 4);
                WorkspaceBuildModel buildModel = new WorkspaceBuildModel(PDEProject.getBuildProperties((IProject)project));
                HashMap<IPath, IPath> packageLocations = new HashMap<IPath, IPath>();
                boolean sourceFound = this.extractSourceFolders(project, model, buildModel, packageLocations, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, 1));
                if (!sourceFound) {
                    sourceFound = this.handleInternalSource(model, buildModel, packageLocations);
                }
                this.importAdditionalSourceFiles(project, model, new SubProgressMonitor((IProgressMonitor)monitor, 1));
                if (this.isJARd(model)) {
                    ZipFile zip = null;
                    try {
                        zip = new ZipFile(new File(model.getInstallLocation()));
                        ZipFileStructureProvider provider = new ZipFileStructureProvider(zip);
                        HashMap<IPath, List<Object>> collected = new HashMap<IPath, List<Object>>();
                        PluginImportHelper.collectBinaryFiles((IImportStructureProvider)provider, provider.getRoot(), packageLocations, collected);
                        for (IPath currentDestination : collected.keySet()) {
                            IPath destination = project.getFullPath();
                            destination = destination.append(currentDestination);
                            PluginImportHelper.importContent(provider.getRoot(), destination, (IImportStructureProvider)provider, (List)collected.get(currentDestination), (IProgressMonitor)new NullProgressMonitor());
                        }
                    }
                    finally {
                        if (zip != null) {
                            zip.close();
                        }
                    }
                    monitor.worked(1);
                } else {
                    HashMap<IPath, List<Object>> collected = new HashMap<IPath, List<Object>>();
                    File srcFile = new File(model.getInstallLocation());
                    PluginImportHelper.collectBinaryFiles((IImportStructureProvider)FileSystemStructureProvider.INSTANCE, srcFile, packageLocations, collected);
                    for (IPath currentDestination : collected.keySet()) {
                        IPath destination = project.getFullPath();
                        destination = destination.append(currentDestination);
                        PluginImportHelper.importContent(srcFile, destination, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, (List)collected.get(currentDestination), (IProgressMonitor)new NullProgressMonitor());
                    }
                    monitor.worked(1);
                }
                if (!PDEProject.getBuildProperties((IProject)project).exists()) {
                    this.configureBinIncludes(buildModel, model, project);
                    buildModel.save();
                }
                monitor.worked(1);
            }
            catch (ZipException e) {
                Status status = new Status(4, PDEPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
            catch (IOException e) {
                Status status = new Status(4, PDEPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        finally {
            monitor.done();
        }
    }

    private IProject createProject(IPluginModelBase model, IProgressMonitor monitor) throws TeamException, CoreException {
        try {
            List<IWorkingSet> workingSets;
            monitor.beginTask("", 2);
            IProject project = this.findProject(model.getPluginBase().getId());
            if ((project.exists() || new File(project.getParent().getLocation().toFile(), project.getName()).exists()) && (project = PDEPlugin.getWorkspace().getRoot().getProject(model.getPluginBase().getId())).exists()) {
                File installLocation = new File(model.getInstallLocation());
                String projectName = installLocation.getName();
                int jarIndex = projectName.toLowerCase().lastIndexOf(".jar");
                if (jarIndex >= 0) {
                    projectName = projectName.substring(0, jarIndex);
                }
                project = PDEPlugin.getWorkspace().getRoot().getProject(projectName);
                int index = 0;
                while (project.exists()) {
                    project = PDEPlugin.getWorkspace().getRoot().getProject(String.valueOf(projectName) + '_' + ++index);
                }
            }
            project.create(monitor);
            if (!project.isOpen()) {
                project.open(monitor);
            }
            if ((workingSets = this.fProjectWorkingSets.get(project.getName())) != null) {
                for (IWorkingSet ws : workingSets) {
                    IProject newElement = project;
                    IAdaptable[] projectAdaptables = ws.adaptElements(new IAdaptable[]{project});
                    if (projectAdaptables.length > 0) {
                        newElement = projectAdaptables[0];
                    }
                    IAdaptable[] currentElements = ws.getElements();
                    IAdaptable[] newElements = new IAdaptable[currentElements.length + 1];
                    System.arraycopy(currentElements, 0, newElements, 0, currentElements.length);
                    newElements[currentElements.length] = newElement;
                    ws.setElements(newElements);
                }
            }
            monitor.worked(1);
            IProject iProject = project;
            return iProject;
        }
        finally {
            monitor.done();
        }
    }

    private IProject findProject(String id) {
        IResource resource;
        IPluginModelBase model = PluginRegistry.findModel((String)id);
        if (model != null && (resource = model.getUnderlyingResource()) != null && resource.exists()) {
            return resource.getProject();
        }
        return PDEPlugin.getWorkspace().getRoot().getProject(id);
    }

    private boolean safeDeleteCheck(IProject project, IProgressMonitor monitor) {
        if (!this.fPluginsAreInUse) {
            return true;
        }
        IPluginModelBase base = PluginRegistry.findModel((IProject)project);
        if (base != null) {
            IPluginLibrary[] libraries = base.getPluginBase().getLibraries();
            int i = 0;
            while (i < libraries.length) {
                IResource res = project.findMember(libraries[i].getName());
                if (res != null) {
                    try {
                        if (!ResourcesPlugin.getWorkspace().delete(new IResource[]{res}, true, monitor).isOK()) {
                            return false;
                        }
                    }
                    catch (CoreException coreException) {
                        return false;
                    }
                }
                ++i;
            }
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    private boolean canFindSource(IPluginModelBase model) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 13[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private SourceLocationManager getSourceManager(IPluginModelBase model) {
        SourceLocationManager manager;
        if (this.fAlternateSource != null) {
            if (this.fAlternateSource.hasBundleManifestLocation(model.getPluginBase())) {
                return this.fAlternateSource;
            }
            String[] libraries = this.getLibraryNames(model);
            int i = 0;
            while (i < libraries.length) {
                String zipName = ClasspathUtilCore.getSourceZipName((String)libraries[i]);
                IPath srcPath = this.fAlternateSource.findSourcePath(model.getPluginBase(), (IPath)new Path(zipName));
                if (srcPath != null) {
                    return this.fAlternateSource;
                }
                ++i;
            }
        }
        if ((manager = PDECore.getDefault().getSourceLocationManager()).hasBundleManifestLocation(model.getPluginBase())) {
            return manager;
        }
        String[] libraries = this.getLibraryNames(model);
        int i = 0;
        while (i < libraries.length) {
            String zipName = ClasspathUtilCore.getSourceZipName((String)libraries[i]);
            IPath srcPath = manager.findSourcePath(model.getPluginBase(), (IPath)new Path(zipName));
            if (srcPath != null) {
                return manager;
            }
            ++i;
        }
        return null;
    }

    private void runBuildJob() {
        Job buildJob = new Job(PDEUIMessages.CompilersConfigurationBlock_building){

            public boolean belongsTo(Object family) {
                return ResourcesPlugin.FAMILY_AUTO_BUILD == family;
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    PDEPlugin.getWorkspace().build(10, monitor);
                }
                catch (CoreException coreException) {}
                return Status.OK_STATUS;
            }
        };
        buildJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        buildJob.schedule();
    }

    private Map<String, IPath> importSourceArchives(IProject project, IPluginModelBase model, int mode, IProgressMonitor monitor) throws CoreException {
        String[] libraries = this.getLibraryNames(model);
        try {
            monitor.beginTask(PDEUIMessages.ImportWizard_operation_importingSource, libraries.length);
            HashMap<String, IPath> sourceMap = new HashMap<String, IPath>(libraries.length);
            SourceLocationManager manager = this.getSourceManager(model);
            if (manager != null) {
                int i = 0;
                while (i < libraries.length) {
                    String zipName = ClasspathUtilCore.getSourceZipName((String)libraries[i]);
                    IPluginBase pluginBase = model.getPluginBase();
                    IPath srcPath = manager.findSourcePath(pluginBase, (IPath)new Path(zipName));
                    if (srcPath != null) {
                        zipName = srcPath.lastSegment();
                        Path dstPath = new Path(zipName);
                        sourceMap.put(libraries[i], (IPath)dstPath);
                        if (project.findMember((IPath)dstPath) == null) {
                            if (mode == 1) {
                                PluginImportHelper.copyArchive(new File(srcPath.toOSString()), project.getFile((IPath)dstPath), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            } else if (mode == 2) {
                                IFile dstFile = project.getFile((IPath)dstPath);
                                dstFile.createLink(srcPath, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            }
                        }
                    }
                    ++i;
                }
            }
            HashMap<String, IPath> hashMap = sourceMap;
            return hashMap;
        }
        finally {
            monitor.done();
        }
    }

    private boolean extractSourceFolders(IProject project, IPluginModelBase model, WorkspaceBuildModel buildModel, Map<IPath, IPath> packageLocations, IProgressMonitor monitor) throws CoreException {
        try {
            String[] libraries = this.getLibraryNames(model);
            monitor.beginTask(PDEUIMessages.ImportWizard_operation_importingSource, libraries.length);
            SourceLocationManager manager = this.getSourceManager(model);
            if (manager != null) {
                if (manager.hasBundleManifestLocation(model.getPluginBase())) {
                    File srcFile = manager.findSourcePlugin(model.getPluginBase());
                    Set sourceRoots = manager.findSourceRoots(model.getPluginBase());
                    int i = 0;
                    while (i < libraries.length) {
                        Path sourceDir;
                        if (libraries[i].equals(DEFAULT_LIBRARY_NAME)) {
                            IFolder destination = project.getFolder(DEFAULT_SOURCE_DIR);
                            if (!destination.exists()) {
                                ArrayList<IPath> excludeFolders = new ArrayList<IPath>(sourceRoots.size());
                                for (String root : sourceRoots) {
                                    if (root.equals(DEFAULT_LIBRARY_NAME)) continue;
                                    excludeFolders.add((IPath)new Path(root));
                                }
                                HashSet<IPath> collectedPackages = new HashSet<IPath>();
                                PluginImportHelper.extractJavaSourceFromArchive(srcFile, excludeFolders, destination.getFullPath(), collectedPackages, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                this.addBuildEntry(buildModel, "source..", "src/");
                                this.addPackageEntries(collectedPackages, (IPath)new Path(DEFAULT_SOURCE_DIR), packageLocations);
                            }
                        } else if (sourceRoots.contains(this.getSourceDirName(libraries[i])) && !project.getFolder((IPath)(sourceDir = new Path(this.getSourceDirName(libraries[i])))).exists()) {
                            HashSet<IPath> collectedPackages = new HashSet<IPath>();
                            PluginImportHelper.extractFolderFromArchive(srcFile, (IPath)sourceDir, project.getFullPath(), collectedPackages, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            this.addBuildEntry(buildModel, "source." + libraries[i], sourceDir.toString());
                            this.addPackageEntries(collectedPackages, (IPath)sourceDir, packageLocations);
                        }
                        ++i;
                    }
                    return true;
                }
                boolean sourceFound = false;
                int i = 0;
                while (i < libraries.length) {
                    String zipName = ClasspathUtilCore.getSourceZipName((String)libraries[i]);
                    IPath srcPath = manager.findSourcePath(model.getPluginBase(), (IPath)new Path(zipName));
                    if (srcPath != null) {
                        sourceFound = true;
                        Path dstPath = new Path(this.getSourceDirName(libraries[i]));
                        IFolder destination = project.getFolder((IPath)dstPath);
                        if (!destination.exists()) {
                            HashSet<IPath> collectedPackages = new HashSet<IPath>();
                            PluginImportHelper.extractArchive(new File(srcPath.toOSString()), destination.getFullPath(), collectedPackages, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            this.addBuildEntry(buildModel, "source." + libraries[i], dstPath.toString());
                            this.addPackageEntries(collectedPackages, (IPath)dstPath, packageLocations);
                        }
                    }
                    ++i;
                }
                boolean bl = sourceFound;
                return bl;
            }
        }
        finally {
            monitor.done();
        }
        return false;
    }

    private boolean handleInternalSource(IPluginModelBase model, WorkspaceBuildModel buildModel, Map<IPath, IPath> packageLocations) throws CoreException, ZipException, IOException {
        Path defaultSourcePath = new Path(DEFAULT_SOURCE_DIR);
        ZipFile zip = null;
        try {
            IPath prefixPath;
            Object root;
            FileSystemStructureProvider provider;
            if (this.isJARd(model)) {
                zip = new ZipFile(new File(model.getInstallLocation()));
                provider = new ZipFileStructureProvider(zip);
                root = ((ZipFileStructureProvider)provider).getRoot();
                prefixPath = defaultSourcePath;
            } else {
                provider = FileSystemStructureProvider.INSTANCE;
                File rootFile = new File(model.getInstallLocation());
                root = rootFile;
                prefixPath = new Path(rootFile.getPath()).append((IPath)defaultSourcePath);
            }
            ArrayList<Object> collected = new ArrayList<Object>();
            PluginImportHelper.collectResourcesFromFolder((IImportStructureProvider)provider, root, (IPath)defaultSourcePath, collected);
            if (collected.size() > 0) {
                HashSet<IPath> packages = new HashSet<IPath>();
                PluginImportHelper.collectJavaPackages((IImportStructureProvider)provider, collected, prefixPath, packages);
                this.addPackageEntries(packages, (IPath)defaultSourcePath, packageLocations);
                this.addBuildEntry(buildModel, "source..", "src/");
                return true;
            }
            return false;
        }
        finally {
            if (zip != null) {
                zip.close();
            }
        }
    }

    private void addPackageEntries(Set<IPath> packages, IPath destination, Map<IPath, IPath> packageLocations) {
        block0: for (IPath currentPackage : packages) {
            packageLocations.put(currentPackage, destination);
            while (currentPackage.segmentCount() > 1) {
                if (packageLocations.containsKey(currentPackage = currentPackage.removeLastSegments(1))) continue block0;
                packageLocations.put(currentPackage, destination);
            }
        }
    }

    private void importAdditionalSourceFiles(IProject project, IPluginModelBase model, SubProgressMonitor monitor) throws CoreException {
        File sourceLocation;
        SourceLocationManager manager = this.getSourceManager(model);
        if (manager != null && (sourceLocation = manager.findSourcePlugin(model.getPluginBase())) != null) {
            if (sourceLocation.isFile()) {
                ZipFile zip = null;
                try {
                    try {
                        zip = new ZipFile(sourceLocation);
                        ZipFileStructureProvider provider = new ZipFileStructureProvider(zip);
                        ArrayList<Object> collected = new ArrayList<Object>();
                        PluginImportHelper.collectNonJavaNonBuildFiles((IImportStructureProvider)provider, provider.getRoot(), collected);
                        PluginImportHelper.importContent(provider.getRoot(), project.getFullPath(), (IImportStructureProvider)provider, collected, (IProgressMonitor)monitor);
                    }
                    catch (IOException e) {
                        Status status = new Status(4, PDEPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
                        throw new CoreException((IStatus)status);
                    }
                }
                catch (Throwable throwable) {
                    if (zip != null) {
                        try {
                            zip.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (zip != null) {
                    try {
                        zip.close();
                    }
                    catch (IOException iOException) {}
                }
            } else {
                ArrayList<Object> collected = new ArrayList<Object>();
                PluginImportHelper.collectNonJavaNonBuildFiles((IImportStructureProvider)FileSystemStructureProvider.INSTANCE, sourceLocation, collected);
                PluginImportHelper.importContent(sourceLocation, project.getFullPath(), (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, collected, (IProgressMonitor)monitor);
            }
        }
    }

    private void importRequiredPluginFiles(IProject project, IPluginModelBase model, IProgressMonitor monitor) throws CoreException {
        if (this.isJARd(model)) {
            ZipFile zip = null;
            try {
                try {
                    zip = new ZipFile(new File(model.getInstallLocation()));
                    ZipFileStructureProvider provider = new ZipFileStructureProvider(zip);
                    ArrayList<Object> collected = new ArrayList<Object>();
                    PluginImportHelper.collectRequiredBundleFiles((IImportStructureProvider)provider, provider.getRoot(), collected);
                    PluginImportHelper.importContent(provider.getRoot(), project.getFullPath(), (IImportStructureProvider)provider, collected, monitor);
                }
                catch (IOException e) {
                    Status status = new Status(4, PDEPlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
                    throw new CoreException((IStatus)status);
                }
            }
            catch (Throwable throwable) {
                if (zip != null) {
                    try {
                        zip.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException iOException) {}
            }
        } else {
            ArrayList<Object> collected = new ArrayList<Object>();
            File file = new File(model.getInstallLocation());
            PluginImportHelper.collectRequiredBundleFiles((IImportStructureProvider)FileSystemStructureProvider.INSTANCE, file, collected);
            PluginImportHelper.importContent(file, project.getFullPath(), (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, collected, monitor);
        }
    }

    private String addBuildEntry(WorkspaceBuildModel model, String key, String value) throws CoreException {
        String[] tokens;
        IBuild build = model.getBuild(true);
        IBuildEntry entry = build.getEntry(key);
        if (entry == null) {
            entry = model.getFactory().createEntry(key);
            entry.addToken(value);
            build.add(entry);
        }
        return (tokens = entry.getTokens()).length > 0 ? tokens[0] : "src/";
    }

    private void configureBinIncludes(WorkspaceBuildModel buildModel, IPluginModelBase model, IProject project) throws CoreException {
        IBuild build = buildModel.getBuild(true);
        IBuildEntry entry = build.getEntry("bin.includes");
        HashMap<String, String> libraryDirs = this.getSourceDirectories(build);
        if (entry == null) {
            entry = buildModel.getFactory().createEntry("bin.includes");
            File location = new File(model.getInstallLocation());
            if (location.isDirectory()) {
                File[] files = location.listFiles();
                int i = 0;
                while (i < files.length) {
                    String token = files[i].getName();
                    if (project.findMember(token) != null || build.getEntry("source." + token) != null) {
                        if (files[i].isDirectory() && libraryDirs.containsKey(token = String.valueOf(token) + "/")) {
                            token = libraryDirs.get(token).toString();
                        }
                        entry.addToken(token);
                    }
                    ++i;
                }
            } else {
                String[] tokens = PluginImportHelper.getTopLevelResources(location);
                int i = 0;
                while (i < tokens.length) {
                    IResource res = project.findMember(tokens[i]);
                    if (!(res == null && build.getEntry("source." + tokens[i]) == null || res instanceof IFolder && libraryDirs.containsKey(tokens[i]))) {
                        entry.addToken(tokens[i]);
                    }
                    ++i;
                }
            }
            buildModel.getBuild().add(entry);
        }
    }

    private HashMap<String, String> getSourceDirectories(IBuild build) {
        HashMap<String, String> set = new HashMap<String, String>();
        IBuildEntry[] entries = build.getBuildEntries();
        int i = 0;
        while (i < entries.length) {
            String name = entries[i].getName();
            if (name.startsWith("source.")) {
                name = name.substring(7);
                String[] tokens = entries[i].getTokens();
                int j = 0;
                while (j < tokens.length) {
                    set.put(tokens[j], name);
                    ++j;
                }
            }
            ++i;
        }
        return set;
    }

    private void modifyBundleClasspathHeader(IProject project, IPluginModelBase base) {
        IFile file = PDEProject.getManifest((IProject)project);
        if (file.exists()) {
            WorkspaceBundleModel bmodel = new WorkspaceBundleModel(file);
            IBundle bundle = bmodel.getBundle();
            String classpath = bundle.getHeader("Bundle-ClassPath");
            if (classpath == null) {
                bundle.setHeader("Bundle-ClassPath", ClasspathUtilCore.getFilename((IPluginModelBase)base));
            } else {
                try {
                    ManifestElement[] elements = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)classpath);
                    StringBuffer buffer = new StringBuffer();
                    int i = 0;
                    while (i < elements.length) {
                        if (buffer.length() > 0) {
                            buffer.append(",");
                            buffer.append(System.getProperty("line.separator"));
                            buffer.append(" ");
                        }
                        if (elements[i].getValue().equals(DEFAULT_LIBRARY_NAME)) {
                            buffer.append(ClasspathUtilCore.getFilename((IPluginModelBase)base));
                        } else {
                            buffer.append(elements[i].getValue());
                        }
                        ++i;
                    }
                    bundle.setHeader("Bundle-ClassPath", buffer.toString());
                }
                catch (BundleException bundleException) {}
            }
            bmodel.save();
        }
    }

    private boolean needsJavaNature(IProject project, IPluginModelBase model) {
        IFile buildProperties;
        if (model.getPluginBase().getLibraries().length > 0) {
            return true;
        }
        BundleDescription desc = model.getBundleDescription();
        if (desc != null) {
            if (desc.getExecutionEnvironments().length > 0) {
                return true;
            }
            if (desc.getExportPackages().length > 0) {
                return true;
            }
        }
        if ((buildProperties = PDEProject.getBuildProperties((IProject)project)).exists()) {
            IBuildEntry buildEntry;
            WorkspaceBuildModel buildModel = new WorkspaceBuildModel(buildProperties);
            buildModel.load();
            IBuild build = buildModel.getBuild();
            if (build != null && (buildEntry = build.getEntry("source..")) != null) {
                return true;
            }
        }
        return false;
    }

    private void setProjectNatures(IProject project, IPluginModelBase model) throws CoreException {
        IProjectDescription desc = project.getDescription();
        if (!desc.hasNature("org.eclipse.pde.PluginNature")) {
            CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.pde.PluginNature", null);
        }
        if (!desc.hasNature("org.eclipse.jdt.core.javanature") && this.needsJavaNature(project, model)) {
            CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.jdt.core.javanature", null);
        }
    }

    private String[] getLibraryNames(IPluginModelBase model) {
        IPluginLibrary[] libraries = model.getPluginBase().getLibraries();
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < libraries.length) {
            list.add(ClasspathUtilCore.expandLibraryName((String)libraries[i].getName()));
            ++i;
        }
        if (libraries.length == 0 && this.isJARd(model)) {
            list.add(DEFAULT_LIBRARY_NAME);
        }
        return list.toArray(new String[list.size()]);
    }

    private String getSourceDirName(String libraryName) {
        int dot = libraryName.lastIndexOf(46);
        return dot != -1 ? String.valueOf(libraryName.substring(0, dot)) + DEFAULT_SOURCE_DIR : libraryName;
    }

    private boolean isJARd(IPluginModelBase model) {
        return new File(model.getInstallLocation()).isFile();
    }

    public void setImportDescriptions(Map<IBundleImporter, ScmUrlImportDescription[]> descriptions) {
        this.fImportDescriptions = descriptions;
    }

    private class NotImportedProjectsWarningDialog
    extends MessageDialog {
        private List<String> fNamesOfNotImportedProjects;

        public NotImportedProjectsWarningDialog(String warningMessage, List<String> namesOfNotImportedProjects) {
            super(PlatformUI.getWorkbench().getModalDialogShellProvider().getShell(), PDEUIMessages.ImportWizard_title, null, warningMessage, 4, new String[]{IDialogConstants.OK_LABEL}, 0);
            this.fNamesOfNotImportedProjects = namesOfNotImportedProjects;
        }

        protected Control createCustomArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(1808));
            Text projectText = new Text(parent, 2824);
            projectText.setBackground(parent.getDisplay().getSystemColor(22));
            GridData gd = new GridData(768);
            gd.widthHint = this.convertWidthInCharsToPixels(60);
            gd.heightHint = this.convertHeightInCharsToPixels(10);
            projectText.setLayoutData((Object)gd);
            StringBuffer projectListBuffer = new StringBuffer();
            for (String project : this.fNamesOfNotImportedProjects) {
                projectListBuffer.append(project).append('\n');
            }
            projectText.setText(projectListBuffer.toString());
            return composite;
        }
    }
}

