/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.core;

import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class CheatSheetUtil {
    public static String parseElementText(Element element) {
        element.normalize();
        if (element.getChildNodes().getLength() > 0) {
            NodeList children = element.getChildNodes();
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < children.getLength()) {
                Node node = children.item(i);
                if (node.getNodeType() == 3) {
                    buffer.append(((Text)node).getData());
                } else if (node.getNodeType() == 1) {
                    String value;
                    Element subElement = (Element)node;
                    buffer.append('<');
                    buffer.append(subElement.getNodeName());
                    String elementAttributeText = CheatSheetUtil.parseElementAttributes(subElement);
                    if (elementAttributeText != null) {
                        buffer.append(elementAttributeText);
                    }
                    if ((value = CheatSheetUtil.parseElementText(subElement)).length() > 0) {
                        buffer.append('>');
                        buffer.append(value);
                        buffer.append('<');
                        buffer.append('/');
                        buffer.append(subElement.getNodeName());
                    } else {
                        buffer.append('/');
                    }
                    buffer.append('>');
                }
                ++i;
            }
            return buffer.toString();
        }
        return "";
    }

    private static String parseElementAttributes(Element element) {
        if (!element.hasAttributes()) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        NamedNodeMap attributeMap = element.getAttributes();
        int i = 0;
        while (i < attributeMap.getLength()) {
            Node node = attributeMap.item(i);
            if (node.getNodeType() == 2) {
                Attr attribute = (Attr)node;
                buffer.append(' ');
                buffer.append(attribute.getName());
                buffer.append('=');
                buffer.append('\"');
                buffer.append(attribute.getValue());
                buffer.append('\"');
            }
            ++i;
        }
        return buffer.toString();
    }
}

