/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.application;

import java.util.ArrayList;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class DelayedEventsProcessor
implements Listener {
    private ArrayList<String> filesToOpen = new ArrayList(1);

    public DelayedEventsProcessor(Display display) {
        display.addListener(46, (Listener)this);
    }

    public void handleEvent(Event event) {
        String path = event.text;
        if (path == null) {
            return;
        }
        this.filesToOpen.add(path);
    }

    public void catchUp(Display display) {
        if (this.filesToOpen.isEmpty()) {
            return;
        }
        String[] filePaths = new String[this.filesToOpen.size()];
        this.filesToOpen.toArray(filePaths);
        this.filesToOpen.clear();
        int i = 0;
        while (i < filePaths.length) {
            this.openFile(display, filePaths[i]);
            ++i;
        }
    }

    private void openFile(Display display, final String path) {
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window == null) {
                    return;
                }
                IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(path));
                IFileInfo fetchInfo = fileStore.fetchInfo();
                if (!fetchInfo.isDirectory() && fetchInfo.exists()) {
                    IWorkbenchPage page = window.getActivePage();
                    if (page == null) {
                        String msg = NLS.bind((String)IDEWorkbenchMessages.OpenDelayedFileAction_message_noWindow, (Object)path);
                        MessageDialog.open((int)1, (Shell)window.getShell(), (String)IDEWorkbenchMessages.OpenDelayedFileAction_title, (String)msg, (int)0x10000000);
                    }
                    try {
                        IDE.openInternalEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                        Shell shell = window.getShell();
                        if (shell != null) {
                            if (shell.getMinimized()) {
                                shell.setMinimized(false);
                            }
                            shell.forceActive();
                        }
                    }
                    catch (PartInitException e) {
                        String msg = NLS.bind((String)IDEWorkbenchMessages.OpenDelayedFileAction_message_errorOnOpen, (Object)fileStore.getName());
                        PartInitException eLog = new PartInitException(e.getMessage());
                        IDEWorkbenchPlugin.log((String)msg, (IStatus)new Status(4, "org.eclipse.ui.ide.application", msg, (Throwable)eLog));
                        MessageDialog.open((int)1, (Shell)window.getShell(), (String)IDEWorkbenchMessages.OpenDelayedFileAction_title, (String)msg, (int)0x10000000);
                    }
                } else {
                    String msg = NLS.bind((String)IDEWorkbenchMessages.OpenDelayedFileAction_message_fileNotFound, (Object)path);
                    MessageDialog.open((int)1, (Shell)window.getShell(), (String)IDEWorkbenchMessages.OpenDelayedFileAction_title, (String)msg, (int)0x10000000);
                }
            }
        });
    }
}

