/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.EOFException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.BaseReceivePack;
import org.eclipse.jgit.transport.HMACSHA1NonceGenerator;
import org.eclipse.jgit.transport.NonceGenerator;
import org.eclipse.jgit.transport.PacketLineIn;
import org.eclipse.jgit.transport.PushCertificate;

public class PushCertificateParser
extends PushCertificate {
    private static final String VERSION = "version ";
    private static final String PUSHER = "pusher";
    private static final String PUSHEE = "pushee";
    private static final String NONCE = "nonce";
    private String sentNonce;
    private String receivedNonce;
    private int nonceSlopLimit;
    NonceGenerator nonceGenerator;
    StringBuilder commandlistBuilder;
    private Repository db;

    PushCertificateParser(Repository into, BaseReceivePack.ReceiveConfig cfg) {
        this.nonceSlopLimit = cfg.certNonceSlopLimit;
        this.nonceGenerator = cfg.certNonceSeed != null ? new HMACSHA1NonceGenerator(cfg.certNonceSeed) : null;
        this.db = into;
    }

    public boolean enabled() {
        return this.nonceGenerator != null;
    }

    public String getAdvertiseNonce() {
        this.sentNonce = this.nonceGenerator.createNonce(this.db, TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()));
        return "push-cert=" + this.sentNonce;
    }

    private String parseNextLine(PacketLineIn pckIn, String startingWith) throws IOException {
        String s = pckIn.readString();
        if (!s.startsWith(startingWith)) {
            throw new IOException(MessageFormat.format(JGitText.get().errorInvalidPushCert, "expected " + startingWith));
        }
        return s.substring(startingWith.length());
    }

    public void receiveHeader(PacketLineIn pckIn, boolean stateless) throws IOException {
        try {
            String version = this.parseNextLine(pckIn, VERSION);
            if (!version.equals("0.1")) {
                throw new IOException(MessageFormat.format(JGitText.get().errorInvalidPushCert, "version not supported"));
            }
            this.pusher = this.parseNextLine(pckIn, PUSHER);
            this.pushee = this.parseNextLine(pckIn, PUSHEE);
            this.receivedNonce = this.parseNextLine(pckIn, NONCE);
            if (!pckIn.readString().isEmpty()) {
                throw new IOException(MessageFormat.format(JGitText.get().errorInvalidPushCert, "expected empty line after header"));
            }
        }
        catch (EOFException eof) {
            throw new IOException(MessageFormat.format(JGitText.get().errorInvalidPushCert, "broken push certificate header"));
        }
        this.nonceStatus = this.nonceGenerator.verify(this.receivedNonce, this.sentNonce, this.db, stateless, this.nonceSlopLimit);
    }

    public void receiveSignature(PacketLineIn pckIn) throws IOException {
        try {
            StringBuilder sig = new StringBuilder();
            String line = pckIn.readStringRaw();
            while (!line.equals("-----END PGP SIGNATURE-----\n")) {
                sig.append(line);
            }
            this.signature = sig.toString();
            this.commandList = this.commandlistBuilder.toString();
        }
        catch (EOFException eof) {
            throw new IOException(MessageFormat.format(JGitText.get().errorInvalidPushCert, "broken push certificate signature"));
        }
    }

    public void addCommand(String rawLine) {
        this.commandlistBuilder.append(rawLine);
    }
}

