/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.wizards.NewElementWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.util.BidiUtils;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.ide.dialogs.PathVariableSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddSourceFolderWizardPage
extends NewElementWizardPage {
    private static final String PAGE_NAME = "NewSourceFolderWizardPage";
    private final StringDialogField fRootDialogField;
    private final SelectionButtonDialogField fAddExclusionPatterns;
    private final SelectionButtonDialogField fRemoveProjectFolder;
    private final SelectionButtonDialogField fIgnoreConflicts;
    private final LinkFields fLinkFields;
    private final CPListElement fNewElement;
    private final List<CPListElement> fExistingEntries;
    private final Hashtable<CPListElement, IPath[]> fOrginalExlusionFilters;
    private final Hashtable<CPListElement, IPath[]> fOrginalInclusionFilters;
    private final Hashtable<CPListElement, IPath[]> fOrginalExlusionFiltersCopy;
    private final Hashtable<CPListElement, IPath[]> fOrginalInclusionFiltersCopy;
    private final IPath fOrginalPath;
    private final boolean fLinkedMode;
    private IPath fOutputLocation;
    private IPath fNewOutputLocation;
    private CPListElement fOldProjectSourceFolder;
    private List<CPListElement> fModifiedElements;
    private List<CPListElement> fRemovedElements;
    private final boolean fAllowConflict;
    private final boolean fAllowRemoveProjectFolder;
    private final boolean fAllowAddExclusionPatterns;
    private final boolean fCanCommitConflictingBuildpath;
    private final IContainer fParent;

    public AddSourceFolderWizardPage(CPListElement newElement, List<CPListElement> existingEntries, IPath outputLocation, boolean linkedMode, boolean canCommitConflictingBuildpath, boolean allowIgnoreConflicts, boolean allowRemoveProjectFolder, boolean allowAddExclusionPatterns, IContainer parent) {
        super(PAGE_NAME);
        this.fLinkedMode = linkedMode;
        this.fCanCommitConflictingBuildpath = canCommitConflictingBuildpath;
        this.fAllowConflict = allowIgnoreConflicts;
        this.fAllowRemoveProjectFolder = allowRemoveProjectFolder;
        this.fAllowAddExclusionPatterns = allowAddExclusionPatterns;
        this.fParent = parent;
        this.fOrginalExlusionFilters = new Hashtable();
        this.fOrginalInclusionFilters = new Hashtable();
        this.fOrginalExlusionFiltersCopy = new Hashtable();
        this.fOrginalInclusionFiltersCopy = new Hashtable();
        for (CPListElement element : existingEntries) {
            IPath[] inclusions;
            IPath[] exlusions = (IPath[])element.getAttribute("exclusion");
            if (exlusions != null) {
                IPath[] save = new IPath[exlusions.length];
                int i = 0;
                while (i < save.length) {
                    save[i] = exlusions[i];
                    ++i;
                }
                this.fOrginalExlusionFiltersCopy.put(element, save);
                this.fOrginalExlusionFilters.put(element, exlusions);
            }
            if ((inclusions = (IPath[])element.getAttribute("inclusion")) == null) continue;
            IPath[] save = new IPath[inclusions.length];
            int i = 0;
            while (i < save.length) {
                save[i] = inclusions[i];
                ++i;
            }
            this.fOrginalInclusionFiltersCopy.put(element, save);
            this.fOrginalInclusionFilters.put(element, inclusions);
        }
        this.setTitle(NewWizardMessages.NewSourceFolderWizardPage_title);
        this.fOrginalPath = newElement.getPath();
        if (this.fOrginalPath == null) {
            if (linkedMode) {
                this.setDescription(Messages.format(NewWizardMessages.NewFolderDialog_createIn, BasicElementLabels.getJavaElementName(newElement.getJavaProject().getElementName())));
            } else {
                this.setDescription(Messages.format(NewWizardMessages.AddSourceFolderWizardPage_description, BasicElementLabels.getPathLabel(this.fParent.getFullPath(), false)));
            }
        } else {
            this.setDescription(NewWizardMessages.NewSourceFolderWizardPage_edit_description);
        }
        this.fNewElement = newElement;
        this.fExistingEntries = existingEntries;
        this.fModifiedElements = new ArrayList<CPListElement>();
        this.fRemovedElements = new ArrayList<CPListElement>();
        this.fOutputLocation = outputLocation;
        RootFieldAdapter adapter = new RootFieldAdapter();
        this.fRootDialogField = new StringDialogField();
        this.fRootDialogField.setLabelText(NewWizardMessages.NewSourceFolderWizardPage_root_label);
        if (this.fNewElement.getPath() == null) {
            this.fRootDialogField.setText("");
        } else {
            this.setFolderDialogText(this.fNewElement.getPath());
        }
        this.fRootDialogField.setEnabled(this.fNewElement.getJavaProject() != null);
        int buttonStyle = 32;
        if (this.fAllowConflict && this.fAllowAddExclusionPatterns || this.fAllowConflict && this.fAllowRemoveProjectFolder || this.fAllowAddExclusionPatterns && this.fAllowRemoveProjectFolder) {
            buttonStyle = 16;
        }
        this.fAddExclusionPatterns = new SelectionButtonDialogField(buttonStyle);
        this.fAddExclusionPatterns.setLabelText(NewWizardMessages.NewSourceFolderWizardPage_exclude_label);
        this.fAddExclusionPatterns.setSelection(!this.fCanCommitConflictingBuildpath && !this.fAllowRemoveProjectFolder);
        this.fRemoveProjectFolder = new SelectionButtonDialogField(buttonStyle);
        this.fRemoveProjectFolder.setLabelText(NewWizardMessages.NewSourceFolderWizardPage_ReplaceExistingSourceFolder_label);
        this.fRemoveProjectFolder.setSelection(!this.fCanCommitConflictingBuildpath && this.fAllowRemoveProjectFolder);
        this.fIgnoreConflicts = new SelectionButtonDialogField(buttonStyle);
        this.fIgnoreConflicts.setLabelText(NewWizardMessages.AddSourceFolderWizardPage_ignoreNestingConflicts);
        this.fIgnoreConflicts.setSelection(this.fCanCommitConflictingBuildpath);
        this.fLinkFields = new LinkFields();
        if (this.fNewElement.getLinkTarget() != null) {
            this.fLinkFields.setLinkTarget(this.fNewElement.getLinkTarget());
        }
        this.fRemoveProjectFolder.setDialogFieldListener(adapter);
        this.fAddExclusionPatterns.setDialogFieldListener(adapter);
        this.fIgnoreConflicts.setDialogFieldListener(adapter);
        this.fRootDialogField.setDialogFieldListener(adapter);
        this.fLinkFields.setDialogFieldListener(adapter);
        this.packRootDialogFieldChanged();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        composite.setLayout((Layout)layout);
        if (this.fLinkedMode) {
            this.fLinkFields.doFillIntoGrid(composite, layout.numColumns);
            this.fRootDialogField.doFillIntoGrid(composite, layout.numColumns - 1);
        } else {
            this.fRootDialogField.doFillIntoGrid(composite, layout.numColumns - 1);
        }
        if (this.fAllowRemoveProjectFolder) {
            this.fRemoveProjectFolder.doFillIntoGrid(composite, layout.numColumns);
        }
        if (this.fAllowAddExclusionPatterns) {
            this.fAddExclusionPatterns.doFillIntoGrid(composite, layout.numColumns);
        }
        if (this.fAllowConflict) {
            this.fIgnoreConflicts.doFillIntoGrid(composite, layout.numColumns);
        }
        LayoutUtil.setHorizontalSpan((Control)this.fRootDialogField.getLabelControl(null), layout.numColumns);
        LayoutUtil.setHorizontalGrabbing((Control)this.fRootDialogField.getTextControl(null));
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.new_packageroot_wizard_page_context");
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fRootDialogField.setFocus();
        }
    }

    protected void packRootChangeControlPressed(DialogField field) {
        Path initialPath;
        String message;
        String title;
        IFolder folder;
        if (field == this.fRootDialogField && (folder = this.chooseFolder(title = NewWizardMessages.NewSourceFolderWizardPage_ChooseExistingRootDialog_title, message = NewWizardMessages.NewSourceFolderWizardPage_ChooseExistingRootDialog_description, (IPath)(initialPath = new Path(this.fRootDialogField.getText())))) != null) {
            this.setFolderDialogText(folder.getFullPath());
        }
    }

    private void setFolderDialogText(IPath path) {
        IPath shortPath = path.removeFirstSegments(1);
        this.fRootDialogField.setText(shortPath.toString());
    }

    protected void packRootDialogFieldChanged() {
        StatusInfo status = this.updateRootStatus();
        this.updateStatus(new IStatus[]{status});
    }

    private StatusInfo updateRootStatus() {
        IStatus linkNameStatus;
        IJavaProject javaProject = this.fNewElement.getJavaProject();
        IProject project = javaProject.getProject();
        StatusInfo pathNameStatus = AddSourceFolderWizardPage.validatePathName(this.fRootDialogField.getText(), this.fParent);
        if (!pathNameStatus.isOK()) {
            return pathNameStatus;
        }
        if (this.fLinkedMode && (linkNameStatus = this.validateLinkLocation(this.fRootDialogField.getText())).matches(4)) {
            StatusInfo result = new StatusInfo();
            result.setError(linkNameStatus.getMessage());
            return result;
        }
        StatusInfo result = new StatusInfo();
        result.setOK();
        IPath projPath = project.getFullPath();
        IPath path = this.fParent.getFullPath().append(this.fRootDialogField.getText());
        this.restoreCPElements();
        int projectEntryIndex = -1;
        boolean createFolderForExisting = false;
        IFolder folder = this.fParent.getFolder((IPath)new Path(this.fRootDialogField.getText()));
        int i = 0;
        while (i < this.fExistingEntries.size()) {
            IClasspathEntry curr = this.fExistingEntries.get(i).getClasspathEntry();
            if (curr.getEntryKind() == 3) {
                if (path.equals((Object)curr.getPath()) && this.fExistingEntries.get(i) != this.fNewElement) {
                    if (folder.exists()) {
                        result.setError(NewWizardMessages.NewSourceFolderWizardPage_error_AlreadyExisting);
                        return result;
                    }
                    createFolderForExisting = true;
                }
                if (projPath.equals((Object)curr.getPath())) {
                    projectEntryIndex = i;
                }
            }
            ++i;
        }
        if (folder.exists() && !folder.getFullPath().equals((Object)this.fOrginalPath)) {
            return new StatusInfo(4, Messages.format(NewWizardMessages.NewFolderDialog_folderNameEmpty_alreadyExists, BasicElementLabels.getPathLabel(folder.getFullPath(), false)));
        }
        boolean isProjectASourceFolder = projectEntryIndex != -1;
        this.fModifiedElements.clear();
        this.updateFilters(this.fNewElement.getPath(), path);
        this.fNewElement.setPath(path);
        if (this.fLinkedMode) {
            this.fNewElement.setLinkTarget(this.fLinkFields.getLinkTarget());
        }
        this.fRemovedElements.clear();
        HashSet<CPListElement> modified = new HashSet<CPListElement>();
        boolean isProjectSourceFolderReplaced = false;
        if (this.fAddExclusionPatterns.isSelected()) {
            if (this.fOrginalPath == null) {
                this.addExclusionPatterns(this.fNewElement, this.fExistingEntries, modified);
                this.fModifiedElements.addAll(modified);
                if (!createFolderForExisting) {
                    CPListElement.insert(this.fNewElement, this.fExistingEntries);
                }
            }
        } else if (isProjectASourceFolder) {
            if (this.fRemoveProjectFolder.isSelected()) {
                this.fOldProjectSourceFolder = this.fExistingEntries.get(projectEntryIndex);
                this.fRemovedElements.add(this.fOldProjectSourceFolder);
                this.fExistingEntries.set(projectEntryIndex, this.fNewElement);
                isProjectSourceFolderReplaced = true;
            } else if (!createFolderForExisting) {
                CPListElement.insert(this.fNewElement, this.fExistingEntries);
            }
        } else if (!createFolderForExisting) {
            CPListElement.insert(this.fNewElement, this.fExistingEntries);
        }
        if (!this.fAllowConflict && this.fCanCommitConflictingBuildpath || createFolderForExisting) {
            return new StatusInfo();
        }
        this.fNewOutputLocation = null;
        IJavaModelStatus status = JavaConventions.validateClasspath((IJavaProject)javaProject, (IClasspathEntry[])CPListElement.convertToClasspathEntries(this.fExistingEntries), (IPath)this.fOutputLocation);
        if (!status.isOK()) {
            if (this.fOutputLocation.equals((Object)projPath)) {
                this.fNewOutputLocation = projPath.append(PreferenceConstants.getPreferenceStore().getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName"));
                IJavaModelStatus status2 = JavaConventions.validateClasspath((IJavaProject)javaProject, (IClasspathEntry[])CPListElement.convertToClasspathEntries(this.fExistingEntries), (IPath)this.fNewOutputLocation);
                if (status2.isOK()) {
                    if (isProjectSourceFolderReplaced) {
                        result.setInfo(Messages.format(NewWizardMessages.NewSourceFolderWizardPage_warning_ReplaceSFandOL, BasicElementLabels.getPathLabel(this.fNewOutputLocation, false)));
                    } else {
                        result.setInfo(Messages.format(NewWizardMessages.NewSourceFolderWizardPage_warning_ReplaceOL, BasicElementLabels.getPathLabel(this.fNewOutputLocation, false)));
                    }
                    return result;
                }
            }
            this.fNewOutputLocation = null;
            if (this.fCanCommitConflictingBuildpath) {
                result.setInfo(String.valueOf(NewWizardMessages.AddSourceFolderWizardPage_conflictWarning) + status.getMessage());
            } else {
                result.setError(status.getMessage());
            }
            return result;
        }
        if (!modified.isEmpty()) {
            if (modified.size() == 1) {
                CPListElement elem = (CPListElement)modified.toArray()[0];
                String changed = BasicElementLabels.getPathLabel(elem.getPath(), false);
                String excl = BasicElementLabels.getPathLabel(this.fNewElement.getPath(), false);
                result.setInfo(Messages.format(NewWizardMessages.AddSourceFolderWizardPage_addSinglePattern, new Object[]{excl, changed}));
            } else {
                result.setInfo(Messages.format(NewWizardMessages.NewSourceFolderWizardPage_warning_AddedExclusions_plural, String.valueOf(modified.size())));
            }
            return result;
        }
        if (isProjectSourceFolderReplaced) {
            result.setInfo(NewWizardMessages.AddSourceFolderWizardPage_replaceSourceFolderInfo);
            return result;
        }
        return result;
    }

    public void restore() {
        for (CPListElement element : this.fExistingEntries) {
            if (this.fOrginalExlusionFilters.containsKey(element)) {
                element.setAttribute("exclusion", this.fOrginalExlusionFiltersCopy.get(element));
            }
            if (!this.fOrginalInclusionFilters.containsKey(element)) continue;
            element.setAttribute("inclusion", this.fOrginalInclusionFiltersCopy.get(element));
        }
        this.fNewElement.setPath(this.fOrginalPath);
    }

    private void restoreCPElements() {
        if (this.fNewElement.getPath() != null) {
            for (CPListElement element : this.fExistingEntries) {
                if (this.fOrginalExlusionFilters.containsKey(element)) {
                    element.setAttribute("exclusion", this.fOrginalExlusionFilters.get(element));
                }
                if (!this.fOrginalInclusionFilters.containsKey(element)) continue;
                element.setAttribute("inclusion", this.fOrginalInclusionFilters.get(element));
            }
            if (this.fOldProjectSourceFolder != null) {
                this.fExistingEntries.set(this.fExistingEntries.indexOf(this.fNewElement), this.fOldProjectSourceFolder);
                this.fOldProjectSourceFolder = null;
            } else if (this.fExistingEntries.contains(this.fNewElement)) {
                this.fExistingEntries.remove(this.fNewElement);
            }
        }
    }

    private void updateFilters(IPath oldPath, IPath newPath) {
        if (oldPath == null) {
            return;
        }
        IPath projPath = this.fNewElement.getJavaProject().getProject().getFullPath();
        if (projPath.isPrefixOf(oldPath)) {
            oldPath = oldPath.removeFirstSegments(projPath.segmentCount()).addTrailingSeparator();
        }
        if (projPath.isPrefixOf(newPath)) {
            newPath = newPath.removeFirstSegments(projPath.segmentCount()).addTrailingSeparator();
        }
        for (CPListElement element : this.fExistingEntries) {
            IPath[] inclusion;
            IPath[] exlusions;
            IPath elementPath = element.getPath();
            if (projPath.isPrefixOf(elementPath) && (elementPath = elementPath.removeFirstSegments(projPath.segmentCount())).segmentCount() > 0) {
                elementPath = elementPath.addTrailingSeparator();
            }
            if ((exlusions = (IPath[])element.getAttribute("exclusion")) != null) {
                int i = 0;
                while (i < exlusions.length) {
                    if (elementPath.append(exlusions[i]).equals((Object)oldPath)) {
                        this.fModifiedElements.add(element);
                        exlusions[i] = newPath.removeFirstSegments(elementPath.segmentCount());
                    }
                    ++i;
                }
                element.setAttribute("exclusion", exlusions);
            }
            if ((inclusion = (IPath[])element.getAttribute("inclusion")) == null) continue;
            int i = 0;
            while (i < inclusion.length) {
                if (elementPath.append(inclusion[i]).equals((Object)oldPath)) {
                    this.fModifiedElements.add(element);
                    inclusion[i] = newPath.removeFirstSegments(elementPath.segmentCount());
                }
                ++i;
            }
            element.setAttribute("inclusion", inclusion);
        }
    }

    private IStatus validateLinkLocation(String folderName) {
        IWorkspace workspace = JavaPlugin.getWorkspace();
        IPath path = Path.fromOSString((String)this.fLinkFields.fLinkLocation.getText());
        Path folderLocation = new Path(folderName);
        if (folderLocation.isAbsolute()) {
            return new StatusInfo(4, NewWizardMessages.AddSourceFolderWizardPage_error_NotARelativePathName);
        }
        IProject project = this.fNewElement.getJavaProject().getProject();
        IFolder folder = project.getFolder((IPath)folderLocation);
        IStatus locationStatus = workspace.validateLinkLocation((IResource)folder, path);
        if (locationStatus.matches(4)) {
            return locationStatus;
        }
        IPathVariableManager pathVariableManager = project.getPathVariableManager();
        IPath path1 = Path.fromOSString((String)this.fLinkFields.fLinkLocation.getText());
        IPath resolvedPath = pathVariableManager.resolvePath(path1);
        String resolvedLinkTarget = resolvedPath.toOSString();
        path = new Path(resolvedLinkTarget);
        File linkTargetFile = new Path(resolvedLinkTarget).toFile();
        if (linkTargetFile.exists()) {
            if (!linkTargetFile.isDirectory()) {
                return new StatusInfo(4, NewWizardMessages.NewFolderDialog_linkTargetNotFolder);
            }
        } else {
            return new StatusInfo(4, NewWizardMessages.NewFolderDialog_linkTargetNonExistent);
        }
        if (locationStatus.isOK()) {
            return new StatusInfo();
        }
        return new StatusInfo(locationStatus.getSeverity(), locationStatus.getMessage());
    }

    private static StatusInfo validatePathName(String str, IContainer parent) {
        StatusInfo result = new StatusInfo();
        result.setOK();
        IPath parentPath = parent.getFullPath();
        if (str.length() == 0) {
            result.setError(Messages.format(NewWizardMessages.NewSourceFolderWizardPage_error_EnterRootName, BasicElementLabels.getPathLabel(parentPath, false)));
            return result;
        }
        IPath path = parentPath.append(str);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IStatus validate = workspaceRoot.getWorkspace().validatePath(path.toString(), 2);
        if (validate.matches(4)) {
            result.setError(Messages.format(NewWizardMessages.NewSourceFolderWizardPage_error_InvalidRootName, validate.getMessage()));
            return result;
        }
        IResource res = workspaceRoot.findMember(path);
        if (res != null) {
            if (res.getType() != 2) {
                result.setError(NewWizardMessages.NewSourceFolderWizardPage_error_NotAFolder);
                return result;
            }
        } else {
            URI parentLocation = parent.getLocationURI();
            if (parentLocation != null) {
                try {
                    IFileStore store = EFS.getStore((URI)parentLocation).getChild(str);
                    if (store.fetchInfo().exists()) {
                        result.setError(NewWizardMessages.NewSourceFolderWizardPage_error_AlreadyExistingDifferentCase);
                        return result;
                    }
                }
                catch (CoreException coreException) {}
            }
        }
        return result;
    }

    private void addExclusionPatterns(CPListElement newEntry, List<CPListElement> existing, Set<CPListElement> modifiedEntries) {
        IPath entryPath = newEntry.getPath();
        int i = 0;
        while (i < existing.size()) {
            boolean added;
            CPListElement curr = existing.get(i);
            IPath currPath = curr.getPath();
            if (curr != newEntry && curr.getEntryKind() == 3 && currPath.isPrefixOf(entryPath) && (added = curr.addToExclusions(entryPath))) {
                modifiedEntries.add(curr);
            }
            ++i;
        }
    }

    public IResource getCorrespondingResource() {
        return this.fParent.getFolder((IPath)new Path(this.fRootDialogField.getText()));
    }

    public IPath getOutputLocation() {
        if (this.fNewOutputLocation != null) {
            return this.fNewOutputLocation;
        }
        return this.fOutputLocation;
    }

    private IFolder chooseFolder(String title, String message, IPath initialPath) {
        Class[] acceptedClasses = new Class[]{IFolder.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false);
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses, null);
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        IProject currProject = this.fNewElement.getJavaProject().getProject();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp){

            protected Control createDialogArea(Composite parent) {
                Control result = super.createDialogArea(parent);
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.jdt.ui.bp_choose_existing_folder_to_make_source_folder");
                return result;
            }
        };
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)currProject);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        IResource res = currProject.findMember(initialPath);
        if (res != null) {
            dialog.setInitialSelection((Object)res);
        }
        if (dialog.open() == 0) {
            return (IFolder)dialog.getFirstResult();
        }
        return null;
    }

    public List<CPListElement> getModifiedElements() {
        if (this.fOrginalPath != null && !this.fModifiedElements.contains(this.fNewElement)) {
            this.fModifiedElements.add(this.fNewElement);
        }
        return this.fModifiedElements;
    }

    public List<CPListElement> getRemovedElements() {
        return this.fRemovedElements;
    }

    private final class LinkFields
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private StringButtonDialogField fLinkLocation = new StringButtonDialogField(this);
        private static final String DIALOGSTORE_LAST_EXTERNAL_LOC = "org.eclipse.jdt.ui.last.external.project";
        private RootFieldAdapter fAdapter;
        private SelectionButtonDialogField fVariables;

        public LinkFields() {
            this.fLinkLocation.setLabelText(NewWizardMessages.LinkFolderDialog_dependenciesGroup_locationLabel_desc);
            this.fLinkLocation.setButtonLabel(NewWizardMessages.LinkFolderDialog_dependenciesGroup_browseButton_desc);
            this.fLinkLocation.setDialogFieldListener(this);
            this.fVariables = new SelectionButtonDialogField(8);
            this.fVariables.setLabelText(NewWizardMessages.LinkFolderDialog_dependenciesGroup_variables_desc);
            this.fVariables.setDialogFieldListener(new IDialogFieldListener(){

                public void dialogFieldChanged(DialogField field) {
                    LinkFields.this.handleVariablesButtonPressed();
                }
            });
        }

        public void setDialogFieldListener(RootFieldAdapter adapter) {
            this.fAdapter = adapter;
        }

        private void doFillIntoGrid(Composite parent, int numColumns) {
            this.fLinkLocation.doFillIntoGrid(parent, numColumns);
            LayoutUtil.setHorizontalSpan((Control)this.fLinkLocation.getLabelControl(null), numColumns);
            LayoutUtil.setHorizontalGrabbing((Control)this.fLinkLocation.getTextControl(null));
            BidiUtils.applyBidiProcessing((Text)this.fLinkLocation.getTextControl(null), (String)"file");
            this.fVariables.doFillIntoGrid(parent, 1);
        }

        public IPath getLinkTarget() {
            return Path.fromOSString((String)this.fLinkLocation.getText());
        }

        public void setLinkTarget(IPath path) {
            this.fLinkLocation.setText(path.toOSString());
        }

        public void changeControlPressed(DialogField field) {
            String selectedDirectory;
            File path;
            String prevLocation;
            DirectoryDialog dialog = new DirectoryDialog(AddSourceFolderWizardPage.this.getShell());
            dialog.setMessage(NewWizardMessages.AddSourceFolderWizardPage_directory_message);
            String directoryName = this.fLinkLocation.getText().trim();
            if (directoryName.length() == 0 && (prevLocation = JavaPlugin.getDefault().getDialogSettings().get(DIALOGSTORE_LAST_EXTERNAL_LOC)) != null) {
                directoryName = prevLocation;
            }
            if (directoryName.length() > 0 && (path = new File(directoryName)).exists()) {
                dialog.setFilterPath(directoryName);
            }
            if ((selectedDirectory = dialog.open()) != null) {
                this.fLinkLocation.setText(selectedDirectory);
                AddSourceFolderWizardPage.this.fRootDialogField.setText(selectedDirectory.substring(selectedDirectory.lastIndexOf(File.separatorChar) + 1));
                JavaPlugin.getDefault().getDialogSettings().put(DIALOGSTORE_LAST_EXTERNAL_LOC, selectedDirectory);
                if (this.fAdapter != null) {
                    this.fAdapter.dialogFieldChanged(AddSourceFolderWizardPage.this.fRootDialogField);
                }
            }
        }

        private void handleVariablesButtonPressed() {
            String[] variableNames;
            int variableTypes = 2;
            PathVariableSelectionDialog dialog = new PathVariableSelectionDialog(AddSourceFolderWizardPage.this.getShell(), variableTypes);
            dialog.setResource((IResource)AddSourceFolderWizardPage.this.fParent);
            if (dialog.open() == 0 && (variableNames = (String[])dialog.getResult()) != null && variableNames.length == 1) {
                this.fLinkLocation.setText(variableNames[0]);
                AddSourceFolderWizardPage.this.fRootDialogField.setText(new Path(variableNames[0]).lastSegment());
                if (this.fAdapter != null) {
                    this.fAdapter.dialogFieldChanged(AddSourceFolderWizardPage.this.fRootDialogField);
                }
            }
        }

        public void dialogFieldChanged(DialogField field) {
            if (this.fAdapter != null) {
                this.fAdapter.dialogFieldChanged(this.fLinkLocation);
            }
        }
    }

    private class RootFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private RootFieldAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            AddSourceFolderWizardPage.this.packRootChangeControlPressed(field);
        }

        public void dialogFieldChanged(DialogField field) {
            AddSourceFolderWizardPage.this.packRootDialogFieldChanged();
        }
    }
}

