/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filesystem.java7;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.internal.filesystem.local.NativeHandler;

public class DefaultHandler
extends NativeHandler {
    private static final int ATTRIBUTES = 102;

    public FileInfo fetchFileInfo(String fileName) {
        Path path = Paths.get(fileName, new String[0]);
        boolean exists = Files.exists(path, new LinkOption[0]);
        FileInfo info = new FileInfo();
        info.setExists(exists);
        boolean isSymbolicLink = Files.isSymbolicLink(path);
        if (isSymbolicLink) {
            info.setAttribute(32, true);
            try {
                info.setStringAttribute(64, Files.readSymbolicLink(path).toString());
            }
            catch (IOException iOException) {
                info.setError(5);
            }
        }
        File file = new File(fileName);
        final String lastName = file.getName();
        if (!info.exists() || EFS.getLocalFileSystem().isCaseSensitive() || lastName.toLowerCase().equals(lastName.toUpperCase())) {
            info.setName(lastName);
        } else {
            String[] names = file.getParentFile().list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String n) {
                    return n.equalsIgnoreCase(lastName);
                }
            });
            if (names.length == 1) {
                info.setName(names[0]);
            } else {
                info.setName(lastName);
            }
        }
        if (!exists) {
            return info;
        }
        try {
            info.setLastModified(Files.getLastModifiedTime(path, new LinkOption[0]).toMillis());
            info.setLength(Files.size(path));
            info.setDirectory(Files.isDirectory(path, new LinkOption[0]));
            info.setAttribute(2, !Files.isWritable(path) && Files.isReadable(path));
            info.setAttribute(4, Files.isExecutable(path));
        }
        catch (IOException iOException) {
            info.setError(5);
        }
        return info;
    }

    public int getSupportedAttributes() {
        return 102;
    }

    public boolean putFileInfo(String fileName, IFileInfo info, int options) {
        File file = new File(fileName);
        if (info.getAttribute(2) ? !file.setReadOnly() : !file.setWritable(true)) {
            return false;
        }
        return file.setExecutable(info.getAttribute(4));
    }
}

