/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.text;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.internal.core.ICoreConstants;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.text.IDocumentRange;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.text.PDETextHover;
import org.eclipse.pde.internal.ui.util.PDEJavaHelperUI;

public class ManifestTextHover
extends PDETextHover {
    private PDESourcePage fSourcePage;
    private IJavaProject fJP;

    public ManifestTextHover(PDESourcePage sourcePage) {
        this.fSourcePage = sourcePage;
        IProject project = ((PDEFormEditor)this.fSourcePage.getEditor()).getCommonProject();
        this.fJP = JavaCore.create((IProject)project);
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        int offset = hoverRegion.getOffset();
        IDocumentRange range = this.fSourcePage.getRangeElement(offset, false);
        if (range instanceof IManifestHeader) {
            IManifestHeader header = (IManifestHeader)range;
            String headerName = header.getName();
            if (offset >= header.getOffset() + headerName.length()) {
                return this.checkForTranslatable(header);
            }
            if (this.fJP != null) {
                return PDEJavaHelperUI.getOSGIConstantJavaDoc(headerName, this.fJP);
            }
        }
        return null;
    }

    private String checkForTranslatable(IManifestHeader header) {
        String name = header.getName();
        String value = header.getValue();
        int i = 0;
        while (i < ICoreConstants.TRANSLATABLE_HEADERS.length) {
            IBaseModel model;
            if (name.equals(ICoreConstants.TRANSLATABLE_HEADERS[i]) && value.startsWith("%") && (model = ((PDEFormEditor)this.fSourcePage.getEditor()).getAggregateModel()) instanceof IModel) {
                return ((IModel)model).getResourceString(value);
            }
            ++i;
        }
        return null;
    }
}

