/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.browsing.JavaBrowsingMessages;
import org.eclipse.jdt.internal.ui.dnd.JdtViewerDropSupport;
import org.eclipse.jdt.internal.ui.viewsupport.SourcePositionComparator;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class LexicalSortingAction
extends Action {
    private JavaElementComparator fComparator = new JavaElementComparator();
    private SourcePositionComparator fSourcePositonComparator = new SourcePositionComparator();
    private StructuredViewer fViewer;
    private String fPreferenceKey;
    private final JdtViewerDropSupport fDropSupport;

    public LexicalSortingAction(StructuredViewer viewer, String id, JdtViewerDropSupport dropSupport) {
        this.fViewer = viewer;
        this.fDropSupport = dropSupport;
        this.fPreferenceKey = "LexicalSortingAction." + id + ".isChecked";
        this.setText(JavaBrowsingMessages.LexicalSortingAction_label);
        JavaPluginImages.setLocalImageDescriptors((IAction)this, "alphab_sort_co.png");
        this.setToolTipText(JavaBrowsingMessages.LexicalSortingAction_tooltip);
        this.setDescription(JavaBrowsingMessages.LexicalSortingAction_description);
        boolean checked = JavaPlugin.getDefault().getPreferenceStore().getBoolean(this.fPreferenceKey);
        this.valueChanged(checked, false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.lexical_sorting_browsing_action");
    }

    public void run() {
        this.valueChanged(this.isChecked(), true);
    }

    private void valueChanged(final boolean on, boolean store) {
        this.setChecked(on);
        BusyIndicator.showWhile((Display)this.fViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                if (on) {
                    LexicalSortingAction.this.fViewer.setComparator((ViewerComparator)LexicalSortingAction.this.fComparator);
                    LexicalSortingAction.this.fDropSupport.setFeedbackEnabled(false);
                } else {
                    LexicalSortingAction.this.fViewer.setComparator((ViewerComparator)LexicalSortingAction.this.fSourcePositonComparator);
                    LexicalSortingAction.this.fDropSupport.setFeedbackEnabled(true);
                }
            }
        });
        if (store) {
            JavaPlugin.getDefault().getPreferenceStore().setValue(this.fPreferenceKey, on);
        }
    }
}

