/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.graphics.Image;

public class JavaCompletionProposal
extends AbstractJavaCompletionProposal {
    public JavaCompletionProposal(String replacementString, int replacementOffset, int replacementLength, Image image, String displayString, int relevance) {
        this(replacementString, replacementOffset, replacementLength, image, new StyledString(displayString), relevance, false);
    }

    public JavaCompletionProposal(String replacementString, int replacementOffset, int replacementLength, Image image, StyledString displayString, int relevance) {
        this(replacementString, replacementOffset, replacementLength, image, displayString, relevance, false);
    }

    public JavaCompletionProposal(String replacementString, int replacementOffset, int replacementLength, Image image, StyledString displayString, int relevance, boolean inJavadoc) {
        this(replacementString, replacementOffset, replacementLength, image, displayString, relevance, inJavadoc, null);
    }

    public JavaCompletionProposal(String replacementString, int replacementOffset, int replacementLength, Image image, StyledString displayString, int relevance, boolean inJavadoc, JavaContentAssistInvocationContext invocationContext) {
        super(invocationContext);
        Assert.isNotNull((Object)replacementString);
        Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        this.setReplacementString(replacementString);
        this.setReplacementOffset(replacementOffset);
        this.setReplacementLength(replacementLength);
        this.setImage(image);
        this.setStyledDisplayString(displayString == null ? new StyledString(replacementString) : displayString);
        this.setRelevance(relevance);
        this.setCursorPosition(replacementString.length());
        this.setInJavadoc(inJavadoc);
        this.setSortString(displayString == null ? replacementString : displayString.getString());
    }

    protected boolean isValidPrefix(String prefix) {
        String word = TextProcessor.deprocess((String)this.getDisplayString());
        if (this.isInJavadoc()) {
            int idx = word.indexOf("{@link ");
            if (idx == 0) {
                word = word.substring(7);
            } else {
                idx = word.indexOf("{@value ");
                if (idx == 0) {
                    word = word.substring(8);
                }
            }
        } else if (word.indexOf("this.") != -1) {
            word = word.substring(word.indexOf("this.") + 5);
        }
        return this.isPrefix(prefix, word);
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        String string = this.getReplacementString();
        int pos = string.indexOf(40);
        if (pos > 0) {
            return string.subSequence(0, pos);
        }
        if (string.startsWith("this.")) {
            return string.substring(5);
        }
        return string;
    }
}

