/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.undo;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IAdvancedUndoableOperation;
import org.eclipse.core.commands.operations.IAdvancedUndoableOperation2;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.Policy;

public class WorkspaceUndoMonitor {
    private static WorkspaceUndoMonitor instance;
    private static int CHANGE_THRESHHOLD;
    private static String DEBUG_PREFIX;
    private int numChanges = 0;
    private IUndoableOperation operationInProgress = null;
    private IResourceChangeListener resourceListener;
    private IOperationHistoryListener historyListener;

    static {
        CHANGE_THRESHHOLD = 10;
        DEBUG_PREFIX = "Workspace Undo Monitor:  ";
    }

    public static WorkspaceUndoMonitor getInstance() {
        if (instance == null) {
            instance = new WorkspaceUndoMonitor();
        }
        return instance;
    }

    private WorkspaceUndoMonitor() {
        if (Policy.DEBUG_UNDOMONITOR) {
            System.out.println(String.valueOf(DEBUG_PREFIX) + "Installing listeners");
        }
        this.resourceListener = this.getResourceChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener);
        this.historyListener = this.getOperationHistoryListener();
        this.getOperationHistory().addOperationHistoryListener(this.historyListener);
    }

    private IResourceChangeListener getResourceChangeListener() {
        return event -> {
            if (this.operationInProgress != null) {
                return;
            }
            if (event.getType() == 1 || event.getType() == 16) {
                this.incrementChangeCount();
                if (this.numChanges >= CHANGE_THRESHHOLD) {
                    this.checkOperationHistory();
                }
            }
        };
    }

    private IOperationHistoryListener getOperationHistoryListener() {
        return event -> {
            if (!event.getOperation().hasContext(WorkspaceUndoUtil.getWorkspaceUndoContext())) {
                return;
            }
            switch (event.getEventType()) {
                case 1: 
                case 2: 
                case 3: {
                    this.operationInProgress = event.getOperation();
                    break;
                }
                case 4: 
                case 9: 
                case 10: {
                    this.resetChangeCount();
                    this.operationInProgress = null;
                    break;
                }
                case 7: {
                    this.operationInProgress = null;
                }
            }
        };
    }

    public void shutdown() {
        if (Policy.DEBUG_UNDOMONITOR) {
            System.out.println(String.valueOf(DEBUG_PREFIX) + "Shutting Down");
        }
        if (this.resourceListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceListener);
        }
        if (this.historyListener != null) {
            this.getOperationHistory().removeOperationHistoryListener(this.historyListener);
        }
    }

    private IOperationHistory getOperationHistory() {
        return PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
    }

    private void checkOperationHistory() {
        IUndoableOperation currentOp;
        if (Policy.DEBUG_UNDOMONITOR) {
            System.out.println(String.valueOf(DEBUG_PREFIX) + "Checking Operation History...");
        }
        if ((currentOp = this.getOperationHistory().getUndoOperation(WorkspaceUndoUtil.getWorkspaceUndoContext())) == null) {
            this.resetChangeCount();
            return;
        }
        if (!currentOp.canUndo()) {
            this.flushWorkspaceHistory(currentOp);
            return;
        }
        if (currentOp instanceof IAdvancedUndoableOperation && currentOp instanceof IAdvancedUndoableOperation2) {
            IStatus status;
            ((IAdvancedUndoableOperation2)currentOp).setQuietCompute(true);
            try {
                status = ((IAdvancedUndoableOperation)currentOp).computeUndoableStatus(null);
            }
            catch (ExecutionException executionException) {
                status = Status.OK_STATUS;
            }
            ((IAdvancedUndoableOperation2)currentOp).setQuietCompute(false);
            if (status.getSeverity() == 4) {
                this.flushWorkspaceHistory(currentOp);
            }
        }
        this.resetChangeCount();
    }

    private void flushWorkspaceHistory(IUndoableOperation op) {
        if (Policy.DEBUG_UNDOMONITOR) {
            System.out.println(String.valueOf(DEBUG_PREFIX) + "Flushing undo history due to " + op);
        }
        this.getOperationHistory().dispose(WorkspaceUndoUtil.getWorkspaceUndoContext(), true, true, false);
    }

    private void resetChangeCount() {
        this.numChanges = 0;
        if (Policy.DEBUG_UNDOMONITOR) {
            System.out.println(String.valueOf(DEBUG_PREFIX) + "Resetting change count to 0");
        }
    }

    private void incrementChangeCount() {
        ++this.numChanges;
        if (Policy.DEBUG_UNDOMONITOR) {
            System.out.println(String.valueOf(DEBUG_PREFIX) + "Incrementing workspace change count.  Count = " + this.numChanges);
        }
    }
}

