/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.push;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.op.PushOperation;
import org.eclipse.egit.core.op.PushOperationResult;
import org.eclipse.egit.core.op.PushOperationSpecification;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.credentials.EGitCredentialsProvider;
import org.eclipse.egit.ui.internal.push.PushResultDialog;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;

public class PushOperationUI {
    private final Repository repository;
    private final boolean dryRun;
    private final String destinationString;
    private final RemoteConfig config;
    private PushOperationSpecification spec;
    private CredentialsProvider credentialsProvider;
    private PushOperation op;
    private final String remoteName;
    private PushOperationResult expectedResult;
    private boolean showConfigureButton = true;

    public PushOperationUI(Repository repository, String remoteName, boolean dryRun) {
        this.repository = repository;
        this.spec = null;
        this.config = null;
        this.remoteName = remoteName;
        this.dryRun = dryRun;
        this.destinationString = NLS.bind((String)"{0} - {1}", (Object)repository.getDirectory().getParentFile().getName(), (Object)remoteName);
    }

    public PushOperationUI(Repository repository, RemoteConfig config, boolean dryRun) {
        this.repository = repository;
        this.spec = null;
        this.config = config;
        this.remoteName = null;
        this.dryRun = dryRun;
        this.destinationString = NLS.bind((String)"{0} - {1}", (Object)repository.getDirectory().getParentFile().getName(), (Object)config.getName());
    }

    public PushOperationUI(Repository repository, PushOperationSpecification spec, boolean dryRun) {
        this.repository = repository;
        this.spec = spec;
        this.config = null;
        this.remoteName = null;
        this.dryRun = dryRun;
        this.destinationString = spec.getURIsNumber() == 1 ? ((URIish)spec.getURIs().iterator().next()).toPrivateString() : NLS.bind((String)UIText.PushOperationUI_MultiRepositoriesDestinationString, (Object)spec.getURIsNumber());
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public void setExpectedResult(PushOperationResult expectedResult) {
        this.expectedResult = expectedResult;
    }

    public void setShowConfigureButton(boolean showConfigureButton) {
        this.showConfigureButton = showConfigureButton;
    }

    public PushOperationResult execute(IProgressMonitor monitor) throws CoreException {
        this.createPushOperation();
        if (this.credentialsProvider != null) {
            this.op.setCredentialsProvider(this.credentialsProvider);
        } else {
            this.op.setCredentialsProvider((CredentialsProvider)new EGitCredentialsProvider());
        }
        try {
            this.op.run(monitor);
            return this.op.getOperationResult();
        }
        catch (InvocationTargetException e) {
            throw new CoreException(Activator.createErrorStatus(e.getCause().getMessage(), e.getCause()));
        }
    }

    private void createPushOperation() throws CoreException {
        if (this.remoteName != null) {
            this.op = new PushOperation(this.repository, this.remoteName, this.dryRun, this.getTimeout());
            return;
        }
        if (this.spec == null) {
            this.spec = new PushOperationSpecification();
            ArrayList<URIish> urisToPush = new ArrayList<URIish>();
            for (URIish uri : this.config.getPushURIs()) {
                urisToPush.add(uri);
            }
            if (urisToPush.isEmpty() && !this.config.getURIs().isEmpty()) {
                urisToPush.add((URIish)this.config.getURIs().get(0));
            }
            ArrayList pushRefSpecs = new ArrayList();
            pushRefSpecs.addAll(this.config.getPushRefSpecs());
            for (URIish uri : urisToPush) {
                try {
                    Collection remoteRefUpdates = Transport.findRemoteRefUpdatesFor((Repository)this.repository, pushRefSpecs, (Collection)this.config.getFetchRefSpecs());
                    this.spec.addURIRefUpdates(uri, remoteRefUpdates);
                }
                catch (NotSupportedException e) {
                    throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
                }
                catch (IOException e) {
                    throw new CoreException(Activator.createErrorStatus(e.getMessage(), e));
                }
            }
        }
        this.op = new PushOperation(this.repository, this.spec, this.dryRun, this.getTimeout());
    }

    public void start() {
        Job job = new Job(NLS.bind((String)UIText.PushOperationUI_PushJobName, (Object)this.destinationString)){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    PushOperationUI.this.execute(monitor);
                }
                catch (CoreException e) {
                    return Activator.createErrorStatus(e.getStatus().getMessage(), e);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.PUSH.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        job.setUser(true);
        job.schedule();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                PushOperationResult result = PushOperationUI.this.op.getOperationResult();
                if (PushOperationUI.this.expectedResult == null || !PushOperationUI.this.expectedResult.equals((Object)result)) {
                    if (event.getResult().isOK()) {
                        PushResultDialog.show(PushOperationUI.this.repository, result, PushOperationUI.this.destinationString, PushOperationUI.this.showConfigureButton, false);
                    } else {
                        Activator.handleError(event.getResult().getMessage(), event.getResult().getException(), true);
                    }
                }
            }
        });
    }

    public String getDestinationString() {
        return this.destinationString;
    }

    private int getTimeout() {
        return Activator.getDefault().getPreferenceStore().getInt("remote_connection_timeout");
    }
}

