/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Dimension;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.WildcardType;
import org.eclipse.jdt.core.util.ExternalAnnotationUtil;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.NullAnnotationsFix;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jdt.internal.ui.text.spelling.WordCorrectionProposal;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.correction.ICommandAccess;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class ExternalNullAnnotationChangeProposals {
    static ITypeBinding resolveBinding(TypeParameter type) {
        ITypeBinding binding = type.resolveBinding();
        if (binding == null || binding.isRecovered()) {
            throw new MissingBindingException((ASTNode)type);
        }
        return binding;
    }

    static ITypeBinding resolveBinding(Type type) {
        ITypeBinding binding = type.resolveBinding();
        if (binding == null || binding.isRecovered()) {
            throw new MissingBindingException((ASTNode)type);
        }
        return binding;
    }

    static IMethodBinding resolveBinding(MethodDeclaration method) {
        IMethodBinding binding = method.resolveBinding();
        if (binding == null || binding.isRecovered()) {
            throw new MissingBindingException((ASTNode)method);
        }
        return binding;
    }

    static IVariableBinding resolveBinding(VariableDeclaration variable) {
        IVariableBinding binding = variable.resolveBinding();
        if (binding == null || binding.isRecovered()) {
            throw new MissingBindingException((ASTNode)variable);
        }
        return binding;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void collectExternalAnnotationProposals(ICompilationUnit cu, ASTNode coveringNode, int offset, ArrayList<IJavaCompletionProposal> resultingCollection) {
        boolean useJava8;
        IJavaProject javaProject = cu.getJavaProject();
        if ("disabled".equals(javaProject.getOption("org.eclipse.jdt.core.compiler.annotation.nullanalysis", true))) {
            return;
        }
        if (!ExternalNullAnnotationChangeProposals.hasAnnotationPathInWorkspace(javaProject, cu)) {
            return;
        }
        ASTNode inner = null;
        Type outer = null;
        SingleVariableDeclaration variable = null;
        boolean annotateVarargs = false;
        int extraDims = 0;
        int outerExtraDims = 0;
        if (coveringNode instanceof Dimension && coveringNode.getLocationInParent() == SingleVariableDeclaration.EXTRA_DIMENSIONS2_PROPERTY) {
            variable = (SingleVariableDeclaration)coveringNode.getParent();
            outer = variable.getType();
            inner = variable.getType();
            List extraDimensions = variable.extraDimensions();
            extraDims = extraDimensions.size();
            outerExtraDims = extraDimensions.indexOf(coveringNode);
        } else if (coveringNode instanceof SingleVariableDeclaration) {
            variable = (SingleVariableDeclaration)coveringNode;
            outer = variable.getType();
            inner = variable.getType();
            if (!variable.isVarargs()) return;
            Type type = variable.getType();
            if (offset < type.getStartPosition() + type.getLength()) {
                return;
            }
            if (offset + 3 > variable.getName().getStartPosition()) {
                return;
            }
            annotateVarargs = true;
        } else {
            ASTNode next;
            block26: {
                do {
                    if (coveringNode instanceof Type || coveringNode instanceof TypeParameter) break block26;
                } while ((coveringNode = coveringNode.getParent()) != null);
                return;
            }
            inner = coveringNode;
            if (inner.getNodeType() == 39) {
                return;
            }
            outer = inner;
            while ((next = outer.getParent()) instanceof Type || next instanceof TypeParameter) {
                outer = next;
            }
        }
        ASTNode typeToAnnotate = !annotateVarargs && extraDims == 0 ? inner : null;
        TypeRenderer rendererNonNull = new TypeRenderer(typeToAnnotate, offset, '1');
        TypeRenderer rendererNullable = new TypeRenderer(typeToAnnotate, offset, '0');
        TypeRenderer rendererRemove = new TypeRenderer(typeToAnnotate, offset, '@');
        if (variable != null) {
            if (variable.isVarargs()) {
                rendererNonNull.addDimension(annotateVarargs);
                rendererNullable.addDimension(annotateVarargs);
                rendererRemove.addDimension(annotateVarargs);
            }
            int i = 0;
            while (i < extraDims) {
                rendererNonNull.addDimension(i == outerExtraDims);
                rendererNullable.addDimension(i == outerExtraDims);
                rendererRemove.addDimension(i == outerExtraDims);
                ++i;
            }
        }
        if (!((useJava8 = JavaModelUtil.is18OrHigher(javaProject.getOption("org.eclipse.jdt.core.compiler.source", true))) || outer == inner && outerExtraDims <= 0 || outer.getNodeType() == 74 && inner.getParent() == outer)) {
            return;
        }
        try {
            void var17_22;
            FieldDeclaration field;
            if (outer instanceof Type) {
                ITypeBinding typeBinding;
                if (extraDims == 0 && !annotateVarargs && (typeBinding = ExternalNullAnnotationChangeProposals.resolveBinding(outer)).isPrimitive()) {
                    return;
                }
                outer.accept((ASTVisitor)rendererNonNull);
                outer.accept((ASTVisitor)rendererNullable);
                outer.accept((ASTVisitor)rendererRemove);
            } else {
                List siblingList = (List)outer.getParent().getStructuralProperty(outer.getLocationInParent());
                rendererNonNull.visitTypeParameters(siblingList);
                rendererNullable.visitTypeParameters(siblingList);
                rendererRemove.visitTypeParameters(siblingList);
            }
            StructuralPropertyDescriptor locationInParent = outer.getLocationInParent();
            Object var17_18 = null;
            if (locationInParent == MethodDeclaration.RETURN_TYPE2_PROPERTY) {
                MethodDeclaration method = (MethodDeclaration)ASTNodes.getParent(coveringNode, MethodDeclaration.class);
                ReturnProposalCreator returnProposalCreator = new ReturnProposalCreator(cu, ExternalNullAnnotationChangeProposals.resolveBinding(method));
            } else if (locationInParent == SingleVariableDeclaration.TYPE_PROPERTY) {
                MethodDeclaration method;
                int paramIdx;
                ASTNode param = outer.getParent();
                if (param.getLocationInParent() == MethodDeclaration.PARAMETERS_PROPERTY && (paramIdx = (method = (MethodDeclaration)ASTNodes.getParent(coveringNode, MethodDeclaration.class)).parameters().indexOf(param)) != -1) {
                    ParameterProposalCreator parameterProposalCreator = new ParameterProposalCreator(cu, ExternalNullAnnotationChangeProposals.resolveBinding(method), paramIdx);
                }
            } else if (locationInParent == FieldDeclaration.TYPE_PROPERTY && (field = (FieldDeclaration)ASTNodes.getParent(coveringNode, FieldDeclaration.class)).fragments().size() > 0) {
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)field.fragments().get(0);
                FieldProposalCreator fieldProposalCreator = new FieldProposalCreator(cu, ExternalNullAnnotationChangeProposals.resolveBinding((VariableDeclaration)fragment));
            }
            if (var17_22 == null) return;
            ExternalNullAnnotationChangeProposals.createProposalsForType(cu, inner, extraDims, outerExtraDims, annotateVarargs, offset, rendererNonNull, rendererNullable, rendererRemove, (ProposalCreator)var17_22, resultingCollection);
            return;
        }
        catch (MissingBindingException mbe) {
            JavaPlugin.log(JavaUIStatus.createError(4, "Error during computation of Annotate proposals: " + mbe.getMessage(), mbe));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean hasAnnotationPathInWorkspace(IJavaProject javaProject, ICompilationUnit cu) {
        IPackageFragmentRoot root = (IPackageFragmentRoot)cu.getAncestor(3);
        if (root == null) return false;
        try {
            IClasspathEntry resolvedClasspathEntry = root.getResolvedClasspathEntry();
            IClasspathAttribute[] iClasspathAttributeArray = resolvedClasspathEntry.getExtraAttributes();
            int n = iClasspathAttributeArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IClasspathAttribute cpa = iClasspathAttributeArray[n2];
                if ("annotationpath".equals(cpa.getName())) {
                    Path annotationPath = new Path(cpa.getValue());
                    IProject project = javaProject.getProject();
                    if (project.exists((IPath)annotationPath)) {
                        return true;
                    }
                    IWorkspaceRoot wsRoot = project.getWorkspace().getRoot();
                    return wsRoot.exists((IPath)annotationPath);
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    static void createProposalsForType(ICompilationUnit cu, ASTNode type, int dims, int outerDims, boolean annotateVarargs, int offset, TypeRenderer rendererNonNull, TypeRenderer rendererNullable, TypeRenderer rendererRemove, ProposalCreator creator, ArrayList<IJavaCompletionProposal> resultingCollection) {
        String label = ExternalNullAnnotationChangeProposals.getAddAnnotationLabel(NullAnnotationsFix.getNonNullAnnotationName((IJavaElement)cu, true), type, dims, outerDims, annotateVarargs, offset);
        SignatureAnnotationChangeProposal operation = creator.create(rendererNonNull.getResult(), label);
        if (operation != null) {
            resultingCollection.add(operation);
        }
        label = ExternalNullAnnotationChangeProposals.getAddAnnotationLabel(NullAnnotationsFix.getNullableAnnotationName((IJavaElement)cu, true), type, dims, outerDims, annotateVarargs, offset);
        operation = creator.create(rendererNullable.getResult(), label);
        if (operation != null) {
            resultingCollection.add(operation);
        }
        label = Messages.format(FixMessages.ExternalNullAnnotationChangeProposals_remove_nullness_annotation, new String[]{ExternalNullAnnotationChangeProposals.type2String(type, offset)});
        operation = creator.create(rendererRemove.getResult(), label);
        if (operation != null) {
            resultingCollection.add(operation);
        }
    }

    static String getAddAnnotationLabel(String annotationName, ASTNode type, int dims, int outerDims, boolean annotateVarargs, int offset) {
        StringBuilder left = null;
        StringBuilder dimsRight = null;
        if (type.getNodeType() == 5) {
            ArrayType arrayType = (ArrayType)type;
            left = new StringBuilder(arrayType.getElementType().toString());
            dimsRight = new StringBuilder();
            List dimensions = arrayType.dimensions();
            int i = 0;
            while (i < dimensions.size()) {
                Dimension dimension = (Dimension)dimensions.get(i);
                if (dimension.getStartPosition() + dimension.getLength() <= offset) {
                    left.append("[]");
                } else {
                    dimsRight.append("[]");
                }
                ++i;
            }
        } else if (dims > 0) {
            left = new StringBuilder(type.toString());
            dimsRight = new StringBuilder();
            int i = 0;
            while (i < dims) {
                if (i < outerDims) {
                    left.append("[]");
                } else {
                    dimsRight.append("[]");
                }
                ++i;
            }
        } else if (annotateVarargs) {
            left = new StringBuilder(type.toString());
            dimsRight = new StringBuilder();
        }
        if (left != null && dimsRight != null) {
            if (annotateVarargs) {
                dimsRight.append("...");
            }
            return Messages.format(FixMessages.ExternalNullAnnotationChangeProposals_add_nullness_array_annotation, new String[]{left.toString(), annotationName, dimsRight.toString()});
        }
        return Messages.format(FixMessages.ExternalNullAnnotationChangeProposals_add_nullness_annotation, new String[]{annotationName, type.toString()});
    }

    static String type2String(ASTNode type, int offset) {
        if (type.getNodeType() == 5) {
            ArrayType arrayType = (ArrayType)type;
            StringBuilder buf = new StringBuilder(arrayType.getElementType().toString());
            List dimensions = arrayType.dimensions();
            int i = 0;
            while (i < dimensions.size()) {
                Dimension dimension = (Dimension)dimensions.get(i);
                if (dimension.getStartPosition() + dimension.getLength() > offset) {
                    buf.append("[]");
                }
                ++i;
            }
            return buf.toString();
        }
        return type.toString();
    }

    static class FieldAnnotationRewriteProposal
    extends SignatureAnnotationChangeProposal {
        FieldAnnotationRewriteProposal() {
        }

        @Override
        protected void dryRun() {
            this.fDryRun = ExternalAnnotationUtil.annotateType((String)this.fCurrentAnnotated, (String)this.fAnnotatedSignature, (ExternalAnnotationUtil.MergeStrategy)this.fMergeStrategy);
        }

        @Override
        protected void doAnnotateMember(IProgressMonitor monitor) throws CoreException, UnsupportedEncodingException, IOException {
            ExternalAnnotationUtil.annotateMember((String)this.fAffectedTypeName, (IFile)this.fAnnotationFile, (String)this.fSelector, (String)this.fSignature, (String)this.fAnnotatedSignature, (ExternalAnnotationUtil.MergeStrategy)this.fMergeStrategy, (IProgressMonitor)monitor);
        }
    }

    private static class FieldProposalCreator
    extends ProposalCreator {
        FieldProposalCreator(ICompilationUnit cu, IVariableBinding fieldBinding) {
            super(cu, fieldBinding.getDeclaringClass(), fieldBinding.getName(), ExternalAnnotationUtil.extractGenericTypeSignature((ITypeBinding)fieldBinding.getType()));
        }

        @Override
        SignatureAnnotationChangeProposal doCreate(String annotatedSignature, String label) {
            return new FieldAnnotationRewriteProposal();
        }
    }

    static class MissingBindingException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        ASTNode fNode;

        MissingBindingException(ASTNode node) {
            this.fNode = node;
        }

        @Override
        public String getMessage() {
            ASTNode cu = ASTNodes.getParent(this.fNode, 15);
            if (cu instanceof CompilationUnit) {
                IProblem[] iProblemArray = ((CompilationUnit)cu).getProblems();
                int n = iProblemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProblem problem = iProblemArray[n2];
                    if (problem.getID() == 0x1000144 || problem.getOriginatingFileName() == null) {
                        return problem.getMessage();
                    }
                    ++n2;
                }
            }
            switch (this.fNode.getNodeType()) {
                case 31: {
                    return "Could not resolve method " + this.fNode.toString();
                }
                case 59: {
                    return "Could not resolve field " + this.fNode.toString();
                }
            }
            return "Could not resolve type " + this.fNode.toString();
        }
    }

    static class ParameterAnnotationRewriteProposal
    extends SignatureAnnotationChangeProposal {
        int fParamIdx;

        ParameterAnnotationRewriteProposal(int paramIdx) {
            this.fParamIdx = paramIdx;
        }

        @Override
        protected void dryRun() {
            this.fDryRun = ExternalAnnotationUtil.annotateParameterType((String)this.fCurrentAnnotated, (String)this.fAnnotatedSignature, (int)this.fParamIdx, (ExternalAnnotationUtil.MergeStrategy)this.fMergeStrategy);
        }

        @Override
        protected void doAnnotateMember(IProgressMonitor monitor) throws CoreException, IOException {
            ExternalAnnotationUtil.annotateMethodParameterType((String)this.fAffectedTypeName, (IFile)this.fAnnotationFile, (String)this.fSelector, (String)this.fSignature, (String)this.fAnnotatedSignature, (int)this.fParamIdx, (ExternalAnnotationUtil.MergeStrategy)this.fMergeStrategy, (IProgressMonitor)monitor);
        }
    }

    private static class ParameterProposalCreator
    extends ProposalCreator {
        int fParamIdx;

        ParameterProposalCreator(ICompilationUnit cu, IMethodBinding methodBinding, int paramIdx) {
            super(cu, methodBinding.getDeclaringClass(), methodBinding.getName(), ExternalAnnotationUtil.extractGenericSignature((IMethodBinding)methodBinding));
            this.fParamIdx = paramIdx;
        }

        @Override
        SignatureAnnotationChangeProposal doCreate(String annotatedSignature, String label) {
            return new ParameterAnnotationRewriteProposal(this.fParamIdx);
        }
    }

    private static abstract class ProposalCreator {
        ICompilationUnit fCU;
        ITypeBinding fDeclaringClass;
        String fSelector;
        String fSignature;
        ExternalAnnotationUtil.MergeStrategy fMergeStrategy = ExternalAnnotationUtil.MergeStrategy.OVERWRITE_ANNOTATIONS;

        ProposalCreator(ICompilationUnit cu, ITypeBinding declaringClass, String selector, String signature) {
            this.fCU = cu;
            this.fDeclaringClass = declaringClass;
            this.fSelector = selector;
            this.fSignature = signature;
        }

        SignatureAnnotationChangeProposal create(String annotatedSignature, String label) {
            SignatureAnnotationChangeProposal operation = this.doCreate(annotatedSignature, label);
            if (!operation.initializeOperation(this.fCU, this.fDeclaringClass, this.fSelector, this.fSignature, annotatedSignature, label, this.fMergeStrategy)) {
                return null;
            }
            return operation;
        }

        abstract SignatureAnnotationChangeProposal doCreate(String var1, String var2);
    }

    static class ReturnAnnotationRewriteProposal
    extends SignatureAnnotationChangeProposal {
        ReturnAnnotationRewriteProposal() {
        }

        @Override
        protected void dryRun() {
            this.fDryRun = ExternalAnnotationUtil.annotateReturnType((String)this.fCurrentAnnotated, (String)this.fAnnotatedSignature, (ExternalAnnotationUtil.MergeStrategy)this.fMergeStrategy);
        }

        @Override
        protected void doAnnotateMember(IProgressMonitor monitor) throws CoreException, IOException {
            ExternalAnnotationUtil.annotateMethodReturnType((String)this.fAffectedTypeName, (IFile)this.fAnnotationFile, (String)this.fSelector, (String)this.fSignature, (String)this.fAnnotatedSignature, (ExternalAnnotationUtil.MergeStrategy)this.fMergeStrategy, (IProgressMonitor)monitor);
        }
    }

    private static class ReturnProposalCreator
    extends ProposalCreator {
        ReturnProposalCreator(ICompilationUnit cu, IMethodBinding methodBinding) {
            super(cu, methodBinding.getDeclaringClass(), methodBinding.getName(), ExternalAnnotationUtil.extractGenericSignature((IMethodBinding)methodBinding));
        }

        @Override
        SignatureAnnotationChangeProposal doCreate(String annotatedSignature, String label) {
            return new ReturnAnnotationRewriteProposal();
        }
    }

    static abstract class SignatureAnnotationChangeProposal
    implements IJavaCompletionProposal,
    ICommandAccess {
        protected String fLabel;
        protected ICompilationUnit fCU;
        protected String fAffectedTypeName;
        protected IFile fAnnotationFile;
        protected String fSelector;
        protected String fSignature;
        protected String fCurrentAnnotated;
        protected String fAnnotatedSignature;
        protected ExternalAnnotationUtil.MergeStrategy fMergeStrategy;
        protected String[] fDryRun;

        SignatureAnnotationChangeProposal() {
        }

        protected boolean initializeOperation(ICompilationUnit cu, ITypeBinding declaringClass, String selector, String plainSignature, String annotatedSignature, String label, ExternalAnnotationUtil.MergeStrategy mergeStrategy) {
            IJavaProject project = (IJavaProject)cu.getAncestor(2);
            IFile file = null;
            try {
                file = ExternalAnnotationUtil.getAnnotationFile((IJavaProject)project, (ITypeBinding)declaringClass, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                return false;
            }
            if (file == null) {
                return false;
            }
            this.fCU = cu;
            this.fAffectedTypeName = declaringClass.getErasure().getBinaryName().replace('.', '/');
            this.fAnnotationFile = file;
            this.fSelector = selector;
            this.fAnnotatedSignature = annotatedSignature;
            this.fSignature = plainSignature;
            this.fLabel = label;
            this.fMergeStrategy = mergeStrategy;
            this.fCurrentAnnotated = ExternalAnnotationUtil.getAnnotatedSignature((String)this.fAffectedTypeName, (IFile)file, (String)this.fSelector, (String)this.fSignature);
            if (this.fCurrentAnnotated == null) {
                this.fCurrentAnnotated = this.fSignature;
            }
            this.dryRun();
            return this.fDryRun != null && !this.fDryRun[1].equals(this.fDryRun[2]);
        }

        protected abstract void dryRun();

        public Point getSelection(IDocument document) {
            return null;
        }

        public String getDisplayString() {
            return this.fLabel;
        }

        public Image getImage() {
            return JavaPluginImages.get("org.eclipse.jdt.ui.annotation_obj.gif");
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public void apply(IDocument document) {
            try {
                this.doAnnotateMember((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
            catch (IOException e) {
                JavaPlugin.log(e);
            }
        }

        @Override
        public int getRelevance() {
            return 6;
        }

        @Override
        public String getCommandId() {
            return "org.eclipse.jdt.ui.annotate.nullAnnotateMember.assist";
        }

        public String getAdditionalProposalInfo() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("<dl>");
            buffer.append("<dt>").append(this.fSelector).append("</dt>");
            buffer.append("<dd>").append(WordCorrectionProposal.getHtmlRepresentation(this.fSignature)).append("</dd>");
            buffer.append("<dd>").append(this.getFullAnnotatedSignatureHTML()).append("</dd>");
            buffer.append("</dl>");
            return buffer.toString();
        }

        protected String getFullAnnotatedSignatureHTML() {
            String[] parts = this.fDryRun;
            int pos = 0;
            while (pos < parts[1].length() && pos < parts[2].length()) {
                if (parts[1].charAt(pos) != parts[2].charAt(pos)) break;
                ++pos;
            }
            StringBuilder buf = new StringBuilder();
            buf.append(WordCorrectionProposal.getHtmlRepresentation(parts[0]));
            buf.append(WordCorrectionProposal.getHtmlRepresentation(parts[2].substring(0, pos)));
            switch (parts[2].charAt(pos)) {
                case '0': 
                case '1': {
                    buf.append("<b>").append(parts[2].charAt(pos)).append("</b>");
                    break;
                }
                default: {
                    buf.append("<del>").append(parts[1].charAt(pos)).append("</del>");
                    --pos;
                }
            }
            buf.append(WordCorrectionProposal.getHtmlRepresentation(parts[2].substring(pos + 1)));
            buf.append(WordCorrectionProposal.getHtmlRepresentation(parts[3]));
            return buf.toString();
        }

        protected abstract void doAnnotateMember(IProgressMonitor var1) throws CoreException, UnsupportedEncodingException, IOException;
    }

    static class TypeRenderer
    extends ASTVisitor {
        StringBuffer fBuffer = new StringBuffer();
        ASTNode fFocusType;
        int fOffset;
        char fAnnotation;

        public TypeRenderer(ASTNode focusType, int offset, char annotation) {
            this.fFocusType = focusType;
            this.fOffset = offset;
            this.fAnnotation = annotation;
        }

        public void addDimension(boolean annotate) {
            this.fBuffer.append('[');
            if (annotate) {
                this.fBuffer.append(this.fAnnotation);
            }
        }

        public String getResult() {
            return this.fBuffer.toString();
        }

        public void visitTypeParameters(List parameters) {
            this.fBuffer.append('<');
            for (Object p : parameters) {
                ((TypeParameter)p).accept((ASTVisitor)this);
            }
            this.fBuffer.append('>');
        }

        public boolean visit(ParameterizedType type) {
            this.fBuffer.append('L');
            if (type == this.fFocusType || type.getType() == this.fFocusType) {
                this.fBuffer.append(this.fAnnotation);
            }
            this.fBuffer.append(this.binaryName(ExternalNullAnnotationChangeProposals.resolveBinding((Type)type)));
            this.fBuffer.append('<');
            for (Object arg : type.typeArguments()) {
                ((Type)arg).accept((ASTVisitor)this);
            }
            this.fBuffer.append('>');
            this.fBuffer.append(';');
            return false;
        }

        public boolean visit(WildcardType wildcard) {
            Type bound = wildcard.getBound();
            if (bound == null) {
                this.fBuffer.append('*');
            } else if (wildcard.isUpperBound()) {
                this.fBuffer.append('+');
            } else {
                this.fBuffer.append('-');
            }
            if (wildcard == this.fFocusType) {
                this.fBuffer.append(this.fAnnotation);
            }
            if (bound != null) {
                bound.accept((ASTVisitor)this);
            }
            return false;
        }

        public boolean visit(ArrayType array) {
            List dimensions = array.dimensions();
            boolean annotated = false;
            int i = 0;
            while (i < dimensions.size()) {
                this.fBuffer.append('[');
                Dimension dimension = (Dimension)dimensions.get(i);
                if (!annotated && array == this.fFocusType && dimension.getStartPosition() + dimension.getLength() > this.fOffset) {
                    this.fBuffer.append(this.fAnnotation);
                    annotated = true;
                }
                ++i;
            }
            array.getElementType().accept((ASTVisitor)this);
            return false;
        }

        public boolean visit(TypeParameter parameter) {
            Type typeBound;
            if (parameter == this.fFocusType) {
                this.fBuffer.append(this.fAnnotation);
            }
            this.fBuffer.append(parameter.getName().getIdentifier());
            Type classBound = null;
            for (Object bound : parameter.typeBounds()) {
                typeBound = (Type)bound;
                if (!ExternalNullAnnotationChangeProposals.resolveBinding(typeBound).isClass()) continue;
                classBound = typeBound;
                break;
            }
            if (classBound != null) {
                this.fBuffer.append(':');
                classBound.accept((ASTVisitor)this);
            } else {
                ITypeBinding typeBinding = ExternalNullAnnotationChangeProposals.resolveBinding(parameter);
                this.fBuffer.append(":L").append(this.binaryName(typeBinding.getSuperclass())).append(';');
            }
            for (Object bound : parameter.typeBounds()) {
                if (bound == classBound) continue;
                typeBound = (Type)bound;
                this.fBuffer.append(':');
                typeBound.accept((ASTVisitor)this);
            }
            return false;
        }

        public boolean visit(SimpleType type) {
            ITypeBinding typeBinding = ExternalNullAnnotationChangeProposals.resolveBinding((Type)type);
            if (typeBinding.isTypeVariable()) {
                this.fBuffer.append('T');
                if (this.fFocusType == type) {
                    this.fBuffer.append(this.fAnnotation);
                }
                this.fBuffer.append(typeBinding.getName()).append(';');
            } else {
                this.fBuffer.append('L');
                if (this.fFocusType == type) {
                    this.fBuffer.append(this.fAnnotation);
                }
                this.fBuffer.append(this.binaryName(typeBinding)).append(';');
            }
            return false;
        }

        public boolean visit(PrimitiveType node) {
            this.fBuffer.append(ExternalNullAnnotationChangeProposals.resolveBinding((Type)node).getBinaryName());
            return false;
        }

        String binaryName(ITypeBinding type) {
            return type.getBinaryName().replace('.', '/');
        }
    }
}

