/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.console;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.console.ConsoleMessages;
import org.eclipse.jdt.internal.debug.ui.console.JavaStackTraceConsolePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.console.IConsoleDocumentPartitioner;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.progress.WorkbenchJob;

public class JavaStackTraceConsole
extends TextConsole {
    public static final String CONSOLE_TYPE = "javaStackTraceConsole";
    public static final String FILE_NAME = String.valueOf(JDIDebugUIPlugin.getDefault().getStateLocation().toOSString()) + File.separator + "stackTraceConsole.txt";
    private JavaStackTraceConsolePartitioner partitioner = new JavaStackTraceConsolePartitioner();
    private IPropertyChangeListener propertyListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            String property = event.getProperty();
            if (property.equals("org.eclipse.debug.ui.consoleFont")) {
                JavaStackTraceConsole.this.setFont(JFaceResources.getFont((String)"org.eclipse.debug.ui.consoleFont"));
            }
        }
    };

    public JavaStackTraceConsole() {
        super(ConsoleMessages.JavaStackTraceConsoleFactory_0, CONSOLE_TYPE, null, true);
        Font font = JFaceResources.getFont((String)"org.eclipse.debug.ui.consoleFont");
        this.setFont(font);
        this.partitioner.connect(this.getDocument());
    }

    void initializeDocument() {
        File file = new File(FILE_NAME);
        if (file.exists()) {
            try {
                Throwable throwable = null;
                Object var3_4 = null;
                try (BufferedInputStream fin = new BufferedInputStream(new FileInputStream(file));){
                    int len = (int)file.length();
                    byte[] b = new byte[len];
                    int read = 0;
                    while (read < len) {
                        read += ((InputStream)fin).read(b);
                    }
                    this.getDocument().set(new String(b));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
        } else {
            this.getDocument().set(ConsoleMessages.JavaStackTraceConsole_0);
        }
    }

    protected void init() {
        JFaceResources.getFontRegistry().addListener(this.propertyListener);
    }

    protected void dispose() {
        this.saveDocument();
        JFaceResources.getFontRegistry().removeListener(this.propertyListener);
        super.dispose();
    }

    void saveDocument() {
        try {
            Throwable throwable = null;
            Object var2_3 = null;
            try (FileOutputStream fout = new FileOutputStream(FILE_NAME);){
                IDocument document = this.getDocument();
                if (document != null) {
                    if (document.getLength() > 0) {
                        String contents = document.get();
                        fout.write(contents.getBytes());
                    } else {
                        File file = new File(FILE_NAME);
                        file.delete();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
    }

    protected IConsoleDocumentPartitioner getPartitioner() {
        return this.partitioner;
    }

    public String getHelpContextId() {
        return IJavaDebugHelpContextIds.STACK_TRACE_CONSOLE;
    }

    public IPageBookViewPage createPage(IConsoleView view) {
        return new JavaStackTraceConsolePage(this, view);
    }

    public void format() {
        WorkbenchJob job = new WorkbenchJob(ConsoleMessages.JavaStackTraceConsole_1){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IJobManager jobManager = Job.getJobManager();
                try {
                    jobManager.join((Object)this, monitor);
                }
                catch (OperationCanceledException operationCanceledException) {
                    return Status.CANCEL_STATUS;
                }
                catch (InterruptedException interruptedException) {
                    return Status.CANCEL_STATUS;
                }
                IDocument document = JavaStackTraceConsole.this.getDocument();
                String orig = document.get();
                if (orig != null && orig.length() > 0) {
                    document.set(JavaStackTraceConsole.this.format(orig));
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private String format(String trace) {
        StringTokenizer tokenizer = new StringTokenizer(trace, " \t\n\r\f", true);
        StringBuffer formattedTrace = new StringBuffer();
        boolean insideAt = false;
        boolean newLine = true;
        int pendingSpaces = 0;
        boolean antTrace = false;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.length() == 0) continue;
            char c = token.charAt(0);
            switch (c) {
                case ' ': {
                    if (newLine) {
                        ++pendingSpaces;
                        break;
                    }
                    pendingSpaces = 1;
                    break;
                }
                case '\t': {
                    if (newLine) {
                        pendingSpaces += 4;
                        break;
                    }
                    pendingSpaces = 1;
                    break;
                }
                case '\n': 
                case '\f': 
                case '\r': {
                    if (insideAt) {
                        pendingSpaces = 1;
                        break;
                    }
                    pendingSpaces = 0;
                    newLine = true;
                    break;
                }
                default: {
                    if (newLine || antTrace) {
                        if (c == '\"') {
                            formattedTrace.append("\n\n");
                        } else {
                            if ("-".equals(token)) {
                                formattedTrace.append("\n");
                                formattedTrace.append("    ");
                                formattedTrace.append(token);
                                pendingSpaces = 0;
                                break;
                            }
                            if ("at".equals(token)) {
                                if (!antTrace) {
                                    formattedTrace.append("\n");
                                    formattedTrace.append("    ");
                                } else {
                                    formattedTrace.append(' ');
                                }
                                insideAt = true;
                                formattedTrace.append(token);
                                pendingSpaces = 0;
                                break;
                            }
                            if (c == '[') {
                                if (antTrace) {
                                    formattedTrace.append("\n");
                                }
                                formattedTrace.append(token);
                                pendingSpaces = 0;
                                newLine = false;
                                antTrace = true;
                                break;
                            }
                        }
                        newLine = false;
                    }
                    if (pendingSpaces > 0) {
                        int i = 0;
                        while (i < pendingSpaces) {
                            formattedTrace.append(' ');
                            ++i;
                        }
                        pendingSpaces = 0;
                    }
                    formattedTrace.append(token);
                    insideAt = false;
                }
            }
        }
        return formattedTrace.toString();
    }

    class JavaStackTraceConsolePartitioner
    extends FastPartitioner
    implements IConsoleDocumentPartitioner {
        public JavaStackTraceConsolePartitioner() {
            super((IPartitionTokenScanner)new RuleBasedPartitionScanner(), null);
            JavaStackTraceConsole.this.getDocument().setDocumentPartitioner((IDocumentPartitioner)this);
        }

        public boolean isReadOnly(int offset) {
            return false;
        }

        public StyleRange[] getStyleRanges(int offset, int length) {
            return null;
        }
    }
}

