/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.adaptors;

import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.service.weaving.CacheEntry;
import org.eclipse.equinox.service.weaving.ICachingService;
import org.eclipse.equinox.service.weaving.IWeavingService;
import org.eclipse.equinox.weaving.adaptors.Debug;
import org.eclipse.equinox.weaving.adaptors.IWeavingAdaptor;
import org.eclipse.equinox.weaving.adaptors.WeavingAdaptorFactory;
import org.eclipse.equinox.weaving.hooks.WeavingBundleFile;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.internal.loader.ModuleClassLoader;
import org.eclipse.osgi.storage.BundleInfo;
import org.eclipse.osgi.storage.bundlefile.BundleFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleRevision;

public class WeavingAdaptor
implements IWeavingAdaptor {
    private static ThreadLocalSet identifyRecursionSet = new ThreadLocalSet();
    private Bundle bundle;
    private ICachingService cachingService;
    private final WeavingAdaptorFactory factory;
    private final BundleInfo.Generation generation;
    private boolean initialized = false;
    private final ModuleClassLoader moduleLoader;
    private final String symbolicName;
    private IWeavingService weavingService;

    public WeavingAdaptor(BundleInfo.Generation generation, WeavingAdaptorFactory weavingAdaptorFactory, IWeavingService iWeavingService, ICachingService iCachingService, ModuleClassLoader moduleClassLoader) {
        this.generation = generation;
        this.factory = weavingAdaptorFactory;
        this.symbolicName = generation.getRevision().getSymbolicName();
        this.moduleLoader = moduleClassLoader;
        if (Debug.DEBUG_GENERAL) {
            Debug.println("- WeavingAdaptor.WeavingAdaptor() bundle=" + this.symbolicName);
        }
    }

    @Override
    public CacheEntry findClass(String string, URL uRL) {
        if (Debug.DEBUG_CACHE) {
            Debug.println("> WeavingAdaptor.findClass() bundle=" + this.symbolicName + ", url=" + uRL + ", name=" + string);
        }
        CacheEntry cacheEntry = null;
        this.initialize();
        if (this.cachingService != null) {
            cacheEntry = this.cachingService.findStoredClass("", uRL, string);
        }
        if (Debug.DEBUG_CACHE) {
            Debug.println("< WeavingAdaptor.findClass() cacheEntry=" + cacheEntry);
        }
        return cacheEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() {
        WeavingAdaptor weavingAdaptor = this;
        synchronized (weavingAdaptor) {
            if (this.initialized) {
                return;
            }
            this.bundle = this.generation.getRevision().getBundle();
            if (!identifyRecursionSet.contains(this)) {
                identifyRecursionSet.put(this);
                if (Debug.DEBUG_GENERAL) {
                    Debug.println("> WeavingAdaptor.initialize() bundle=" + this.symbolicName + ", moduleLoader=" + this.moduleLoader);
                }
                if (this.symbolicName.startsWith("org.aspectj")) {
                    if (Debug.DEBUG_GENERAL) {
                        Debug.println("- WeavingAdaptor.initialize() symbolicName=" + this.symbolicName + ", moduleLoader=" + this.moduleLoader);
                    }
                } else if (this.moduleLoader != null) {
                    this.weavingService = this.factory.getWeavingService(this.moduleLoader);
                    this.cachingService = this.factory.getCachingService(this.moduleLoader, this.bundle, this.weavingService);
                } else if ((this.generation.getRevision().getTypes() & 1) != 0) {
                    BundleInfo.Generation generation;
                    BundleFile bundleFile;
                    Bundle bundle = this.factory.getHost(this.bundle);
                    if (Debug.DEBUG_GENERAL) {
                        Debug.println("- WeavingAdaptor.initialize() symbolicName=" + this.symbolicName + ", host=" + bundle);
                    }
                    if ((bundleFile = (generation = (BundleInfo.Generation)((ModuleRevision)bundle.adapt(BundleRevision.class)).getRevisionInfo()).getBundleFile()) instanceof WeavingBundleFile) {
                        WeavingBundleFile weavingBundleFile = (WeavingBundleFile)bundleFile;
                        WeavingAdaptor weavingAdaptor2 = (WeavingAdaptor)weavingBundleFile.getAdaptor();
                        this.weavingService = weavingAdaptor2.weavingService;
                        this.cachingService = this.factory.getCachingService(weavingAdaptor2.moduleLoader, this.bundle, this.weavingService);
                    }
                } else if (Debug.DEBUG_GENERAL) {
                    Debug.println("W WeavingAdaptor.initialize() symbolicName=" + this.symbolicName + ", baseLoader=" + this.moduleLoader);
                }
                this.initialized = true;
                identifyRecursionSet.remove(this);
            }
            if (Debug.DEBUG_GENERAL) {
                Debug.println("< WeavingAdaptor.initialize() weavingService=" + (this.weavingService != null) + ", cachingService=" + (this.cachingService != null));
            }
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public boolean storeClass(String string, URL uRL, Class<?> clazz, byte[] byArray) {
        if (Debug.DEBUG_CACHE) {
            Debug.println("> WeavingAdaptor.storeClass() bundle=" + this.symbolicName + ", url=" + uRL + ", name=" + string + ", clazz=" + clazz);
        }
        boolean bl = false;
        this.initialize();
        if (this.cachingService != null) {
            if (this.weavingService != null && this.weavingService.generatedClassesExistFor((ClassLoader)this.moduleLoader, string)) {
                if (this.cachingService.canCacheGeneratedClasses()) {
                    Map<String, byte[]> map = this.weavingService.getGeneratedClassesFor(string);
                    bl = this.cachingService.storeClassAndGeneratedClasses("", uRL, clazz, byArray, map);
                } else {
                    this.weavingService.flushGeneratedClasses((ClassLoader)this.moduleLoader);
                    if (Debug.DEBUG_CACHE) {
                        Debug.println("- WeavingAdaptor.storeClass() generatedClassesExistFor=true");
                    }
                }
            } else {
                bl = this.cachingService.storeClass("", uRL, clazz, byArray);
                if (!bl && Debug.DEBUG_CACHE) {
                    Debug.println("E WeavingAdaptor.storeClass() bundle=" + this.symbolicName + ", name=" + string);
                }
            }
        }
        if (Debug.DEBUG_CACHE) {
            Debug.println("< WeavingAdaptor.storeClass() stored=" + bl);
        }
        return bl;
    }

    public String toString() {
        return "WeavingAdaptor[" + this.symbolicName + "]";
    }

    @Override
    public byte[] weaveClass(String string, byte[] byArray) {
        if (Debug.DEBUG_WEAVE) {
            Debug.println("> WeavingAdaptor.weaveClass() bundle=" + this.symbolicName + ", name=" + string + ", bytes=" + byArray.length);
        }
        byte[] byArray2 = null;
        this.initialize();
        if (this.weavingService != null) {
            try {
                byArray2 = this.weavingService.preProcess(string, byArray, (ClassLoader)this.moduleLoader);
            }
            catch (IOException iOException) {
                throw new ClassFormatError(iOException.toString());
            }
        }
        if (Debug.DEBUG_WEAVE) {
            Debug.println("< WeavingAdaptor.weaveClass() newBytes=" + byArray2);
        }
        return byArray2;
    }

    private static class ThreadLocalSet
    extends ThreadLocal<Set<Object>> {
        private ThreadLocalSet() {
        }

        public boolean contains(Object object) {
            Set set = (Set)this.get();
            return set.contains(object);
        }

        @Override
        protected Set<Object> initialValue() {
            return new HashSet<Object>();
        }

        public void put(Object object) {
            Set set = (Set)this.get();
            if (set.contains(object)) {
                throw new RuntimeException(object.toString());
            }
            set.add(object);
        }

        public void remove(Object object) {
            Set set = (Set)this.get();
            if (!set.contains(object)) {
                throw new RuntimeException(object.toString());
            }
            set.remove(object);
        }
    }
}

