/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.reorg;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameFieldProcessor;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.reorg.RenameInputWizardPage;
import org.eclipse.jdt.internal.ui.refactoring.reorg.RenameRefactoringWizard;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class RenameFieldWizard
extends RenameRefactoringWizard {
    public RenameFieldWizard(Refactoring refactoring) {
        super(refactoring, RefactoringMessages.RenameFieldWizard_defaultPageTitle, RefactoringMessages.RenameFieldWizard_inputPage_description, JavaPluginImages.DESC_WIZBAN_REFACTOR_FIELD, "org.eclipse.jdt.ui.rename_field_wizard_page_context");
    }

    @Override
    protected RenameInputWizardPage createInputPage(String message, String initialSetting) {
        return new RenameFieldInputWizardPage(message, "org.eclipse.jdt.ui.rename_field_wizard_page_context", initialSetting){

            @Override
            protected RefactoringStatus validateTextField(String text) {
                RefactoringStatus result = RenameFieldWizard.this.validateNewName(text);
                this.updateGetterSetterLabels();
                return result;
            }
        };
    }

    private static class RenameFieldInputWizardPage
    extends RenameInputWizardPage {
        private Button fRenameGetter;
        private Button fRenameSetter;
        private String fGetterRenamingErrorMessage;
        private String fSetterRenamingErrorMessage;

        public RenameFieldInputWizardPage(String message, String contextHelpId, String initialValue) {
            super(message, contextHelpId, true, initialValue);
        }

        @Override
        public void createControl(Composite parent) {
            super.createControl(parent);
            Composite parentComposite = (Composite)this.getControl();
            Composite composite = new Composite(parentComposite, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(1808));
            Label separator = new Label(composite, 258);
            separator.setLayoutData((Object)new GridData(768));
            this.getGetterSetterRenamingEnablement();
            this.fRenameGetter = new Button(composite, 32);
            boolean getterEnablement = this.fGetterRenamingErrorMessage == null;
            this.fRenameGetter.setEnabled(getterEnablement);
            boolean getterSelection = getterEnablement && this.getBooleanSetting("renameGetter", this.getRenameFieldProcessor().getRenameGetter());
            this.fRenameGetter.setSelection(getterSelection);
            this.getRenameFieldProcessor().setRenameGetter(getterSelection);
            this.fRenameGetter.setLayoutData((Object)new GridData(768));
            this.fRenameGetter.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RenameFieldInputWizardPage.this.getRenameFieldProcessor().setRenameGetter(RenameFieldInputWizardPage.this.fRenameGetter.getSelection());
                    RenameFieldInputWizardPage.this.updateLeaveDelegateCheckbox(RenameFieldInputWizardPage.this.getRenameFieldProcessor().getDelegateCount());
                }
            });
            this.fRenameSetter = new Button(composite, 32);
            boolean setterEnablement = this.fSetterRenamingErrorMessage == null;
            this.fRenameSetter.setEnabled(setterEnablement);
            boolean setterSelection = setterEnablement && this.getBooleanSetting("renameSetter", this.getRenameFieldProcessor().getRenameSetter());
            this.fRenameSetter.setSelection(setterSelection);
            this.getRenameFieldProcessor().setRenameSetter(setterSelection);
            this.fRenameSetter.setLayoutData((Object)new GridData(768));
            this.fRenameSetter.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RenameFieldInputWizardPage.this.getRenameFieldProcessor().setRenameSetter(RenameFieldInputWizardPage.this.fRenameSetter.getSelection());
                    RenameFieldInputWizardPage.this.updateLeaveDelegateCheckbox(RenameFieldInputWizardPage.this.getRenameFieldProcessor().getDelegateCount());
                }
            });
            this.updateGetterSetterLabels();
            this.updateLeaveDelegateCheckbox(this.getRenameFieldProcessor().getDelegateCount());
            Dialog.applyDialogFont((Control)composite);
        }

        @Override
        public void dispose() {
            if (this.saveSettings()) {
                if (this.fRenameGetter.isEnabled()) {
                    this.saveBooleanSetting("renameGetter", this.fRenameGetter);
                }
                if (this.fRenameSetter.isEnabled()) {
                    this.saveBooleanSetting("renameSetter", this.fRenameSetter);
                }
            }
            super.dispose();
        }

        private void getGetterSetterRenamingEnablement() {
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    RenameFieldInputWizardPage.this.checkGetterRenamingEnablement();
                    RenameFieldInputWizardPage.this.checkSetterRenamingEnablement();
                }
            });
        }

        protected void updateGetterSetterLabels() {
            this.fRenameGetter.setText(this.getRenameGetterLabel());
            this.fRenameSetter.setText(this.getRenameSetterLabel());
        }

        private String getRenameGetterLabel() {
            String defaultLabel = RefactoringMessages.RenameFieldInputWizardPage_rename_getter;
            if (this.fGetterRenamingErrorMessage != null) {
                return this.constructDisabledGetterRenamingLabel(defaultLabel);
            }
            try {
                IMethod getter = this.getRenameFieldProcessor().getGetter();
                if (getter == null || !getter.exists()) {
                    return defaultLabel;
                }
                String oldGetterName = BasicElementLabels.getJavaElementName(getter.getElementName());
                String newGetterName = BasicElementLabels.getJavaElementName(this.createNewGetterName());
                return Messages.format(RefactoringMessages.RenameFieldInputWizardPage_rename_getter_to, new String[]{oldGetterName, newGetterName});
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
                return defaultLabel;
            }
        }

        private String getRenameSetterLabel() {
            String defaultLabel = RefactoringMessages.RenameFieldInputWizardPage_rename_setter;
            if (this.fSetterRenamingErrorMessage != null) {
                return this.constructDisabledSetterRenamingLabel(defaultLabel);
            }
            try {
                IMethod setter = this.getRenameFieldProcessor().getSetter();
                if (setter == null || !setter.exists()) {
                    return defaultLabel;
                }
                String oldSetterName = BasicElementLabels.getJavaElementName(setter.getElementName());
                String newSetterName = BasicElementLabels.getJavaElementName(this.createNewSetterName());
                return Messages.format(RefactoringMessages.RenameFieldInputWizardPage_rename_setter_to, new String[]{oldSetterName, newSetterName});
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
                return defaultLabel;
            }
        }

        private String constructDisabledSetterRenamingLabel(String defaultLabel) {
            if (this.fSetterRenamingErrorMessage.equals("")) {
                return defaultLabel;
            }
            Object[] keys = new String[]{defaultLabel, this.fSetterRenamingErrorMessage};
            return Messages.format(RefactoringMessages.RenameFieldInputWizardPage_setter_label, keys);
        }

        private String constructDisabledGetterRenamingLabel(String defaultLabel) {
            if (this.fGetterRenamingErrorMessage.equals("")) {
                return defaultLabel;
            }
            Object[] keys = new String[]{defaultLabel, this.fGetterRenamingErrorMessage};
            return Messages.format(RefactoringMessages.RenameFieldInputWizardPage_getter_label, keys);
        }

        private String createNewGetterName() throws CoreException {
            return this.getRenameFieldProcessor().getNewGetterName();
        }

        private String createNewSetterName() throws CoreException {
            return this.getRenameFieldProcessor().getNewSetterName();
        }

        private String checkGetterRenamingEnablement() {
            if (this.fGetterRenamingErrorMessage != null) {
                return this.fGetterRenamingErrorMessage;
            }
            try {
                this.fGetterRenamingErrorMessage = this.getRenameFieldProcessor().canEnableGetterRenaming();
                return this.fGetterRenamingErrorMessage;
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
                return "";
            }
        }

        private String checkSetterRenamingEnablement() {
            if (this.fSetterRenamingErrorMessage != null) {
                return this.fSetterRenamingErrorMessage;
            }
            try {
                this.fSetterRenamingErrorMessage = this.getRenameFieldProcessor().canEnableSetterRenaming();
                return this.fSetterRenamingErrorMessage;
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
                return "";
            }
        }

        private RenameFieldProcessor getRenameFieldProcessor() {
            return (RenameFieldProcessor)((RenameRefactoring)this.getRefactoring()).getProcessor();
        }
    }
}

