/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.OpenBrowserUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class OpenAttachedJavadocAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;
    private Shell fShell;

    public OpenAttachedJavadocAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.OpenAttachedJavadocAction_label);
        this.setDescription(ActionMessages.OpenAttachedJavadocAction_description);
        this.setToolTipText(ActionMessages.OpenAttachedJavadocAction_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.open_attached_javadoc_action");
    }

    public OpenAttachedJavadocAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    @Override
    public void selectionChanged(ITextSelection selection) {
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.canEnableFor(selection));
    }

    protected boolean canEnableFor(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return false;
        }
        return selection.getFirstElement() instanceof IJavaElement;
    }

    @Override
    public void run(ITextSelection selection) {
        ITypeRoot element = SelectionConverter.getInput(this.fEditor);
        if (!ActionUtil.isProcessable(this.getShell(), (IJavaElement)element)) {
            return;
        }
        try {
            IJavaElement[] elements = SelectionConverter.codeResolveOrInputForked(this.fEditor);
            if (elements == null || elements.length == 0) {
                return;
            }
            IJavaElement candidate = elements[0];
            if (elements.length > 1) {
                candidate = SelectionConverter.selectJavaElement(elements, this.getShell(), this.getDialogTitle(), ActionMessages.OpenAttachedJavadocAction_select_element);
            }
            if (candidate != null) {
                this.run(candidate);
            }
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), this.getDialogTitle(), ActionMessages.OpenAttachedJavadocAction_code_resolve_failed);
        }
        catch (InterruptedException interruptedException) {}
    }

    @Override
    public void run(IStructuredSelection selection) {
        if (!this.canEnableFor(selection)) {
            return;
        }
        IJavaElement element = (IJavaElement)selection.getFirstElement();
        if (!ActionUtil.isProcessable(this.getShell(), element)) {
            return;
        }
        this.run(element);
    }

    protected void run(IJavaElement element) {
        if (element == null) {
            return;
        }
        Shell shell = this.getShell();
        try {
            String labelName = JavaElementLabels.getElementLabel(element, JavaElementLabels.ALL_DEFAULT);
            URL baseURL = JavaUI.getJavadocBaseLocation(element);
            if (baseURL == null) {
                IPackageFragmentRoot root = JavaModelUtil.getPackageFragmentRoot(element);
                if (root != null && root.getKind() == 2) {
                    String message = ActionMessages.OpenAttachedJavadocAction_libraries_no_location;
                    OpenAttachedJavadocAction.showMessage(shell, Messages.format(message, new String[]{labelName, JavaElementLabels.getElementLabel((IJavaElement)root, JavaElementLabels.ALL_DEFAULT)}), false);
                } else {
                    IJavaProject annotatedElement = element.getJavaProject();
                    String message = ActionMessages.OpenAttachedJavadocAction_source_no_location;
                    OpenAttachedJavadocAction.showMessage(shell, Messages.format(message, new String[]{labelName, JavaElementLabels.getElementLabel((IJavaElement)annotatedElement, JavaElementLabels.ALL_DEFAULT)}), false);
                }
                return;
            }
            URL url = JavaUI.getJavadocLocation(element, true);
            if (url != null) {
                this.open(url);
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
            OpenAttachedJavadocAction.showMessage(shell, ActionMessages.OpenAttachedJavadocAction_opening_failed, true);
        }
    }

    protected void open(URL url) {
        if (this.forceExternalBrowser()) {
            OpenBrowserUtil.openExternal(url, this.getShell().getDisplay());
        } else {
            OpenBrowserUtil.open(url, this.getShell().getDisplay());
        }
    }

    boolean forceExternalBrowser() {
        return false;
    }

    private static void showMessage(final Shell shell, final String message, final boolean isError) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (isError) {
                    MessageDialog.openError((Shell)shell, (String)OpenAttachedJavadocAction.getTitle(), (String)message);
                } else {
                    MessageDialog.openInformation((Shell)shell, (String)OpenAttachedJavadocAction.getTitle(), (String)message);
                }
            }
        });
    }

    private static String getTitle() {
        return ActionMessages.OpenAttachedJavadocAction_dialog_title;
    }

    protected String getDialogTitle() {
        return OpenAttachedJavadocAction.getTitle();
    }

    @Override
    public Shell getShell() {
        if (this.fShell != null) {
            return this.fShell;
        }
        return super.getShell();
    }
}

