/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.resources.viewers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.rcptt.core.internal.builder.Q7Builder;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.ui.internal.resources.WSValidators;
import org.eclipse.rcptt.workspace.WSLink;
import org.eclipse.swt.widgets.Display;

public class WSResourceDecorator
implements ILightweightLabelDecorator {
    private static final ImageDescriptor LINK = Images.getImageDescriptor((String)"icons/link-ovelay.gif");
    private static final ImageDescriptor BROKEN = Images.getImageDescriptor((String)"icons/link-broken.gif");
    Runnable buildListener = new Runnable(){

        @Override
        public void run() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    for (ILabelProviderListener listener : WSResourceDecorator.this.listeners) {
                        listener.labelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)WSResourceDecorator.this));
                    }
                }
            });
        }
    };
    private List<ILabelProviderListener> listeners = new ArrayList<ILabelProviderListener>();

    public synchronized void addListener(ILabelProviderListener listener) {
        if (this.listeners.size() == 0) {
            Q7Builder.addListener((Runnable)this.buildListener);
        }
        this.listeners.add(listener);
    }

    public void dispose() {
        Q7Builder.removeListener((Runnable)this.buildListener);
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public synchronized void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            Q7Builder.removeListener((Runnable)this.buildListener);
        }
    }

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof WSLink) {
            if (WSValidators.validateLink((WSLink)element, null, null)) {
                decoration.addOverlay(LINK, 3);
            } else {
                decoration.addOverlay(BROKEN, 3);
            }
        }
    }
}

