/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.controls;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.rcptt.core.ContextType;
import org.eclipse.rcptt.core.ContextTypeManager;
import org.eclipse.rcptt.core.Q7Features;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IElementChangedListener;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7ElementDelta;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.model.IQ7ProjectMetadata;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.Q7ElementChangedEvent;
import org.eclipse.rcptt.core.model.search.AllProjectScope;
import org.eclipse.rcptt.core.model.search.ISearchScope;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.core.scenario.Context;
import org.eclipse.rcptt.core.scenario.GroupContext;
import org.eclipse.rcptt.core.scenario.ScenarioPackage;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.core.model.Q7TestCase;
import org.eclipse.rcptt.internal.core.model.ReferencedProjectScope;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.commons.EObjectTable;
import org.eclipse.rcptt.ui.commons.NamedElementTransfer;
import org.eclipse.rcptt.ui.dialogs.ContextSelectionDialog;
import org.eclipse.rcptt.ui.editors.NamedElementLabelProvider;
import org.eclipse.rcptt.ui.launching.LaunchUtils;
import org.eclipse.rcptt.ui.recording.RecordingSupport;
import org.eclipse.rcptt.ui.utils.WorkbenchUtils;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ResourceTransfer;

public class ContextsTable
extends EObjectTable {
    private final IElementChangedListener workspaceMonitorListener = new IElementChangedListener(){

        private void refreshTable(IQ7NamedElement[] elements) {
            if (ContextsTable.this.viewer == null || ContextsTable.this.getControl() == null || ContextsTable.this.getControl().isDisposed()) {
                return;
            }
            boolean needRefresh = false;
            if (elements == null) {
                needRefresh = true;
            } else {
                IQ7NamedElement testCase = ContextsTable.this.getContent();
                String[] contexts = null;
                if (contexts == null && testCase instanceof ITestCase) {
                    try {
                        contexts = ((ITestCase)testCase).getContexts();
                    }
                    catch (ModelException modelException) {
                        needRefresh = true;
                    }
                }
                if (contexts == null && testCase instanceof IQ7ProjectMetadata) {
                    try {
                        contexts = ((IQ7ProjectMetadata)testCase).getContexts();
                    }
                    catch (ModelException modelException) {
                        needRefresh = true;
                    }
                }
                try {
                    EList list;
                    if (contexts == null && testCase instanceof IContext && testCase.getNamedElement() instanceof GroupContext && (list = ((GroupContext)ContextsTable.this.getContent().getNamedElement()).getContextReferences()) != null) {
                        contexts = (String[])list.toArray((Object[])new String[list.size()]);
                    }
                }
                catch (Exception exception) {
                    needRefresh = true;
                }
                ArrayList<String> lc = new ArrayList<String>();
                if (contexts != null) {
                    lc.addAll(Arrays.asList(contexts));
                }
                IQ7NamedElement[] iQ7NamedElementArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IQ7NamedElement element = iQ7NamedElementArray[n2];
                    try {
                        String elementID = Q7SearchCore.findIDByDocument((IQ7Element)element);
                        if (elementID == null) {
                            elementID = element.getID();
                        }
                        if (needRefresh = lc.contains(elementID)) {
                            break;
                        }
                    }
                    catch (ModelException modelException) {
                        needRefresh = true;
                    }
                    ++n2;
                }
            }
            if (needRefresh) {
                ContextsTable.this.refresh();
            }
        }

        private IQ7NamedElement findRenamed(IQ7ElementDelta delta, IQ7NamedElement element) {
            IQ7ElementDelta[] deltas;
            if (delta.getElement() instanceof ITestCase) {
                Q7TestCase test = (Q7TestCase)delta.getElement();
                if ((delta.getFlags() & 0x10) != 0 && delta.getMovedFromElement().getPath().equals((Object)element.getPath())) {
                    return test;
                }
            }
            IQ7ElementDelta[] iQ7ElementDeltaArray = deltas = delta.getAffectedChildren();
            int n = deltas.length;
            int n2 = 0;
            while (n2 < n) {
                IQ7ElementDelta d = iQ7ElementDeltaArray[n2];
                IQ7NamedElement result = this.findRenamed(d, element);
                if (result != null) {
                    return result;
                }
                ++n2;
            }
            return null;
        }

        public void elementChanged(Q7ElementChangedEvent event) {
            IQ7ElementDelta[] elementDeltas;
            IQ7ElementDelta delta = event.getDelta();
            IQ7NamedElement newContent = this.findRenamed(delta, ContextsTable.this.getContent());
            if (newContent != null) {
                ContextsTable.this.setContent(newContent);
            }
            IQ7ElementDelta[] iQ7ElementDeltaArray = elementDeltas = event.getDelta().getAffectedChildren();
            int n = elementDeltas.length;
            int n2 = 0;
            while (n2 < n) {
                IQ7ElementDelta iq7ElementDelta = iQ7ElementDeltaArray[n2];
                if (iq7ElementDelta.getElement() instanceof IQ7Project && (iq7ElementDelta.getFlags() & 0x80000) != 0) {
                    ContextsTable.this.updateProjectContextsList();
                    this.refreshTable(null);
                    return;
                }
                ++n2;
            }
            IQ7NamedElement[] elements = event.getDelta().getNamedElements();
            this.refreshTable(elements);
        }
    };
    private IProject project;
    private boolean showProjectContexts = true;
    private static NamedElementTransfer TRANSFER = null;
    private IQ7NamedElement namedElement;
    private EList<String> projectContexts = new BasicEList();
    private String contextFilter = null;

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)new Action("&Open"){

            public void run() {
                ContextsTable.this.doOpen((IStructuredSelection)ContextsTable.this.viewer.getSelection());
            }
        });
        final Action runAction = new Action("&Run"){
            {
                this.setToolTipText(Messages.RunSelectedAction_ToolTip);
                this.setText("&Run");
                this.setImageDescriptor(Images.getImageDescriptor("icons/recording/play.gif"));
                this.setDisabledImageDescriptor(Images.getImageDescriptor("icons/recording/d_play.gif"));
            }

            public void run() {
                ContextsTable.this.doRun((IStructuredSelection)ContextsTable.this.viewer.getSelection());
            }
        };
        this.observeRecordingMode().addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                ContextsTable.this.updateRunAction(runAction);
            }
        });
        manager.add((IAction)runAction);
        this.updateRunAction(runAction);
        super.fillContextMenu(manager);
    }

    protected void doRun(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            ArrayList<IResource> resources = new ArrayList<IResource>();
            for (String elementId : selection) {
                IQ7NamedElement element = this.getContentsElementById(elementId);
                if (element == null) continue;
                resources.add(element.getResource());
            }
            if (resources.size() > 0) {
                LaunchUtils.launchContext(resources.toArray(new IResource[resources.size()]), "run", false);
            }
        }
    }

    public ContextsTable(IQ7NamedElement content, EStructuralFeature feature, boolean showProjectContexts) throws ModelException {
        super((EObject)content.getNamedElement(), feature);
        this.showProjectContexts = showProjectContexts;
        this.namedElement = content;
        this.updateProjectContextsList();
    }

    @Override
    protected List<Object> getViewerContents() {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.showProjectContexts) {
            result.addAll((Collection<Object>)this.projectContexts);
        }
        result.addAll((Collection<Object>)this.getContexts());
        return result;
    }

    private void updateProjectContextsList() {
        if (!this.showProjectContexts) {
            return;
        }
        try {
            String[] ctxs;
            IQ7ProjectMetadata metadata;
            IQ7Project prj = this.namedElement.getQ7Project();
            if (prj != null && (metadata = prj.getMetadata()) != null && metadata.exists() && (ctxs = metadata.getContexts()) != null) {
                this.projectContexts.clear();
                this.projectContexts.addAll(Arrays.asList(ctxs));
            }
        }
        catch (ModelException e) {
            Q7UIPlugin.log(e);
        }
    }

    public ContextsTable(ITestCase scenario) throws ModelException {
        this((IQ7NamedElement)scenario, (EStructuralFeature)ScenarioPackage.Literals.SCENARIO__CONTEXTS, true);
        RcpttCore.addElementChangedListener((IElementChangedListener)this.workspaceMonitorListener);
    }

    public ContextsTable(IQ7ProjectMetadata metadata) throws ModelException {
        this((IQ7NamedElement)metadata, (EStructuralFeature)ScenarioPackage.Literals.PROJECT_METADATA__CONTEXTS, false);
        RcpttCore.addElementChangedListener((IElementChangedListener)this.workspaceMonitorListener);
    }

    public ContextsTable(IContext context) throws ModelException {
        this((IQ7NamedElement)context, (EStructuralFeature)ScenarioPackage.Literals.GROUP_CONTEXT__CONTEXT_REFERENCES, false);
        RcpttCore.addElementChangedListener((IElementChangedListener)this.workspaceMonitorListener);
    }

    public IQ7NamedElement getContent() {
        return this.namedElement;
    }

    protected void setContent(IQ7NamedElement content) {
        this.namedElement = content;
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ContextsTable.this.doOpen(selection);
            }
        });
        this.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                RcpttCore.removeElementChangedListener((IElementChangedListener)ContextsTable.this.workspaceMonitorListener);
            }
        });
        this.createProjectContexts(parent);
    }

    @Override
    protected Transfer getContentTransfer() {
        if (TRANSFER == null) {
            TRANSFER = new NamedElementTransfer();
        }
        return TRANSFER;
    }

    @Override
    protected boolean allowDrag(IStructuredSelection selection) {
        if (!super.allowDrag(selection)) {
            return false;
        }
        Object element = selection.getFirstElement();
        if (element == null || !(element instanceof String)) {
            return false;
        }
        return !this.projectContexts.contains(element);
    }

    @Override
    protected boolean doPerformDrop(Object data, Object currentTarget, int currentLocation) {
        if (data instanceof IResource[]) {
            IResource[] resources = (IResource[])data;
            EList<Object> content = this.getContents();
            int targetPosition = content.size() - 1;
            if (currentTarget != null) {
                targetPosition = content.indexOf(currentTarget);
            }
            if (currentLocation == 2 || currentLocation == 4) {
                ++targetPosition;
            }
            EList<Object> contents = this.getContents();
            ArrayList<String> newContents = new ArrayList<String>();
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                IQ7NamedElement element = this.getNamedElementByResource(resource);
                if (this.isValidToAdd(element)) {
                    try {
                        newContents.add(element.getID());
                    }
                    catch (ModelException e) {
                        Q7UIPlugin.log(e);
                    }
                }
                ++n2;
            }
            if (targetPosition != -1) {
                contents.addAll(targetPosition, newContents);
            } else {
                contents.addAll(newContents);
            }
            this.refresh();
            return true;
        }
        return super.doPerformDrop(data, currentTarget, currentLocation);
    }

    @Override
    protected boolean doValidateDrop(Object target, int operation, TransferData transferType, int currentLocation) {
        if (ResourceTransfer.getInstance().isSupportedType(transferType)) {
            IResource[] resources;
            IResource[] iResourceArray = resources = this.getSelectedResources();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                IQ7NamedElement element = this.getNamedElementByResource(resource);
                if (this.isValidToAdd(element)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return super.doValidateDrop(target, operation, transferType, currentLocation);
    }

    @Override
    protected Transfer[] getDropTransferTypes() {
        Transfer[] base = super.getDropTransferTypes();
        Transfer[] result = new Transfer[base.length + 1];
        int i = 0;
        while (i < base.length) {
            result[i] = base[i];
            ++i;
        }
        result[base.length] = ResourceTransfer.getInstance();
        return result;
    }

    private IResource[] getSelectedResources() {
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (selection instanceof IStructuredSelection) {
            return this.getSelectedResources((IStructuredSelection)selection);
        }
        return new IResource[0];
    }

    private IResource[] getSelectedResources(IStructuredSelection selection) {
        ArrayList<IResource> selectedResources = new ArrayList<IResource>();
        for (Object o : selection) {
            IAdaptable a;
            IResource r;
            if (o instanceof IResource) {
                selectedResources.add((IResource)o);
                continue;
            }
            if (!(o instanceof IAdaptable) || (r = (IResource)(a = (IAdaptable)o).getAdapter(IResource.class)) == null) continue;
            selectedResources.add(r);
        }
        return selectedResources.toArray(new IResource[selectedResources.size()]);
    }

    private IQ7NamedElement getNamedElementByResource(IResource resource) {
        IWorkspace workspace;
        IFile file;
        if (resource.getType() == 1 && (file = (workspace = ResourcesPlugin.getWorkspace()).getRoot().getFile(resource.getFullPath())) != null && file.exists()) {
            return (IQ7NamedElement)RcpttCore.create((IResource)file);
        }
        return null;
    }

    protected void doOpen(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return;
        }
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            String elementId = (String)element;
            this.openSingleContext(elementId);
            ++n2;
        }
    }

    protected void openSingleContext(String elementId) {
        IQ7NamedElement element = this.getContentsElementById(elementId);
        if (element != null) {
            try {
                IDE.openEditor((IWorkbenchPage)WorkbenchUtils.getPage(), (IFile)((IFile)element.getResource()));
            }
            catch (PartInitException e) {
                Q7UIPlugin.log(e);
            }
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    @Override
    public String getName() {
        return Messages.ContextsTable_Name;
    }

    @Override
    public Image getImage() {
        return Images.getImage("icons/context.gif");
    }

    public EList<String> getContexts() {
        return this.getContents();
    }

    @Override
    protected ILabelProvider createLabelProvider() {
        IQ7Project prj = this.getContent().getQ7Project();
        if (prj == null && this.project != null) {
            prj = RcpttCore.create((IProject)this.project);
        }
        NamedElementLabelProvider provider = new NamedElementLabelProvider(prj){

            @Override
            protected void addExtraAnnotation(IQ7NamedElement namedElement, StyledString styled, int rowIndex) {
                if (ContextsTable.this.showProjectContexts) {
                    if (rowIndex < ContextsTable.this.projectContexts.size()) {
                        styled.append(" - ");
                        styled.append("default context", StyledString.COUNTER_STYLER);
                    } else {
                        try {
                            if (ContextsTable.this.projectContexts.contains((Object)namedElement.getID())) {
                                styled.append(" - ");
                                styled.append("project default context conflict. Current context will be ignored", StyledString.DECORATIONS_STYLER);
                            }
                        }
                        catch (ModelException e) {
                            Q7UIPlugin.log(e);
                        }
                    }
                }
            }
        };
        return provider;
    }

    protected boolean isValidToAdd(IQ7NamedElement element) {
        block8: {
            IContext context;
            block9: {
                ContextType type;
                block7: {
                    block6: {
                        String[] ctx;
                        IQ7ProjectMetadata metadata;
                        IQ7Project q7Project = this.getContent().getQ7Project();
                        if (q7Project == null || (metadata = q7Project.getMetadata()) == null || !metadata.exists() || (ctx = metadata.getContexts()) == null || !Arrays.asList(ctx).contains(element.getID())) break block6;
                        return false;
                    }
                    if (!(this.getContent().getNamedElement() instanceof GroupContext)) break block7;
                    String id = Q7SearchCore.findIDByDocument((IQ7Element)element);
                    if (id == null) {
                        id = element.getID();
                    }
                    if (!this.getContent().getID().equals(id)) break block7;
                    return false;
                }
                if (element == null || !(element instanceof IContext)) break block8;
                context = (IContext)element;
                if (this.contextFilter == null || (type = ContextTypeManager.getInstance().getTypeByContext((Context)context.getNamedElement())) != null && type.getId().equals(this.contextFilter)) break block9;
                return false;
            }
            try {
                return !this.getContexts().contains((Object)context.getID());
            }
            catch (ModelException e) {
                Q7UIPlugin.log(e);
            }
        }
        return false;
    }

    protected String[] handleAdd() {
        ContextSelectionDialog dialog = new ContextSelectionDialog(this.getControl().getShell(), this.getContent(), this.project){

            @Override
            protected boolean isValidToAdd(IContext context) {
                return ContextsTable.this.isValidToAdd((IQ7NamedElement)context);
            }
        };
        int result = dialog.open();
        if (result == 0) {
            Object[] selected = dialog.getResult();
            ArrayList<String> list = new ArrayList<String>();
            if (selected != null) {
                int i = 0;
                while (i < selected.length) {
                    IContext context = (IContext)selected[i];
                    try {
                        String id = Q7SearchCore.findIDByDocument((IQ7Element)context);
                        if (id == null) {
                            id = context.getID();
                        }
                        list.add(id);
                    }
                    catch (ModelException e) {
                        Q7UIPlugin.log(e);
                    }
                    ++i;
                }
            }
            this.setVisible(true);
            return list.toArray(new String[list.size()]);
        }
        return null;
    }

    @Override
    protected Class<?> getContentsType() {
        return String.class;
    }

    @Override
    protected IQ7Element.HandleType getAppropriateHandleType() {
        return IQ7Element.HandleType.Context;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean canAdd(Object[] objects) {
        if (!super.canAdd(objects)) {
            return false;
        }
        IQ7NamedElement content = this.getContent();
        IFile iFile = (IFile)content.getResource();
        IQ7Project project = null;
        if (iFile != null) {
            project = RcpttCore.create((IProject)iFile.getProject());
        }
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            IQ7Element file;
            Object obj = objectArray[n2];
            String val = null;
            if (obj instanceof String) {
                val = (String)obj;
            }
            if (obj instanceof IResource && (file = RcpttCore.create((IResource)((IResource)obj))).getElementType().equals((Object)IQ7Element.HandleType.Context)) {
                try {
                    val = ((IContext)file).getID();
                }
                catch (ModelException e) {
                    Q7UIPlugin.log(e);
                }
            }
            if (val != null) {
                try {
                    IQ7NamedElement[] id;
                    List context;
                    List list = context = project != null ? project.find(IContext.class, val) : null;
                    if (context != null && context.size() > 0) {
                        if (this.contextFilter != null) {
                            for (IContext ctx : context) {
                                if (ctx.getType().getId().equals(this.contextFilter)) continue;
                                return false;
                            }
                        }
                        return true;
                    }
                    IQ7NamedElement[] iQ7NamedElementArray = id = Q7SearchCore.findById((String)val, (ISearchScope)new AllProjectScope(), (IProgressMonitor)new NullProgressMonitor());
                    int n3 = id.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IQ7NamedElement iq7NamedElement = iQ7NamedElementArray[n4];
                        if (iq7NamedElement instanceof IContext) {
                            return true;
                        }
                        ++n4;
                    }
                    return false;
                }
                catch (ModelException e) {
                    Q7UIPlugin.log(e);
                }
            }
            ++n2;
        }
        return true;
    }

    protected IQ7NamedElement getContentsElementById(String elementId) {
        IQ7NamedElement[] elts;
        IQ7Project contentProject = this.getContent().getQ7Project();
        ReferencedProjectScope scope = new ReferencedProjectScope(contentProject);
        if (contentProject == null) {
            scope = new AllProjectScope();
        }
        if ((elts = Q7SearchCore.findById((String)elementId, (ISearchScope)scope, (IProgressMonitor)new NullProgressMonitor())) != null && elts.length > 0) {
            return elts[0];
        }
        return null;
    }

    @Override
    public String getContentName(Object content) {
        try {
            IQ7Project group = this.getContent().getQ7Project();
            ArrayList<IContext> context = null;
            if (group == null) {
                IQ7NamedElement[] elements = Q7SearchCore.findById((String)((String)content), (ISearchScope)new AllProjectScope(), (IProgressMonitor)new NullProgressMonitor());
                context = new ArrayList<IContext>();
                IQ7NamedElement[] iQ7NamedElementArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IQ7NamedElement iq7NamedElement = iQ7NamedElementArray[n2];
                    if (iq7NamedElement instanceof IContext) {
                        context.add((IContext)iq7NamedElement);
                    }
                    ++n2;
                }
            } else {
                context = group.find(IContext.class, (String)content);
            }
            if (context.size() > 0) {
                String name = Q7SearchCore.findNameByDocument((IQ7Element)((IQ7Element)context.get(0)));
                if (name == null) {
                    return ((IContext)context.get(0)).getElementName();
                }
                return name;
            }
        }
        catch (ModelException e) {
            Q7UIPlugin.log(e);
        }
        return null;
    }

    private void createProjectContexts(Composite parent) {
        if (this.showProjectContexts && Q7Features.supportQ7OptionsFile) {
            Composite c = new Composite(parent, 0);
            GridLayoutFactory.fillDefaults().numColumns(2).margins(0, 0).applyTo(c);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)c);
            Link configure = new Link(c, 0);
            GridDataFactory.fillDefaults().grab(true, false).span(2, 1).align(131072, 0x1000000).applyTo((Control)configure);
            configure.setText("<a>Configure Project Default Contexts</a>");
            configure.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        IQ7ProjectMetadata md = ContextsTable.this.getContent().getQ7Project().getMetadata();
                        if (md.exists() && md.getResource() != null) {
                            IDE.openEditor((IWorkbenchPage)WorkbenchUtils.getPage(), (IFile)((IFile)md.getResource()));
                        }
                    }
                    catch (Exception ee) {
                        Q7UIPlugin.log(ee);
                    }
                }
            });
        }
    }

    @Override
    public void setVisible(boolean value) {
        super.setVisible(value);
        if (!value) {
            this.setSelection(new Object[0], false);
        }
    }

    @Override
    protected boolean disableToolBarOnHide() {
        return false;
    }

    private void updateRunAction(Action runAction) {
        RecordingSupport.RecordingMode mode = (RecordingSupport.RecordingMode)((Object)this.observeRecordingMode().getValue());
        runAction.setEnabled(mode.equals((Object)RecordingSupport.RecordingMode.Stopped));
    }

    public void setContextFilter(String contextFilter) {
        this.contextFilter = contextFilter;
    }
}

