/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.blame;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.AdapterUtils;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.blame.BlameInformationControlCreator;
import org.eclipse.egit.ui.internal.blame.BlameRevision;
import org.eclipse.egit.ui.internal.history.HistoryPageInput;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.revisions.IRevisionRulerColumn;
import org.eclipse.jface.text.revisions.IRevisionRulerColumnExtension;
import org.eclipse.jface.text.revisions.Revision;
import org.eclipse.jface.text.revisions.RevisionInformation;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jgit.api.BlameCommand;
import org.eclipse.jgit.blame.BlameResult;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.team.ui.history.RevisionAnnotationController;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;

public class BlameOperation
implements IEGitOperation {
    private Repository repository;
    private IStorage storage;
    private String path;
    private RevCommit startCommit;
    private Shell shell;
    private IWorkbenchPage page;
    private int lineNumberToReveal;

    public BlameOperation(Repository repository, IStorage storage, String path, RevCommit startCommit, Shell shell, IWorkbenchPage page) {
        this(repository, storage, path, startCommit, shell, page, -1);
    }

    public BlameOperation(Repository repository, IStorage storage, String path, RevCommit startCommit, Shell shell, IWorkbenchPage page, int lineNumberToReveal) {
        this.repository = repository;
        this.storage = storage;
        this.path = path;
        this.startCommit = startCommit;
        this.shell = shell;
        this.page = page;
        this.lineNumberToReveal = lineNumberToReveal;
    }

    public void execute(IProgressMonitor monitor) throws CoreException {
        BlameResult result;
        final RevisionInformation info = new RevisionInformation();
        BlameCommand command = new BlameCommand(this.repository).setFollowFileRenames(true).setFilePath(this.path);
        if (this.startCommit != null) {
            command.setStartCommit((AnyObjectId)this.startCommit);
        } else {
            try {
                command.setStartCommit((AnyObjectId)this.repository.resolve("HEAD"));
            }
            catch (IOException e) {
                Activator.error("Error resolving HEAD for showing annotations in repository: " + this.repository, e);
                return;
            }
        }
        if (Activator.getDefault().getPreferenceStore().getBoolean("Blame_IgnoreWhitespace")) {
            command.setTextComparator(RawTextComparator.WS_IGNORE_ALL);
        }
        try {
            result = command.call();
        }
        catch (Exception e1) {
            Activator.error(e1.getMessage(), e1);
            return;
        }
        if (result == null) {
            return;
        }
        HashMap<RevCommit, BlameRevision> revisions = new HashMap<RevCommit, BlameRevision>();
        int lineCount = result.getResultContents().size();
        BlameRevision previous = null;
        int i = 0;
        while (i < lineCount) {
            RevCommit commit = result.getSourceCommit(i);
            String sourcePath = result.getSourcePath(i);
            if (commit == null) {
                if (previous != null) {
                    previous.register();
                    previous = null;
                }
            } else {
                BlameRevision revision = (BlameRevision)((Object)revisions.get(commit));
                if (revision == null) {
                    revision = new BlameRevision();
                    revision.setRepository(this.repository);
                    revision.setCommit(commit);
                    revision.setSourcePath(sourcePath);
                    revisions.put(commit, revision);
                    info.addRevision((Revision)revision);
                }
                revision.addSourceLine(i, result.getSourceLine(i));
                if (previous != null) {
                    if (previous == revision) {
                        previous.addLine();
                    } else {
                        previous.register();
                        previous = revision.reset(i);
                    }
                } else {
                    previous = revision.reset(i);
                }
            }
            ++i;
        }
        if (previous != null) {
            previous.register();
        }
        if (this.shell.isDisposed()) {
            return;
        }
        this.shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                BlameOperation.this.openEditor(info);
            }
        });
    }

    private void openEditor(RevisionInformation info) {
        IRevisionRulerColumn revisionRuler;
        AbstractDecoratedTextEditor editor;
        try {
            editor = this.storage instanceof IFile ? RevisionAnnotationController.openEditor((IWorkbenchPage)this.page, (IFile)((IFile)this.storage)) : RevisionAnnotationController.openEditor((IWorkbenchPage)this.page, (Object)this.storage, (IStorage)this.storage);
        }
        catch (PartInitException e) {
            Activator.handleError("Error displaying blame annotations", e, false);
            return;
        }
        if (editor == null) {
            return;
        }
        try {
            IHistoryView part = (IHistoryView)this.page.showView("org.eclipse.team.ui.GenericHistoryView", null, 2);
            HistoryPageInput input = this.createHistoryPageInputWhenEditorOpened();
            part.showHistoryFor((Object)input);
        }
        catch (PartInitException e) {
            Activator.handleError("Error displaying blame annotations", e, false);
        }
        IVerticalRulerInfo rulerInfo = (IVerticalRulerInfo)AdapterUtils.adapt((Object)editor, IVerticalRulerInfo.class);
        BlameInformationControlCreator creator = new BlameInformationControlCreator(rulerInfo);
        info.setHoverControlCreator((IInformationControlCreator)creator);
        info.setInformationPresenterControlCreator((IInformationControlCreator)creator);
        editor.showRevisionInformation(info, "org.eclipse.egit.ui.internal.decorators.GitQuickDiffProvider");
        if (this.lineNumberToReveal >= 0) {
            IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
            try {
                int offset = document.getLineOffset(this.lineNumberToReveal);
                editor.selectAndReveal(offset, 0);
            }
            catch (BadLocationException e) {
                Activator.logError("Error revealing line " + this.lineNumberToReveal, e);
            }
        }
        if ((revisionRuler = (IRevisionRulerColumn)AdapterUtils.adapt((Object)editor, IRevisionRulerColumn.class)) instanceof IRevisionRulerColumnExtension) {
            ((IRevisionRulerColumnExtension)revisionRuler).getRevisionSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)new RevisionSelectionHandler(this.repository, this.path, this.storage));
        }
    }

    private HistoryPageInput createHistoryPageInputWhenEditorOpened() {
        if (this.storage instanceof IFile) {
            IResource resource = (IResource)this.storage;
            if (this.startCommit != null) {
                return new BlameHistoryPageInput(this.repository, this.startCommit, resource);
            }
            return new HistoryPageInput(this.repository, new IResource[]{resource});
        }
        if (!this.repository.isBare()) {
            File file = new File(this.repository.getWorkTree(), this.path);
            if (this.startCommit != null) {
                return new BlameHistoryPageInput(this.repository, this.startCommit, file);
            }
            return new HistoryPageInput(this.repository, new File[]{file});
        }
        return new HistoryPageInput(this.repository);
    }

    public ISchedulingRule getSchedulingRule() {
        return null;
    }

    static class BlameHistoryPageInput
    extends HistoryPageInput
    implements IAdaptable {
        private final RevCommit commit;

        BlameHistoryPageInput(Repository repository, RevCommit commit, File file) {
            super(repository, new File[]{file});
            this.commit = commit;
        }

        BlameHistoryPageInput(Repository repository, RevCommit commit, IResource file) {
            super(repository, new IResource[]{file});
            this.commit = commit;
        }

        BlameHistoryPageInput(Repository repository, RevCommit commit) {
            super(repository);
            this.commit = commit;
        }

        public Object getAdapter(Class adapter) {
            if (RevCommit.class == adapter) {
                return this.commit;
            }
            return Platform.getAdapterManager().getAdapter((Object)this, adapter);
        }
    }

    private static class RevisionSelectionHandler
    implements ISelectionChangedListener {
        private IFile resourceFile;
        private File nonResourceFile;
        private boolean firstSelectionChange = true;

        private RevisionSelectionHandler(Repository repository, String path, IStorage storage) {
            if (storage instanceof IFile) {
                this.resourceFile = (IFile)storage;
            } else if (!repository.isBare()) {
                this.nonResourceFile = new File(repository.getWorkTree(), path);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (this.firstSelectionChange) {
                this.firstSelectionChange = false;
                return;
            }
            ISelection selection = event.getSelection();
            if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
                return;
            }
            Object first = ((IStructuredSelection)selection).getFirstElement();
            if (!(first instanceof BlameRevision)) {
                return;
            }
            IHistoryView part = (IHistoryView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.team.ui.GenericHistoryView");
            if (part == null) {
                return;
            }
            BlameRevision revision = (BlameRevision)((Object)first);
            BlameHistoryPageInput input = this.resourceFile != null ? new BlameHistoryPageInput(revision.getRepository(), revision.getCommit(), (IResource)this.resourceFile) : (this.nonResourceFile != null ? new BlameHistoryPageInput(revision.getRepository(), revision.getCommit(), this.nonResourceFile) : new BlameHistoryPageInput(revision.getRepository(), revision.getCommit()));
            part.showHistoryFor((Object)input);
        }
    }
}

