/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.io.IOException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.fst.Outputs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PairOutputs<A, B>
extends Outputs<Pair<A, B>> {
    private final Pair<A, B> NO_OUTPUT;
    private final Outputs<A> outputs1;
    private final Outputs<B> outputs2;

    public PairOutputs(Outputs<A> outputs1, Outputs<B> outputs2) {
        this.outputs1 = outputs1;
        this.outputs2 = outputs2;
        this.NO_OUTPUT = new Pair<A, B>(outputs1.getNoOutput(), outputs2.getNoOutput());
    }

    public Pair<A, B> get(A output1, B output2) {
        if (output1 == this.outputs1.getNoOutput() && output2 == this.outputs2.getNoOutput()) {
            return this.NO_OUTPUT;
        }
        return new Pair<A, B>(output1, output2);
    }

    @Override
    public Pair<A, B> common(Pair<A, B> pair1, Pair<A, B> pair2) {
        return this.get(this.outputs1.common(pair1.output1, pair2.output1), this.outputs2.common(pair1.output2, pair2.output2));
    }

    @Override
    public Pair<A, B> subtract(Pair<A, B> output, Pair<A, B> inc) {
        return this.get(this.outputs1.subtract(output.output1, inc.output1), this.outputs2.subtract(output.output2, inc.output2));
    }

    @Override
    public Pair<A, B> add(Pair<A, B> prefix, Pair<A, B> output) {
        return this.get(this.outputs1.add(prefix.output1, output.output1), this.outputs2.add(prefix.output2, output.output2));
    }

    @Override
    public void write(Pair<A, B> output, DataOutput writer) throws IOException {
        this.outputs1.write(output.output1, writer);
        this.outputs2.write(output.output2, writer);
    }

    @Override
    public Pair<A, B> read(DataInput in) throws IOException {
        A output1 = this.outputs1.read(in);
        B output2 = this.outputs2.read(in);
        return this.get(output1, output2);
    }

    @Override
    public Pair<A, B> getNoOutput() {
        return this.NO_OUTPUT;
    }

    @Override
    public String outputToString(Pair<A, B> output) {
        return "<pair:" + this.outputs1.outputToString(output.output1) + "," + this.outputs2.outputToString(output.output2) + ">";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Pair<A, B> {
        public final A output1;
        public final B output2;

        public Pair(A output1, B output2) {
            this.output1 = output1;
            this.output2 = output2;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof Pair) {
                Pair pair = (Pair)other;
                return this.output1.equals(pair.output1) && this.output2.equals(pair.output2);
            }
            return false;
        }

        public int hashCode() {
            return this.output1.hashCode() + this.output2.hashCode();
        }
    }
}

