/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.actions;

import org.eclipse.ant.internal.ui.AntUIImages;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.editor.AntEditor;
import org.eclipse.ant.internal.ui.editor.actions.AntEditorActionMessages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class ToggleMarkOccurrencesAction
extends TextEditorAction
implements IPropertyChangeListener {
    private IPreferenceStore fStore;

    public ToggleMarkOccurrencesAction() {
        super(AntEditorActionMessages.getResourceBundle(), "ToggleMarkOccurrencesAction.", null, 2);
        this.setImageDescriptor(AntUIImages.getImageDescriptor("org.eclipse.ant.ui.markOccurrences"));
        this.setToolTipText(AntEditorActionMessages.getString("ToggleMarkOccurrencesAction.tooltip"));
        this.update();
    }

    public void run() {
        this.fStore.setValue("editor_mark_occurrences", this.isChecked());
    }

    public void update() {
        ITextEditor editor = this.getTextEditor();
        boolean checked = false;
        boolean enabled = false;
        if (editor instanceof AntEditor) {
            checked = ((AntEditor)editor).isMarkingOccurrences();
            enabled = ((AntEditor)editor).getAntModel() != null;
        }
        this.setChecked(checked);
        this.setEnabled(enabled);
    }

    public void setEditor(ITextEditor editor) {
        super.setEditor(editor);
        if (editor != null) {
            if (this.fStore == null) {
                this.fStore = AntUIPlugin.getDefault().getPreferenceStore();
                this.fStore.addPropertyChangeListener((IPropertyChangeListener)this);
            }
        } else if (this.fStore != null) {
            this.fStore.removePropertyChangeListener((IPropertyChangeListener)this);
            this.fStore = null;
        }
        this.update();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("editor_mark_occurrences")) {
            this.setChecked(Boolean.valueOf(event.getNewValue().toString()));
        }
    }
}

