/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.browsing;

import java.util.List;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.browsing.IPackagesViewViewer;
import org.eclipse.jdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.jdt.internal.ui.viewsupport.ProblemTreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public class PackagesViewTreeViewer
extends ProblemTreeViewer
implements IPackagesViewViewer {
    public PackagesViewTreeViewer(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    public void mapElement(Object element, Widget item) {
        if (element instanceof LogicalPackage && item instanceof Item) {
            LogicalPackage cp = (LogicalPackage)((Object)element);
            IPackageFragment[] fragments = cp.getFragments();
            int i = 0;
            while (i < fragments.length) {
                IPackageFragment fragment = fragments[i];
                this.fResourceToItemsMapper.addToMap(fragment, (Item)item);
                ++i;
            }
        }
        super.mapElement(element, item);
    }

    @Override
    public void unmapElement(Object element, Widget item) {
        if (element instanceof LogicalPackage && item instanceof Item) {
            LogicalPackage cp = (LogicalPackage)((Object)element);
            IPackageFragment[] fragments = cp.getFragments();
            int i = 0;
            while (i < fragments.length) {
                IPackageFragment fragment = fragments[i];
                this.fResourceToItemsMapper.removeFromMap(fragment, (Item)item);
                ++i;
            }
        }
        super.unmapElement(element, item);
    }

    @Override
    protected boolean isFiltered(Object object, Object parent, ViewerFilter[] filters) {
        boolean res = super.isFiltered(object, parent, filters);
        if (res && this.isEssential(object)) {
            return false;
        }
        return res;
    }

    private boolean isEssential(Object object) {
        try {
            LogicalPackage logicalPackage;
            if (object instanceof IPackageFragment) {
                IPackageFragment fragment = (IPackageFragment)object;
                if (!fragment.isDefaultPackage() && fragment.hasSubpackages()) {
                    return this.hasFilteredChildren(fragment);
                }
            } else if (object instanceof LogicalPackage && !(logicalPackage = (LogicalPackage)((Object)object)).isDefaultPackage() && logicalPackage.hasSubpackages()) {
                return !this.hasFilteredChildren(object);
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        return false;
    }

    @Override
    public Widget doFindItem(Object element) {
        return super.doFindItem(element);
    }

    @Override
    public Widget doFindInputItem(Object element) {
        return super.doFindInputItem(element);
    }

    @Override
    public List<?> getSelectionFromWidget() {
        return super.getSelectionFromWidget();
    }

    @Override
    public void doUpdateItem(Widget item, Object element, boolean fullMap) {
        super.doUpdateItem(item, element, fullMap);
    }

    @Override
    public void internalRefresh(Object element) {
        super.internalRefresh(element);
    }

    @Override
    public void setSelectionToWidget(List l, boolean reveal) {
        super.setSelectionToWidget(l, reveal);
    }
}

