/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.LazyGenericTypeProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.MethodProposalInfo;
import org.eclipse.jdt.internal.ui.text.java.ProposalContextInformation;
import org.eclipse.jdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.osgi.util.TextProcessor;

public class JavaMethodCompletionProposal
extends LazyJavaCompletionProposal {
    protected static final char[] METHOD_TRIGGERS = new char[]{';', ',', '.', '\t', '['};
    protected static final char[] METHOD_WITH_ARGUMENTS_TRIGGERS = new char[]{';', '(', '-', ' '};
    protected static final char[] METHOD_NAME_TRIGGERS = new char[]{';'};
    private boolean fHasParameters;
    private boolean fHasParametersComputed = false;
    private LazyJavaCompletionProposal.FormatterPrefs fFormatterPrefs;

    public JavaMethodCompletionProposal(CompletionProposal proposal, JavaContentAssistInvocationContext context) {
        super(proposal, context);
    }

    @Override
    public void apply(IDocument document, char trigger, int offset) {
        if (trigger == ' ' || trigger == '(') {
            trigger = '\u0000';
        }
        super.apply(document, trigger, offset);
        if (this.needsLinkedMode()) {
            this.setUpLinkedMode(document, ')');
        } else if (!this.fProposal.isConstructor() && this.getReplacementString().endsWith(";")) {
            this.setUpLinkedMode(document, ';');
        }
    }

    protected boolean needsLinkedMode() {
        return this.hasArgumentList() && this.hasParameters();
    }

    @Override
    public int getPrefixCompletionStart(IDocument document, int completionOffset) {
        if (this.fProposal.getKind() == 24) {
            return this.fProposal.getTokenStart();
        }
        if (this.fProposal.getKind() == 26) {
            return this.fProposal.getRequiredProposals()[0].getReplaceStart();
        }
        return super.getPrefixCompletionStart(document, completionOffset);
    }

    @Override
    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        if (this.hasArgumentList() || this.fProposal.getKind() == 26) {
            String completion = String.valueOf(this.fProposal.getName());
            if (this.isCamelCaseMatching()) {
                String prefix = this.getPrefix(document, completionOffset);
                return this.getCamelCaseCompound(prefix, completion);
            }
            return completion;
        }
        return super.getPrefixCompletionText(document, completionOffset);
    }

    @Override
    protected IContextInformation computeContextInformation() {
        if ((this.fProposal.getKind() == 6 || this.fProposal.getKind() == 26) && this.hasParameters() && (this.getReplacementString().endsWith(")") || this.getReplacementString().endsWith(";") || this.getReplacementString().length() == 0)) {
            ProposalContextInformation contextInformation = new ProposalContextInformation(this.fProposal);
            if (this.fContextInformationPosition != 0 && this.fProposal.getCompletion().length == 0) {
                contextInformation.setContextInformationPosition(this.fContextInformationPosition);
            }
            return contextInformation;
        }
        return super.computeContextInformation();
    }

    @Override
    protected char[] computeTriggerCharacters() {
        if (this.fProposal.getKind() == 12) {
            return METHOD_NAME_TRIGGERS;
        }
        if (this.hasParameters()) {
            return METHOD_WITH_ARGUMENTS_TRIGGERS;
        }
        return METHOD_TRIGGERS;
    }

    protected final boolean hasParameters() {
        if (!this.fHasParametersComputed) {
            this.fHasParametersComputed = true;
            this.fHasParameters = this.computeHasParameters();
        }
        return this.fHasParameters;
    }

    protected final boolean canAutomaticallyAppendSemicolon() {
        return !this.fProposal.isConstructor() && CharOperation.equals((char[])new char[]{'V'}, (char[])Signature.getReturnType((char[])this.fProposal.getSignature()));
    }

    private boolean computeHasParameters() throws IllegalArgumentException {
        return Signature.getParameterCount((char[])this.fProposal.getSignature()) > 0;
    }

    protected boolean hasArgumentList() {
        if (12 == this.fProposal.getKind()) {
            return false;
        }
        IPreferenceStore preferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        boolean noOverwrite = preferenceStore.getBoolean("content_assist_insert_completion") ^ this.isToggleEating();
        char[] completion = this.fProposal.getCompletion();
        return !this.isInJavadoc() && completion.length > 0 && (noOverwrite || completion[completion.length - 1] == ')');
    }

    @Override
    protected final LazyJavaCompletionProposal.FormatterPrefs getFormatterPrefs() {
        if (this.fFormatterPrefs == null) {
            this.fFormatterPrefs = new LazyJavaCompletionProposal.FormatterPrefs(this.fInvocationContext.getProject());
        }
        return this.fFormatterPrefs;
    }

    @Override
    protected String computeReplacementString() {
        if (!this.hasArgumentList()) {
            return super.computeReplacementString();
        }
        StringBuffer buffer = new StringBuffer();
        this.appendMethodNameReplacement(buffer);
        LazyJavaCompletionProposal.FormatterPrefs prefs = this.getFormatterPrefs();
        if (this.hasParameters()) {
            this.setCursorPosition(buffer.length());
            if (prefs.afterOpeningParen) {
                buffer.append(" ");
            }
        } else if (prefs.inEmptyList) {
            buffer.append(" ");
        }
        buffer.append(")");
        if (this.canAutomaticallyAppendSemicolon()) {
            buffer.append(";");
        }
        return buffer.toString();
    }

    protected void appendMethodNameReplacement(StringBuffer buffer) {
        if (this.fProposal.getKind() == 24) {
            String coreCompletion = String.valueOf(this.fProposal.getCompletion());
            String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)this.getTextViewer().getDocument());
            String replacement = CodeFormatterUtil.format(1, coreCompletion, 0, lineDelimiter, this.fInvocationContext.getProject());
            buffer.append(replacement.substring(0, replacement.lastIndexOf(46) + 1));
        }
        if (this.fProposal.getKind() != 26) {
            buffer.append(this.fProposal.getName());
        }
        LazyJavaCompletionProposal.FormatterPrefs prefs = this.getFormatterPrefs();
        if (prefs.beforeOpeningParen) {
            buffer.append(" ");
        }
        buffer.append("(");
    }

    @Override
    protected ProposalInfo computeProposalInfo() {
        IJavaProject project = this.fInvocationContext.getProject();
        if (project != null) {
            return new MethodProposalInfo(project, this.fProposal);
        }
        return super.computeProposalInfo();
    }

    @Override
    protected String computeSortString() {
        char[] name = this.fProposal.getName();
        char[] parameterList = Signature.toCharArray((char[])this.fProposal.getSignature(), null, null, (boolean)false, (boolean)false);
        int parameterCount = Signature.getParameterCount((char[])this.fProposal.getSignature()) % 10;
        StringBuffer buf = new StringBuffer(name.length + 2 + parameterList.length);
        buf.append(name);
        buf.append('\u0000');
        buf.append(parameterCount);
        buf.append(parameterList);
        return buf.toString();
    }

    @Override
    protected boolean isOffsetValid(int offset) {
        if (this.fProposal.getKind() != 26) {
            return super.isOffsetValid(offset);
        }
        return this.fProposal.getRequiredProposals()[0].getReplaceStart() <= offset;
    }

    @Override
    protected boolean isValidPrefix(String prefix) {
        if (super.isValidPrefix(prefix)) {
            return true;
        }
        String word = TextProcessor.deprocess((String)this.getDisplayString());
        if (this.fProposal.getKind() == 26) {
            int start = word.indexOf(JavaElementLabels.CONCAT_STRING) + JavaElementLabels.CONCAT_STRING.length();
            return this.isPrefix(prefix, word = word.substring(start)) || this.isPrefix(prefix, new String(this.fProposal.getName()));
        }
        if (this.isInJavadoc()) {
            int idx = word.indexOf("{@link ");
            if (idx == 0) {
                word = word.substring(7);
            } else {
                idx = word.indexOf("{@value ");
                if (idx == 0) {
                    word = word.substring(8);
                }
            }
        }
        return this.isPrefix(prefix, word);
    }

    @Override
    protected boolean isPrefix(String prefix, String string) {
        if (this.fProposal.getKind() == 24 && prefix != null) {
            prefix = prefix.substring(this.fProposal.getReceiverEnd() - this.fProposal.getReceiverStart() + 1);
        }
        return super.isPrefix(prefix, string);
    }

    @Override
    protected String getPrefix(IDocument document, int offset) {
        if (this.fProposal.getKind() != 26) {
            return super.getPrefix(document, offset);
        }
        int replacementOffset = this.fProposal.getRequiredProposals()[0].getReplaceStart();
        try {
            int length = offset - replacementOffset;
            if (length > 0) {
                return document.get(replacementOffset, length);
            }
        }
        catch (BadLocationException badLocationException) {}
        return "";
    }

    @Override
    protected LazyJavaCompletionProposal createRequiredTypeCompletionProposal(CompletionProposal completionProposal, JavaContentAssistInvocationContext invocationContext) {
        LazyJavaCompletionProposal requiredProposal = super.createRequiredTypeCompletionProposal(completionProposal, invocationContext);
        if (this.fProposal.getKind() == 26 && requiredProposal instanceof LazyGenericTypeProposal) {
            ((LazyGenericTypeProposal)requiredProposal).canUseDiamond(this.fProposal.canUseDiamond(this.fInvocationContext.getCoreContext()));
        }
        return requiredProposal;
    }
}

