/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class RevUtils {
    private RevUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RevCommit getCommonAncestor(Repository repo, AnyObjectId commit1, AnyObjectId commit2) throws IOException {
        Assert.isNotNull((Object)repo);
        Assert.isNotNull((Object)commit1);
        Assert.isNotNull((Object)commit2);
        Throwable throwable = null;
        Object var4_5 = null;
        try (RevWalk rw = new RevWalk(repo);){
            rw.setRetainBody(false);
            rw.setRevFilter(RevFilter.MERGE_BASE);
            RevCommit srcRev = rw.lookupCommit(commit1);
            RevCommit dstRev = rw.lookupCommit(commit2);
            rw.markStart(dstRev);
            rw.markStart(srcRev);
            RevCommit result = rw.next();
            if (result != null) {
                rw.parseBody((RevObject)result);
                return result;
            }
            return null;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    public static ConflictCommits getConflictCommits(Repository repository, String path) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (RevWalk walk = new RevWalk(repository);){
            RevCommit theirCommit = null;
            walk.setTreeFilter(AndTreeFilter.create((TreeFilter)PathFilter.create((String)path), (TreeFilter)TreeFilter.ANY_DIFF));
            RevCommit head = walk.parseCommit((AnyObjectId)repository.resolve("HEAD"));
            walk.markStart(head);
            RevCommit ourCommit = walk.next();
            RepositoryState state = repository.getRepositoryState();
            if (state == RepositoryState.REBASING || state == RepositoryState.CHERRY_PICKING) {
                ObjectId cherryPickHead = repository.readCherryPickHead();
                if (cherryPickHead != null) {
                    RevCommit cherryPickCommit;
                    theirCommit = cherryPickCommit = walk.parseCommit((AnyObjectId)cherryPickHead);
                }
            } else if (state == RepositoryState.MERGING) {
                List mergeHeads = repository.readMergeHeads();
                Assert.isNotNull((Object)mergeHeads);
                if (mergeHeads.size() == 1) {
                    ObjectId mergeHead = (ObjectId)mergeHeads.get(0);
                    RevCommit mergeCommit = walk.parseCommit((AnyObjectId)mergeHead);
                    walk.reset();
                    walk.markStart(mergeCommit);
                    theirCommit = walk.next();
                }
            }
            return new ConflictCommits(ourCommit, theirCommit);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isContainedInAnyRef(Repository repo, ObjectId commitId, Collection<Ref> refs) throws IOException {
        for (Ref ref : refs) {
            if (!commitId.equals((AnyObjectId)ref.getObjectId())) continue;
            return true;
        }
        int skew = 86400;
        Object object = null;
        Object var5_7 = null;
        try {
            RevWalk walk = new RevWalk(repo);
            try {
                boolean contained;
                Ref ref;
                RevCommit refCommit;
                RevCommit commit = walk.parseCommit((AnyObjectId)commitId);
                Iterator<Ref> iterator = refs.iterator();
                do {
                    if (iterator.hasNext()) continue;
                    walk.dispose();
                    return false;
                } while ((refCommit = walk.parseCommit((AnyObjectId)(ref = iterator.next()).getObjectId())).getCommitTime() + 86400 < commit.getCommitTime() || !(contained = walk.isMergedInto(commit, refCommit)));
                return true;
            }
            finally {
                if (walk == null) return true;
                walk.close();
            }
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
                throw object;
            }
            if (object == throwable) throw object;
            ((Throwable)object).addSuppressed(throwable);
            throw object;
        }
    }

    public static class ConflictCommits {
        private final RevCommit ourCommit;
        private final RevCommit theirCommit;

        private ConflictCommits(RevCommit ourCommit, RevCommit theirCommit) {
            this.ourCommit = ourCommit;
            this.theirCommit = theirCommit;
        }

        public RevCommit getOurCommit() {
            return this.ourCommit;
        }

        public RevCommit getTheirCommit() {
            return this.theirCommit;
        }
    }
}

