/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.ui.editor.contentassist;

import java.util.ArrayList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.internal.core.text.AbstractEditingModel;
import org.eclipse.pde.internal.core.text.IDocumentAttributeNode;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.core.text.IDocumentRange;
import org.eclipse.pde.internal.core.text.IDocumentTextNode;
import org.eclipse.pde.internal.core.text.IReconcilingParticipant;
import org.eclipse.pde.internal.ds.core.IDSComponent;
import org.eclipse.pde.internal.ds.core.IDSObject;
import org.eclipse.pde.internal.ds.core.IDSProvide;
import org.eclipse.pde.internal.ds.core.IDSService;
import org.eclipse.pde.internal.ds.core.text.DSModel;
import org.eclipse.pde.internal.ds.ui.editor.contentassist.DSAttrCompletionProposal;
import org.eclipse.pde.internal.ds.ui.editor.contentassist.DSCompletionProposal;
import org.eclipse.pde.internal.ds.ui.editor.contentassist.DSContentAssistText;
import org.eclipse.pde.internal.ds.ui.editor.contentassist.TypeCompletionProposal;
import org.eclipse.pde.internal.ds.ui.editor.contentassist.TypePackageCompletionProcessor;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;

public class DSContentAssistProcessor
extends TypePackageCompletionProcessor
implements IContentAssistProcessor,
ICompletionListener {
    protected boolean fAssistSessionStarted;
    private PDESourcePage fSourcePage;
    private IDocumentRange fRange;
    private static final int F_NO_ASSIST = 0;
    private static final int F_ADD_ATTRIB = 1;
    private static final int F_ADD_CHILD = 2;
    private static final int F_OPEN_TAG = 3;

    public DSContentAssistProcessor(PDESourcePage sourcePage) {
        this.fSourcePage = sourcePage;
    }

    public void assistSessionEnded(ContentAssistEvent event) {
        this.fRange = null;
    }

    public void assistSessionStarted(ContentAssistEvent event) {
        this.fAssistSessionStarted = true;
    }

    public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
    }

    @Override
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        IDocument doc = viewer.getDocument();
        IBaseModel model = this.fSourcePage.getInputContext().getModel();
        if (model instanceof AbstractEditingModel && this.fSourcePage.isDirty() && ((AbstractEditingModel)model).isStale() && this.fRange == null) {
            ((AbstractEditingModel)model).reconciled(doc);
        } else if (this.fAssistSessionStarted) {
            ((AbstractEditingModel)model).reconciled(doc);
            this.fAssistSessionStarted = false;
        }
        if (this.fRange == null) {
            this.assignRange(offset);
        } else {
            boolean resetAndReconcile = false;
            if (!(this.fRange instanceof IDocumentAttributeNode)) {
                resetAndReconcile = true;
            }
            if (resetAndReconcile) {
                this.fRange = null;
                if (model instanceof IReconcilingParticipant) {
                    ((IReconcilingParticipant)model).reconciled(doc);
                }
            }
        }
        DSContentAssistText caText = DSContentAssistText.parse(offset, doc);
        if (caText != null) {
            return this.computeCATextProposal(doc, offset, caText);
        }
        if (this.fRange instanceof IDocumentAttributeNode) {
            return this.computeCompletionProposal((IDocumentAttributeNode)this.fRange, offset, doc);
        }
        if (this.fRange instanceof IDocumentElementNode) {
            return this.computeCompletionProposal((IDocumentElementNode)this.fRange, offset, doc);
        }
        return null;
    }

    private ICompletionProposal[] computeCATextProposal(IDocument doc, int offset, DSContentAssistText caText) {
        this.fRange = this.fSourcePage.getRangeElement(offset, true);
        if (this.fRange != null && this.fRange instanceof IDocumentTextNode) {
            this.fRange = ((IDocumentTextNode)this.fRange).getEnclosingElement();
        }
        if (this.fRange != null && this.fRange instanceof IDocumentElementNode) {
            return this.computeAddChildProposal((IDocumentElementNode)this.fRange, caText.getStartOffset(), doc, caText.getText());
        }
        return null;
    }

    private ICompletionProposal[] computeCompletionProposal(IDocumentAttributeNode attr, int offset, IDocument doc) {
        if (offset < attr.getValueOffset()) {
            return null;
        }
        int[] offests = new int[]{offset, offset, offset};
        String[] guess = this.guessContentRequest(offests, doc, false);
        if (guess == null) {
            return null;
        }
        String element = guess[0];
        String attribute = guess[1];
        String attrValue = guess[2];
        int attrValueLength = attrValue == null ? 0 : attrValue.length();
        int startOffset = offests[2] + 1;
        if (element != null && element.equals("scr:component")) {
            boolean isAttrConfigPolicy;
            boolean isAttrImmediate = attribute == null ? false : attribute.equals("immediate");
            boolean isAttrEnabled = attribute == null ? false : attribute.equals("enabled");
            boolean bl = isAttrConfigPolicy = attribute == null ? false : attribute.equals("configuration-policy");
            if (isAttrImmediate || isAttrEnabled) {
                return this.getCompletionBooleans(startOffset, attrValueLength);
            }
            if (isAttrConfigPolicy) {
                return this.getConfigurationPolicyValues(attrValueLength, startOffset);
            }
        } else if (element != null && element.equals("service")) {
            boolean isAttrServFactory;
            boolean bl = isAttrServFactory = attribute == null ? false : attribute.equals("servicefactory");
            if (isAttrServFactory) {
                return this.getCompletionBooleans(startOffset, attrValueLength);
            }
        } else if (element != null && element.equals("reference")) {
            boolean isAttrPolicy;
            boolean isAttrCardinality = attribute == null ? false : attribute.equals("cardinality");
            boolean bl = isAttrPolicy = attribute == null ? false : attribute.equals("policy");
            if (isAttrCardinality) {
                return this.getReferenceCardinalityValues(attrValueLength, startOffset);
            }
            if (isAttrPolicy) {
                return this.getReferencePolicyValues(attrValueLength, startOffset);
            }
        } else if (element != null && element.equals("property")) {
            boolean isAttrType;
            boolean bl = isAttrType = attribute == null ? false : attribute.equals("type");
            if (isAttrType) {
                return this.getPropertyTypeValues(attrValueLength, startOffset);
            }
        }
        return null;
    }

    private ICompletionProposal[] getReferencePolicyValues(int attrValueLength, int startOffset) {
        return new ICompletionProposal[]{new TypeCompletionProposal("static", null, "static", startOffset, attrValueLength), new TypeCompletionProposal("dynamic", null, "dynamic", startOffset, attrValueLength)};
    }

    private ICompletionProposal[] getConfigurationPolicyValues(int attrValueLength, int startOffset) {
        return new ICompletionProposal[]{new TypeCompletionProposal("ignore", null, "ignore", startOffset, attrValueLength), new TypeCompletionProposal("optional", null, "optional", startOffset, attrValueLength), new TypeCompletionProposal("require", null, "require", startOffset, attrValueLength)};
    }

    private ICompletionProposal[] getReferenceCardinalityValues(int attrValueLength, int startOffset) {
        return new ICompletionProposal[]{new TypeCompletionProposal("0..1", null, "0..1", startOffset, attrValueLength), new TypeCompletionProposal("0..n", null, "0..n", startOffset, attrValueLength), new TypeCompletionProposal("1..1", null, "1..1", startOffset, attrValueLength), new TypeCompletionProposal("1..n", null, "1..n", startOffset, attrValueLength)};
    }

    private ICompletionProposal[] getPropertyTypeValues(int attrValueLength, int startOffset) {
        return new ICompletionProposal[]{new TypeCompletionProposal("String", null, "String", startOffset, attrValueLength), new TypeCompletionProposal("Long", null, "Long", startOffset, attrValueLength), new TypeCompletionProposal("Double", null, "Double", startOffset, attrValueLength), new TypeCompletionProposal("Float", null, "Float", startOffset, attrValueLength), new TypeCompletionProposal("Integer", null, "Integer", startOffset, attrValueLength), new TypeCompletionProposal("Byte", null, "Byte", startOffset, attrValueLength), new TypeCompletionProposal("Character", null, "Character", startOffset, attrValueLength), new TypeCompletionProposal("Boolean", null, "Boolean", startOffset, attrValueLength), new TypeCompletionProposal("Short", null, "Short", startOffset, attrValueLength)};
    }

    private ICompletionProposal[] getCompletionBooleans(int startOffset, int attrValueLength) {
        return new ICompletionProposal[]{new TypeCompletionProposal("true", null, "true", startOffset, attrValueLength), new TypeCompletionProposal("false", null, "false", startOffset, attrValueLength)};
    }

    private ICompletionProposal[] computeCompletionProposal(IDocumentElementNode node, int offset, IDocument doc) {
        int prop_type = this.determineAssistType(node, doc, offset);
        switch (prop_type) {
            case 1: {
                return this.computeAddAttributeProposal(node, offset, doc, null, node.getXMLTagName());
            }
            case 2: {
                return this.computeAddChildProposal(node, offset, doc, null);
            }
        }
        return null;
    }

    private ICompletionProposal[] computeAddAttributeProposal(IDocumentElementNode node, int offset, IDocument doc, String filter, String tag) {
        ArrayList<DSAttrCompletionProposal> proposals = new ArrayList<DSAttrCompletionProposal>();
        if (!(node instanceof IDSObject)) {
            return null;
        }
        String[] attributesList = ((IDSObject)node).getAttributesNames();
        if (attributesList == null || attributesList.length == 0) {
            return null;
        }
        String[] stringArray = attributesList;
        int n = attributesList.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            IDocumentAttributeNode[] nodeAttributes = node.getNodeAttributes();
            boolean EqualToAnyItem = false;
            IDocumentAttributeNode[] iDocumentAttributeNodeArray = nodeAttributes;
            int n3 = nodeAttributes.length;
            int n4 = 0;
            while (n4 < n3) {
                IDocumentAttributeNode documentAttributeNode = iDocumentAttributeNodeArray[n4];
                EqualToAnyItem |= attribute.equals(documentAttributeNode.getAttributeName());
                ++n4;
            }
            if (!EqualToAnyItem) {
                DSAttrCompletionProposal dsAttrCompletionProposal = new DSAttrCompletionProposal(attribute, offset, 0);
                this.addFilteredProposal(offset, proposals, dsAttrCompletionProposal, filter);
            }
            ++n2;
        }
        if (proposals.size() > 0) {
            ICompletionProposal[] proposalsArray = new ICompletionProposal[proposals.size()];
            int i = 0;
            while (i < proposals.size()) {
                proposalsArray[i] = (ICompletionProposal)proposals.get(i);
                ++i;
            }
            return proposalsArray;
        }
        return null;
    }

    private ICompletionProposal[] computeAddChildProposal(IDocumentElementNode node, int offset, IDocument doc, String filter) {
        if (node instanceof IDSComponent) {
            return this.computeRootNodeProposals(node, offset, filter);
        }
        if (node instanceof IDSService) {
            DSModel model = (DSModel)this.fSourcePage.getInputContext().getModel();
            IDSProvide provide = model.getFactory().createProvide();
            return new DSCompletionProposal[]{new DSCompletionProposal((IDSObject)provide, offset)};
        }
        return null;
    }

    private ICompletionProposal[] computeRootNodeProposals(IDocumentElementNode node, int offset, String filter) {
        boolean hasService;
        ArrayList<DSCompletionProposal> proposals = new ArrayList<DSCompletionProposal>();
        DSModel model = (DSModel)this.fSourcePage.getInputContext().getModel();
        IDSComponent component = model.getDSComponent();
        int length = filter != null ? filter.length() : 0;
        this.addFilteredProposal(offset, proposals, new DSCompletionProposal((IDSObject)model.getFactory().createProperty(), offset, length), filter);
        this.addFilteredProposal(offset, proposals, new DSCompletionProposal((IDSObject)model.getFactory().createProperties(), offset, length), filter);
        this.addFilteredProposal(offset, proposals, new DSCompletionProposal((IDSObject)model.getFactory().createReference(), offset, length), filter);
        boolean bl = hasService = component.getService() != null;
        if (!hasService) {
            this.addFilteredProposal(offset, proposals, new DSCompletionProposal((IDSObject)model.getFactory().createService(), offset, length), filter);
        }
        if (component.getImplementation() == null) {
            this.addFilteredProposal(offset, proposals, new DSCompletionProposal((IDSObject)model.getFactory().createImplementation(), offset, length), filter);
        }
        ICompletionProposal[] proposalsArray = new DSCompletionProposal[proposals.size()];
        int i = 0;
        while (i < proposalsArray.length) {
            proposalsArray[i] = proposals.get(i);
            ++i;
        }
        return proposalsArray;
    }

    private void addFilteredProposal(int offset, ArrayList<DSCompletionProposal> proposals, DSCompletionProposal proposal, String filter) {
        if (filter == null || filter.length() == 0) {
            proposals.add(proposal);
        } else if (filter.regionMatches(true, 0, proposal.getDisplayString(), 0, filter.length())) {
            proposals.add(proposal);
        }
    }

    private void addFilteredProposal(int offset, ArrayList<DSAttrCompletionProposal> proposals, DSAttrCompletionProposal proposal, String filter) {
        if (filter == null || filter.length() == 0) {
            proposals.add(proposal);
        } else if (filter.regionMatches(true, 0, proposal.getDisplayString(), 0, filter.length())) {
            proposals.add(proposal);
        }
    }

    private int determineAssistType(IDocumentElementNode node, IDocument doc, int offset) {
        int len = node.getLength();
        int off = node.getOffset();
        if (len == -1 || off == -1) {
            return 0;
        }
        if ((offset -= off) > node.getXMLTagName().length() + 1) {
            int ind;
            String eleValue;
            block10: {
                block9: {
                    try {
                        eleValue = doc.get(off, len);
                        ind = eleValue.indexOf(62);
                        if (ind > 0 && eleValue.charAt(ind - 1) == '/') {
                            --ind;
                        }
                        if (offset > ind) break block9;
                        if (this.canInsertAttrib(eleValue, offset)) {
                            return 1;
                        }
                        return 0;
                    }
                    catch (BadLocationException badLocationException) {}
                }
                ind = eleValue.lastIndexOf(60);
                if (ind != 0 || offset != len - 1) break block10;
                return 3;
            }
            if (ind + 1 < len && eleValue.charAt(ind + 1) == '/' && offset <= ind) {
                return 2;
            }
        }
        return 0;
    }

    private boolean canInsertAttrib(String eleValue, int offset) {
        char c = eleValue.charAt(offset);
        return offset - 1 >= 0 && Character.isWhitespace(eleValue.charAt(offset - 1)) && (Character.isWhitespace(c) || c == '/' || c == '>');
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String[] guessContentRequest(int[] offset, IDocument doc, boolean brokenModel) {
        StringBuffer nodeBuffer = new StringBuffer();
        StringBuffer attrBuffer = new StringBuffer();
        StringBuffer attrValBuffer = new StringBuffer();
        String node = null;
        String attr = null;
        String attVal = null;
        int quoteCount = 0;
        try {
            while ((offset[0] = offset[0] - 1) >= 0) {
                char c = doc.getChar(offset[0]);
                if (c == '\"') {
                    ++quoteCount;
                    nodeBuffer.setLength(0);
                    attrBuffer.setLength(0);
                    if (attVal != null) continue;
                    offset[2] = offset[0];
                    attVal = attrValBuffer.toString();
                    continue;
                }
                if (Character.isWhitespace(c)) {
                    nodeBuffer.setLength(0);
                    if (attr != null) continue;
                    offset[1] = offset[0];
                    int attBuffLen = attrBuffer.length();
                    if (attBuffLen > 0 && attrBuffer.charAt(attBuffLen - 1) == '=') {
                        attrBuffer.setLength(attBuffLen - 1);
                    }
                    attr = attrBuffer.toString();
                    continue;
                }
                if (c == '<') {
                    node = nodeBuffer.toString();
                    break;
                }
                if (c == '>') {
                    return null;
                }
                attrValBuffer.insert(0, c);
                attrBuffer.insert(0, c);
                nodeBuffer.insert(0, c);
            }
        }
        catch (BadLocationException badLocationException) {}
        if (node == null) {
            return null;
        }
        if (quoteCount % 2 == 0) {
            attVal = null;
            return new String[]{node, attr, attVal};
        } else {
            if (!brokenModel) return new String[]{node, attr, attVal};
            return null;
        }
    }

    private void assignRange(int offset) {
        this.fRange = this.fSourcePage.getRangeElement(offset, true);
        if (this.fRange == null) {
            return;
        }
        if (this.fRange instanceof IDocumentAttributeNode) {
            if (((IDocumentAttributeNode)this.fRange).getNameOffset() == offset) {
                this.fRange = ((IDocumentAttributeNode)this.fRange).getEnclosingElement();
            }
        } else if (this.fRange instanceof IDocumentElementNode) {
            if (((IDocumentElementNode)this.fRange).getOffset() == offset) {
                this.fRange = ((IDocumentElementNode)this.fRange).getParentNode();
            }
        } else if (this.fRange instanceof IDocumentTextNode && ((IDocumentTextNode)this.fRange).getOffset() == offset) {
            this.fRange = ((IDocumentTextNode)this.fRange).getEnclosingElement();
        }
    }

    public void dispose() {
    }

    protected ITextSelection getCurrentSelection() {
        ISelection sel = this.fSourcePage.getSelectionProvider().getSelection();
        if (sel instanceof ITextSelection) {
            return (ITextSelection)sel;
        }
        return null;
    }

    protected void flushDocument() {
        this.fSourcePage.getInputContext().flushEditorInput();
    }
}

