/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.aspectj.loadtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.aspectj.weaver.loadtime.definition.Definition;
import org.eclipse.equinox.service.weaving.ISupplementerRegistry;
import org.eclipse.equinox.service.weaving.Supplementer;
import org.eclipse.equinox.weaving.aspectj.AspectAdmin;
import org.eclipse.equinox.weaving.aspectj.AspectConfiguration;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public class AspectResolver {
    private final AspectAdmin aspectAdmin;
    private final ISupplementerRegistry supplementerRegistry;
    private final BundleContext weavingBundleContext;

    public AspectResolver(ISupplementerRegistry iSupplementerRegistry, AspectAdmin aspectAdmin, BundleContext bundleContext) {
        this.supplementerRegistry = iSupplementerRegistry;
        this.aspectAdmin = aspectAdmin;
        this.weavingBundleContext = bundleContext;
    }

    private int getApplyAspectsPolicy(ManifestElement[] manifestElementArray, String string) {
        int n = 0;
        if (manifestElementArray != null) {
            int n2 = 0;
            while (n2 < manifestElementArray.length) {
                if (manifestElementArray[n2].getValue().equals(string)) {
                    String string2 = manifestElementArray[n2].getDirective("apply-aspects");
                    if ("true".equals(string2)) {
                        n = 1;
                    } else if ("false".equals(string2)) {
                        n = 2;
                    }
                }
                ++n2;
            }
        }
        return n;
    }

    private String getBundleVersion(Bundle bundle) {
        return bundle.getVersion().toString();
    }

    public AspectConfiguration resolveAspectsFor(Bundle bundle, BundleRevision bundleRevision) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<Definition> list = this.resolveAspectsForBundle(arrayList, bundle, bundleRevision);
        Definition[] definitionArray = list.toArray(new Definition[list.size()]);
        Collections.sort(arrayList);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : arrayList) {
            stringBuilder.append(string);
            stringBuilder.append(';');
        }
        return new AspectConfiguration(bundle, definitionArray, stringBuilder.toString());
    }

    private List<Definition> resolveAspectsForBundle(List<String> list, Bundle bundle, BundleRevision bundleRevision) {
        ArrayList<Definition> arrayList = new ArrayList<Definition>();
        BundleWiring bundleWiring = bundleRevision.getWiring();
        if (bundleWiring != null && this.weavingBundleContext != null) {
            String string;
            BundleWire bundleWire;
            Object object2;
            List list22;
            Definition definition = null;
            for (List list22 : bundleWiring.getProvidedWires("osgi.wiring.host")) {
                object2 = list22.getRequirer().getBundle();
                if (object2 == null || (definition = this.aspectAdmin.getAspectDefinition((Bundle)object2)) == null) continue;
                arrayList.add(definition);
                list.add(String.valueOf(object2.getSymbolicName()) + ":" + list22.getRequirer().getVersion().toString());
            }
            list22 = bundleWiring.getRequiredWires("osgi.wiring.bundle");
            ManifestElement[] manifestElementArray = null;
            if (!list22.isEmpty()) {
                try {
                    manifestElementArray = ManifestElement.parseHeader((String)"Require-Bundle", (String)((String)bundle.getHeaders("").get("Require-Bundle")));
                }
                catch (BundleException bundleException) {}
            }
            for (Object object2 : list22) {
                int n;
                bundleWire = object2.getProvider().getBundle();
                if (bundleWire == null || (definition = this.aspectAdmin.resolveRequiredBundle((Bundle)bundleWire, n = this.getApplyAspectsPolicy(manifestElementArray, bundleWire.getSymbolicName()))) == null) continue;
                arrayList.add(definition);
                list.add(String.valueOf(bundleWire.getSymbolicName()) + ":" + object2.getProvider().getVersion().toString());
            }
            object2 = bundleWiring.getRequiredWires("osgi.wiring.package");
            ManifestElement[] manifestElementArray2 = null;
            if (!object2.isEmpty()) {
                try {
                    manifestElementArray2 = ManifestElement.parseHeader((String)"Import-Package", (String)((String)bundle.getHeaders("").get("Import-Package")));
                }
                catch (BundleException bundleException) {}
            }
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                int n;
                String string2;
                bundleWire = (BundleWire)iterator.next();
                Bundle bundle2 = bundleWire.getProvider().getBundle();
                if (bundle2 == null || (definition = this.aspectAdmin.resolveImportedPackage(bundle2, string2 = (String)bundleWire.getCapability().getAttributes().get("osgi.wiring.package"), n = this.getApplyAspectsPolicy(manifestElementArray2, string2))) == null) continue;
                arrayList.add(definition);
                Object v = bundleWire.getCapability().getAttributes().get("version");
                String string3 = v == null ? Version.emptyVersion.toString() : v.toString();
                list.add(String.valueOf(string2) + ":" + string3);
            }
            bundleWire = this.supplementerRegistry.getSupplementers(bundleRevision.getBundle().getBundleId());
            int n = 0;
            while (n < ((Supplementer[])bundleWire).length) {
                definition = this.aspectAdmin.getExportedAspectDefinitions(bundleWire[n].getSupplementerBundle());
                if (definition != null) {
                    arrayList.add(definition);
                    list.add(String.valueOf(bundleWire[n].getSymbolicName()) + ":" + this.getBundleVersion(bundleWire[n].getSupplementerBundle()));
                }
                ++n;
            }
            definition = this.aspectAdmin.getAspectDefinition(bundle);
            if (!(definition == null || (string = (String)bundle.getHeaders("").get("Eclipse-AspectBundle")) != null && "finished".equals(string))) {
                arrayList.add(definition);
                list.add(String.valueOf(bundle.getSymbolicName()) + ":" + bundleRevision.getVersion().toString());
            }
        }
        return arrayList;
    }
}

