/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IModelProviderDescriptor;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ModelStatus;
import org.eclipse.core.resources.mapping.ResourceChangeValidator;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeMatcher;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IMarkerHelpRegistry;
import org.eclipse.ui.ISaveableFilter;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.MultiPartInitException;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IEditorAssociationOverride;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.ide.IUnassociatedEditorStrategy;
import org.eclipse.ui.ide.ResourceSaveableFilter;
import org.eclipse.ui.internal.ide.EditorAssociationOverrideDescriptor;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.SystemEditorOrTextEditorStrategy;
import org.eclipse.ui.internal.ide.UnassociatedEditorStrategyRegistry;
import org.eclipse.ui.internal.ide.model.StandardPropertiesAdapterFactory;
import org.eclipse.ui.internal.ide.model.WorkbenchAdapterFactory;
import org.eclipse.ui.internal.ide.registry.MarkerHelpRegistry;
import org.eclipse.ui.internal.ide.registry.MarkerHelpRegistryReader;
import org.eclipse.ui.internal.misc.UIStats;
import org.eclipse.ui.part.FileEditorInput;

public final class IDE {
    public static final QualifiedName EDITOR_KEY = new QualifiedName("org.eclipse.ui.internal.registry.ResourceEditorRegistry", "EditorProperty");
    public static final String EDITOR_ID_ATTR = "org.eclipse.ui.editorID";
    public static final String RESOURCE_PERSPECTIVE_ID = "org.eclipse.ui.resourcePerspective";
    public static final String UNASSOCIATED_EDITOR_STRATEGY_PREFERENCE_KEY = "unassociatedEditorStrategy";
    private static MarkerHelpRegistry markerHelpRegistry = null;
    private static IEditorAssociationOverride[] editorAssociationOverrides;

    private IDE() {
    }

    public static IMarkerHelpRegistry getMarkerHelpRegistry() {
        if (markerHelpRegistry == null) {
            markerHelpRegistry = new MarkerHelpRegistry();
            new MarkerHelpRegistryReader().addHelp(markerHelpRegistry);
        }
        return markerHelpRegistry;
    }

    public static void gotoMarker(IEditorPart editor, IMarker marker) {
        IGotoMarker gotoMarker = (IGotoMarker)Adapters.adapt((Object)editor, IGotoMarker.class);
        if (gotoMarker != null) {
            gotoMarker.gotoMarker(marker);
        }
    }

    public static IEditorPart openEditor(IWorkbenchPage page, IEditorInput input, String editorId) throws PartInitException {
        if (page == null) {
            throw new IllegalArgumentException();
        }
        return page.openEditor(input, editorId);
    }

    public static IEditorPart openEditor(IWorkbenchPage page, URI uri, String editorId, boolean activate) throws PartInitException {
        IFileStore fileStore;
        if (page == null) {
            throw new IllegalArgumentException();
        }
        try {
            fileStore = EFS.getStore((URI)uri);
        }
        catch (CoreException e) {
            throw new PartInitException(IDEWorkbenchMessages.IDE_coreExceptionFileStore, (Throwable)e);
        }
        IEditorInput input = IDE.getEditorInput(fileStore);
        return page.openEditor(input, editorId, activate);
    }

    private static IEditorInput getEditorInput(IFileStore fileStore) {
        IFile workspaceFile = IDE.getWorkspaceFile(fileStore);
        if (workspaceFile != null) {
            return new FileEditorInput(workspaceFile);
        }
        return new FileStoreEditorInput(fileStore);
    }

    private static IFile getWorkspaceFile(IFileStore fileStore) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] files = root.findFilesForLocationURI(fileStore.toURI());
        if ((files = IDE.filterNonExistentFiles(files)) == null || files.length == 0) {
            return null;
        }
        return files[0];
    }

    private static IFile[] filterNonExistentFiles(IFile[] files) {
        if (files == null) {
            return null;
        }
        int length = files.length;
        ArrayList<IFile> existentFiles = new ArrayList<IFile>(length);
        int i = 0;
        while (i < length) {
            if (files[i].exists()) {
                existentFiles.add(files[i]);
            }
            ++i;
        }
        return existentFiles.toArray(new IFile[existentFiles.size()]);
    }

    public static IEditorPart openEditor(IWorkbenchPage page, IEditorInput input, String editorId, boolean activate) throws PartInitException {
        if (page == null) {
            throw new IllegalArgumentException();
        }
        return page.openEditor(input, editorId, activate);
    }

    public static IEditorPart openEditor(IWorkbenchPage page, IFile input, boolean activate) throws PartInitException {
        return IDE.openEditor(page, input, activate, true);
    }

    public static IEditorPart openEditor(IWorkbenchPage page, IFile input, boolean activate, boolean determineContentType) throws PartInitException {
        IEditorDescriptor editorDesc;
        if (page == null) {
            throw new IllegalArgumentException();
        }
        try {
            editorDesc = IDE.getEditorDescriptor(input, determineContentType, true);
        }
        catch (OperationCanceledException operationCanceledException) {
            return null;
        }
        return page.openEditor((IEditorInput)new FileEditorInput(input), editorDesc.getId(), activate);
    }

    public static IEditorPart openEditor(IWorkbenchPage page, IFile input) throws PartInitException {
        IEditorDescriptor editorDesc;
        if (page == null) {
            throw new IllegalArgumentException();
        }
        try {
            editorDesc = IDE.getEditorDescriptor(input, true, true);
        }
        catch (OperationCanceledException operationCanceledException) {
            return null;
        }
        return page.openEditor((IEditorInput)new FileEditorInput(input), editorDesc.getId());
    }

    public static IEditorPart openEditor(IWorkbenchPage page, IFile input, String editorId) throws PartInitException {
        if (page == null) {
            throw new IllegalArgumentException();
        }
        return page.openEditor((IEditorInput)new FileEditorInput(input), editorId);
    }

    public static IEditorPart openEditor(IWorkbenchPage page, IFile input, String editorId, boolean activate) throws PartInitException {
        if (page == null) {
            throw new IllegalArgumentException();
        }
        return page.openEditor((IEditorInput)new FileEditorInput(input), editorId, activate);
    }

    @Deprecated
    public static IEditorDescriptor getEditorDescriptor(IFile file) throws PartInitException {
        return IDE.getEditorDescriptor(file, true);
    }

    @Deprecated
    public static IEditorDescriptor getEditorDescriptor(IFile file, boolean determineContentType) throws PartInitException {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        return IDE.getEditorDescriptor(file.getName(), PlatformUI.getWorkbench().getEditorRegistry(), IDE.getDefaultEditor(file, determineContentType));
    }

    public static IEditorDescriptor getEditorDescriptor(IFile file, boolean determineContentType, boolean allowInteractive) throws PartInitException, OperationCanceledException {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        return IDE.getEditorDescriptor(file.getName(), PlatformUI.getWorkbench().getEditorRegistry(), IDE.getDefaultEditor(file, determineContentType), allowInteractive);
    }

    private static String getEditorId(IFileStore fileStore, boolean allowInteractive) throws PartInitException {
        String name = fileStore.fetchInfo().getName();
        if (name == null) {
            throw new IllegalArgumentException();
        }
        IContentType contentType = null;
        try (InputStream is = null;){
            is = fileStore.openInputStream(0, null);
            contentType = Platform.getContentTypeManager().findContentTypeFor(is, name);
        }
        catch (CoreException coreException) {
        }
        catch (IOException iOException) {}
        IEditorRegistry editorReg = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor defaultEditor = editorReg.getDefaultEditor(name, contentType);
        defaultEditor = IDE.overrideDefaultEditorAssociation(new FileStoreEditorInput(fileStore), contentType, defaultEditor);
        return IDE.getEditorDescriptor(name, editorReg, defaultEditor, allowInteractive).getId();
    }

    public static IEditorDescriptor overrideDefaultEditorAssociation(IEditorInput editorInput, IContentType contentType, IEditorDescriptor editorDescriptor) {
        IEditorAssociationOverride[] overrides = IDE.getEditorAssociationOverrides();
        int i = 0;
        while (i < overrides.length) {
            editorDescriptor = overrides[i].overrideDefaultEditor(editorInput, contentType, editorDescriptor);
            ++i;
        }
        return editorDescriptor;
    }

    private static IEditorDescriptor overrideDefaultEditorAssociation(String fileName, IContentType contentType, IEditorDescriptor editorDescriptor) {
        IEditorAssociationOverride[] overrides = IDE.getEditorAssociationOverrides();
        int i = 0;
        while (i < overrides.length) {
            editorDescriptor = overrides[i].overrideDefaultEditor(fileName, contentType, editorDescriptor);
            ++i;
        }
        return editorDescriptor;
    }

    public static IEditorDescriptor[] overrideEditorAssociations(IEditorInput editorInput, IContentType contentType, IEditorDescriptor[] editorDescriptors) {
        IEditorAssociationOverride[] overrides = IDE.getEditorAssociationOverrides();
        int i = 0;
        while (i < overrides.length) {
            editorDescriptors = overrides[i].overrideEditors(editorInput, contentType, editorDescriptors);
            ++i;
        }
        return IDE.removeNullEntries(editorDescriptors);
    }

    public static IEditorDescriptor[] overrideEditorAssociations(String fileName, IContentType contentType, IEditorDescriptor[] editorDescriptors) {
        IEditorAssociationOverride[] overrides = IDE.getEditorAssociationOverrides();
        int i = 0;
        while (i < overrides.length) {
            editorDescriptors = overrides[i].overrideEditors(fileName, contentType, editorDescriptors);
            ++i;
        }
        return IDE.removeNullEntries(editorDescriptors);
    }

    private static IEditorDescriptor[] removeNullEntries(IEditorDescriptor[] editorDescriptors) {
        boolean nullDescriptorFound = false;
        IEditorDescriptor[] iEditorDescriptorArray = editorDescriptors;
        int n = editorDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorDescriptor d = iEditorDescriptorArray[n2];
            if (d == null) {
                nullDescriptorFound = true;
                break;
            }
            ++n2;
        }
        if (!nullDescriptorFound) {
            return editorDescriptors;
        }
        ArrayList<IEditorDescriptor> nonNullDescriptors = new ArrayList<IEditorDescriptor>(editorDescriptors.length);
        IEditorDescriptor[] iEditorDescriptorArray2 = editorDescriptors;
        int n3 = editorDescriptors.length;
        n = 0;
        while (n < n3) {
            IEditorDescriptor d = iEditorDescriptorArray2[n];
            if (d != null) {
                nonNullDescriptors.add(d);
            }
            ++n;
        }
        return nonNullDescriptors.toArray(new IEditorDescriptor[nonNullDescriptors.size()]);
    }

    @Deprecated
    public static IEditorDescriptor getEditorDescriptor(String name) throws PartInitException {
        return IDE.getEditorDescriptor(name, true);
    }

    @Deprecated
    public static IEditorDescriptor getEditorDescriptor(String name, boolean inferContentType) throws PartInitException {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        IContentType contentType = inferContentType ? Platform.getContentTypeManager().findContentTypeFor(name) : null;
        IEditorRegistry editorReg = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor defaultEditor = editorReg.getDefaultEditor(name, contentType);
        defaultEditor = IDE.getEditorDescriptor(name, editorReg, defaultEditor);
        return IDE.overrideDefaultEditorAssociation(name, contentType, defaultEditor);
    }

    public static IEditorDescriptor getEditorDescriptor(String name, boolean inferContentType, boolean allowInteractive) throws PartInitException, OperationCanceledException {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        IContentType contentType = inferContentType ? Platform.getContentTypeManager().findContentTypeFor(name) : null;
        IEditorRegistry editorReg = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor defaultEditor = editorReg.getDefaultEditor(name, contentType);
        defaultEditor = IDE.getEditorDescriptor(name, editorReg, defaultEditor, allowInteractive);
        return IDE.overrideDefaultEditorAssociation(name, contentType, defaultEditor);
    }

    private static IEditorDescriptor getEditorDescriptor(String name, IEditorRegistry editorReg, IEditorDescriptor defaultDescriptor, boolean allowInteractive) throws PartInitException, OperationCanceledException {
        IEditorDescriptor editorDesc;
        if (defaultDescriptor != null) {
            return defaultDescriptor;
        }
        IUnassociatedEditorStrategy strategy = IDE.getUnassociatedEditorStrategy(allowInteractive);
        try {
            editorDesc = strategy.getEditorDescriptor(name, editorReg);
        }
        catch (CoreException e) {
            throw new PartInitException(IDEWorkbenchMessages.IDE_noFileEditorFound, (Throwable)e);
        }
        if (editorDesc == null) {
            throw new PartInitException(IDEWorkbenchMessages.IDE_noFileEditorFound);
        }
        return editorDesc;
    }

    @Deprecated
    private static IEditorDescriptor getEditorDescriptor(String name, IEditorRegistry editorReg, IEditorDescriptor defaultDescriptor) throws PartInitException {
        if (defaultDescriptor != null) {
            return defaultDescriptor;
        }
        IEditorDescriptor editorDesc = defaultDescriptor;
        if (editorReg.isSystemInPlaceEditorAvailable(name)) {
            editorDesc = editorReg.findEditor("org.eclipse.ui.systemInPlaceEditor");
        }
        if (editorDesc == null && editorReg.isSystemExternalEditorAvailable(name)) {
            editorDesc = editorReg.findEditor("org.eclipse.ui.systemExternalEditor");
        }
        if (editorDesc == null) {
            editorDesc = editorReg.findEditor("org.eclipse.ui.DefaultTextEditor");
        }
        if (editorDesc == null) {
            throw new PartInitException(IDEWorkbenchMessages.IDE_noFileEditorFound);
        }
        return editorDesc;
    }

    private static IUnassociatedEditorStrategy getUnassociatedEditorStrategy(boolean allowInteractive) {
        String preferedStrategy = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getString(UNASSOCIATED_EDITOR_STRATEGY_PREFERENCE_KEY);
        IUnassociatedEditorStrategy res = null;
        UnassociatedEditorStrategyRegistry registry = IDEWorkbenchPlugin.getDefault().getUnassociatedEditorStrategyRegistry();
        if (allowInteractive || !registry.isInteractive(preferedStrategy)) {
            res = registry.getStrategy(preferedStrategy);
        }
        if (res == null) {
            res = new SystemEditorOrTextEditorStrategy();
        }
        return res;
    }

    public static IEditorPart openEditor(IWorkbenchPage page, IMarker marker) throws PartInitException {
        return IDE.openEditor(page, marker, true);
    }

    public static IEditorPart openEditor(IWorkbenchPage page, IMarker marker, boolean activate) throws PartInitException {
        if (page == null || marker == null) {
            throw new IllegalArgumentException();
        }
        if (!(marker.getResource() instanceof IFile)) {
            IDEWorkbenchPlugin.log("Open editor on marker failed; marker resource not an IFile");
            return null;
        }
        IFile file = (IFile)marker.getResource();
        IEditorRegistry editorReg = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor editorDesc = null;
        try {
            String editorID = (String)marker.getAttribute(EDITOR_ID_ATTR);
            if (editorID != null) {
                editorDesc = editorReg.findEditor(editorID);
            }
        }
        catch (CoreException coreException) {}
        IEditorPart editor = null;
        editor = editorDesc == null ? IDE.openEditor(page, file, activate) : page.openEditor((IEditorInput)new FileEditorInput(file), editorDesc.getId(), activate, 3);
        if (editor != null) {
            IDE.gotoMarker(editor, marker);
        }
        return editor;
    }

    public static IEditorPart openEditorOnFileStore(IWorkbenchPage page, IFileStore fileStore) throws PartInitException {
        String editorId;
        if (page == null) {
            throw new IllegalArgumentException();
        }
        IEditorInput input = IDE.getEditorInput(fileStore);
        try {
            editorId = IDE.getEditorId(fileStore, true);
        }
        catch (OperationCanceledException operationCanceledException) {
            return null;
        }
        return page.openEditor(input, editorId);
    }

    /*
     * Unable to fully structure code
     */
    public static IEditorPart openInternalEditorOnFileStore(IWorkbenchPage page, IFileStore fileStore) throws PartInitException {
        block27: {
            if (page == null) {
                throw new IllegalArgumentException();
            }
            if (fileStore == null) {
                throw new IllegalArgumentException();
            }
            input = IDE.getEditorInput(fileStore);
            name = fileStore.fetchInfo().getName();
            if (name == null) {
                throw new IllegalArgumentException();
            }
            contentTypes = null;
            is = null;
            try {
                is = fileStore.openInputStream(0, null);
                contentTypes = Platform.getContentTypeManager().findContentTypesFor(is, name);
            }
            catch (CoreException v0) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException v1) {}
                }
                break block27;
            }
            catch (IOException v2) {
                try {
                    ** if (is == null) goto lbl-1000
                }
                catch (Throwable var6_6) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException v4) {}
                    }
                    throw var6_6;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        is.close();
                    }
                    catch (IOException v3) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block27;
                }
            }
            if (is == null) break block27;
            try {
                is.close();
            }
            catch (IOException v5) {}
        }
        editorReg = PlatformUI.getWorkbench().getEditorRegistry();
        if (contentTypes != null) {
            i = 0;
            while (i < contentTypes.length) {
                editorDesc = editorReg.getDefaultEditor(name, contentTypes[i]);
                if ((editorDesc = IDE.overrideDefaultEditorAssociation(input, contentTypes[i], editorDesc)) != null && editorDesc.isInternal()) {
                    return page.openEditor(input, editorDesc.getId());
                }
                ++i;
            }
        }
        if ((editors = editorReg.getEditors(name)) != null) {
            editors = IDE.overrideEditorAssociations(input, null, editors);
            i = 0;
            while (i < editors.length) {
                if (editors[i] != null && editors[i].isInternal()) {
                    return page.openEditor(input, editors[i].getId());
                }
                ++i;
            }
        }
        if ((textEditor = editorReg.findEditor("org.eclipse.ui.DefaultTextEditor")) == null) {
            throw new PartInitException(IDEWorkbenchMessages.IDE_noFileEditorFound);
        }
        return page.openEditor(input, textEditor.getId());
    }

    public static boolean saveAllEditors(final IResource[] resourceRoots, final boolean confirm) {
        if (resourceRoots.length == 0) {
            return true;
        }
        final boolean[] result = new boolean[]{true};
        SafeRunner.run((ISafeRunnable)new SafeRunnable(IDEWorkbenchMessages.ErrorOnSaveAll){

            public void run() {
                IWorkbenchWindow[] windows;
                IWorkbenchWindow w = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (w == null && (windows = PlatformUI.getWorkbench().getWorkbenchWindows()).length > 0) {
                    w = windows[0];
                }
                if (w != null) {
                    result[0] = PlatformUI.getWorkbench().saveAll((IShellProvider)w, (IRunnableContext)w, (ISaveableFilter)new ResourceSaveableFilter(resourceRoots), confirm);
                }
            }
        });
        return result[0];
    }

    public static void setDefaultEditor(IFile file, String editorID) {
        try {
            file.setPersistentProperty(EDITOR_KEY, editorID);
        }
        catch (CoreException coreException) {}
    }

    public static IEditorDescriptor getDefaultEditor(IFile file) {
        return IDE.getDefaultEditor(file, true);
    }

    public static IEditorDescriptor getDefaultEditor(IFile file, boolean determineContentType) {
        IEditorRegistry editorReg = PlatformUI.getWorkbench().getEditorRegistry();
        IContentType contentType = null;
        if (determineContentType) {
            contentType = IDE.getContentType(file);
        }
        try {
            IEditorDescriptor desc;
            String editorID = file.getPersistentProperty(EDITOR_KEY);
            if (editorID != null && (desc = editorReg.findEditor(editorID)) != null) {
                return IDE.overrideDefaultEditorAssociation(new FileEditorInput(file), contentType, desc);
            }
        }
        catch (CoreException coreException) {}
        IEditorDescriptor desc = editorReg.getDefaultEditor(file.getName(), contentType);
        return IDE.overrideDefaultEditorAssociation(new FileEditorInput(file), contentType, desc);
    }

    public static List computeSelectedResources(IStructuredSelection originalSelection) {
        ArrayList<Object> resources = null;
        for (Object next : originalSelection) {
            Object resource = Adapters.adapt(next, IResource.class);
            if (resource == null) continue;
            if (resources == null) {
                resources = new ArrayList<Object>(originalSelection.size());
            }
            resources.add(resource);
        }
        if (resources == null) {
            return Collections.EMPTY_LIST;
        }
        return resources;
    }

    public static IContentType getContentType(IFile file) {
        try {
            UIStats.start((int)14, (String)file.getName());
            IContentDescription contentDescription = file.getContentDescription();
            if (contentDescription == null) {
                return null;
            }
            IContentType iContentType = contentDescription.getContentType();
            return iContentType;
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 274) {
                IContentType iContentType = Platform.getContentTypeManager().findContentTypeFor(file.getName());
                return iContentType;
            }
            return null;
        }
        finally {
            UIStats.end((int)14, (Object)file, (String)file.getName());
        }
    }

    public static IContentType guessContentType(IFile file) {
        String fileName = file.getName();
        try {
            UIStats.start((int)14, (String)fileName);
            IContentTypeMatcher matcher = file.getProject().getContentTypeMatcher();
            IContentType iContentType = matcher.findContentTypeFor(fileName);
            return iContentType;
        }
        catch (CoreException coreException) {
            return null;
        }
        finally {
            UIStats.end((int)14, (Object)file, (String)fileName);
        }
    }

    public static boolean promptToConfirm(Shell shell, String title, String message, IResourceDelta delta, String[] ignoreModelProviderIds, boolean syncExec) {
        Object displayStatus;
        IStatus status = ResourceChangeValidator.getValidator().validateChange(delta, null);
        if (status.isOK()) {
            return true;
        }
        if (status.isMultiStatus()) {
            ArrayList<IStatus> result = new ArrayList<IStatus>();
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                IStatus child = children[i];
                if (!IDE.isIgnoredStatus(child, ignoreModelProviderIds)) {
                    result.add(child);
                }
                ++i;
            }
            if (result.isEmpty()) {
                return true;
            }
            displayStatus = result.size() == 1 ? (IStatus)result.get(0) : new MultiStatus(status.getPlugin(), status.getCode(), result.toArray(new IStatus[result.size()]), status.getMessage(), status.getException());
        } else {
            if (IDE.isIgnoredStatus(status, ignoreModelProviderIds)) {
                return true;
            }
            displayStatus = status;
        }
        if (message == null) {
            message = IDEWorkbenchMessages.IDE_sideEffectWarning;
        }
        String dialogMessage = NLS.bind((String)IDEWorkbenchMessages.IDE_areYouSure, (Object)message);
        boolean[] result = new boolean[1];
        Runnable runnable = () -> IDE.lambda$0(shell, title, dialogMessage, (IStatus)displayStatus, result);
        if (syncExec) {
            shell.getDisplay().syncExec(runnable);
        } else {
            runnable.run();
        }
        return result[0];
    }

    public static void registerAdapters() {
        IAdapterManager manager = Platform.getAdapterManager();
        WorkbenchAdapterFactory factory = new WorkbenchAdapterFactory();
        manager.registerAdapters((IAdapterFactory)factory, IWorkspace.class);
        manager.registerAdapters((IAdapterFactory)factory, IWorkspaceRoot.class);
        manager.registerAdapters((IAdapterFactory)factory, IProject.class);
        manager.registerAdapters((IAdapterFactory)factory, IFolder.class);
        manager.registerAdapters((IAdapterFactory)factory, IFile.class);
        manager.registerAdapters((IAdapterFactory)factory, IMarker.class);
        StandardPropertiesAdapterFactory paFactory = new StandardPropertiesAdapterFactory();
        manager.registerAdapters((IAdapterFactory)paFactory, IWorkspace.class);
        manager.registerAdapters((IAdapterFactory)paFactory, IWorkspaceRoot.class);
        manager.registerAdapters((IAdapterFactory)paFactory, IProject.class);
        manager.registerAdapters((IAdapterFactory)paFactory, IFolder.class);
        manager.registerAdapters((IAdapterFactory)paFactory, IFile.class);
        manager.registerAdapters((IAdapterFactory)paFactory, IMarker.class);
    }

    private static boolean isIgnoredStatus(IStatus status, String[] ignoreModelProviderIds) {
        if (ignoreModelProviderIds == null) {
            return false;
        }
        if (status instanceof ModelStatus) {
            ModelStatus ms = (ModelStatus)status;
            int i = 0;
            while (i < ignoreModelProviderIds.length) {
                String id = ignoreModelProviderIds[i];
                if (ms.getModelProviderId().equals(id)) {
                    return true;
                }
                IModelProviderDescriptor desc = ModelProvider.getModelProviderDescriptor((String)id);
                String[] extended = desc.getExtendedModels();
                if (IDE.isIgnoredStatus(status, extended)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static IEditorReference[] openEditors(IWorkbenchPage page, IFile[] inputs) throws MultiPartInitException {
        if (page == null || inputs == null) {
            throw new IllegalArgumentException();
        }
        String[] editorDescriptions = new String[inputs.length];
        IEditorInput[] editorInputs = new IEditorInput[inputs.length];
        int i = 0;
        while (i < inputs.length) {
            editorInputs[i] = new FileEditorInput(inputs[i]);
            try {
                editorDescriptions[i] = IDE.getEditorDescriptor(inputs[i]).getId();
            }
            catch (PartInitException e) {
                PartInitException[] exceptions = new PartInitException[inputs.length];
                exceptions[i] = e;
                throw new MultiPartInitException(new IWorkbenchPartReference[inputs.length], exceptions);
            }
            ++i;
        }
        return page.openEditors(editorInputs, editorDescriptions, 1);
    }

    private static synchronized IEditorAssociationOverride[] getEditorAssociationOverrides() {
        if (editorAssociationOverrides == null) {
            EditorAssociationOverrideDescriptor[] descriptors = EditorAssociationOverrideDescriptor.getContributedEditorAssociationOverrides();
            ArrayList<IEditorAssociationOverride> overrides = new ArrayList<IEditorAssociationOverride>(descriptors.length);
            int i = 0;
            while (i < descriptors.length) {
                try {
                    IEditorAssociationOverride override = descriptors[i].createOverride();
                    overrides.add(override);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++i;
            }
            editorAssociationOverrides = overrides.toArray(new IEditorAssociationOverride[overrides.size()]);
        }
        return editorAssociationOverrides;
    }

    private static /* synthetic */ void lambda$0(Shell shell, String string, String string2, IStatus iStatus, boolean[] blArray) {
        ErrorDialog dialog = new ErrorDialog(shell, string, string2, iStatus, 7){

            protected void createButtonsForButtonBar(Composite parent) {
                this.createButton(parent, 2, IDialogConstants.YES_LABEL, false);
                this.createButton(parent, 3, IDialogConstants.NO_LABEL, true);
                this.createDetailsButton(parent);
            }

            protected void buttonPressed(int id) {
                if (id == 2) {
                    super.buttonPressed(0);
                } else if (id == 3) {
                    super.buttonPressed(1);
                }
                super.buttonPressed(id);
            }

            protected int getShellStyle() {
                return super.getShellStyle() | 0x10000000;
            }
        };
        int code = dialog.open();
        blArray[0] = code == 0;
    }

    public static interface Preferences {
        public static final String PROJECT_OPEN_NEW_PERSPECTIVE = "PROJECT_OPEN_NEW_PERSPECTIVE";
        public static final String SHOW_WORKSPACE_SELECTION_DIALOG = "SHOW_WORKSPACE_SELECTION_DIALOG";
        public static final String SHOW_RECENT_WORKSPACES = "SHOW_RECENT_WORKSPACES";
        public static final String MAX_RECENT_WORKSPACES = "MAX_RECENT_WORKSPACES";
        public static final String RECENT_WORKSPACES = "RECENT_WORKSPACES";
        public static final String RECENT_WORKSPACES_PROTOCOL = "RECENT_WORKSPACES_PROTOCOL";
        public static final String WORKSPACE_NAME = "WORKSPACE_NAME";
    }

    public static interface SharedImages {
        public static final String IMG_OBJ_PROJECT = "IMG_OBJ_PROJECT";
        public static final String IMG_OBJ_PROJECT_CLOSED = "IMG_OBJ_PROJECT_CLOSED";
        public static final String IMG_OPEN_MARKER = "IMG_OPEN_MARKER";
        public static final String IMG_OBJS_TASK_TSK = "IMG_OBJS_TASK_TSK";
        public static final String IMG_OBJS_BKMRK_TSK = "IMG_OBJS_BKMRK_TSK";
    }
}

