/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.ui.workingsets.ClearWorkingSetAction;
import org.eclipse.jdt.internal.ui.workingsets.EditWorkingSetAction;
import org.eclipse.jdt.internal.ui.workingsets.IWorkingSetActionGroup;
import org.eclipse.jdt.internal.ui.workingsets.SelectWorkingSetAction;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetComparator;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetFilter;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetMenuContributionItem;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;

public class WorkingSetFilterActionGroup
extends ActionGroup
implements IWorkingSetActionGroup {
    private static final String TAG_WORKING_SET_NAME = "workingSetName";
    private static final String LRU_GROUP = "workingSet_lru_group";
    private final WorkingSetFilter fWorkingSetFilter;
    private IWorkingSet fWorkingSet = null;
    private final ClearWorkingSetAction fClearWorkingSetAction;
    private final SelectWorkingSetAction fSelectWorkingSetAction;
    private final EditWorkingSetAction fEditWorkingSetAction;
    private IPropertyChangeListener fWorkingSetListener;
    private IPropertyChangeListener fChangeListener;
    private int fLRUMenuCount;
    private IMenuManager fMenuManager;
    private IMenuListener fMenuListener;
    private List<IContributionItem> fContributions = new ArrayList<IContributionItem>();
    private final IWorkbenchPage fWorkbenchPage;
    private boolean fAllowWindowWorkingSetByDefault;

    public WorkingSetFilterActionGroup(IWorkbenchPartSite site, IPropertyChangeListener changeListener) {
        Assert.isNotNull((Object)site);
        Assert.isNotNull((Object)changeListener);
        this.fChangeListener = changeListener;
        this.fWorkbenchPage = site.getPage();
        this.fAllowWindowWorkingSetByDefault = true;
        this.fClearWorkingSetAction = new ClearWorkingSetAction(this);
        this.fSelectWorkingSetAction = new SelectWorkingSetAction(this, site);
        this.fEditWorkingSetAction = new EditWorkingSetAction(this, site);
        this.fWorkingSetListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                WorkingSetFilterActionGroup.this.doPropertyChange(event);
            }
        };
        this.fWorkingSetFilter = new WorkingSetFilter();
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        manager.addPropertyChangeListener(this.fWorkingSetListener);
        if (this.useWindowWorkingSetByDefault()) {
            this.setWorkingSet(site.getPage().getAggregateWorkingSet(), false);
        }
    }

    public WorkingSetFilterActionGroup(Shell shell, IWorkbenchPage page, IPropertyChangeListener changeListener) {
        Assert.isNotNull((Object)shell);
        Assert.isNotNull((Object)changeListener);
        this.fWorkbenchPage = page;
        this.fAllowWindowWorkingSetByDefault = false;
        this.fChangeListener = changeListener;
        this.fClearWorkingSetAction = new ClearWorkingSetAction(this);
        this.fSelectWorkingSetAction = new SelectWorkingSetAction(this, shell);
        this.fEditWorkingSetAction = new EditWorkingSetAction(this, shell);
        this.fWorkingSetListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                WorkingSetFilterActionGroup.this.doPropertyChange(event);
            }
        };
        this.fWorkingSetFilter = new WorkingSetFilter();
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        manager.addPropertyChangeListener(this.fWorkingSetListener);
        this.setWorkingSet(null, false);
    }

    public boolean isFiltered(Object parent, Object object) {
        if (this.fWorkingSetFilter == null) {
            return false;
        }
        return !this.fWorkingSetFilter.select(null, parent, object);
    }

    public IWorkingSet getWorkingSet() {
        return this.fWorkingSet;
    }

    public void setWorkingSet(IWorkingSet workingSet, boolean refreshViewer) {
        this.fClearWorkingSetAction.setEnabled(workingSet != null);
        this.fEditWorkingSetAction.setEnabled(workingSet != null && !workingSet.isAggregateWorkingSet());
        this.fWorkingSet = workingSet;
        this.fWorkingSetFilter.setWorkingSet(workingSet);
        if (refreshViewer) {
            this.fChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "workingSetContentChange", null, (Object)workingSet));
        }
    }

    public void saveState(IMemento memento) {
        if (this.fWorkingSet != null) {
            memento.putString(TAG_WORKING_SET_NAME, this.fWorkingSet.getName());
        } else {
            memento.putString(TAG_WORKING_SET_NAME, "");
        }
    }

    public void restoreState(IMemento memento) {
        String workingSetName = memento.getString(TAG_WORKING_SET_NAME);
        if (workingSetName != null && workingSetName.length() > 0) {
            this.setWorkingSet(PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(workingSetName), false);
        } else if (this.fWorkbenchPage != null && this.useWindowWorkingSetByDefault()) {
            this.setWorkingSet(this.fWorkbenchPage.getAggregateWorkingSet(), false);
        }
    }

    private boolean useWindowWorkingSetByDefault() {
        return this.fAllowWindowWorkingSetByDefault && PlatformUI.getPreferenceStore().getBoolean("USE_WINDOW_WORKING_SET_BY_DEFAULT");
    }

    public void fillActionBars(IActionBars actionBars) {
        this.fillToolBar(actionBars.getToolBarManager());
        this.fillViewMenu(actionBars.getMenuManager());
    }

    private void fillToolBar(IToolBarManager tbm) {
    }

    @Override
    public void fillViewMenu(IMenuManager mm) {
        if (mm.find("working_set_action_group") == null) {
            mm.add((IContributionItem)new Separator("working_set_action_group"));
        }
        this.add(mm, (IAction)this.fSelectWorkingSetAction);
        this.add(mm, (IAction)this.fClearWorkingSetAction);
        this.add(mm, (IAction)this.fEditWorkingSetAction);
        this.add(mm, (IContributionItem)new Separator());
        this.add(mm, (IContributionItem)new Separator(LRU_GROUP));
        this.fMenuManager = mm;
        this.fMenuListener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                WorkingSetFilterActionGroup.this.removePreviousLRUWorkingSetActions(manager);
                WorkingSetFilterActionGroup.this.addLRUWorkingSetActions(manager);
            }
        };
        this.fMenuManager.addMenuListener(this.fMenuListener);
    }

    private void add(IMenuManager mm, IAction action) {
        ActionContributionItem item = new ActionContributionItem(action);
        mm.appendToGroup("working_set_action_group", (IContributionItem)item);
        this.fContributions.add((IContributionItem)item);
    }

    private void add(IMenuManager mm, IContributionItem item) {
        mm.appendToGroup("working_set_action_group", item);
        this.fContributions.add(item);
    }

    private void removePreviousLRUWorkingSetActions(IMenuManager mm) {
        int i = 1;
        while (i < this.fLRUMenuCount) {
            String id = WorkingSetMenuContributionItem.getId(i);
            IContributionItem item = mm.remove(id);
            if (item != null) {
                item.dispose();
                this.fContributions.remove(item);
            }
            ++i;
        }
    }

    private void addLRUWorkingSetActions(IMenuManager mm) {
        IWorkingSet[] workingSets = PlatformUI.getWorkbench().getWorkingSetManager().getRecentWorkingSets();
        Arrays.sort(workingSets, new WorkingSetComparator());
        int currId = 1;
        if (this.fWorkbenchPage != null) {
            this.addLRUWorkingSetAction(mm, currId++, this.fWorkbenchPage.getAggregateWorkingSet());
        }
        int i = 0;
        while (i < workingSets.length) {
            if (!workingSets[i].isAggregateWorkingSet()) {
                this.addLRUWorkingSetAction(mm, currId++, workingSets[i]);
            }
            ++i;
        }
        this.fLRUMenuCount = currId;
    }

    private void addLRUWorkingSetAction(IMenuManager mm, int id, IWorkingSet workingSet) {
        WorkingSetMenuContributionItem item = new WorkingSetMenuContributionItem(id, this, workingSet);
        mm.insertBefore(LRU_GROUP, (IContributionItem)item);
        this.fContributions.add((IContributionItem)item);
    }

    @Override
    public void cleanViewMenu(IMenuManager menuManager) {
        Iterator<IContributionItem> iter = this.fContributions.iterator();
        while (iter.hasNext()) {
            IContributionItem removed = menuManager.remove(iter.next());
            if (removed == null) continue;
            removed.dispose();
        }
        this.fContributions.clear();
        this.fMenuManager.removeMenuListener(this.fMenuListener);
        this.fMenuListener = null;
    }

    public void dispose() {
        if (this.fMenuManager != null && this.fMenuListener != null) {
            this.fMenuManager.removeMenuListener(this.fMenuListener);
        }
        if (this.fWorkingSetListener != null) {
            PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener(this.fWorkingSetListener);
            this.fWorkingSetListener = null;
        }
        this.fChangeListener = null;
        super.dispose();
    }

    public ViewerFilter getWorkingSetFilter() {
        return this.fWorkingSetFilter;
    }

    private void doPropertyChange(PropertyChangeEvent event) {
        IWorkingSet newWorkingSet;
        String property = event.getProperty();
        if ("workingSetLabelChange".equals(property)) {
            this.fChangeListener.propertyChange(event);
        } else if ("workingSetContentChange".equals(property) && (newWorkingSet = (IWorkingSet)event.getNewValue()).equals(this.fWorkingSet)) {
            if (this.fWorkingSetFilter != null) {
                this.fWorkingSetFilter.notifyWorkingSetContentChange();
            }
            this.fChangeListener.propertyChange(event);
        }
    }
}

