/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.tasklist;

import java.util.ArrayList;
import org.eclipse.ui.views.tasklist.MarkerTypesModel;

class MarkerType {
    private MarkerTypesModel model;
    private String id;
    private String label;
    private String[] supertypeIds;

    public MarkerType(MarkerTypesModel model, String id, String label, String[] supertypeIds) {
        this.model = model;
        this.id = id;
        this.label = label;
        this.supertypeIds = supertypeIds;
    }

    public MarkerType[] getAllSupertypes() {
        ArrayList result = new ArrayList();
        this.getAllSupertypes(result);
        return result.toArray(new MarkerType[result.size()]);
    }

    private void getAllSupertypes(ArrayList result) {
        MarkerType[] markerTypeArray = this.getSupertypes();
        int n = markerTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MarkerType sup = markerTypeArray[n2];
            if (!result.contains(sup)) {
                result.add(sup);
                sup.getAllSupertypes(result);
            }
            ++n2;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public MarkerType[] getSubtypes() {
        ArrayList<MarkerType> result = new ArrayList<MarkerType>();
        MarkerType[] markerTypeArray = this.model.getTypes();
        int n = markerTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MarkerType markerType = markerTypeArray[n2];
            String[] stringArray = markerType.getSupertypeIds();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String supertypeId = stringArray[n4];
                if (supertypeId.equals(this.id)) {
                    result.add(markerType);
                }
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new MarkerType[result.size()]);
    }

    public String[] getSupertypeIds() {
        return this.supertypeIds;
    }

    public MarkerType[] getSupertypes() {
        ArrayList<MarkerType> result = new ArrayList<MarkerType>();
        String[] stringArray = this.supertypeIds;
        int n = this.supertypeIds.length;
        int n2 = 0;
        while (n2 < n) {
            String supertypeId = stringArray[n2];
            MarkerType sup = this.model.getType(supertypeId);
            if (sup != null) {
                result.add(sup);
            }
            ++n2;
        }
        return result.toArray(new MarkerType[result.size()]);
    }

    public boolean isSubtypeOf(MarkerType superType) {
        if (this.id.equals(superType.getId())) {
            return true;
        }
        String[] stringArray = this.supertypeIds;
        int n = this.supertypeIds.length;
        int n2 = 0;
        while (n2 < n) {
            String supertypeId = stringArray[n2];
            MarkerType sup = this.model.getType(supertypeId);
            if (sup != null && sup.isSubtypeOf(superType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

