/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.site;

import java.io.PrintWriter;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.core.isite.ISiteBundle;
import org.eclipse.pde.internal.core.isite.ISiteCategory;
import org.eclipse.pde.internal.core.site.SiteCategory;
import org.eclipse.pde.internal.core.site.VersionableObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SiteBundle
extends VersionableObject
implements ISiteBundle {
    private static final long serialVersionUID = 1L;
    private Vector<ISiteCategory> fCategories = new Vector();

    @Override
    public boolean isValid() {
        int i = 0;
        while (i < this.fCategories.size()) {
            ISiteCategory category = this.fCategories.get(i);
            if (!category.isValid()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void addCategories(ISiteCategory[] newCategories) throws CoreException {
        this.ensureModelEditable();
        ISiteCategory[] iSiteCategoryArray = newCategories;
        int n = newCategories.length;
        int n2 = 0;
        while (n2 < n) {
            ISiteCategory category = iSiteCategoryArray[n2];
            ((SiteCategory)category).setInTheModel(true);
            this.fCategories.add(category);
            ++n2;
        }
        this.fireStructureChanged(newCategories, 1);
    }

    @Override
    public void removeCategories(ISiteCategory[] newCategories) throws CoreException {
        this.ensureModelEditable();
        ISiteCategory[] iSiteCategoryArray = newCategories;
        int n = newCategories.length;
        int n2 = 0;
        while (n2 < n) {
            ISiteCategory category = iSiteCategoryArray[n2];
            ((SiteCategory)category).setInTheModel(false);
            this.fCategories.remove(category);
            ++n2;
        }
        this.fireStructureChanged(newCategories, 2);
    }

    @Override
    public ISiteCategory[] getCategories() {
        return this.fCategories.toArray(new ISiteCategory[this.fCategories.size()]);
    }

    @Override
    protected void parse(Node node) {
        super.parse(node);
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().equalsIgnoreCase("category")) {
                SiteCategory category = (SiteCategory)this.getModel().getFactory().createCategory(this);
                category.parse(child);
                category.setInTheModel(true);
                this.fCategories.add(category);
            }
            ++i;
        }
    }

    @Override
    protected void reset() {
        super.reset();
        this.fCategories.clear();
    }

    @Override
    public void write(String indent, PrintWriter writer) {
        writer.print(indent);
        writer.print("<bundle");
        if (this.id != null) {
            writer.print(" id=\"" + this.getId() + "\"");
        }
        if (this.version != null) {
            writer.print(" version=\"" + this.getVersion() + "\"");
        }
        if (this.label != null) {
            writer.print(" label=\"" + this.getLabel() + "\"");
        }
        if (this.fCategories.size() > 0) {
            writer.println(">");
            String indent2 = String.valueOf(indent) + "   ";
            int i = 0;
            while (i < this.fCategories.size()) {
                ISiteCategory category = this.fCategories.get(i);
                category.write(indent2, writer);
                ++i;
            }
            writer.println(String.valueOf(indent) + "</bundle>");
        } else {
            writer.println("/>");
        }
    }
}

