/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.product;

import java.io.PrintWriter;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.iproduct.IRepositoryInfo;
import org.eclipse.pde.internal.core.product.ProductObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RepositoryInfo
extends ProductObject
implements IRepositoryInfo {
    private static final long serialVersionUID = 1L;
    public static final String P_LOCATION = "location";
    public static final String P_ENABLED = "enabled";
    private String fURL;
    private boolean fEnabled = true;

    public RepositoryInfo(IProductModel model) {
        super(model);
    }

    @Override
    public void setURL(String url) {
        String old = this.fURL;
        this.fURL = url;
        if (this.isEditable()) {
            this.firePropertyChanged(P_LOCATION, old, this.fURL);
        }
    }

    @Override
    public String getURL() {
        return this.fURL;
    }

    @Override
    public boolean getEnabled() {
        return this.fEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean old = this.fEnabled;
        this.fEnabled = enabled;
        if (this.isEditable()) {
            this.firePropertyChanged(P_ENABLED, old, this.fEnabled);
        }
    }

    @Override
    public void parse(Node node) {
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            this.fURL = element.getAttribute(P_LOCATION);
            this.fEnabled = Boolean.valueOf(element.getAttribute(P_ENABLED));
        }
    }

    @Override
    public void write(String indent, PrintWriter writer) {
        if (this.isURLDefined()) {
            writer.print(String.valueOf(indent) + "<repository location=\"" + this.fURL + "\"");
            writer.print(" enabled=\"" + this.fEnabled + "\"");
            writer.println(" />");
        }
    }

    private boolean isURLDefined() {
        return this.fURL != null && this.fURL.length() > 0;
    }
}

