/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jdt.ui.text.IColorManagerExtension;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class JavaColorManager
implements IColorManager,
IColorManagerExtension {
    protected Map<String, RGB> fKeyTable = new HashMap<String, RGB>(10);
    protected Map<Display, Map<RGB, Color>> fDisplayTable = new HashMap<Display, Map<RGB, Color>>(2);
    private boolean fAutoDisposeOnDisplayDispose;

    public JavaColorManager() {
        this(true);
    }

    public JavaColorManager(boolean autoDisposeOnDisplayDispose) {
        this.fAutoDisposeOnDisplayDispose = autoDisposeOnDisplayDispose;
    }

    public void dispose(Display display) {
        Map<RGB, Color> colorTable = this.fDisplayTable.get(display);
        if (colorTable != null) {
            for (Color color : colorTable.values()) {
                if (color == null || color.isDisposed()) continue;
                color.dispose();
            }
        }
    }

    public Color getColor(RGB rgb) {
        Color color;
        if (rgb == null) {
            return null;
        }
        final Display display = Display.getCurrent();
        Map<RGB, Color> colorTable = this.fDisplayTable.get(display);
        if (colorTable == null) {
            colorTable = new HashMap<RGB, Color>(10);
            this.fDisplayTable.put(display, colorTable);
            if (this.fAutoDisposeOnDisplayDispose) {
                display.disposeExec(new Runnable(){

                    @Override
                    public void run() {
                        JavaColorManager.this.dispose(display);
                    }
                });
            }
        }
        if ((color = colorTable.get(rgb)) == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            colorTable.put(rgb, color);
        }
        return color;
    }

    public void dispose() {
        if (!this.fAutoDisposeOnDisplayDispose) {
            this.dispose(Display.getCurrent());
        }
    }

    @Override
    public Color getColor(String key) {
        if (key == null) {
            return null;
        }
        RGB rgb = this.fKeyTable.get(key);
        return this.getColor(rgb);
    }

    @Override
    public void bindColor(String key, RGB rgb) {
        RGB value = this.fKeyTable.get(key);
        if (value != null) {
            throw new UnsupportedOperationException();
        }
        this.fKeyTable.put(key, rgb);
    }

    @Override
    public void unbindColor(String key) {
        this.fKeyTable.remove(key);
    }
}

