/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.Collection;
import java.util.Hashtable;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.fix.NullAnnotationsFix;
import org.eclipse.jdt.internal.corext.fix.NullAnnotationsRewriteOperations;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.fix.NullAnnotationsCleanUp;
import org.eclipse.jdt.internal.ui.text.correction.proposals.ExtractToNullCheckedLocalProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.FixCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.MakeLocalVariableNonNullProposal;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.correction.ICommandAccess;
import org.eclipse.swt.graphics.Image;

public class NullAnnotationsCorrectionProcessor {
    public static void addReturnAndArgumentTypeProposal(IInvocationContext context, IProblemLocation problem, NullAnnotationsRewriteOperations.ChangeKind changeKind, Collection<ICommandAccess> proposals) {
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        boolean isArgumentProblem = NullAnnotationsFix.isComplainingAboutArgument(selectedNode);
        if (isArgumentProblem || NullAnnotationsFix.isComplainingAboutReturn(selectedNode)) {
            NullAnnotationsCorrectionProcessor.addNullAnnotationInSignatureProposal(context, problem, proposals, changeKind, isArgumentProblem);
        }
    }

    public static void addNullAnnotationInSignatureProposal(IInvocationContext context, IProblemLocation problem, Collection<ICommandAccess> proposals, NullAnnotationsRewriteOperations.ChangeKind changeKind, boolean isArgumentProblem) {
        NullAnnotationsFix fix = NullAnnotationsFix.createNullAnnotationInSignatureFix(context.getASTRoot(), problem, changeKind, isArgumentProblem);
        if (fix != null) {
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            Hashtable<String, String> options = new Hashtable<String, String>();
            if (fix.getCu() != context.getASTRoot()) {
                final CompilationUnit cu = fix.getCu();
                final IInvocationContext originalContext = context;
                context = new IInvocationContext(){

                    @Override
                    public int getSelectionOffset() {
                        return originalContext.getSelectionOffset();
                    }

                    @Override
                    public int getSelectionLength() {
                        return originalContext.getSelectionLength();
                    }

                    @Override
                    public ASTNode getCoveringNode() {
                        return originalContext.getCoveringNode();
                    }

                    @Override
                    public ASTNode getCoveredNode() {
                        return originalContext.getCoveredNode();
                    }

                    @Override
                    public ICompilationUnit getCompilationUnit() {
                        return (ICompilationUnit)cu.getJavaElement();
                    }

                    @Override
                    public CompilationUnit getASTRoot() {
                        return cu;
                    }
                };
            }
            int relevance = changeKind == NullAnnotationsRewriteOperations.ChangeKind.OVERRIDDEN ? 9 : 10;
            FixCorrectionProposal proposal = new FixCorrectionProposal(fix, new NullAnnotationsCleanUp(options, problem.getProblemId()), relevance, image, context);
            proposals.add(proposal);
        }
    }

    public static void addRemoveRedundantAnnotationProposal(IInvocationContext context, IProblemLocation problem, Collection<ICommandAccess> proposals) {
        NullAnnotationsFix fix = NullAnnotationsFix.createRemoveRedundantNullAnnotationsFix(context.getASTRoot(), problem);
        if (fix == null) {
            return;
        }
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        Hashtable<String, String> options = new Hashtable<String, String>();
        FixCorrectionProposal proposal = new FixCorrectionProposal(fix, new NullAnnotationsCleanUp(options, problem.getProblemId()), 5, image, context);
        proposals.add(proposal);
    }

    public static void addExtractCheckedLocalProposal(IInvocationContext context, IProblemLocation problem, Collection<ICommandAccess> proposals) {
        CompilationUnit compilationUnit = context.getASTRoot();
        ICompilationUnit cu = (ICompilationUnit)compilationUnit.getJavaElement();
        ASTNode selectedNode = problem.getCoveringNode(compilationUnit);
        SimpleName name = NullAnnotationsCorrectionProcessor.findProblemFieldName(selectedNode, problem.getProblemId());
        if (name == null) {
            return;
        }
        ASTNode method = ASTNodes.getParent((ASTNode)selectedNode, MethodDeclaration.class);
        if (method == null) {
            method = ASTNodes.getParent((ASTNode)selectedNode, Initializer.class);
        }
        if (method == null) {
            return;
        }
        proposals.add(new ExtractToNullCheckedLocalProposal(cu, compilationUnit, name, method));
    }

    private static SimpleName findProblemFieldName(ASTNode selectedNode, int problemID) {
        if (selectedNode instanceof FieldAccess) {
            selectedNode = ((FieldAccess)selectedNode).getName();
        } else if (selectedNode instanceof QualifiedName) {
            selectedNode = ((QualifiedName)selectedNode).getName();
        }
        if (selectedNode instanceof SimpleName) {
            SimpleName name = (SimpleName)selectedNode;
            if (problemID == 33555356) {
                return name;
            }
            IBinding binding = name.resolveBinding();
            if (binding instanceof IVariableBinding && ((IVariableBinding)binding).isField()) {
                return name;
            }
        }
        return null;
    }

    public static void addLocalVariableAnnotationProposal(IInvocationContext context, IProblemLocation problem, Collection<ICommandAccess> proposals) {
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        String nonNullAnnotationName = NullAnnotationsFix.getNonNullAnnotationName(astRoot.getJavaElement(), false);
        if (nonNullAnnotationName == null) {
            return;
        }
        ASTNode selectedNode = problem.getCoveredNode(astRoot);
        if (!(selectedNode instanceof Expression)) {
            return;
        }
        Expression nodeToCast = (Expression)selectedNode;
        IBinding callerBinding = Bindings.resolveExpressionBinding((Expression)nodeToCast, (boolean)false);
        if (callerBinding instanceof IVariableBinding) {
            IVariableBinding variableBinding = (IVariableBinding)callerBinding;
            if (variableBinding.isField()) {
                return;
            }
            ITypeBinding type = variableBinding.getType();
            if (type == null || type.isArray()) {
                return;
            }
            proposals.add(new MakeLocalVariableNonNullProposal(cu, variableBinding, astRoot, 10, nonNullAnnotationName));
        }
    }
}

