/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java.hover;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.IJavaAnnotation;
import org.eclipse.jdt.internal.ui.text.correction.AssistContext;
import org.eclipse.jdt.internal.ui.text.correction.JavaCorrectionProcessor;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.jdt.internal.ui.text.java.hover.AbstractAnnotationHover;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jdt.ui.text.java.CompletionProposalComparator;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class ProblemHover
extends AbstractAnnotationHover {
    public ProblemHover() {
        super(false);
    }

    @Override
    protected AbstractAnnotationHover.AnnotationInfo createAnnotationInfo(Annotation annotation, Position position, ITextViewer textViewer) {
        return new ProblemInfo(annotation, position, textViewer);
    }

    protected static class ProblemInfo
    extends AbstractAnnotationHover.AnnotationInfo {
        private static final ICompletionProposal[] NO_PROPOSALS = new ICompletionProposal[0];

        public ProblemInfo(Annotation annotation, Position position, ITextViewer textViewer) {
            super(annotation, position, textViewer);
        }

        @Override
        public ICompletionProposal[] getCompletionProposals() {
            ICompletionProposal[] result;
            if (this.annotation instanceof IJavaAnnotation && (result = this.getJavaAnnotationFixes((IJavaAnnotation)this.annotation)).length > 0) {
                return result;
            }
            if (this.annotation instanceof MarkerAnnotation) {
                return this.getMarkerAnnotationFixes((MarkerAnnotation)this.annotation);
            }
            return NO_PROPOSALS;
        }

        private ICompletionProposal[] getJavaAnnotationFixes(IJavaAnnotation javaAnnotation) {
            ProblemLocation location = new ProblemLocation(this.position.getOffset(), this.position.getLength(), javaAnnotation);
            ICompilationUnit cu = javaAnnotation.getCompilationUnit();
            if (cu == null) {
                return NO_PROPOSALS;
            }
            ISourceViewer sourceViewer = null;
            if (this.viewer instanceof ISourceViewer) {
                sourceViewer = (ISourceViewer)this.viewer;
            }
            AssistContext context = new AssistContext(cu, sourceViewer, location.getOffset(), location.getLength(), SharedASTProvider.WAIT_ACTIVE_ONLY);
            if (!"org.eclipse.ui.workbench.texteditor.spelling".equals(javaAnnotation.getType()) && !ProblemInfo.hasProblem(context.getASTRoot().getProblems(), location)) {
                return NO_PROPOSALS;
            }
            ArrayList<IJavaCompletionProposal> proposals = new ArrayList<IJavaCompletionProposal>();
            JavaCorrectionProcessor.collectCorrections(context, new IProblemLocation[]{location}, proposals);
            Collections.sort(proposals, new CompletionProposalComparator());
            return proposals.toArray(new ICompletionProposal[proposals.size()]);
        }

        private static boolean hasProblem(IProblem[] problems, IProblemLocation location) {
            int i = 0;
            while (i < problems.length) {
                IProblem problem = problems[i];
                if (problem.getID() == location.getProblemId() && problem.getSourceStart() == location.getOffset()) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private ICompletionProposal[] getMarkerAnnotationFixes(MarkerAnnotation markerAnnotation) {
            if (markerAnnotation.isQuickFixableStateSet() && !markerAnnotation.isQuickFixable()) {
                return NO_PROPOSALS;
            }
            IMarker marker = markerAnnotation.getMarker();
            ICompilationUnit cu = ProblemInfo.getCompilationUnit(marker);
            if (cu == null) {
                return NO_PROPOSALS;
            }
            IEditorInput input = EditorUtility.getEditorInput(cu);
            if (input == null) {
                return NO_PROPOSALS;
            }
            IAnnotationModel model = JavaUI.getDocumentProvider().getAnnotationModel((Object)input);
            if (model == null) {
                return NO_PROPOSALS;
            }
            ISourceViewer sourceViewer = null;
            if (this.viewer instanceof ISourceViewer) {
                sourceViewer = (ISourceViewer)this.viewer;
            }
            AssistContext context = new AssistContext(cu, sourceViewer, this.position.getOffset(), this.position.getLength());
            ArrayList<IJavaCompletionProposal> proposals = new ArrayList<IJavaCompletionProposal>();
            JavaCorrectionProcessor.collectProposals(context, model, new Annotation[]{markerAnnotation}, true, false, proposals);
            Collections.sort(proposals, new CompletionProposalComparator());
            return proposals.toArray(new ICompletionProposal[proposals.size()]);
        }

        private static ICompilationUnit getCompilationUnit(IMarker marker) {
            IJavaElement element;
            IResource res = marker.getResource();
            if (res instanceof IFile && res.isAccessible() && (element = JavaCore.create((IFile)((IFile)res))) instanceof ICompilationUnit) {
                return (ICompilationUnit)element;
            }
            return null;
        }
    }
}

