/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit;

import java.util.Arrays;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.egit.ui.internal.commit.DiffRegionFormatter;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.Repository;

public class DiffDocument
extends Document {
    static final String HEADLINE_CONTENT_TYPE = "_egit_diff_headline";
    static final String HUNK_CONTENT_TYPE = "_egit_diff_hunk";
    static final String ADDED_CONTENT_TYPE = "_egit_diff_added";
    static final String REMOVED_CONTENT_TYPE = "_egit_diff_removed";
    private DiffRegionFormatter.DiffRegion[] regions;
    private DiffRegionFormatter.FileDiffRegion[] fileRegions;
    private Pattern newPathPattern;
    private Pattern oldPathPattern;
    private Repository defaultRepository;
    private FileDiff defaultFileDiff;
    private int[] maximumLineNumbers;

    public DiffDocument() {
    }

    public DiffDocument(String text) {
        super(text);
    }

    public void connect(DiffRegionFormatter formatter) {
        this.regions = formatter.getRegions();
        this.fileRegions = formatter.getFileRegions();
        if ((this.fileRegions == null || this.fileRegions.length == 0) && this.defaultRepository != null && this.defaultFileDiff != null) {
            this.fileRegions = new DiffRegionFormatter.FileDiffRegion[]{new DiffRegionFormatter.FileDiffRegion(this.defaultRepository, this.defaultFileDiff, 0, this.getLength())};
        }
        this.newPathPattern = Pattern.compile(String.valueOf(Pattern.quote(formatter.getNewPrefix())) + "\\S+");
        this.oldPathPattern = Pattern.compile(String.valueOf(Pattern.quote(formatter.getOldPrefix())) + "\\S+");
        this.maximumLineNumbers = formatter.getMaximumLineNumbers();
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new DiffPartitionTokenScanner(), new String[]{"__dftl_partition_content_type", HEADLINE_CONTENT_TYPE, HUNK_CONTENT_TYPE, ADDED_CONTENT_TYPE, REMOVED_CONTENT_TYPE});
        IDocumentPartitioner oldPartitioner = this.getDocumentPartitioner();
        if (oldPartitioner != null) {
            oldPartitioner.disconnect();
        }
        partitioner.connect((IDocument)this);
        this.setDocumentPartitioner((IDocumentPartitioner)partitioner);
    }

    public void setDefault(Repository repository, FileDiff fileDiff) {
        this.defaultRepository = repository;
        this.defaultFileDiff = fileDiff;
    }

    DiffRegionFormatter.DiffRegion[] getRegions() {
        return this.regions;
    }

    DiffRegionFormatter.FileDiffRegion[] getFileRegions() {
        return this.fileRegions;
    }

    int getMaximumLineNumber(@NonNull DiffEntry.Side side) {
        if (this.maximumLineNumbers == null) {
            return -1;
        }
        if (DiffEntry.Side.OLD.equals((Object)side)) {
            return this.maximumLineNumbers[0];
        }
        return this.maximumLineNumbers[1];
    }

    private int findRegionIndex(int offset) {
        DiffRegionFormatter.DiffRegion key = new DiffRegionFormatter.DiffRegion(offset, 0);
        return Arrays.binarySearch(this.regions, key, (a, b) -> {
            if (!TextUtilities.overlaps((IRegion)a, (IRegion)b)) {
                return a.getOffset() - b.getOffset();
            }
            return 0;
        });
    }

    DiffRegionFormatter.DiffRegion findRegion(int offset) {
        int i = this.findRegionIndex(offset);
        return i >= 0 ? this.regions[i] : null;
    }

    DiffRegionFormatter.FileDiffRegion findFileRegion(int offset) {
        DiffRegionFormatter.FileDiffRegion key = new DiffRegionFormatter.FileDiffRegion(null, null, offset, 0);
        int i = Arrays.binarySearch(this.fileRegions, key, (a, b) -> {
            if (!TextUtilities.overlaps((IRegion)a, (IRegion)b)) {
                return a.getOffset() - b.getOffset();
            }
            return 0;
        });
        return i >= 0 ? this.fileRegions[i] : null;
    }

    int getLogicalLine(int physicalLine, @NonNull DiffEntry.Side side) {
        int logicalStart;
        DiffRegionFormatter.DiffRegion region;
        block5: {
            block4: {
                try {
                    int offset = this.getLineOffset(physicalLine);
                    region = this.findRegion(offset);
                    if (region != null) break block4;
                    return -1;
                }
                catch (BadLocationException e) {
                    return -1;
                }
            }
            logicalStart = region.getLine(side);
            if (logicalStart != -1) break block5;
            return -1;
        }
        int physicalStart = this.getLineOfOffset(region.getOffset());
        return logicalStart + (physicalLine - physicalStart);
    }

    Pattern getPathPattern(@NonNull DiffEntry.Side side) {
        switch (side) {
            case OLD: {
                return this.oldPathPattern;
            }
        }
        return this.newPathPattern;
    }

    private class DiffPartitionTokenScanner
    implements IPartitionTokenScanner {
        private final Token HEADLINE_TOKEN = new Token((Object)"_egit_diff_headline");
        private final Token HUNK_TOKEN = new Token((Object)"_egit_diff_hunk");
        private final Token ADDED_TOKEN = new Token((Object)"_egit_diff_added");
        private final Token DELETED_TOKEN = new Token((Object)"_egit_diff_removed");
        private final Token OTHER_TOKEN = new Token((Object)"__dftl_partition_content_type");
        private int currentOffset;
        private int end;
        private int tokenStart;
        private int currIdx;

        private DiffPartitionTokenScanner() {
        }

        public void setRange(IDocument document, int offset, int length) {
            Assert.isLegal((document == DiffDocument.this ? 1 : 0) != 0);
            this.currentOffset = offset;
            this.end = offset + length;
            this.tokenStart = -1;
        }

        public IToken nextToken() {
            if (this.tokenStart < 0) {
                this.currIdx = DiffDocument.this.findRegionIndex(this.currentOffset);
                if (this.currIdx < 0) {
                    this.currIdx = -(this.currIdx + 1);
                }
            }
            this.tokenStart = this.currentOffset;
            if (this.currentOffset < this.end) {
                if (this.currIdx >= DiffDocument.this.regions.length) {
                    this.currentOffset = this.end;
                    return this.OTHER_TOKEN;
                }
                if (this.currentOffset < DiffDocument.this.regions[this.currIdx].getOffset()) {
                    this.currentOffset = DiffDocument.this.regions[this.currIdx].getOffset();
                    return this.OTHER_TOKEN;
                }
                this.currentOffset += DiffDocument.this.regions[this.currIdx].getLength() - (this.currentOffset - DiffDocument.this.regions[this.currIdx].getOffset());
                switch (DiffDocument.this.regions[this.currIdx++].getType()) {
                    case HEADLINE: {
                        return this.HEADLINE_TOKEN;
                    }
                    case HUNK: {
                        return this.HUNK_TOKEN;
                    }
                    case ADD: {
                        return this.ADDED_TOKEN;
                    }
                    case REMOVE: {
                        return this.DELETED_TOKEN;
                    }
                }
                return this.OTHER_TOKEN;
            }
            return Token.EOF;
        }

        public int getTokenOffset() {
            return this.tokenStart;
        }

        public int getTokenLength() {
            return this.currentOffset - this.tokenStart;
        }

        public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
            this.setRange(document, offset, length);
        }
    }
}

