/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaComplexType;
import org.eclipse.pde.internal.core.ischema.ISchemaCompositor;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.ischema.ISchemaRestriction;
import org.eclipse.pde.internal.core.ischema.ISchemaSimpleType;
import org.eclipse.pde.internal.core.text.AbstractEditingModel;
import org.eclipse.pde.internal.core.text.IDocumentAttributeNode;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.core.text.IDocumentRange;
import org.eclipse.pde.internal.core.text.IDocumentTextNode;
import org.eclipse.pde.internal.core.text.IReconcilingParticipant;
import org.eclipse.pde.internal.core.text.plugin.PluginModelBase;
import org.eclipse.pde.internal.core.util.IdUtil;
import org.eclipse.pde.internal.core.util.PDESchemaHelper;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.contentassist.TypePackageCompletionProcessor;
import org.eclipse.pde.internal.ui.editor.contentassist.VirtualSchemaObject;
import org.eclipse.pde.internal.ui.editor.contentassist.XMLCompletionProposal;
import org.eclipse.pde.internal.ui.editor.contentassist.XMLContentAssistText;
import org.eclipse.pde.internal.ui.editor.contentassist.XMLElementProposalComputer;
import org.eclipse.pde.internal.ui.editor.text.XMLUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.forms.editor.FormEditor;

public class XMLContentAssistProcessor
extends TypePackageCompletionProcessor
implements ICompletionListener {
    protected boolean fAssistSessionStarted;
    protected static final int F_INFER_BY_OBJECT = -1;
    protected static final int F_EXTENSION_POINT = 0;
    protected static final int F_EXTENSION = 1;
    protected static final int F_ELEMENT = 2;
    protected static final int F_ATTRIBUTE = 3;
    protected static final int F_CLOSE_TAG = 4;
    protected static final int F_ATTRIBUTE_VALUE = 5;
    protected static final int F_EXTENSION_ATTRIBUTE_POINT_VALUE = 6;
    protected static final int F_EXTENSION_POINT_AND_VALUE = 7;
    protected static final int F_ATTRIBUTE_ID_VALUE = 8;
    protected static final int F_ATTRIBUTE_BOOLEAN_VALUE = 9;
    protected static final int F_TOTAL_TYPES = 10;
    private static final int F_NO_ASSIST = 0;
    private static final int F_ADD_ATTRIB = 1;
    private static final int F_ADD_CHILD = 2;
    private static final int F_OPEN_TAG = 3;
    private static final ArrayList<VirtualSchemaObject> F_V_BOOLS = new ArrayList();
    private static final String F_STR_EXT_PT = "extension-point";
    private static final String F_STR_EXT = "extension";
    private PDESourcePage fSourcePage;
    private final Image[] fImages = new Image[10];
    private IDocumentRange fRange;
    private int fDocLen = -1;
    private ArrayList<ISchemaObject> fExternalExtPoints;
    private ArrayList<VirtualSchemaObject> fInternalExtPoints;
    private ArrayList<ISchemaObject> fAllExtPoints;

    static {
        F_V_BOOLS.add(new VirtualSchemaObject("true", null, 9));
        F_V_BOOLS.add(new VirtualSchemaObject("false", null, 9));
    }

    public XMLContentAssistProcessor(PDESourcePage sourcePage) {
        this.fSourcePage = sourcePage;
    }

    @Override
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        IDocument doc = viewer.getDocument();
        int docLen = doc.getLength();
        if (docLen == this.fDocLen) {
            return null;
        }
        this.fDocLen = docLen;
        IBaseModel model = this.getModel();
        if (model instanceof AbstractEditingModel && this.fSourcePage.isDirty() && ((AbstractEditingModel)model).isStale() && this.fRange == null) {
            ((AbstractEditingModel)model).reconciled(doc);
        } else if (this.fAssistSessionStarted) {
            ((AbstractEditingModel)model).reconciled(doc);
            this.fAssistSessionStarted = false;
        }
        if (this.fRange == null) {
            this.assignRange(offset);
        } else {
            boolean resetAndReconcile = false;
            if (!(this.fRange instanceof IDocumentAttributeNode)) {
                resetAndReconcile = true;
            }
            if (resetAndReconcile) {
                this.fRange = null;
                if (model instanceof IReconcilingParticipant) {
                    ((IReconcilingParticipant)model).reconciled(doc);
                }
            }
        }
        XMLContentAssistText caText = XMLContentAssistText.parse(offset, doc);
        if (caText != null) {
            return this.computeCATextProposal(doc, offset, caText);
        }
        if (this.fRange instanceof IDocumentAttributeNode) {
            return this.computeCompletionProposal((IDocumentAttributeNode)this.fRange, offset, doc);
        }
        if (this.fRange instanceof IDocumentElementNode) {
            return this.computeCompletionProposal((IDocumentElementNode)this.fRange, offset, doc);
        }
        if (this.fRange instanceof IDocumentTextNode) {
            return null;
        }
        if (model instanceof PluginModelBase) {
            return this.computeBrokenModelProposal(((PluginModelBase)model).getLastErrorNode(), offset, doc);
        }
        return null;
    }

    protected ICompletionProposal[] debugPrintProposals(ICompletionProposal[] proposals, String id, boolean print) {
        if (proposals == null) {
            System.out.println("[0] " + id);
            return proposals;
        }
        System.out.println("[" + proposals.length + "] " + id);
        if (!print) {
            return proposals;
        }
        ICompletionProposal[] iCompletionProposalArray = proposals;
        int n = proposals.length;
        int n2 = 0;
        while (n2 < n) {
            ICompletionProposal proposal = iCompletionProposalArray[n2];
            System.out.println(proposal.getDisplayString());
            ++n2;
        }
        return proposals;
    }

    private void assignRange(int offset) {
        this.fRange = this.fSourcePage.getRangeElement(offset, true);
        if (this.fRange == null) {
            return;
        }
        if (this.fRange instanceof IDocumentAttributeNode) {
            if (((IDocumentAttributeNode)this.fRange).getNameOffset() == offset) {
                this.fRange = ((IDocumentAttributeNode)this.fRange).getEnclosingElement();
            }
        } else if (this.fRange instanceof IDocumentElementNode) {
            if (((IDocumentElementNode)this.fRange).getOffset() == offset) {
                this.fRange = ((IDocumentElementNode)this.fRange).getParentNode();
            }
        } else if (this.fRange instanceof IDocumentTextNode && ((IDocumentTextNode)this.fRange).getOffset() == offset) {
            this.fRange = ((IDocumentTextNode)this.fRange).getEnclosingElement();
        }
    }

    private ICompletionProposal[] computeCATextProposal(IDocument doc, int offset, XMLContentAssistText caText) {
        this.fRange = this.fSourcePage.getRangeElement(offset, true);
        if (this.fRange != null && this.fRange instanceof IDocumentTextNode) {
            this.fRange = ((IDocumentTextNode)this.fRange).getEnclosingElement();
        }
        if (this.fRange != null && this.fRange instanceof IDocumentElementNode) {
            return this.computeAddChildProposal((IDocumentElementNode)this.fRange, caText.getStartOffset(), doc, caText.getText());
        }
        return null;
    }

    private ICompletionProposal[] computeCompletionProposal(IDocumentAttributeNode attr, int offset, IDocument doc) {
        if (offset < attr.getValueOffset()) {
            return null;
        }
        int[] offests = new int[]{offset, offset, offset};
        String[] guess = this.guessContentRequest(offests, doc, false);
        if (guess == null) {
            return null;
        }
        String attrValue = guess[2];
        IPluginObject obj = XMLUtil.getTopLevelParent((IDocumentRange)attr);
        if (obj instanceof IPluginExtension) {
            if (attr.getAttributeName().equals("point") && offset >= attr.getValueOffset()) {
                return this.computeExtPointAttrProposals(attr, offset, attrValue);
            }
            ISchemaAttribute sAttr = XMLUtil.getSchemaAttribute(attr, ((IPluginExtension)obj).getPoint());
            if (sAttr == null) {
                return null;
            }
            if (sAttr.getKind() == 1) {
                IResource resource = obj.getModel().getUnderlyingResource();
                if (resource == null) {
                    return null;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                ICompletionProposal[] proposals = null;
                this.generateTypePackageProposals(attrValue, resource.getProject(), list, offset - attrValue.length(), 10);
                if (!list.isEmpty()) {
                    proposals = list.toArray(new ICompletionProposal[list.size()]);
                    this.sortCompletions(proposals);
                    return proposals;
                }
                return null;
            }
            if (sAttr.getKind() != 2) {
                if (sAttr.getKind() == 3) {
                    Object[] validAttributes = PDESchemaHelper.getValidAttributes((ISchemaAttribute)sAttr).keySet().toArray(new String[0]);
                    Arrays.sort(validAttributes);
                    ArrayList<VirtualSchemaObject> objs = new ArrayList<VirtualSchemaObject>(validAttributes.length);
                    Object[] objectArray = validAttributes;
                    int n = validAttributes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object validAttribute = objectArray[n2];
                        objs.add(new VirtualSchemaObject((String)validAttribute, null, 8));
                        ++n2;
                    }
                    return this.computeAttributeProposal(attr, offset, attrValue, objs);
                }
                if (sAttr.getType() == null) {
                    return null;
                }
                ISchemaRestriction sRestr = sAttr.getType().getRestriction();
                ArrayList<VirtualSchemaObject> objs = new ArrayList<VirtualSchemaObject>();
                if (sRestr == null) {
                    ISchemaSimpleType type = sAttr.getType();
                    if (type != null && type.getName().equals("boolean")) {
                        objs = F_V_BOOLS;
                    }
                } else {
                    Object[] restrictions;
                    Object[] objectArray = restrictions = sRestr.getChildren();
                    int n = restrictions.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Object restriction = objectArray[n3];
                        if (restriction instanceof ISchemaObject) {
                            objs.add(new VirtualSchemaObject(((ISchemaObject)restriction).getName(), null, 5));
                        }
                        ++n3;
                    }
                }
                return this.computeAttributeProposal(attr, offset, attrValue, objs);
            }
        } else if (obj instanceof IPluginExtensionPoint) {
            attr.getAttributeValue().equals("schema");
        }
        return null;
    }

    private ICompletionProposal[] computeExtPointAttrProposals(IDocumentAttributeNode attribute, int offset, String currentAttributeValue) {
        ArrayList<ISchemaObject> allExtensionPoints = this.getAllExtensionPoints(6);
        if (allExtensionPoints == null || allExtensionPoints.size() == 0) {
            return null;
        }
        if (currentAttributeValue == null || currentAttributeValue.length() == 0) {
            return this.convertListToProposal(allExtensionPoints, (IDocumentRange)attribute, offset);
        }
        ArrayList<ISchemaObject> filteredProposalList = new ArrayList<ISchemaObject>();
        this.filterExtPointAttrProposals(filteredProposalList, allExtensionPoints, currentAttributeValue);
        return this.convertListToProposal(filteredProposalList, (IDocumentRange)attribute, offset);
    }

    private ICompletionProposal[] computeRootNodeProposals(IDocumentElementNode node, int offset, String filter) {
        ArrayList<ISchemaObject> filteredProposalList = new ArrayList<ISchemaObject>();
        this.addToList(filteredProposalList, filter, new VirtualSchemaObject(F_STR_EXT, PDEUIMessages.XMLContentAssistProcessor_extensions, 1));
        this.addToList(filteredProposalList, filter, new VirtualSchemaObject(F_STR_EXT_PT, PDEUIMessages.XMLContentAssistProcessor_extensionPoints, 0));
        ArrayList<ISchemaObject> allExtensionPoints = this.getAllExtensionPoints(7);
        if (allExtensionPoints == null || allExtensionPoints.size() == 0) {
            return this.convertListToProposal(filteredProposalList, (IDocumentRange)node, offset);
        }
        if (filter == null || filter.length() == 0) {
            filteredProposalList.addAll(allExtensionPoints);
            return this.convertListToProposal(filteredProposalList, (IDocumentRange)node, offset);
        }
        this.filterExtPointAttrProposals(filteredProposalList, allExtensionPoints, filter);
        return this.convertListToProposal(filteredProposalList, (IDocumentRange)node, offset);
    }

    private void filterExtPointAttrProposals(ArrayList<ISchemaObject> filteredProposalList, ArrayList<ISchemaObject> allExtensionPoints, String filter) {
        String patternString = "(?i)" + filter;
        Pattern pattern = Pattern.compile(patternString);
        for (ISchemaObject schemaObject : allExtensionPoints) {
            String name;
            if (schemaObject == null || !pattern.matcher(name = schemaObject.getName()).find()) continue;
            filteredProposalList.add(schemaObject);
        }
    }

    private ICompletionProposal[] computeAttributeProposal(IDocumentAttributeNode attr, int offset, String currValue, List<VirtualSchemaObject> validValues) {
        if (validValues == null) {
            return null;
        }
        ArrayList<ISchemaObject> list = new ArrayList<ISchemaObject>();
        int i = 0;
        while (i < validValues.size()) {
            this.addToList(list, currValue, validValues.get(i));
            ++i;
        }
        return this.convertListToProposal(list, (IDocumentRange)attr, offset);
    }

    private ICompletionProposal[] computeCompletionProposal(IDocumentElementNode node, int offset, IDocument doc) {
        int prop_type = this.determineAssistType(node, doc, offset);
        switch (prop_type) {
            case 1: {
                return this.computeAddAttributeProposal(-1, node, offset, doc, null, node.getXMLTagName());
            }
            case 3: {
                return this.computeOpenTagProposal(node, offset, doc);
            }
            case 2: {
                return this.computeAddChildProposal(node, offset, doc, null);
            }
        }
        return null;
    }

    private int determineAssistType(IDocumentElementNode node, IDocument doc, int offset) {
        int len = node.getLength();
        int off = node.getOffset();
        if (len == -1 || off == -1) {
            return 0;
        }
        if ((offset -= off) > node.getXMLTagName().length() + 1) {
            int ind;
            String eleValue;
            block10: {
                block9: {
                    try {
                        eleValue = doc.get(off, len);
                        ind = eleValue.indexOf(62);
                        if (ind > 0 && eleValue.charAt(ind - 1) == '/') {
                            --ind;
                        }
                        if (offset > ind) break block9;
                        if (this.canInsertAttrib(eleValue, offset)) {
                            return 1;
                        }
                        return 0;
                    }
                    catch (BadLocationException badLocationException) {}
                }
                ind = eleValue.lastIndexOf(60);
                if (ind != 0 || offset != len - 1) break block10;
                return 3;
            }
            if (ind + 1 < len && eleValue.charAt(ind + 1) == '/' && offset <= ind) {
                return 2;
            }
        }
        return 0;
    }

    private boolean canInsertAttrib(String eleValue, int offset) {
        char c = eleValue.charAt(offset);
        return offset - 1 >= 0 && Character.isWhitespace(eleValue.charAt(offset - 1)) && (Character.isWhitespace(c) || c == '/' || c == '>');
    }

    private ICompletionProposal[] computeAddChildProposal(IDocumentElementNode node, int offset, IDocument doc, String filter) {
        ArrayList<ISchemaObject> propList = new ArrayList<ISchemaObject>();
        if (node instanceof IPluginBase) {
            return this.computeRootNodeProposals(node, offset, filter);
        }
        if (node instanceof IPluginExtensionPoint) {
            return null;
        }
        IPluginObject obj = XMLUtil.getTopLevelParent((IDocumentRange)node);
        if (obj instanceof IPluginExtension) {
            ISchemaElement sElement = XMLUtil.getSchemaElement(node, ((IPluginExtension)obj).getPoint());
            if (sElement != null && sElement.getType() instanceof ISchemaComplexType) {
                TreeSet<ISchemaElement> elementSet = XMLElementProposalComputer.computeElementProposal(sElement, node);
                Iterator<ISchemaElement> iterator = elementSet.iterator();
                while (iterator.hasNext()) {
                    this.addToList(propList, filter, (ISchemaObject)iterator.next());
                }
            } else {
                return null;
            }
        }
        return this.convertListToProposal(propList, (IDocumentRange)node, offset);
    }

    private ICompletionProposal[] computeOpenTagProposal(IDocumentElementNode node, int offset, IDocument doc) {
        IPluginObject obj = XMLUtil.getTopLevelParent((IDocumentRange)node);
        if (obj instanceof IPluginExtension) {
            ISchemaElement sElem = XMLUtil.getSchemaElement(node, ((IPluginExtension)obj).getPoint());
            if (sElem == null) {
                return null;
            }
            ISchemaCompositor comp = ((ISchemaComplexType)sElem.getType()).getCompositor();
            if (comp != null) {
                return new ICompletionProposal[]{new XMLCompletionProposal((IDocumentRange)node, null, offset, this)};
            }
        }
        return null;
    }

    private ICompletionProposal[] computeAddAttributeProposal(int type, IDocumentElementNode node, int offset, IDocument doc, String filter, String tag) {
        String nodeName = tag;
        if (nodeName == null && node != null) {
            nodeName = node.getXMLTagName();
        }
        if (type == 1 || node instanceof IPluginExtension) {
            ISchemaAttribute[] iSchemaAttributeArray;
            ISchemaElement sElem = XMLUtil.getSchemaElement(node, node != null ? ((IPluginExtension)node).getPoint() : null);
            if (sElem != null) {
                iSchemaAttributeArray = sElem.getAttributes();
            } else {
                ISchemaObject[] iSchemaObjectArray = new ISchemaObject[3];
                iSchemaObjectArray[0] = new VirtualSchemaObject("id", PDEUIMessages.XMLContentAssistProcessor_extId, 3);
                iSchemaObjectArray[1] = new VirtualSchemaObject("name", PDEUIMessages.XMLContentAssistProcessor_extName, 3);
                iSchemaAttributeArray = iSchemaObjectArray;
                iSchemaObjectArray[2] = new VirtualSchemaObject("point", PDEUIMessages.XMLContentAssistProcessor_extPoint, 3);
            }
            ISchemaAttribute[] sAttrs = iSchemaAttributeArray;
            return this.computeAttributeProposals((ISchemaObject[])sAttrs, node, offset, filter, nodeName);
        }
        if (type == 0 || node instanceof IPluginExtensionPoint) {
            ISchemaObject[] sAttrs = new ISchemaObject[]{new VirtualSchemaObject("id", PDEUIMessages.XMLContentAssistProcessor_extPointId, 3), new VirtualSchemaObject("name", PDEUIMessages.XMLContentAssistProcessor_extPointName, 3), new VirtualSchemaObject("schema", PDEUIMessages.XMLContentAssistProcessor_schemaLocation, 3)};
            return this.computeAttributeProposals(sAttrs, node, offset, filter, nodeName);
        }
        IPluginObject obj = XMLUtil.getTopLevelParent((IDocumentRange)node);
        if (obj instanceof IPluginExtension) {
            ISchemaElement sElem = XMLUtil.getSchemaElement(node, node != null ? ((IPluginExtension)obj).getPoint() : null);
            ISchemaAttribute[] sAttrs = sElem != null ? sElem.getAttributes() : null;
            return this.computeAttributeProposals((ISchemaObject[])sAttrs, node, offset, filter, nodeName);
        }
        return null;
    }

    private void addToList(ArrayList<ISchemaObject> list, String filter, ISchemaObject object) {
        if (object == null) {
            return;
        }
        if (filter == null || filter.length() == 0) {
            list.add(object);
        } else {
            String name = object.getName();
            if (filter.regionMatches(true, 0, name, 0, filter.length())) {
                list.add(object);
            }
        }
    }

    private ICompletionProposal[] computeBrokenModelProposal(IDocumentElementNode parent, int offset, IDocument doc) {
        if (parent == null) {
            return null;
        }
        int[] offArr = new int[]{offset, offset, offset};
        String[] guess = this.guessContentRequest(offArr, doc, true);
        if (guess == null) {
            return null;
        }
        int elRepOffset = offArr[0];
        int atRepOffset = offArr[1];
        int atValRepOffest = offArr[2];
        String element = guess[0];
        String attr = guess[1];
        String attVal = guess[2];
        IPluginObject obj = XMLUtil.getTopLevelParent((IDocumentRange)parent);
        if (obj instanceof IPluginExtension) {
            String point = ((IPluginExtension)obj).getPoint();
            if (attr == null) {
                return this.computeAddChildProposal(parent, elRepOffset, doc, element);
            }
            ISchemaElement sEle = XMLUtil.getSchemaElement(parent, point);
            if (sEle == null) {
                return null;
            }
            if ((sEle = sEle.getSchema().findElement(element)) == null) {
                return null;
            }
            if (attr.indexOf(61) != -1) {
                return this.computeBrokenModelAttributeContentProposal(parent, atValRepOffest, element, attr, attVal);
            }
            return this.computeAttributeProposals((ISchemaObject[])sEle.getAttributes(), null, atRepOffset, attr, element);
        }
        if (parent instanceof IPluginBase) {
            if (attr == null) {
                return this.computeAddChildProposal(parent, elRepOffset, doc, element);
            }
            if (element.equalsIgnoreCase(F_STR_EXT)) {
                return this.computeAddAttributeProposal(1, null, atRepOffset, doc, attr, F_STR_EXT);
            }
            if (element.equalsIgnoreCase(F_STR_EXT_PT)) {
                return this.computeAddAttributeProposal(0, null, atRepOffset, doc, attr, F_STR_EXT_PT);
            }
        }
        return null;
    }

    private ICompletionProposal[] computeBrokenModelAttributeContentProposal(IDocumentElementNode parent, int offset, String element, String attr, String filter) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String[] guessContentRequest(int[] offset, IDocument doc, boolean brokenModel) {
        StringBuffer nodeBuffer = new StringBuffer();
        StringBuffer attrBuffer = new StringBuffer();
        StringBuffer attrValBuffer = new StringBuffer();
        String node = null;
        String attr = null;
        String attVal = null;
        int quoteCount = 0;
        try {
            while ((offset[0] = offset[0] - 1) >= 0) {
                char c = doc.getChar(offset[0]);
                if (c == '\"') {
                    ++quoteCount;
                    nodeBuffer.setLength(0);
                    attrBuffer.setLength(0);
                    if (attVal != null) continue;
                    offset[2] = offset[0];
                    attVal = attrValBuffer.toString();
                    continue;
                }
                if (Character.isWhitespace(c)) {
                    nodeBuffer.setLength(0);
                    if (attr != null) continue;
                    offset[1] = offset[0];
                    int attBuffLen = attrBuffer.length();
                    if (attBuffLen > 0 && attrBuffer.charAt(attBuffLen - 1) == '=') {
                        attrBuffer.setLength(attBuffLen - 1);
                    }
                    attr = attrBuffer.toString();
                    continue;
                }
                if (c == '<') {
                    node = nodeBuffer.toString();
                    break;
                }
                if (c == '>') {
                    return null;
                }
                attrValBuffer.insert(0, c);
                attrBuffer.insert(0, c);
                nodeBuffer.insert(0, c);
            }
        }
        catch (BadLocationException badLocationException) {}
        if (node == null) {
            return null;
        }
        if (quoteCount % 2 == 0) {
            attVal = null;
            return new String[]{node, attr, attVal};
        } else {
            if (!brokenModel) return new String[]{node, attr, attVal};
            return null;
        }
    }

    protected IBaseModel getModel() {
        return this.fSourcePage.getInputContext().getModel();
    }

    protected ITextSelection getCurrentSelection() {
        ISelection sel = this.fSourcePage.getSelectionProvider().getSelection();
        if (sel instanceof ITextSelection) {
            return (ITextSelection)sel;
        }
        return null;
    }

    protected void flushDocument() {
        this.fSourcePage.getInputContext().flushEditorInput();
    }

    private ICompletionProposal[] computeAttributeProposals(ISchemaObject[] sAttrs, IDocumentElementNode node, int offset, String filter, String parentName) {
        if (sAttrs == null || sAttrs.length == 0) {
            return null;
        }
        IDocumentAttributeNode[] attrs = node != null ? node.getNodeAttributes() : new IDocumentAttributeNode[]{};
        ArrayList<ISchemaObject> list = new ArrayList<ISchemaObject>();
        ISchemaObject[] iSchemaObjectArray = sAttrs;
        int n = sAttrs.length;
        int n2 = 0;
        while (n2 < n) {
            ISchemaObject attr = iSchemaObjectArray[n2];
            int k = 0;
            while (k < attrs.length) {
                if (attrs[k].getAttributeName().equals(attr.getName())) break;
                ++k;
            }
            if (k == attrs.length) {
                this.addToList(list, filter, attr);
            }
            ++n2;
        }
        if (filter != null && filter.length() == 0) {
            list.add(0, new VirtualSchemaObject(parentName, null, 4));
        }
        return this.convertListToProposal(list, (IDocumentRange)node, offset);
    }

    private ICompletionProposal[] convertListToProposal(ArrayList<ISchemaObject> list, IDocumentRange range, int offset) {
        ICompletionProposal[] proposals = new ICompletionProposal[list.size()];
        if (proposals.length == 0) {
            return null;
        }
        int i = 0;
        while (i < proposals.length) {
            proposals[i] = new XMLCompletionProposal(range, list.get(i), offset, this);
            ++i;
        }
        return proposals;
    }

    public void assistSessionEnded(ContentAssistEvent event) {
        this.fRange = null;
        this.fAllExtPoints = null;
        this.fInternalExtPoints = null;
        this.fDocLen = -1;
    }

    public void assistSessionStarted(ContentAssistEvent event) {
        this.fAssistSessionStarted = true;
    }

    public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
    }

    private ArrayList<ISchemaObject> getAllExtensionPoints(int vSchemaType) {
        if (this.fAllExtPoints != null) {
            return this.fAllExtPoints;
        }
        IPluginModelBase model = this.getPluginModelBase();
        this.fAllExtPoints = (ArrayList)this.getExternalExtensionPoints(model, vSchemaType).clone();
        this.fAllExtPoints.addAll(this.getInternalExtensionPoints(model, vSchemaType));
        return this.fAllExtPoints;
    }

    private ArrayList<ISchemaObject> getExternalExtensionPoints(IPluginModelBase model, int vSchemaType) {
        IPluginModelBase[] plugins;
        if (this.fExternalExtPoints != null) {
            this.updateExternalExtPointTypes(vSchemaType);
            return this.fExternalExtPoints;
        }
        this.fExternalExtPoints = new ArrayList();
        IPluginModelBase[] iPluginModelBaseArray = plugins = PluginRegistry.getActiveModels();
        int n = plugins.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase plugin = iPluginModelBaseArray[n2];
            if (!plugin.getPluginBase().getId().equals(model.getPluginBase().getId())) {
                IPluginExtensionPoint[] points;
                IPluginExtensionPoint[] iPluginExtensionPointArray = points = plugin.getPluginBase().getExtensionPoints();
                int n3 = points.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPluginExtensionPoint point = iPluginExtensionPointArray[n4];
                    VirtualSchemaObject vObject = new VirtualSchemaObject(IdUtil.getFullId((IPluginExtensionPoint)point, (IPluginModelBase)model), point, vSchemaType);
                    this.fExternalExtPoints.add(vObject);
                    ++n4;
                }
            }
            ++n2;
        }
        return this.fExternalExtPoints;
    }

    private void updateExternalExtPointTypes(int newVType) {
        if (this.fExternalExtPoints.size() == 0) {
            return;
        }
        VirtualSchemaObject vObject = (VirtualSchemaObject)this.fExternalExtPoints.get(0);
        if (vObject.getVType() == newVType) {
            return;
        }
        Iterator<ISchemaObject> iterator = this.fExternalExtPoints.iterator();
        while (iterator.hasNext()) {
            ((VirtualSchemaObject)iterator.next()).setVType(newVType);
        }
    }

    private ArrayList<VirtualSchemaObject> getInternalExtensionPoints(IPluginModelBase model, int vSchemaType) {
        IPluginExtensionPoint[] points;
        if (this.fInternalExtPoints != null) {
            return this.fInternalExtPoints;
        }
        this.fInternalExtPoints = new ArrayList();
        IPluginExtensionPoint[] iPluginExtensionPointArray = points = model.getPluginBase().getExtensionPoints();
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginExtensionPoint point = iPluginExtensionPointArray[n2];
            VirtualSchemaObject vObject = new VirtualSchemaObject(IdUtil.getFullId((IPluginExtensionPoint)point, (IPluginModelBase)model), point, vSchemaType);
            this.fInternalExtPoints.add(vObject);
            ++n2;
        }
        return this.fInternalExtPoints;
    }

    private IPluginModelBase getPluginModelBase() {
        FormEditor formEditor = this.fSourcePage.getEditor();
        if (!(formEditor instanceof PDEFormEditor)) {
            return null;
        }
        IBaseModel bModel = ((PDEFormEditor)formEditor).getAggregateModel();
        if (!(bModel instanceof IPluginModelBase)) {
            return null;
        }
        return (IPluginModelBase)bModel;
    }

    public Image getImage(int type) {
        if (this.fImages[type] == null) {
            switch (type) {
                case 0: 
                case 6: {
                    this.fImages[type] = PDEPluginImages.DESC_EXT_POINT_OBJ.createImage();
                    return this.fImages[type];
                }
                case 1: 
                case 7: {
                    this.fImages[type] = PDEPluginImages.DESC_EXTENSION_OBJ.createImage();
                    return this.fImages[type];
                }
                case 2: 
                case 4: {
                    this.fImages[type] = PDEPluginImages.DESC_XML_ELEMENT_OBJ.createImage();
                    return this.fImages[type];
                }
                case 3: 
                case 5: {
                    this.fImages[type] = PDEPluginImages.DESC_ATT_URI_OBJ.createImage();
                    return this.fImages[type];
                }
                case 8: {
                    this.fImages[type] = PDEPluginImages.DESC_ATT_ID_OBJ.createImage();
                    return this.fImages[type];
                }
                case 9: {
                    this.fImages[type] = PDEPluginImages.DESC_ATT_BOOLEAN_OBJ.createImage();
                    return this.fImages[type];
                }
            }
        }
        return this.fImages[type];
    }

    public void dispose() {
        int i = 0;
        while (i < this.fImages.length) {
            if (this.fImages[i] != null && !this.fImages[i].isDisposed()) {
                this.fImages[i].dispose();
            }
            ++i;
        }
    }

    public PDESourcePage getSourcePage() {
        return this.fSourcePage;
    }
}

