/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.product;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.plugin.IExtensionsModelFactory;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.eclipse.pde.internal.ui.wizards.product.BaseManifestOperation;
import org.eclipse.pde.internal.ui.wizards.templates.ControlStack;
import org.eclipse.pde.ui.templates.IVariableProvider;
import org.eclipse.swt.widgets.Shell;

public class ProductIntroOperation
extends BaseManifestOperation
implements IVariableProvider {
    protected String fIntroId;
    private Shell fShell;
    private IProduct fProduct;
    private IProject fProject;
    private static final String INTRO_POINT = "org.eclipse.ui.intro";
    private static final String INTRO_CONFIG_POINT = "org.eclipse.ui.intro.config";
    private static final String INTRO_CLASS = "org.eclipse.ui.intro.config.CustomizableIntroPart";
    private static final String KEY_PRODUCT_NAME = "productName";

    public ProductIntroOperation(IProduct product, String pluginId, String introId, Shell shell) {
        super(shell, pluginId);
        this.fIntroId = introId;
        this.fProduct = product;
        this.fProject = PluginRegistry.findModel((String)pluginId).getUnderlyingResource().getProject();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            IFile file = this.getFile();
            if (!file.exists()) {
                this.createNewFile(file);
            } else {
                this.modifyExistingFile(file, monitor);
            }
            this.updateSingleton(monitor);
            this.generateFiles(monitor);
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    private void createNewFile(IFile file) throws CoreException {
        WorkspacePluginModelBase model = (WorkspacePluginModelBase)this.getModel(file);
        IPluginBase base = model.getPluginBase();
        base.setSchemaVersion(TargetPlatformHelper.getSchemaVersion());
        base.add(this.createIntroExtension((IPluginModelBase)model));
        base.add(this.createIntroConfigExtension((IPluginModelBase)model));
        model.save();
    }

    private IPluginExtension createIntroExtension(IPluginModelBase model) throws CoreException {
        IPluginExtension extension = model.getFactory().createExtension();
        extension.setPoint(INTRO_POINT);
        extension.add((IPluginObject)this.createIntroExtensionContent(extension));
        extension.add((IPluginObject)this.createIntroBindingExtensionContent(extension));
        return extension;
    }

    private IPluginExtension createIntroConfigExtension(IPluginModelBase model) throws CoreException {
        IPluginExtension extension = model.getFactory().createExtension();
        extension.setPoint(INTRO_CONFIG_POINT);
        extension.add((IPluginObject)this.createIntroConfigExtensionContent(extension));
        return extension;
    }

    private IPluginElement createIntroExtensionContent(IPluginExtension extension) throws CoreException {
        IPluginElement element = extension.getModel().getFactory().createElement((IPluginObject)extension);
        element.setName("intro");
        element.setAttribute("id", this.fIntroId);
        element.setAttribute("class", INTRO_CLASS);
        return element;
    }

    private IPluginElement createIntroBindingExtensionContent(IPluginExtension extension) throws CoreException {
        IPluginElement element = extension.getModel().getFactory().createElement((IPluginObject)extension);
        element.setName("introProductBinding");
        element.setAttribute("productId", this.fProduct.getProductId());
        element.setAttribute("introId", this.fIntroId);
        return element;
    }

    private IPluginElement createIntroConfigExtensionContent(IPluginExtension extension) throws CoreException {
        IPluginElement element = extension.getModel().getFactory().createElement((IPluginObject)extension);
        element.setName("config");
        element.setAttribute("id", String.valueOf(this.fPluginId) + ".introConfigId");
        element.setAttribute("introId", this.fIntroId);
        element.setAttribute("content", "introContent.xml");
        element.add((IPluginObject)this.createPresentationElement(element));
        return element;
    }

    private IPluginElement createPresentationElement(IPluginElement parent) throws CoreException {
        IPluginElement presentation = null;
        IPluginElement implementation = null;
        IExtensionsModelFactory factory = parent.getModel().getFactory();
        presentation = factory.createElement((IPluginObject)parent);
        presentation.setName("presentation");
        presentation.setAttribute("home-page-id", "root");
        implementation = factory.createElement((IPluginObject)presentation);
        implementation.setName("implementation");
        implementation.setAttribute("kind", "html");
        implementation.setAttribute("style", "content/shared.css");
        implementation.setAttribute("os", "win32,linux,macosx");
        presentation.add((IPluginObject)implementation);
        return presentation;
    }

    private void modifyExistingFile(IFile file, IProgressMonitor monitor) throws CoreException {
        IStatus status = PDEPlugin.getWorkspace().validateEdit(new IFile[]{file}, (Object)this.fShell);
        if (status.getSeverity() != 0) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.ui", 4, NLS.bind((String)PDEUIMessages.ProductDefinitionOperation_readOnly, (Object)this.fPluginId), null));
        }
        ModelModification mod = new ModelModification(file){

            @Override
            protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                if (!(model instanceof IPluginModelBase)) {
                    return;
                }
                IPluginModelBase pluginModel = (IPluginModelBase)model;
                IPluginExtension extension = ProductIntroOperation.this.getExtension(pluginModel, ProductIntroOperation.INTRO_POINT);
                if (extension == null) {
                    extension = ProductIntroOperation.this.createIntroExtension(pluginModel);
                    pluginModel.getPluginBase().add(extension);
                } else {
                    extension.add((IPluginObject)ProductIntroOperation.this.createIntroExtensionContent(extension));
                    extension.add((IPluginObject)ProductIntroOperation.this.createIntroBindingExtensionContent(extension));
                }
                extension = ProductIntroOperation.this.getExtension(pluginModel, ProductIntroOperation.INTRO_CONFIG_POINT);
                if (extension == null) {
                    extension = ProductIntroOperation.this.createIntroConfigExtension(pluginModel);
                    pluginModel.getPluginBase().add(extension);
                } else {
                    extension.add((IPluginObject)ProductIntroOperation.this.createIntroConfigExtensionContent(extension));
                }
            }
        };
        PDEModelUtility.modifyModel(mod, monitor);
    }

    private IPluginExtension getExtension(IPluginModelBase model, String tPoint) {
        IPluginExtension[] extensions;
        IPluginExtension[] iPluginExtensionArray = extensions = model.getPluginBase().getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginExtension extension = iPluginExtensionArray[n2];
            String point = extension.getPoint();
            if (tPoint.equals(point)) {
                return extension;
            }
            ++n2;
        }
        return null;
    }

    protected void generateFiles(IProgressMonitor monitor) throws CoreException {
        monitor.setTaskName(PDEUIMessages.AbstractTemplateSection_generating);
        URL locationUrl = null;
        try {
            locationUrl = new URL(PDEPlugin.getDefault().getInstallURL(), "templates_3.1/intro/");
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
        try {
            locationUrl = FileLocator.resolve((URL)locationUrl);
            locationUrl = FileLocator.toFileURL((URL)locationUrl);
        }
        catch (IOException iOException) {
            return;
        }
        if ("file".equals(locationUrl.getProtocol())) {
            File templateDirectory = new File(locationUrl.getFile());
            if (!templateDirectory.exists()) {
                return;
            }
            this.generateFiles(templateDirectory, (IContainer)this.fProject, true, false, monitor);
        }
        monitor.subTask("");
        monitor.worked(1);
    }

    private void generateFiles(File src, IContainer dst, boolean firstLevel, boolean binary, IProgressMonitor monitor) throws CoreException {
        File[] members;
        File[] fileArray = members = src.listFiles();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            block23: {
                File member = fileArray[n2];
                if (!(member.getName().equals("ext.xml") || member.getName().equals("java") || member.getName().equals("concept3.xhtml") || member.getName().equals("extContent.xhtml"))) {
                    if (member.isDirectory()) {
                        IFolder dstContainer = null;
                        if (firstLevel) {
                            binary = false;
                            if (member.getName().equals("bin")) {
                                binary = true;
                                dstContainer = dst;
                            }
                        }
                        if (dstContainer == null) {
                            dstContainer = dst.getFolder((IPath)new Path(member.getName()));
                        }
                        if (dstContainer instanceof IFolder && !dstContainer.exists()) {
                            dstContainer.create(true, true, monitor);
                        }
                        this.generateFiles(member, (IContainer)dstContainer, false, binary, monitor);
                    } else {
                        if (firstLevel) {
                            binary = false;
                        }
                        FileInputStream in = null;
                        try {
                            try {
                                in = new FileInputStream(member);
                                this.copyFile(member.getName(), in, dst, binary, monitor);
                            }
                            catch (IOException iOException) {
                                if (in != null) {
                                    try {
                                        ((InputStream)in).close();
                                    }
                                    catch (IOException iOException2) {}
                                }
                                break block23;
                            }
                        }
                        catch (Throwable throwable) {
                            if (in != null) {
                                try {
                                    ((InputStream)in).close();
                                }
                                catch (IOException iOException) {}
                            }
                            throw throwable;
                        }
                        if (in != null) {
                            try {
                                ((InputStream)in).close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            }
            ++n2;
        }
    }

    private void copyFile(String fileName, InputStream input, IContainer dst, boolean binary, IProgressMonitor monitor) throws CoreException {
        monitor.subTask(fileName);
        IFile dstFile = dst.getFile((IPath)new Path(fileName));
        try {
            InputStream stream = this.getProcessedStream(fileName, input, binary);
            if (dstFile.exists()) {
                dstFile.setContents(stream, true, true, monitor);
            } else {
                dstFile.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (IOException iOException) {}
    }

    private InputStream getProcessedStream(String fileName, InputStream stream, boolean binary) throws IOException, CoreException {
        if (binary) {
            return stream;
        }
        InputStreamReader reader = new InputStreamReader(stream);
        int bufsize = 1024;
        char[] cbuffer = new char[bufsize];
        int read = 0;
        StringBuffer keyBuffer = new StringBuffer();
        StringBuffer outBuffer = new StringBuffer();
        ControlStack preStack = new ControlStack();
        preStack.setValueProvider(this);
        boolean replacementMode = false;
        while (read != -1) {
            read = reader.read(cbuffer);
            int i = 0;
            while (i < read) {
                char c = cbuffer[i];
                if (preStack.getCurrentState()) {
                    if (c == '$') {
                        if (replacementMode) {
                            replacementMode = false;
                            String key = keyBuffer.toString();
                            String value = key.length() == 0 ? "$" : this.getReplacementString(fileName, key);
                            outBuffer.append(value);
                            keyBuffer.delete(0, keyBuffer.length());
                        } else {
                            replacementMode = true;
                        }
                    } else if (replacementMode) {
                        keyBuffer.append(c);
                    } else {
                        outBuffer.append(c);
                    }
                }
                ++i;
            }
        }
        return new ByteArrayInputStream(outBuffer.toString().getBytes(this.fProject.getDefaultCharset()));
    }

    private String getReplacementString(String fileName, String key) {
        if (key.equals(KEY_PRODUCT_NAME)) {
            return this.fProduct.getName();
        }
        return key;
    }

    @Override
    public Object getValue(String variable) {
        return null;
    }
}

