/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.ui.dialogs.ITypeInfoFilterExtension;
import org.eclipse.jdt.ui.dialogs.ITypeInfoRequestor;
import org.eclipse.jdt.ui.dialogs.TypeSelectionExtension;
import org.eclipse.pde.internal.ds.core.IDSModel;
import org.eclipse.pde.internal.ds.core.IDSProvide;
import org.eclipse.pde.internal.ds.core.IDSService;

public class DSTypeSelectionExtension
extends TypeSelectionExtension {
    private IDSModel fModel;

    public DSTypeSelectionExtension() {
    }

    public DSTypeSelectionExtension(IDSModel model) {
        this.fModel = model;
    }

    public ITypeInfoFilterExtension getFilterExtension() {
        IDSService service = this.fModel.getDSComponent().getService();
        if (service != null) {
            return new TypeInfoFilterExtension(service.getProvidedServices());
        }
        return null;
    }

    class TypeInfoFilterExtension
    implements ITypeInfoFilterExtension {
        List<String> fProvides = new ArrayList<String>(3);

        public TypeInfoFilterExtension(IDSProvide[] provides) {
            IDSProvide[] iDSProvideArray = provides;
            int n = provides.length;
            int n2 = 0;
            while (n2 < n) {
                IDSProvide provide = iDSProvideArray[n2];
                this.fProvides.add(provide.getInterface());
                ++n2;
            }
        }

        public boolean select(ITypeInfoRequestor typeInfoRequestor) {
            StringBuffer buffer = new StringBuffer(typeInfoRequestor.getPackageName());
            buffer.append(".");
            buffer.append(typeInfoRequestor.getTypeName());
            return !this.fProvides.contains(buffer.toString());
        }
    }
}

