/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.memory.IMemoryRenderingUpdater;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.internal.ui.views.memory.renderings.BasicDebugViewContentProvider;
import org.eclipse.debug.internal.ui.views.memory.renderings.TableRenderingContentInput;
import org.eclipse.debug.internal.ui.views.memory.renderings.TableRenderingLine;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.memory.AbstractTableRendering;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;

public class TableRenderingContentProvider
extends BasicDebugViewContentProvider {
    protected Vector<TableRenderingLine> lineCache = new Vector();
    protected Hashtable<String, TableRenderingLine> contentCache = new Hashtable();
    private MemoryByte[] fContentCacheInBytes;
    private String fContentCacheStartAddress;
    private BigInteger fBufferTopAddress;
    private TableRenderingContentInput fInput;
    private BigInteger fBufferEndAddress;
    private boolean fDynamicLoad;

    public TableRenderingContentProvider() {
        this.initializeDynamicLoad();
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public void setViewer(StructuredViewer viewer) {
        this.fViewer = viewer;
    }

    @Override
    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        try {
            if (newInput instanceof TableRenderingContentInput) {
                this.fInput = (TableRenderingContentInput)((Object)newInput);
                if (this.fInput.getMemoryBlock() instanceof IMemoryBlockExtension) {
                    this.loadContentForExtendedMemoryBlock();
                } else {
                    this.loadContentForSimpleMemoryBlock();
                }
                this.getTableRendering(this.fInput).displayTable();
            }
        }
        catch (DebugException e) {
            this.getTableRendering(this.fInput).displayError(e);
        }
    }

    @Override
    public void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        super.dispose();
    }

    public Object[] getElements(Object parent) {
        if (this.lineCache.isEmpty()) {
            try {
                this.getMemoryFromMemoryBlock();
            }
            catch (DebugException e) {
                DebugUIPlugin.log(e.getStatus());
                this.getTableRendering(this.fInput).displayError(e);
                return this.lineCache.toArray();
            }
        }
        if (this.lineCache.isEmpty()) {
            return this.lineCache.toArray();
        }
        TableRenderingLine line = this.lineCache.get(0);
        int currentRowSize = line.getByteArray().length;
        int renderingRowSize = this.getTableRendering(this.fInput).getBytesPerLine();
        if (renderingRowSize != currentRowSize) {
            try {
                this.reorganizeContentCache(renderingRowSize);
                this.reorganizeLines(this.lineCache, renderingRowSize);
            }
            catch (DebugException e) {
                DebugUIPlugin.log(e.getStatus());
                this.getTableRendering(this.fInput).displayError(e);
                return this.lineCache.toArray();
            }
        }
        return this.lineCache.toArray();
    }

    private void getMemoryFromMemoryBlock() throws DebugException {
        IMemoryBlock memoryBlock = this.fInput.getMemoryBlock();
        if (memoryBlock instanceof IMemoryBlockExtension) {
            this.loadContentForExtendedMemoryBlock();
            this.getTableRendering(this.fInput).displayTable();
        } else {
            this.loadContentForSimpleMemoryBlock();
            this.getTableRendering(this.fInput).displayTable();
        }
    }

    public void loadContentForSimpleMemoryBlock() throws DebugException {
        this.fInput.setPreBuffer(0);
        this.fInput.setPostBuffer(0);
        long startAddress = this.fInput.getMemoryBlock().getStartAddress();
        BigInteger address = BigInteger.valueOf(startAddress);
        long length = this.fInput.getMemoryBlock().getLength();
        long numLines = length / (long)this.getTableRendering(this.fInput).getBytesPerLine();
        this.getMemoryToFitTable(address, numLines, this.fInput.isUpdateDelta());
    }

    public void loadContentForExtendedMemoryBlock() throws DebugException {
        if (this.fInput.getNumLines() <= 0) {
            return;
        }
        BigInteger loadAddress = this.fInput.getLoadAddress();
        if (loadAddress == null) {
            loadAddress = new BigInteger("0");
        }
        BigInteger mbStart = this.fInput.getStartAddress();
        BigInteger mbEnd = this.fInput.getEndAddress();
        if (loadAddress.compareTo(mbStart) < 0 || loadAddress.compareTo(mbEnd) > 0) {
            loadAddress = ((IMemoryBlockExtension)this.getMemoryBlock()).getBigBaseAddress();
            this.fInput.setLoadAddress(loadAddress);
        }
        if (loadAddress.compareTo(mbStart) < 0 || loadAddress.compareTo(mbEnd) > 0) {
            throw new DebugException(DebugUIPlugin.newErrorStatus(String.valueOf(DebugUIMessages.TableRenderingContentProvider_0) + loadAddress.toString(16), null));
        }
        int addressableUnitsPerLine = this.getTableRendering(this.fInput).getAddressableUnitPerLine();
        BigInteger bufferStart = loadAddress.subtract(BigInteger.valueOf(this.fInput.getPreBuffer() * addressableUnitsPerLine));
        BigInteger bufferEnd = loadAddress.add(BigInteger.valueOf(this.fInput.getPostBuffer() * addressableUnitsPerLine));
        bufferEnd = bufferEnd.add(BigInteger.valueOf(this.fInput.getNumLines() * addressableUnitsPerLine));
        if (this.isDynamicLoad()) {
            int numLines;
            if (bufferStart.compareTo(mbStart) < 0) {
                bufferStart = mbStart;
            }
            if (bufferEnd.compareTo(mbEnd) > 0) {
                bufferEnd = mbEnd;
                numLines = bufferEnd.subtract(bufferStart).divide(BigInteger.valueOf(addressableUnitsPerLine)).intValue();
                if (numLines < this.fInput.getNumLines()) {
                    bufferStart = bufferEnd.subtract(BigInteger.valueOf(this.fInput.getNumLines() * addressableUnitsPerLine));
                    bufferStart = bufferStart.subtract(BigInteger.valueOf(this.fInput.getPreBuffer() * addressableUnitsPerLine));
                }
                if (bufferStart.compareTo(mbStart) < 0) {
                    bufferStart = mbStart;
                }
            }
            if (bufferEnd.compareTo(bufferStart) <= 0) {
                throw new DebugException(DebugUIPlugin.newErrorStatus(DebugUIMessages.TableRenderingContentProvider_1, null));
            }
            numLines = bufferEnd.subtract(bufferStart).divide(BigInteger.valueOf(addressableUnitsPerLine)).intValue() + 1;
            this.getMemoryToFitTable(bufferStart, numLines, this.fInput.isUpdateDelta());
        } else {
            if (bufferStart.compareTo(mbStart) < 0) {
                bufferStart = mbStart;
            }
            if (bufferEnd.compareTo(mbEnd) > 0) {
                bufferStart = mbEnd.subtract(BigInteger.valueOf((this.fInput.getNumLines() - 1) * addressableUnitsPerLine));
                bufferEnd = mbEnd;
                if (bufferStart.compareTo(mbStart) < 0) {
                    bufferStart = mbStart;
                }
            }
            if (bufferEnd.compareTo(bufferStart) <= 0) {
                throw new DebugException(DebugUIPlugin.newErrorStatus(DebugUIMessages.TableRenderingContentProvider_2, null));
            }
            int numLines = this.fInput.getNumLines();
            int bufferNumLines = bufferEnd.subtract(bufferStart).divide(BigInteger.valueOf(addressableUnitsPerLine)).intValue() + 1;
            if (bufferNumLines < numLines) {
                numLines = bufferNumLines;
            }
            this.getMemoryToFitTable(bufferStart, numLines, this.fInput.isUpdateDelta());
        }
    }

    public IMemoryBlock getMemoryBlock() {
        return this.fInput.getMemoryBlock();
    }

    public void getMemoryToFitTable(BigInteger startingAddress, long numberOfLines, boolean updateDelta) throws DebugException {
        int addressSize;
        IDebugTarget target = this.fInput.getMemoryBlock().getDebugTarget();
        if (target.isDisconnected() || target.isTerminated()) {
            return;
        }
        DebugException dbgEvt = null;
        String adjustedAddress = startingAddress.toString(16);
        try {
            addressSize = this.getAddressSize(startingAddress);
        }
        catch (DebugException e1) {
            dbgEvt = e1;
            addressSize = 4;
        }
        int addressLength = addressSize * 2;
        if (this.getMemoryBlock() instanceof IMemoryBlockExtension) {
            startingAddress = MemoryViewUtil.alignToBoundary(startingAddress, this.getTableRendering(this.fInput).getAddressableUnitPerLine());
        }
        IMemoryBlockExtension extMemoryBlock = null;
        MemoryByte[] memoryBuffer = null;
        String paddedString = DebugUIPlugin.getDefault().getPreferenceStore().getString("org.eclipse.debug.ui.memory.paddedStr");
        long reqNumBytes = 0L;
        try {
            if (this.fInput.getMemoryBlock() instanceof IMemoryBlockExtension) {
                long reqNumberOfUnits;
                reqNumBytes = (long)this.getTableRendering(this.fInput).getBytesPerLine() * numberOfLines;
                extMemoryBlock = (IMemoryBlockExtension)this.fInput.getMemoryBlock();
                memoryBuffer = extMemoryBlock.getBytesFromAddress(startingAddress, reqNumberOfUnits = (long)this.getTableRendering(this.fInput).getAddressableUnitPerLine() * numberOfLines);
                if (memoryBuffer == null) {
                    DebugException e = new DebugException(DebugUIPlugin.newErrorStatus(DebugUIMessages.MemoryViewContentProvider_Unable_to_retrieve_content, null));
                    throw e;
                }
            } else {
                MemoryByte tmp;
                byte[] memory = this.fInput.getMemoryBlock().getBytes();
                if (memory == null) {
                    DebugException e = new DebugException(DebugUIPlugin.newErrorStatus(DebugUIMessages.MemoryViewContentProvider_Unable_to_retrieve_content, null));
                    throw e;
                }
                int prefillNumBytes = 0;
                if (!startingAddress.toString(16).endsWith("0")) {
                    adjustedAddress = startingAddress.toString(16).substring(0, adjustedAddress.length() - 1);
                    adjustedAddress = String.valueOf(adjustedAddress) + "0";
                    BigInteger adjustedStart = new BigInteger(adjustedAddress, 16);
                    prefillNumBytes = startingAddress.subtract(adjustedStart).intValue();
                    startingAddress = adjustedStart;
                }
                reqNumBytes = this.fInput.getMemoryBlock().getLength() + (long)prefillNumBytes;
                while (reqNumBytes % (long)this.getTableRendering(this.fInput).getBytesPerLine() != 0L) {
                    ++reqNumBytes;
                }
                numberOfLines = reqNumBytes / (long)this.getTableRendering(this.fInput).getBytesPerLine();
                memoryBuffer = new MemoryByte[(int)reqNumBytes];
                int i = 0;
                while (i < prefillNumBytes) {
                    MemoryByte tmp2 = new MemoryByte();
                    tmp2.setValue((byte)0);
                    tmp2.setWritable(false);
                    tmp2.setReadable(false);
                    tmp2.setEndianessKnown(false);
                    memoryBuffer[i] = tmp2;
                    ++i;
                }
                int j = prefillNumBytes;
                int i2 = 0;
                while (i2 < memory.length) {
                    tmp = new MemoryByte();
                    tmp.setValue(memory[i2]);
                    tmp.setReadable(true);
                    tmp.setWritable(true);
                    tmp.setEndianessKnown(false);
                    memoryBuffer[j] = tmp;
                    ++j;
                    ++i2;
                }
                i2 = j;
                while (i2 < memoryBuffer.length) {
                    tmp = new MemoryByte();
                    tmp.setValue((byte)0);
                    tmp.setWritable(false);
                    tmp.setReadable(false);
                    tmp.setEndianessKnown(false);
                    memoryBuffer[i2] = tmp;
                    ++i2;
                }
            }
        }
        catch (DebugException e) {
            memoryBuffer = this.makeDummyContent(numberOfLines);
            dbgEvt = e;
        }
        catch (Throwable e) {
            memoryBuffer = this.makeDummyContent(numberOfLines);
            dbgEvt = new DebugException(DebugUIPlugin.newErrorStatus(e.getMessage(), e));
        }
        if ((long)memoryBuffer.length < reqNumBytes) {
            ArrayList<MemoryByte> newBuffer = new ArrayList<MemoryByte>();
            int i = 0;
            while (i < memoryBuffer.length) {
                newBuffer.add(memoryBuffer[i]);
                ++i;
            }
            i = memoryBuffer.length;
            while ((long)i < reqNumBytes) {
                MemoryByte mb = new MemoryByte();
                mb.setReadable(false);
                mb.setWritable(false);
                mb.setEndianessKnown(false);
                newBuffer.add(mb);
                ++i;
            }
            memoryBuffer = newBuffer.toArray(new MemoryByte[newBuffer.size()]);
        }
        if (!this.lineCache.isEmpty()) {
            this.lineCache.clear();
        }
        String address = startingAddress.toString(16);
        this.fBufferTopAddress = startingAddress;
        boolean manageDelta = true;
        if (this.fInput.getMemoryBlock() instanceof IMemoryBlockExtension) {
            manageDelta = !((IMemoryBlockExtension)this.fInput.getMemoryBlock()).supportsChangeManagement();
        }
        this.organizeLines(numberOfLines, updateDelta, addressLength, memoryBuffer, paddedString, address, manageDelta);
        if (dbgEvt != null) {
            throw dbgEvt;
        }
    }

    private void organizeLines(long numberOfLines, boolean updateDelta, int addressLength, MemoryByte[] memoryBuffer, String paddedString, String address, boolean manageDelta) {
        int i = 0;
        while ((long)i < numberOfLines) {
            BigInteger bigInt;
            String tmpAddress = address.toUpperCase();
            if (tmpAddress.length() < addressLength) {
                while (tmpAddress.length() < addressLength) {
                    tmpAddress = "0" + tmpAddress;
                }
            }
            int bytesPerLine = this.getTableRendering(this.fInput).getBytesPerLine();
            MemoryByte[] memory = new MemoryByte[bytesPerLine];
            boolean isMonitored = true;
            int k = 0;
            int j = i * bytesPerLine;
            while (j < i * bytesPerLine + bytesPerLine) {
                MemoryByte newByteObj;
                byte changeFlag = memoryBuffer[j].getFlags();
                if (manageDelta) {
                    changeFlag = (byte)(changeFlag | 8);
                    changeFlag = (byte)(changeFlag ^ 8);
                    changeFlag = (byte)(changeFlag | 4);
                    changeFlag = (byte)(changeFlag ^ 4);
                }
                memory[k] = newByteObj = new MemoryByte(memoryBuffer[j].getValue(), changeFlag);
                ++k;
                if (!manageDelta && !memoryBuffer[j].isHistoryKnown()) {
                    isMonitored = false;
                }
                ++j;
            }
            TableRenderingLine newLine = new TableRenderingLine(tmpAddress, memory, this.lineCache.size(), paddedString);
            TableRenderingLine oldLine = this.contentCache.get(newLine.getAddress());
            newLine.isMonitored = manageDelta ? oldLine != null : isMonitored;
            if (manageDelta && !this.getTableRendering(this.fInput).isDisplayingError()) {
                if (updateDelta) {
                    if (oldLine != null) {
                        newLine.markDeltas(oldLine);
                    }
                } else if (oldLine != null) {
                    if (newLine.isLineChanged(oldLine)) {
                        newLine.markDeltas(oldLine);
                    } else {
                        newLine.copyDeltas(oldLine);
                    }
                }
            } else if (manageDelta && this.getTableRendering(this.fInput).isDisplayingError()) {
                newLine.isMonitored = false;
            }
            this.lineCache.add(newLine);
            this.fBufferEndAddress = bigInt = new BigInteger(address, 16);
            int addressableUnit = this.getTableRendering(this.fInput).getBytesPerLine() / this.getTableRendering(this.fInput).getAddressableSize();
            address = bigInt.add(BigInteger.valueOf(addressableUnit)).toString(16);
            ++i;
        }
    }

    private MemoryByte[] makeDummyContent(long numberOfLines) {
        int numBytes = (int)((long)this.getTableRendering(this.fInput).getBytesPerLine() * numberOfLines);
        MemoryByte[] memoryBuffer = new MemoryByte[numBytes];
        int i = 0;
        while (i < memoryBuffer.length) {
            memoryBuffer[i] = new MemoryByte();
            memoryBuffer[i].setValue((byte)0);
            memoryBuffer[i].setWritable(false);
            memoryBuffer[i].setReadable(false);
            memoryBuffer[i].setEndianessKnown(false);
            ++i;
        }
        return memoryBuffer;
    }

    @Override
    protected void doHandleDebugEvent(DebugEvent event) {
        if (this.getTableRendering(this.fInput).isVisible() && this.isUpdateManagedByMB()) {
            return;
        }
        if (!(event.getSource() instanceof IDebugElement)) {
            return;
        }
        if (this.fInput == null) {
            return;
        }
        IDebugElement src = (IDebugElement)event.getSource();
        if (event.getKind() == 16 && event.getSource() == this.fInput.getMemoryBlock()) {
            if (event.getDetail() == 256) {
                this.getTableRendering(this.fInput).updateLabels();
            } else {
                this.updateContent();
            }
        }
        if (event.getKind() == 2 && src.getDebugTarget() == this.fInput.getMemoryBlock().getDebugTarget()) {
            this.updateContent();
        }
    }

    public void updateContent() {
        IDebugTarget dt = this.fInput.getMemoryBlock().getDebugTarget();
        if (dt.isDisconnected() || dt.isTerminated()) {
            return;
        }
        this.takeContentSnapshot();
        if (!this.getTableRendering(this.fInput).isVisible()) {
            return;
        }
        this.getTableRendering(this.fInput).refresh();
    }

    public void takeContentSnapshot() {
        TableRenderingLine[] lines = this.lineCache.toArray(new TableRenderingLine[this.lineCache.size()]);
        this.fContentCacheInBytes = this.convertLinesToBytes(lines);
        this.fContentCacheStartAddress = lines[0].getAddress();
        if (this.contentCache != null) {
            this.contentCache.clear();
        }
        if (!this.getTableRendering(this.fInput).isVisible()) {
            return;
        }
        if (!this.getTableRendering(this.fInput).isDisplayingError()) {
            int i = 0;
            while (i < lines.length) {
                this.contentCache.put(lines[i].getAddress(), lines[i]);
                lines[i].isMonitored = true;
                ++i;
            }
        }
        this.resetDeltas();
    }

    public BigInteger getBufferTopAddress() {
        return this.fBufferTopAddress;
    }

    public BigInteger getBufferEndAddress() {
        return this.fBufferEndAddress;
    }

    public int getAddressSize(BigInteger address) throws DebugException {
        String adjustedAddress = address.toString(16);
        int addressSize = 0;
        if (this.fInput.getMemoryBlock() instanceof IMemoryBlockExtension) {
            addressSize = ((IMemoryBlockExtension)this.fInput.getMemoryBlock()).getAddressSize();
        }
        if (addressSize <= 0) {
            addressSize = adjustedAddress.length() > 8 ? 8 : 4;
        }
        return addressSize;
    }

    public BigInteger getContentBaseAddress() {
        return this.fInput.getContentBaseAddress();
    }

    public void resetDeltas() {
        Enumeration<TableRenderingLine> enumeration = this.contentCache.elements();
        while (enumeration.hasMoreElements()) {
            TableRenderingLine line = enumeration.nextElement();
            line.unmarkDeltas();
        }
    }

    public boolean isAddressOutOfRange(BigInteger address) {
        if (this.lineCache != null && !this.lineCache.isEmpty()) {
            TableRenderingLine first = this.lineCache.firstElement();
            TableRenderingLine last = this.lineCache.lastElement();
            if (first == null || last == null) {
                return true;
            }
            BigInteger startAddress = new BigInteger(first.getAddress(), 16);
            BigInteger lastAddress = new BigInteger(last.getAddress(), 16);
            int addressableUnit = this.getTableRendering(this.fInput).getAddressableUnitPerLine();
            lastAddress = lastAddress.add(BigInteger.valueOf(addressableUnit)).subtract(BigInteger.valueOf(1L));
            return startAddress.compareTo(address) > 0 || lastAddress.compareTo(address) < 0;
        }
        return true;
    }

    public void clearContentCache() {
        this.fContentCacheInBytes = new MemoryByte[0];
        this.fContentCacheStartAddress = null;
        this.contentCache.clear();
    }

    private boolean isUpdateManagedByMB() {
        IMemoryBlock memoryBlock = this.getMemoryBlock();
        IMemoryRenderingUpdater managedMB = null;
        if (memoryBlock instanceof IMemoryRenderingUpdater) {
            managedMB = (IMemoryRenderingUpdater)memoryBlock;
        }
        if (managedMB == null) {
            managedMB = (IMemoryRenderingUpdater)memoryBlock.getAdapter(IMemoryRenderingUpdater.class);
        }
        return managedMB != null && managedMB.supportsManagedUpdate(this.getTableRendering(this.fInput));
    }

    public boolean isDynamicLoad() {
        return this.fDynamicLoad;
    }

    private void initializeDynamicLoad() {
        this.fDynamicLoad = DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclpise.debug.ui.memory.dynamicLoad");
    }

    public void setDynamicLoad(boolean dynamicLoad) {
        this.fDynamicLoad = dynamicLoad;
    }

    private void reorganizeLines(Vector<TableRenderingLine> lines, int numBytesPerLine) throws DebugException {
        if (lines == null || lines.isEmpty()) {
            return;
        }
        Object[] objs = lines.toArray();
        if (objs.length > 0) {
            TableRenderingLine[] renderingLines = lines.toArray(new TableRenderingLine[lines.size()]);
            MemoryByte[] buffer = this.convertLinesToBytes(renderingLines);
            BigInteger lineAddress = new BigInteger(renderingLines[0].getAddress(), 16);
            int numberOfLines = buffer.length / numBytesPerLine;
            boolean updateDelta = false;
            int addressLength = this.getAddressSize(lineAddress) * 2;
            MemoryByte[] memoryBuffer = buffer;
            String address = renderingLines[0].getAddress();
            String paddedString = DebugUITools.getPreferenceStore().getString("org.eclipse.debug.ui.memory.paddedStr");
            boolean manageDelta = true;
            if (this.fInput.getMemoryBlock() instanceof IMemoryBlockExtension) {
                manageDelta = !((IMemoryBlockExtension)this.fInput.getMemoryBlock()).supportsChangeManagement();
            }
            this.lineCache.clear();
            this.organizeLines(numberOfLines, updateDelta, addressLength, memoryBuffer, paddedString, address, manageDelta);
        }
    }

    private void reorganizeContentCache(int bytesPerLine) {
        if (this.contentCache == null || this.contentCache.isEmpty() || this.fContentCacheInBytes.length == 0 || this.fContentCacheStartAddress == null) {
            return;
        }
        MemoryByte[] bytes = this.fContentCacheInBytes;
        TableRenderingLine[] convertedLines = this.convertBytesToLines(bytes, bytesPerLine, new BigInteger(this.fContentCacheStartAddress, 16));
        this.contentCache.clear();
        int i = 0;
        while (i < convertedLines.length) {
            this.contentCache.put(convertedLines[i].getAddress(), convertedLines[i]);
            ++i;
        }
    }

    private MemoryByte[] convertLinesToBytes(TableRenderingLine[] lines) {
        TableRenderingLine temp = lines[0];
        int lineLength = temp.getLength();
        MemoryByte[] buffer = new MemoryByte[lines.length * lineLength];
        int i = 0;
        while (i < lines.length) {
            TableRenderingLine line = lines[i];
            MemoryByte[] bytes = line.getBytes();
            System.arraycopy(bytes, 0, buffer, i * lineLength, lineLength);
            ++i;
        }
        return buffer;
    }

    private TableRenderingLine[] convertBytesToLines(MemoryByte[] bytes, int bytesPerLine, BigInteger startAddress) {
        int addressLength;
        int numOfLines = bytes.length / bytesPerLine;
        String address = startAddress.toString(16);
        try {
            addressLength = this.getAddressSize(startAddress) * 2;
        }
        catch (DebugException e) {
            DebugUIPlugin.log(e);
            addressLength = 8;
        }
        ArrayList<TableRenderingLine> lines = new ArrayList<TableRenderingLine>();
        String paddedString = DebugUITools.getPreferenceStore().getString("org.eclipse.debug.ui.memory.paddedStr");
        int i = 0;
        while (i < numOfLines) {
            BigInteger bigInt;
            MemoryByte[] temp = new MemoryByte[bytesPerLine];
            System.arraycopy(bytes, i * bytesPerLine, temp, 0, bytesPerLine);
            String tmpAddress = address.toUpperCase();
            if (tmpAddress.length() < addressLength) {
                while (tmpAddress.length() < addressLength) {
                    tmpAddress = "0" + tmpAddress;
                }
            }
            TableRenderingLine newLine = new TableRenderingLine(tmpAddress, temp, lines.size(), paddedString);
            lines.add(newLine);
            this.fBufferEndAddress = bigInt = new BigInteger(address, 16);
            int addressableUnit = this.getTableRendering(this.fInput).getBytesPerLine() / this.getTableRendering(this.fInput).getAddressableSize();
            address = bigInt.add(BigInteger.valueOf(addressableUnit)).toString(16);
            ++i;
        }
        return lines.toArray(new TableRenderingLine[lines.size()]);
    }

    private AbstractTableRendering getTableRendering(TableRenderingContentInput input) {
        return input.getAdapter(AbstractTableRendering.class);
    }
}

