/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.commands.ExpressionContext;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.internal.workbench.OpaqueElementUtil;
import org.eclipse.e4.ui.internal.workbench.RenderedElementUtil;
import org.eclipse.e4.ui.internal.workbench.swt.Policy;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MExpression;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MDynamicMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.MPopupMenu;
import org.eclipse.e4.ui.workbench.IResourceUtilities;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.renderers.swt.ContributionRecord;
import org.eclipse.e4.ui.workbench.renderers.swt.DirectContributionItem;
import org.eclipse.e4.ui.workbench.renderers.swt.DynamicContributionContributionItem;
import org.eclipse.e4.ui.workbench.renderers.swt.HandledContributionItem;
import org.eclipse.e4.ui.workbench.renderers.swt.MenuManagerHideProcessor;
import org.eclipse.e4.ui.workbench.renderers.swt.MenuManagerRendererFilter;
import org.eclipse.e4.ui.workbench.renderers.swt.MenuManagerShowProcessor;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.e4.ui.workbench.swt.util.ISWTResourceUtilities;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.internal.MenuManagerEventHelper;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class MenuManagerRenderer
extends SWTPartRenderer {
    public static final String VISIBILITY_IDENTIFIER = "IIdentifier";
    private static final String NO_LABEL = "UnLabled";
    public static final String GROUP_MARKER = "org.eclipse.jface.action.GroupMarker.GroupMarker(String)";
    private Map<MMenu, MenuManager> modelToManager = new HashMap<MMenu, MenuManager>();
    private Map<MenuManager, MMenu> managerToModel = new HashMap<MenuManager, MMenu>();
    private Map<MMenuElement, IContributionItem> modelToContribution = new HashMap<MMenuElement, IContributionItem>();
    private Map<IContributionItem, MMenuElement> contributionToModel = new HashMap<IContributionItem, MMenuElement>();
    private Map<MMenuElement, ContributionRecord> modelContributionToRecord = new HashMap<MMenuElement, ContributionRecord>();
    private Map<MMenuElement, ArrayList<ContributionRecord>> sharedElementToRecord = new HashMap<MMenuElement, ArrayList<ContributionRecord>>();
    private Collection<IContributionManager> mgrToUpdate = new LinkedHashSet<IContributionManager>();
    @Inject
    private Logger logger;
    @Inject
    private MApplication application;
    @Inject
    IEventBroker eventBroker;
    private EventHandler selectionUpdater = event -> {
        if (!(event.getProperty("ChangedElement") instanceof MMenuItem)) {
            return;
        }
        MMenuItem itemModel = (MMenuItem)event.getProperty("ChangedElement");
        IContributionItem ici = this.getContribution((MMenuElement)itemModel);
        if (ici != null) {
            ici.update();
        }
    };
    private MenuManagerRendererFilter rendererFilter;
    private static ArrayList<ContributionRecord> DEFAULT = new ArrayList();

    @Inject
    @Optional
    private void subscribeUIElementTopicAllRenderedVisibility(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/UIElement/*") Event event) {
        MElementContainer obj;
        MMenuItem itemModel;
        Object element = event.getProperty("ChangedElement");
        String attName = (String)event.getProperty("AttName");
        if (element instanceof MMenuItem) {
            itemModel = (MMenuItem)element;
            if ("toBeRendered".equals(attName)) {
                obj = itemModel.getParent();
                if (!(obj instanceof MMenu)) {
                    return;
                }
                MenuManager parent = this.getManager((MMenu)obj);
                if (itemModel.isToBeRendered()) {
                    if (parent != null) {
                        this.modelProcessSwitch(parent, (MMenuElement)itemModel);
                    }
                } else {
                    IContributionItem ici = this.getContribution((MMenuElement)itemModel);
                    this.clearModelToContribution((MMenuElement)itemModel, ici);
                    if (ici != null && parent != null) {
                        parent.remove(ici);
                    }
                    if (ici != null) {
                        ici.dispose();
                    }
                }
            }
        }
        if (element instanceof MPart) {
            boolean tbr;
            MPart part = (MPart)element;
            if ("toBeRendered".equals(attName) && !(tbr = ((Boolean)event.getProperty("NewValue")).booleanValue())) {
                List menus = part.getMenus();
                for (MMenu menu : menus) {
                    if (!(menu instanceof MPopupMenu)) continue;
                    this.unlinkMenu(menu);
                }
            }
        }
        if ("visible".equals(attName)) {
            if (element instanceof MMenu) {
                Object data;
                MMenu menuModel = (MMenu)element;
                MenuManager manager = this.getManager(menuModel);
                if (manager == null) {
                    return;
                }
                boolean visible = menuModel.isVisible();
                manager.setVisible(visible);
                if (manager.getParent() != null) {
                    manager.getParent().markDirty();
                    this.scheduleManagerUpdate(manager.getParent());
                }
                if (menuModel.getParent() == null && menuModel instanceof MPopupMenu && (data = menuModel.getTransientData().get("Rendering Parent")) instanceof Control) {
                    Menu menu = (Menu)menuModel.getWidget();
                    if (visible && menuModel.isToBeRendered() && menu != null && !menu.isDisposed()) {
                        ((Control)data).setMenu(menu);
                    }
                    if (!visible) {
                        ((Control)data).setMenu(null);
                    }
                }
            } else if (element instanceof MMenuElement) {
                itemModel = (MMenuElement)element;
                obj = this.getContribution((MMenuElement)itemModel);
                if (!(obj instanceof ContributionItem)) {
                    return;
                }
                ContributionItem item = (ContributionItem)obj;
                item.setVisible(itemModel.isVisible());
                if (item.getParent() != null) {
                    item.getParent().markDirty();
                    this.scheduleManagerUpdate(item.getParent());
                }
            }
        }
    }

    @Inject
    @Optional
    private void subscribeUILabelTopicAll(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/UILabel/*") Event event) {
        Object element = event.getProperty("ChangedElement");
        if (element instanceof MMenuItem) {
            this.handleLabelOfMenuItem(event, element);
        } else if (element instanceof MMenu) {
            this.updateLabelOfMenu(event);
        }
    }

    @Inject
    @Optional
    private void subscribeItemEnabledUpdate(@UIEventTopic(value="org/eclipse/e4/ui/model/menu/Item/enabled/*") Event event) {
        Object element = event.getProperty("ChangedElement");
        if (!(element instanceof MMenuItem)) {
            return;
        }
        MMenuItem itemModel = (MMenuItem)element;
        IContributionItem ici = this.getContribution((MMenuElement)itemModel);
        if (ici != null) {
            ici.update();
        }
    }

    private void updateLabelOfMenu(Event event) {
        String attName = (String)event.getProperty("AttName");
        MMenu model = (MMenu)event.getProperty("ChangedElement");
        MenuManager manager = this.getManager(model);
        if (manager == null) {
            return;
        }
        if ("label".equals(attName) || "localizedLabel".equals(attName)) {
            manager.setMenuText(this.getText(model));
            manager.update("text");
        }
        if ("iconURI".equals(attName)) {
            manager.setImageDescriptor(this.getImageDescriptor((MUILabel)model));
            manager.update("image");
        }
    }

    private void handleLabelOfMenuItem(Event event, Object element) {
        String attName = (String)event.getProperty("AttName");
        MMenuItem itemModel = (MMenuItem)element;
        IContributionItem ici = this.getContribution((MMenuElement)itemModel);
        if (ici == null) {
            return;
        }
        if ("label".equals(attName) || "localizedLabel".equals(attName)) {
            ici.update();
        } else if ("iconURI".equals(attName)) {
            ici.update();
        } else if ("tooltip".equals(attName) || "localizedTooltip".equals(attName)) {
            ici.update();
        }
    }

    @PostConstruct
    public void init() {
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/menu/Item/selected/*", this.selectionUpdater);
        this.context.set(MenuManagerRenderer.class, (Object)this);
        Display display = (Display)this.context.get(Display.class);
        this.rendererFilter = (MenuManagerRendererFilter)ContextInjectionFactory.make(MenuManagerRendererFilter.class, (IEclipseContext)this.context);
        display.addFilter(22, (Listener)this.rendererFilter);
        display.addFilter(23, (Listener)this.rendererFilter);
        display.addFilter(12, (Listener)this.rendererFilter);
        this.context.set(MenuManagerRendererFilter.class, (Object)this.rendererFilter);
        MenuManagerEventHelper.getInstance().setShowHelper((IMenuListener2)ContextInjectionFactory.make(MenuManagerShowProcessor.class, (IEclipseContext)this.context));
        MenuManagerEventHelper.getInstance().setHideHelper((IMenuListener2)ContextInjectionFactory.make(MenuManagerHideProcessor.class, (IEclipseContext)this.context));
    }

    @Inject
    @Optional
    private void subscribeTopicChildAdded(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/ElementContainer/children/*") Event event) {
        if (!(event.getProperty("ChangedElement") instanceof MMenu)) {
            return;
        }
        MMenu menuModel = (MMenu)event.getProperty("ChangedElement");
        if (UIEvents.isADD((Event)event)) {
            MMenu obj = menuModel;
            this.processContents((MElementContainer<MUIElement>)((MElementContainer)obj));
        }
    }

    @PreDestroy
    public void contextDisposed() {
        this.eventBroker.unsubscribe(this.selectionUpdater);
        ContextInjectionFactory.uninject((Object)MenuManagerEventHelper.getInstance().getShowHelper(), (IEclipseContext)this.context);
        MenuManagerEventHelper.getInstance().setShowHelper(null);
        ContextInjectionFactory.uninject((Object)MenuManagerEventHelper.getInstance().getHideHelper(), (IEclipseContext)this.context);
        MenuManagerEventHelper.getInstance().setHideHelper(null);
        this.context.remove(MenuManagerRendererFilter.class);
        Display display = (Display)this.context.get(Display.class);
        if (display != null && !display.isDisposed() && this.rendererFilter != null) {
            display.removeFilter(22, (Listener)this.rendererFilter);
            display.removeFilter(23, (Listener)this.rendererFilter);
            display.removeFilter(12, (Listener)this.rendererFilter);
        }
        if (this.rendererFilter != null) {
            ContextInjectionFactory.uninject((Object)this.rendererFilter, (IEclipseContext)this.context);
            this.rendererFilter = null;
        }
        this.context.remove(MenuManagerRenderer.class);
        if (Policy.DEBUG_RENDERER) {
            this.logger.debug("\nMMR:dispose: modelToManager size = {0}, managerToModel size = {1}", (Object)this.modelToManager.size(), (Object)this.managerToModel.size());
        }
    }

    public Object createWidget(MUIElement element, Object parent) {
        if (!(element instanceof MMenu)) {
            return null;
        }
        MMenu menuModel = (MMenu)element;
        Menu newMenu = null;
        MenuManager menuManager = null;
        boolean menuBar = false;
        if (parent instanceof Decorations) {
            MUIElement container = this.modelService.getContainer(element);
            if (container instanceof MWindow) {
                menuManager = this.getManager(menuModel);
                if (menuManager == null) {
                    menuManager = new MenuManager(NO_LABEL, menuModel.getElementId());
                    this.linkModelToManager(menuModel, menuManager);
                }
                newMenu = menuManager.createMenuBar((Decorations)parent);
                ((Decorations)parent).setMenuBar(newMenu);
                newMenu.setData((Object)menuManager);
                menuBar = true;
            } else {
                menuManager = this.getManager(menuModel);
                if (menuManager == null) {
                    menuManager = new MenuManager(NO_LABEL, menuModel.getElementId());
                    this.linkModelToManager(menuModel, menuManager);
                }
                newMenu = menuManager.createContextMenu((Control)parent);
                newMenu.setData((Object)menuManager);
            }
        } else {
            if (parent instanceof Menu) {
                this.logger.debug((Throwable)new Exception(), "Trying to render a sub menu " + menuModel + "\n\t" + parent);
                return null;
            }
            if (parent instanceof Control) {
                Object data;
                menuManager = this.getManager(menuModel);
                if (menuManager == null) {
                    menuManager = new MenuManager(NO_LABEL, menuModel.getElementId());
                    this.linkModelToManager(menuModel, menuManager);
                }
                newMenu = menuManager.createContextMenu((Control)parent);
                if (element instanceof MPopupMenu && element.isVisible() && (data = this.getUIContainer(element)) instanceof Control && parent.equals(data)) {
                    ((Control)parent).setMenu(newMenu);
                }
                newMenu.setData((Object)menuManager);
            }
        }
        if (menuManager != null && !menuManager.getRemoveAllWhenShown()) {
            this.processContributions(menuModel, menuModel.getElementId(), menuBar, menuModel instanceof MPopupMenu);
        }
        if (newMenu != null) {
            newMenu.addDisposeListener(e -> {
                this.cleanUp(menuModel);
                MenuManager manager = this.getManager(menuModel);
                if (manager != null) {
                    manager.markDirty();
                }
            });
        }
        return newMenu;
    }

    public void cleanUp(MMenu menuModel) {
        for (MMenuElement childElement : menuModel.getChildren()) {
            if (!(childElement instanceof MMenu)) continue;
            this.cleanUp((MMenu)childElement);
        }
        Collection<ContributionRecord> vals = this.modelContributionToRecord.values();
        ArrayList<ContributionRecord> disposedRecords = new ArrayList<ContributionRecord>();
        ContributionRecord[] contributionRecordArray = vals.toArray(new ContributionRecord[vals.size()]);
        int n = contributionRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            ContributionRecord record = contributionRecordArray[n2];
            if (record.menuModel == menuModel) {
                record.dispose();
                for (MMenuElement copy : record.getGeneratedElements()) {
                    this.cleanUpCopy(record, copy);
                }
                for (MMenuElement copy : record.getSharedElements()) {
                    this.cleanUpCopy(record, copy);
                }
                record.getGeneratedElements().clear();
                record.getSharedElements().clear();
                disposedRecords.add(record);
            }
            ++n2;
        }
        Iterator<Map.Entry<MMenuElement, ContributionRecord>> iterator = this.modelContributionToRecord.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<MMenuElement, ContributionRecord> entry = iterator.next();
            ContributionRecord record = entry.getValue();
            if (!disposedRecords.contains(record)) continue;
            iterator.remove();
        }
    }

    public void cleanUpCopy(ContributionRecord record, MMenuElement copy) {
        this.modelContributionToRecord.remove(copy);
        if (copy instanceof MMenu) {
            MMenu menuCopy = (MMenu)copy;
            this.cleanUp(menuCopy);
            MenuManager copyManager = this.getManager(menuCopy);
            this.clearModelToManager(menuCopy, copyManager);
            if (copyManager != null) {
                record.getManagerForModel().remove((IContributionItem)copyManager);
                copyManager.dispose();
            }
        } else {
            IContributionItem ici = this.getContribution(copy);
            this.clearModelToContribution(copy, ici);
            if (ici != null) {
                record.getManagerForModel().remove(ici);
            }
        }
    }

    public void processContributions(MMenu menuModel, String elementId, boolean isMenuBar, boolean isPopup) {
        if (elementId == null) {
            return;
        }
        ArrayList<MMenuContribution> toContribute = new ArrayList<MMenuContribution>();
        ContributionsAnalyzer.XXXgatherMenuContributions((MMenu)menuModel, (List)this.application.getMenuContributions(), (String)elementId, toContribute, null, (boolean)isPopup);
        this.generateContributions(menuModel, toContribute, isMenuBar);
        for (MMenuElement element : menuModel.getChildren()) {
            if (!(element instanceof MMenu)) continue;
            this.processContributions((MMenu)element, element.getElementId(), false, isPopup);
        }
    }

    private void generateContributions(MMenu menuModel, ArrayList<MMenuContribution> toContribute, boolean menuBar) {
        HashSet<String> existingMenuIds = new HashSet<String>();
        HashSet<String> existingSeparatorNames = new HashSet<String>();
        for (MMenuElement child : menuModel.getChildren()) {
            String elementId = child.getElementId();
            if (child instanceof MMenu && elementId != null) {
                existingMenuIds.add(elementId);
                continue;
            }
            if (!(child instanceof MMenuSeparator) || elementId == null) continue;
            existingSeparatorNames.add(elementId);
        }
        MenuManager manager = this.getManager(menuModel);
        boolean done = toContribute.size() == 0;
        while (!done) {
            ArrayList<MMenuContribution> curList = new ArrayList<MMenuContribution>(toContribute);
            int retryCount = toContribute.size();
            toContribute.clear();
            for (MMenuContribution menuContribution : curList) {
                if (this.processAddition(menuModel, manager, menuContribution, existingMenuIds, existingSeparatorNames, menuBar)) continue;
                toContribute.add(menuContribution);
            }
            boolean bl = done = toContribute.size() == 0 || toContribute.size() == retryCount;
        }
    }

    private boolean processAddition(MMenu menuModel, final MenuManager manager, MMenuContribution menuContribution, HashSet<String> existingMenuIds, HashSet<String> existingSeparatorNames, boolean menuBar) {
        final ContributionRecord record = new ContributionRecord(menuModel, menuContribution, this);
        if (!record.mergeIntoModel()) {
            return false;
        }
        if (menuBar || this.isPartMenu(menuModel)) {
            final IEclipseContext parentContext = this.getContext((MUIElement)menuModel);
            parentContext.runAndTrack(new RunAndTrack(){

                public boolean changed(IEclipseContext context) {
                    record.updateVisibility(parentContext.getActiveLeaf());
                    MenuManagerRenderer.this.scheduleManagerUpdate((IContributionManager)manager);
                    return true;
                }
            });
        }
        return true;
    }

    private boolean isPartMenu(MMenu menuModel) {
        return !(menuModel instanceof MPopupMenu) && this.modelService.getContainer((MUIElement)menuModel) instanceof MPart;
    }

    public ArrayList<ContributionRecord> getList(MMenuElement item) {
        ArrayList<ContributionRecord> tmp = this.sharedElementToRecord.get(item);
        if (tmp == null) {
            tmp = DEFAULT;
        }
        return tmp;
    }

    public void addRecord(MMenuElement item, ContributionRecord rec) {
        ArrayList<ContributionRecord> tmp = this.sharedElementToRecord.get(item);
        if (tmp == null) {
            tmp = new ArrayList();
            this.sharedElementToRecord.put(item, tmp);
        }
        tmp.add(rec);
    }

    public void removeRecord(MMenuElement item, ContributionRecord rec) {
        ArrayList<ContributionRecord> tmp = this.sharedElementToRecord.get(item);
        if (tmp != null) {
            tmp.remove(rec);
            if (tmp.isEmpty()) {
                this.sharedElementToRecord.remove(item);
            }
        }
    }

    void removeMenuContributions(MMenu menuModel, ArrayList<MMenuElement> menuContributionsToRemove) {
        for (MMenuElement item : menuContributionsToRemove) {
            menuModel.getChildren().remove(item);
            if (!(item instanceof MMenu)) continue;
            this.removeMenuContribution((MMenu)item);
        }
    }

    private void removeMenuContribution(MMenu menuModel) {
        this.clearModelToContribution((MMenuElement)menuModel, this.modelToContribution.get(menuModel));
        if (menuModel.getChildren() != null) {
            for (MMenuElement child : menuModel.getChildren()) {
                if (child instanceof MMenu) {
                    this.removeMenuContribution((MMenu)child);
                    continue;
                }
                this.clearModelToContribution(child, this.modelToContribution.get(child));
            }
        }
    }

    @Override
    public void processContents(MElementContainer<MUIElement> container) {
        if (container == null) {
            return;
        }
        MenuManager parentManager = this.getManager((MMenu)container);
        if (parentManager == null) {
            return;
        }
        List parts = container.getChildren();
        if (parts != null) {
            MUIElement[] plist;
            MUIElement[] mUIElementArray = plist = parts.toArray(new MUIElement[parts.size()]);
            int n = plist.length;
            int n2 = 0;
            while (n2 < n) {
                MUIElement childME = mUIElementArray[n2];
                this.modelProcessSwitch(parentManager, (MMenuElement)childME);
                ++n2;
            }
        }
        this.scheduleManagerUpdate((IContributionManager)parentManager);
    }

    private void addToManager(MenuManager parentManager, MMenuElement model, IContributionItem menuManager) {
        MElementContainer parent = model.getParent();
        if (parent == null) {
            parentManager.add(menuManager);
        } else {
            int index = parent.getChildren().indexOf(model);
            if (index > parentManager.getSize() || index == -1) {
                parentManager.add(menuManager);
            } else {
                parentManager.insert(index, menuManager);
            }
        }
    }

    private void processMenu(MenuManager parentManager, MMenu menuModel) {
        List parts;
        MenuManager menuManager = this.getManager(menuModel);
        if (menuManager == null) {
            menuModel.setRenderer((Object)this);
            String menuText = this.getText(menuModel);
            ImageDescriptor desc = this.getImageDescriptor((MUILabel)menuModel);
            menuManager = new MenuManager(menuText, desc, menuModel.getElementId());
            this.linkModelToManager(menuModel, menuManager);
            menuManager.setVisible(menuModel.isVisible());
            this.addToManager(parentManager, (MMenuElement)menuModel, (IContributionItem)menuManager);
        }
        if ((parts = menuModel.getChildren()) != null) {
            MMenuElement[] plist;
            MMenuElement[] mMenuElementArray = plist = parts.toArray(new MMenuElement[parts.size()]);
            int n = plist.length;
            int n2 = 0;
            while (n2 < n) {
                MMenuElement childME = mMenuElementArray[n2];
                this.modelProcessSwitch(menuManager, childME);
                ++n2;
            }
        }
    }

    void modelProcessSwitch(MenuManager menuManager, MMenuElement childME) {
        if (!childME.isToBeRendered()) {
            return;
        }
        if (RenderedElementUtil.isRenderedMenuItem((MUIElement)childME)) {
            MMenuItem itemModel = (MMenuItem)childME;
            this.processRenderedItem(menuManager, itemModel);
        } else if (OpaqueElementUtil.isOpaqueMenuItem((MUIElement)childME)) {
            MMenuItem itemModel = (MMenuItem)childME;
            this.processOpaqueItem(menuManager, itemModel);
        } else if (childME instanceof MHandledMenuItem) {
            MHandledMenuItem itemModel = (MHandledMenuItem)childME;
            this.processHandledItem(menuManager, itemModel);
        } else if (childME instanceof MDirectMenuItem) {
            MDirectMenuItem itemModel = (MDirectMenuItem)childME;
            this.processDirectItem(menuManager, itemModel, null);
        } else if (childME instanceof MMenuSeparator) {
            MMenuSeparator sep = (MMenuSeparator)childME;
            this.processSeparator(menuManager, sep);
        } else if (childME instanceof MMenu) {
            MMenu itemModel = (MMenu)childME;
            this.processMenu(menuManager, itemModel);
        } else if (childME instanceof MDynamicMenuContribution) {
            MDynamicMenuContribution itemModel = (MDynamicMenuContribution)childME;
            this.processDynamicMenuContribution(menuManager, itemModel);
        }
    }

    void processRenderedItem(MenuManager parentManager, MMenuItem itemModel) {
        IContributionItem ici = this.getContribution((MMenuElement)itemModel);
        if (ici != null) {
            return;
        }
        itemModel.setRenderer((Object)this);
        Object obj = RenderedElementUtil.getContributionManager((MUIElement)itemModel);
        if (obj instanceof IContextFunction) {
            IEclipseContext lclContext = this.getContext((MUIElement)itemModel);
            ici = (IContributionItem)((IContextFunction)obj).compute(lclContext, null);
            RenderedElementUtil.setContributionManager((MUIElement)itemModel, (Object)ici);
        } else if (obj instanceof IContributionItem) {
            ici = (IContributionItem)obj;
        } else {
            return;
        }
        ici.setVisible(itemModel.isVisible());
        this.addToManager(parentManager, (MMenuElement)itemModel, ici);
        this.linkModelToContribution((MMenuElement)itemModel, ici);
    }

    void processOpaqueItem(MenuManager parentManager, MMenuItem itemModel) {
        IContributionItem ici = this.getContribution((MMenuElement)itemModel);
        if (ici != null) {
            return;
        }
        itemModel.setRenderer((Object)this);
        Object obj = OpaqueElementUtil.getOpaqueItem((MUIElement)itemModel);
        if (!(obj instanceof IContributionItem)) {
            return;
        }
        ici = (IContributionItem)obj;
        ici.setVisible(itemModel.isVisible());
        this.addToManager(parentManager, (MMenuElement)itemModel, ici);
        this.linkModelToContribution((MMenuElement)itemModel, ici);
    }

    private void processSeparator(MenuManager menuManager, MMenuSeparator itemModel) {
        IContributionItem ici = this.getContribution((MMenuElement)itemModel);
        if (ici != null) {
            return;
        }
        itemModel.setRenderer((Object)this);
        Separator marker = null;
        if (itemModel.getTags().contains(GROUP_MARKER) || !itemModel.isVisible()) {
            if (itemModel.getElementId() != null) {
                marker = new GroupMarker(itemModel.getElementId());
            }
        } else {
            marker = new Separator();
            marker.setId(itemModel.getElementId());
        }
        if (marker == null) {
            return;
        }
        this.addToManager(menuManager, (MMenuElement)itemModel, (IContributionItem)marker);
        this.linkModelToContribution((MMenuElement)itemModel, (IContributionItem)marker);
    }

    void processDirectItem(MenuManager parentManager, MDirectMenuItem itemModel, String id) {
        IContributionItem ici = this.getContribution((MMenuElement)itemModel);
        if (ici != null) {
            return;
        }
        itemModel.setRenderer((Object)this);
        IEclipseContext lclContext = this.getContext((MUIElement)itemModel);
        DirectContributionItem ci = (DirectContributionItem)((Object)ContextInjectionFactory.make(DirectContributionItem.class, (IEclipseContext)lclContext));
        ci.setModel((MItem)itemModel);
        ci.setVisible(itemModel.isVisible());
        this.addToManager(parentManager, (MMenuElement)itemModel, (IContributionItem)ci);
        this.linkModelToContribution((MMenuElement)itemModel, (IContributionItem)ci);
    }

    private void processDynamicMenuContribution(MenuManager menuManager, MDynamicMenuContribution itemModel) {
        IContributionItem ici = this.getContribution((MMenuElement)itemModel);
        if (ici != null) {
            return;
        }
        itemModel.setRenderer((Object)this);
        DynamicContributionContributionItem ci = new DynamicContributionContributionItem(itemModel);
        this.addToManager(menuManager, (MMenuElement)itemModel, (IContributionItem)ci);
        this.linkModelToContribution((MMenuElement)itemModel, (IContributionItem)ci);
    }

    void processHandledItem(MenuManager parentManager, MHandledMenuItem itemModel) {
        IContributionItem ici = this.getContribution((MMenuElement)itemModel);
        if (ici != null) {
            return;
        }
        itemModel.setRenderer((Object)this);
        IEclipseContext lclContext = this.getContext((MUIElement)itemModel);
        HandledContributionItem ci = (HandledContributionItem)((Object)ContextInjectionFactory.make(HandledContributionItem.class, (IEclipseContext)lclContext));
        ci.setModel((MHandledItem)itemModel);
        ci.setVisible(itemModel.isVisible());
        this.addToManager(parentManager, (MMenuElement)itemModel, (IContributionItem)ci);
        this.linkModelToContribution((MMenuElement)itemModel, (IContributionItem)ci);
    }

    private String getText(MMenu menuModel) {
        String text = menuModel.getLocalizedLabel();
        if (text == null || text.length() == 0) {
            return NO_LABEL;
        }
        return text;
    }

    private ImageDescriptor getImageDescriptor(MUILabel element) {
        IEclipseContext localContext = this.context;
        String iconURI = element.getIconURI();
        if (iconURI != null && iconURI.length() > 0) {
            ISWTResourceUtilities resUtils = (ISWTResourceUtilities)localContext.get(IResourceUtilities.class.getName());
            return (ImageDescriptor)resUtils.imageDescriptorFromURI(URI.createURI((String)iconURI));
        }
        return null;
    }

    public MenuManager getManager(MMenu model) {
        return this.modelToManager.get(model);
    }

    public MMenu getMenuModel(MenuManager manager) {
        return this.managerToModel.get(manager);
    }

    public void linkModelToManager(MMenu model, MenuManager manager) {
        this.modelToManager.put(model, manager);
        this.managerToModel.put(manager, model);
        if (Policy.DEBUG_RENDERER) {
            this.logger.debug("\nMMR:linkModelToManager: modelToManager size = {0}, managerToModel size = {1}", (Object)this.modelToManager.size(), (Object)this.managerToModel.size());
        }
    }

    public void clearModelToManager(MMenu model, MenuManager manager) {
        for (MMenuElement element : model.getChildren()) {
            if (element instanceof MMenu) {
                this.clearModelToManager((MMenu)element, this.getManager((MMenu)element));
            }
            IContributionItem ici = this.getContribution(element);
            this.clearModelToContribution(element, ici);
        }
        this.modelToManager.remove(model);
        this.managerToModel.remove(manager);
        if (Policy.DEBUG_RENDERER) {
            this.logger.debug("\nMMR:clearModelToManager: modelToManager size = {0}, managerToModel size = {1}", (Object)this.modelToManager.size(), (Object)this.managerToModel.size());
        }
    }

    public IContributionItem getContribution(MMenuElement model) {
        return this.modelToContribution.get(model);
    }

    public MMenuElement getMenuElement(IContributionItem item) {
        return this.contributionToModel.get(item);
    }

    public void linkModelToContribution(MMenuElement model, IContributionItem item) {
        this.modelToContribution.put(model, item);
        this.contributionToModel.put(item, model);
        if (Policy.DEBUG_RENDERER) {
            this.logger.debug("\nMMR:linkModelToContribution: modelToContribution size = {0}, contributionToModel size = {1}", (Object)this.modelToContribution.size(), (Object)this.contributionToModel.size());
        }
    }

    public void clearModelToContribution(MMenuElement model, IContributionItem item) {
        if (model instanceof MMenu) {
            for (MMenuElement element : ((MMenu)model).getChildren()) {
                IContributionItem ici = this.getContribution(element);
                this.clearModelToContribution(element, ici);
            }
        }
        this.modelToContribution.remove(model);
        this.contributionToModel.remove(item);
        if (Policy.DEBUG_RENDERER) {
            this.logger.debug("\nMMR:clearModelToContribution: modelToContribution size = {0}, contributionToModel size = {1}", (Object)this.modelToContribution.size(), (Object)this.contributionToModel.size());
        }
    }

    public ContributionRecord getContributionRecord(MMenuElement element) {
        return this.modelContributionToRecord.get(element);
    }

    public void linkElementToContributionRecord(MMenuElement element, ContributionRecord record) {
        this.modelContributionToRecord.put(element, record);
    }

    public ContributionRecord[] getContributionRecords() {
        HashSet<ContributionRecord> records = new HashSet<ContributionRecord>(this.modelContributionToRecord.values());
        return records.toArray(new ContributionRecord[records.size()]);
    }

    public IEclipseContext getContext(MUIElement el) {
        return super.getContext(el);
    }

    public void reconcileManagerToModel(MenuManager menuManager, MMenu menuModel) {
        IContributionItem item;
        List modelChildren = menuModel.getChildren();
        HashSet<MMenuItem> oldModelItems = new HashSet<MMenuItem>();
        HashSet<MMenu> oldMenus = new HashSet<MMenu>();
        HashSet<MMenuSeparator> oldSeps = new HashSet<MMenuSeparator>();
        for (MMenuElement itemModel : modelChildren) {
            if (OpaqueElementUtil.isOpaqueMenuSeparator((MUIElement)itemModel)) {
                oldSeps.add((MMenuSeparator)itemModel);
                continue;
            }
            if (OpaqueElementUtil.isOpaqueMenuItem((MUIElement)itemModel)) {
                oldModelItems.add((MMenuItem)itemModel);
                continue;
            }
            if (!OpaqueElementUtil.isOpaqueMenu((MUIElement)itemModel)) continue;
            oldMenus.add((MMenu)itemModel);
        }
        IContributionItem[] items = menuManager.getItems();
        int src = 0;
        int dest = 0;
        while (src < items.length) {
            MMenuElement menuElement;
            item = items[src];
            if (item instanceof SubContributionItem) {
                item = ((SubContributionItem)item).getInnerItem();
            }
            if (item instanceof MenuManager) {
                MenuManager childManager = (MenuManager)item;
                MMenu childModel = this.getMenuModel(childManager);
                if (childModel == null) {
                    MMenu legacyModel = OpaqueElementUtil.createOpaqueMenu();
                    legacyModel.setElementId(childManager.getId());
                    legacyModel.setVisible(childManager.isVisible());
                    legacyModel.setLabel(childManager.getMenuText());
                    this.linkModelToManager(legacyModel, childManager);
                    OpaqueElementUtil.setOpaqueItem((MUIElement)legacyModel, (Object)childManager);
                    if (modelChildren.size() > dest) {
                        modelChildren.add(dest, legacyModel);
                    } else {
                        modelChildren.add(legacyModel);
                    }
                    this.reconcileManagerToModel(childManager, legacyModel);
                } else {
                    IEclipseContext lclContext;
                    if (OpaqueElementUtil.isOpaqueMenu((MUIElement)childModel)) {
                        oldMenus.remove(childModel);
                    }
                    if (modelChildren.size() > dest) {
                        if (modelChildren.get(dest) != childModel) {
                            modelChildren.remove(childModel);
                            modelChildren.add(dest, childModel);
                        }
                    } else {
                        modelChildren.add(childModel);
                    }
                    if (childModel instanceof MPopupMenu && ((MPopupMenu)childModel).getContext() == null && (lclContext = this.getContext((MUIElement)menuModel)) != null) {
                        ((MPopupMenu)childModel).setContext(lclContext.createChild(childModel.getElementId()));
                    }
                    if (childModel.getChildren().size() != childManager.getSize()) {
                        this.reconcileManagerToModel(childManager, childModel);
                    }
                }
            } else if (item.isSeparator() || item.isGroupMarker()) {
                MMenuSeparator legacySep;
                menuElement = this.getMenuElement(item);
                if (menuElement == null) {
                    legacySep = OpaqueElementUtil.createOpaqueMenuSeparator();
                    legacySep.setElementId(item.getId());
                    legacySep.setVisible(item.isVisible());
                    OpaqueElementUtil.setOpaqueItem((MUIElement)legacySep, (Object)item);
                    this.linkModelToContribution((MMenuElement)legacySep, item);
                    if (modelChildren.size() > dest) {
                        modelChildren.add(dest, legacySep);
                    } else {
                        modelChildren.add(legacySep);
                    }
                } else if (OpaqueElementUtil.isOpaqueMenuSeparator((MUIElement)menuElement)) {
                    legacySep = (MMenuSeparator)menuElement;
                    oldSeps.remove(legacySep);
                    if (modelChildren.size() > dest) {
                        if (modelChildren.get(dest) != legacySep) {
                            modelChildren.remove(legacySep);
                            modelChildren.add(dest, legacySep);
                        }
                    } else {
                        modelChildren.add(legacySep);
                    }
                }
            } else {
                MMenuItem legacyItem;
                menuElement = this.getMenuElement(item);
                if (menuElement == null) {
                    legacyItem = OpaqueElementUtil.createOpaqueMenuItem();
                    legacyItem.setElementId(item.getId());
                    legacyItem.setVisible(item.isVisible());
                    OpaqueElementUtil.setOpaqueItem((MUIElement)legacyItem, (Object)item);
                    this.linkModelToContribution((MMenuElement)legacyItem, item);
                    if (modelChildren.size() > dest) {
                        modelChildren.add(dest, legacyItem);
                    } else {
                        modelChildren.add(legacyItem);
                    }
                } else if (OpaqueElementUtil.isOpaqueMenuItem((MUIElement)menuElement)) {
                    legacyItem = (MMenuItem)menuElement;
                    oldModelItems.remove(legacyItem);
                    if (modelChildren.size() > dest) {
                        if (modelChildren.get(dest) != legacyItem) {
                            modelChildren.remove(legacyItem);
                            modelChildren.add(dest, legacyItem);
                        }
                    } else {
                        modelChildren.add(legacyItem);
                    }
                }
            }
            ++src;
            ++dest;
        }
        if (!oldModelItems.isEmpty()) {
            modelChildren.removeAll(oldModelItems);
            for (MMenuItem model : oldModelItems) {
                IContributionItem ici = (IContributionItem)OpaqueElementUtil.getOpaqueItem((MUIElement)model);
                this.clearModelToContribution((MMenuElement)model, ici);
            }
        }
        if (!oldMenus.isEmpty()) {
            modelChildren.removeAll(oldMenus);
            for (MMenu oldMenu : oldMenus) {
                MenuManager oldManager = this.getManager(oldMenu);
                this.clearModelToManager(oldMenu, oldManager);
            }
        }
        if (!oldSeps.isEmpty()) {
            modelChildren.removeAll(oldSeps);
            for (MMenuSeparator model : oldSeps) {
                item = (IContributionItem)OpaqueElementUtil.getOpaqueItem((MUIElement)model);
                this.clearModelToContribution((MMenuElement)model, item);
            }
        }
    }

    public static void updateVisibility(MenuManager menuManager, MMenuElement element, ExpressionContext evalContext) {
        boolean current = element.isVisible();
        boolean visible = true;
        boolean evaluated = false;
        if (element.getPersistedState().get(VISIBILITY_IDENTIFIER) != null) {
            evaluated = true;
            String identifier = (String)element.getPersistedState().get(VISIBILITY_IDENTIFIER);
            Object rc = evalContext.eclipseContext.get(identifier);
            if (rc instanceof Boolean) {
                visible = (Boolean)rc;
            }
        }
        if (visible && element.getVisibleWhen() != null) {
            evaluated = true;
            visible = ContributionsAnalyzer.isVisible((MExpression)element.getVisibleWhen(), (ExpressionContext)evalContext);
        }
        if (evaluated && visible != current) {
            element.setVisible(visible);
            menuManager.markDirty();
        }
    }

    public void removeDynamicMenuContributions(MenuManager menuManager, MMenu menuModel, ArrayList<MMenuElement> dump) {
        this.removeMenuContributions(menuModel, dump);
        for (MMenuElement mMenuElement : dump) {
            IContributionItem ici = this.getContribution(mMenuElement);
            if (ici == null && mMenuElement instanceof MMenu) {
                MMenu menuElement = (MMenu)mMenuElement;
                ici = this.getManager(menuElement);
                this.clearModelToManager(menuElement, (MenuManager)ici);
            } else {
                this.clearModelToContribution((MMenuElement)menuModel, ici);
            }
            menuManager.remove(ici);
            this.clearModelToContribution(mMenuElement, ici);
        }
    }

    public void removeDynamicMenuContributions(MenuManager menuManager, MMenu menuModel) {
        for (MMenuElement menuElement : new HashSet<MMenuElement>(this.modelToContribution.keySet())) {
            ArrayList childElements;
            DynamicContributionContributionItem dynamicContributionItem;
            IContributionItem contributionItem;
            if (!(menuElement instanceof MDynamicMenuContribution) || !((contributionItem = this.modelToContribution.get(menuElement)) instanceof DynamicContributionContributionItem) || !((dynamicContributionItem = (DynamicContributionContributionItem)contributionItem).getParent() instanceof MenuManager) || !dynamicContributionItem.getParent().equals(menuManager) || (childElements = (ArrayList)menuElement.getTransientData().get(MenuManagerShowProcessor.DYNAMIC_ELEMENT_STORAGE_KEY)) == null) continue;
            this.removeDynamicMenuContributions(menuManager, menuModel, childElements);
        }
    }

    private void unlinkMenu(MMenu menu) {
        List children = menu.getChildren();
        for (MMenuElement child : children) {
            if (child instanceof MMenu) {
                this.unlinkMenu((MMenu)child);
                continue;
            }
            IContributionItem contribution = this.getContribution(child);
            this.clearModelToContribution(child, contribution);
        }
        MenuManager mm = this.getManager(menu);
        this.clearModelToManager(menu, mm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleManagerUpdate(IContributionManager mgr) {
        boolean workaroundEnabled = Boolean.getBoolean("eclipse.workaround.bug467000");
        if (!workaroundEnabled) {
            mgr.update(false);
            return;
        }
        Collection<IContributionManager> collection = this.mgrToUpdate;
        synchronized (collection) {
            if (this.mgrToUpdate.isEmpty()) {
                Display display = (Display)this.context.get(Display.class);
                if (display != null && !display.isDisposed()) {
                    display.timerExec(100, () -> {
                        LinkedHashSet<IContributionManager> toUpdate = new LinkedHashSet<IContributionManager>();
                        Collection<IContributionManager> collection = this.mgrToUpdate;
                        synchronized (collection) {
                            toUpdate.addAll(this.mgrToUpdate);
                            this.mgrToUpdate.clear();
                        }
                        for (IContributionManager mgr1 : toUpdate) {
                            mgr1.update(false);
                        }
                    });
                }
                this.mgrToUpdate.add(mgr);
            }
        }
    }
}

