/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.pde.api.tools.internal.FilterStore;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFilter;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;

public class AntFilterStore
extends FilterStore {
    String fComponentId = null;
    String fFiltersRoot = null;
    public static ArrayList<IApiProblem> filteredAPIProblems = new ArrayList();

    public AntFilterStore(String filtersRoot, String componentID) {
        this.fComponentId = componentID;
        this.fFiltersRoot = filtersRoot;
    }

    @Override
    public boolean isFiltered(IApiProblem problem) {
        boolean isFiltered = super.isFiltered(problem);
        if (isFiltered) {
            filteredAPIProblems.add(problem);
        }
        return isFiltered;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected synchronized void initializeApiFilters() {
        File filterFileParent;
        InputStream contents;
        block14: {
            if (this.fFilterMap != null) {
                return;
            }
            this.fFilterMap = new HashMap(5);
            contents = null;
            filterFileParent = new File(this.fFiltersRoot, this.fComponentId);
            if (filterFileParent.exists()) break block14;
            if (contents == null) return;
            try {
                contents.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        try {
            try {
                contents = new BufferedInputStream(new FileInputStream(new File(filterFileParent, ".api_filters")));
                this.readFilterFile(contents);
            }
            catch (IOException iOException) {
                if (contents == null) return;
                try {
                    contents.close();
                    return;
                }
                catch (IOException iOException2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            if (contents == null) throw throwable;
            try {
                contents.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        if (contents == null) return;
        try {
            contents.close();
            return;
        }
        catch (IOException iOException) {}
    }

    @Override
    protected void internalAddFilters(IApiProblem[] problems, String[] comments) {
        if (problems == null || problems.length == 0) {
            return;
        }
        HashSet<ApiProblemFilter> globalFilters = (HashSet<ApiProblemFilter>)this.fFilterMap.get("!global!");
        if (globalFilters == null) {
            globalFilters = new HashSet<ApiProblemFilter>();
            this.fFilterMap.put("!global!", globalFilters);
        }
        int i = 0;
        while (i < problems.length) {
            IApiProblem problem = problems[i];
            String comment = comments != null ? comments[i] : null;
            ApiProblemFilter filter = new ApiProblemFilter(this.fComponentId, problem, comment);
            globalFilters.add(filter);
            ++i;
        }
    }
}

