/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.core.cheatsheet.comp;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.pde.internal.core.util.PDETextHelper;
import org.eclipse.pde.internal.ua.core.CheatSheetUtil;
import org.eclipse.pde.internal.ua.core.cheatsheet.comp.CompCSObject;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSDataObject;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSModel;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSObject;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSTaskObject;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public abstract class CompCSDataObject
extends CompCSObject
implements ICompCSDataObject {
    private static final long serialVersionUID = 1L;
    private String fFieldContent;

    public CompCSDataObject(ICompCSModel model, ICompCSObject parent) {
        super(model, parent);
    }

    @Override
    public List<ICompCSTaskObject> getChildren() {
        return new ArrayList<ICompCSTaskObject>();
    }

    @Override
    public abstract String getElement();

    @Override
    public String getName() {
        return this.fFieldContent;
    }

    @Override
    public abstract int getType();

    @Override
    protected void parseContent(Element element) {
        this.fFieldContent = CheatSheetUtil.parseElementText(element).trim();
    }

    @Override
    protected void parseAttributes(Element element) {
    }

    @Override
    protected void parseElement(Element element) {
    }

    @Override
    protected void parseText(Text text) {
    }

    @Override
    public void reset() {
        this.fFieldContent = null;
    }

    @Override
    protected void writeAttributes(StringBuffer buffer) {
    }

    @Override
    protected void writeElements(String indent, PrintWriter writer) {
        String newIndent = String.valueOf(indent) + "   ";
        if (this.fFieldContent != null && this.fFieldContent.length() > 0) {
            writer.write(String.valueOf(newIndent) + PDETextHelper.translateWriteText((String)this.fFieldContent.trim(), (HashSet)DEFAULT_TAG_EXCEPTIONS, (HashMap)DEFAULT_SUBSTITUTE_CHARS) + "\n");
        }
    }

    @Override
    public String getFieldContent() {
        return this.fFieldContent;
    }

    @Override
    public void setFieldContent(String content) {
        String old = this.fFieldContent;
        this.fFieldContent = content;
        if (this.isEditable()) {
            this.firePropertyChanged(this.getElement(), old, this.fFieldContent);
        }
    }
}

