/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors.verification;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rcptt.core.VerificationType;
import org.eclipse.rcptt.core.VerificationTypeManager;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.scenario.Verification;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.ui.actions.VerificationSnapshotAction;
import org.eclipse.rcptt.ui.editors.EditorHeader;
import org.eclipse.rcptt.ui.editors.IQ7Editor;
import org.eclipse.rcptt.ui.editors.IQ7EditorActionsProvider;
import org.eclipse.rcptt.ui.editors.NamedElementEditorPage;
import org.eclipse.rcptt.ui.editors.verification.VerificationEditor;
import org.eclipse.rcptt.ui.launching.LaunchUtils;
import org.eclipse.rcptt.ui.utils.ImageManager;
import org.eclipse.rcptt.ui.verification.VerificationUIManager;
import org.eclipse.rcptt.ui.verification.VerificationViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.ide.IGotoMarker;

public class VerificationEditorPage
extends NamedElementEditorPage
implements IGotoMarker {
    private ImageManager imageManager = new ImageManager();
    private IQ7Editor<Verification> editor;

    public VerificationEditorPage(VerificationEditor editor) {
        super(editor, "verification", Messages.VerificationEditorPage_Name);
    }

    public Verification getElement() {
        return (Verification)super.getElement();
    }

    @Override
    protected EditorHeader createHeader() {
        return new EditorHeader(this.getModel(), (NamedElement)this.getElement()){

            @Override
            protected Button createRecordButton(Composite composite, FormToolkit toolkit) {
                Button button = toolkit.createButton(composite, Messages.VerificationEditorPage_CaptureButtonText, 8);
                button.setImage(Images.getImageDescriptor("icons/camera.png").createImage());
                button.setBackground(null);
                GridDataFactory.fillDefaults().applyTo((Control)button);
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        this.record();
                    }
                });
                VerificationType type = VerificationTypeManager.getInstance().getTypeByVerification((Verification)this.getElement());
                VerificationViewer viewer = VerificationUIManager.getInstance().getViewer(type);
                if (viewer != null) {
                    button.setEnabled(viewer.getViewer().isCaptureSupported());
                }
                return button;
            }

            @Override
            protected Button createReplayButton(Composite composite, FormToolkit toolkit) {
                Button button = toolkit.createButton(composite, Messages.VerificationEditorPage_VerifyButtonText, 8);
                button.setImage(DebugUITools.getImageDescriptor((String)"IMG_ACT_RUN").createImage());
                button.setBackground(null);
                GridDataFactory.fillDefaults().applyTo((Control)button);
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if ((e.stateMask & 0x20000) != 0) {
                            this.multiReplay();
                        } else {
                            this.replay();
                        }
                    }
                });
                VerificationType type = VerificationTypeManager.getInstance().getTypeByVerification((Verification)this.getElement());
                VerificationViewer viewer = VerificationUIManager.getInstance().getViewer(type);
                if (viewer != null) {
                    button.setEnabled(viewer.getViewer().isApplySupported());
                }
                return button;
            }

            @Override
            protected void record() {
                VerificationEditorPage.this.record();
            }

            @Override
            protected void replay() {
                VerificationEditorPage.this.replay();
            }
        };
    }

    @Override
    protected void createSpecificContent(Composite parent, FormToolkit toolkit, IManagedForm form) {
        VerificationType type = VerificationTypeManager.getInstance().getTypeByVerification(this.getElement());
        VerificationViewer viewer = VerificationUIManager.getInstance().getViewer(type);
        if (viewer != null) {
            ImageDescriptor descriptor;
            this.editor = viewer.getViewer().createEditor();
            this.editor.setElement(this.getModel());
            this.editor.setForm(form);
            this.editor.create(parent, toolkit, (IWorkbenchSite)this.getSite(), this.getHeader());
            if (this.editor instanceof IQ7EditorActionsProvider) {
                ((VerificationEditor)this.getEditor()).setVerificationActions(((IQ7EditorActionsProvider)((Object)this.editor)).createActions());
            }
            if ((descriptor = viewer.getIcon()) != null) {
                Image img = this.imageManager.getImage(descriptor);
                ((VerificationEditor)this.getEditor()).setEditorImage(img);
            }
        }
    }

    @Override
    protected void record() {
        new VerificationSnapshotAction(null, this.editor, null).run();
    }

    @Override
    protected void replay() {
        IResource res = this.getModel().getResource();
        if (res == null) {
            return;
        }
        LaunchUtils.launchVerification(new IResource[]{res}, "run");
    }

    public void save() throws CoreException {
        this.editor.save();
    }

    public void select(Object data) {
        if (this.editor != null) {
            this.editor.select(data);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.editor != null) {
            this.editor.dispose();
            this.editor = null;
        }
        if (this.getEditor() instanceof VerificationEditor) {
            ((VerificationEditor)this.getEditor()).setEditorImage(Images.getImage("icons/verification.gif"));
        }
        if (this.imageManager != null) {
            this.imageManager.dispose();
            this.imageManager = null;
        }
    }

    public void gotoMarker(IMarker marker) {
        IGotoMarker adapter = (IGotoMarker)Platform.getAdapterManager().getAdapter(this.editor, IGotoMarker.class);
        if (adapter != null) {
            adapter.gotoMarker(marker);
        }
    }
}

