/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javadocexport;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocLocations;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.IDialogSettings;

public class RecentSettingsStore {
    private final String HREF = "href";
    private final String DESTINATION = "destdir";
    private final String ANTPATH = "antpath";
    private final String SECTION_PROJECTS = "projects";
    private static final char REF_SEPARATOR = ';';
    private Map<IJavaProject, ProjectData> fPerProjectSettings = new HashMap<IJavaProject, ProjectData>();

    public RecentSettingsStore(IDialogSettings settings) {
        if (settings != null) {
            this.load(settings);
        }
    }

    private void load(IDialogSettings settings) {
        int i;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IDialogSettings projectsSection = settings.getSection("projects");
        if (projectsSection != null) {
            IDialogSettings[] sections = projectsSection.getSections();
            i = 0;
            while (i < sections.length) {
                IJavaProject javaProject;
                IDialogSettings curr = sections[i];
                String projectName = curr.getName();
                IProject project = root.getProject(projectName);
                if (project.isAccessible() && !this.fPerProjectSettings.containsKey(javaProject = JavaCore.create((IProject)project))) {
                    String antpath;
                    String destdir;
                    String hrefs = curr.get("href");
                    if (hrefs == null) {
                        hrefs = "";
                    }
                    if ((destdir = curr.get("destdir")) == null || destdir.length() == 0) {
                        destdir = this.getDefaultDestination(javaProject);
                    }
                    if ((antpath = curr.get("antpath")) == null || antpath.length() == 0) {
                        antpath = this.getDefaultAntPath(javaProject);
                    }
                    ProjectData data = new ProjectData();
                    data.setDestination(destdir);
                    data.setAntpath(antpath);
                    data.setHRefs(hrefs);
                    this.fPerProjectSettings.put(javaProject, data);
                }
                ++i;
            }
        }
        IProject[] projects = root.getProjects();
        i = 0;
        while (i < projects.length) {
            IJavaProject curr;
            IProject project = projects[i];
            if (project.isAccessible() && !this.fPerProjectSettings.containsKey(curr = JavaCore.create((IProject)project))) {
                ProjectData data = new ProjectData();
                data.setDestination(this.getDefaultDestination(curr));
                data.setAntpath(this.getDefaultAntPath(curr));
                data.setHRefs("");
                this.fPerProjectSettings.put(curr, data);
            }
            ++i;
        }
    }

    public void store(IDialogSettings settings) {
        IDialogSettings projectsSection = settings.addNewSection("projects");
        Set<IJavaProject> keys = this.fPerProjectSettings.keySet();
        for (IJavaProject curr : keys) {
            IDialogSettings proj = projectsSection.addNewSection(curr.getElementName());
            if (!keys.contains(curr)) {
                proj.put("href", "");
                proj.put("destdir", "");
                proj.put("antpath", "");
            } else {
                ProjectData data = this.fPerProjectSettings.get(curr);
                proj.put("href", data.getHRefs());
                proj.put("destdir", data.getDestination());
                proj.put("antpath", data.getAntPath());
            }
            projectsSection.addSection(proj);
        }
    }

    public void setProjectSettings(IJavaProject project, String destination, String antpath, String[] hrefs) {
        ProjectData data = this.fPerProjectSettings.get(project);
        if (data == null) {
            data = new ProjectData();
        }
        data.setDestination(destination);
        data.setAntpath(antpath);
        StringBuffer refs = new StringBuffer();
        int i = 0;
        while (i < hrefs.length) {
            if (i > 0) {
                refs.append(';');
            }
            refs.append(hrefs[i]);
            ++i;
        }
        data.setHRefs(refs.toString());
    }

    public static String[] getRefTokens(String refs) {
        StringTokenizer tok = new StringTokenizer(refs, String.valueOf(';'));
        String[] res = new String[tok.countTokens()];
        int i = 0;
        while (i < res.length) {
            res[i] = tok.nextToken();
            ++i;
        }
        return res;
    }

    public String[] getHRefs(IJavaProject project) {
        ProjectData data = this.fPerProjectSettings.get(project);
        if (data != null) {
            String refs = data.getHRefs();
            return RecentSettingsStore.getRefTokens(refs);
        }
        return new String[0];
    }

    public String getDestination(IJavaProject project) {
        ProjectData data = this.fPerProjectSettings.get(project);
        if (data != null) {
            return data.getDestination();
        }
        return this.getDefaultDestination(project);
    }

    public String getAntpath(IJavaProject project) {
        ProjectData data = this.fPerProjectSettings.get(project);
        if (data != null) {
            return data.getAntPath();
        }
        return this.getDefaultAntPath(project);
    }

    private String getDefaultAntPath(IJavaProject project) {
        IPath path;
        if (project != null && (path = project.getProject().getLocation()) != null) {
            return path.append("javadoc.xml").toOSString();
        }
        return "";
    }

    private String getDefaultDestination(IJavaProject project) {
        if (project != null) {
            URL url = JavaUI.getProjectJavadocLocation(project);
            if (url == null || !url.getProtocol().equals("file")) {
                IPath path = project.getProject().getLocation();
                if (path != null) {
                    return path.append("doc").toOSString();
                }
            } else {
                return JavaDocLocations.toFile(url).getPath();
            }
        }
        return "";
    }

    private static class ProjectData {
        private String fHrefs;
        private String fDestinationDir;
        private String fAntPath;

        private ProjectData() {
        }

        public void setHRefs(String hrefs) {
            this.fHrefs = hrefs == null ? "" : hrefs;
        }

        public void setDestination(String destination) {
            this.fDestinationDir = destination == null ? "" : destination;
        }

        public void setAntpath(String antpath) {
            this.fAntPath = antpath == null ? "" : antpath;
        }

        public String getHRefs() {
            return this.fHrefs;
        }

        public String getDestination() {
            return this.fDestinationDir;
        }

        public String getAntPath() {
            return this.fAntPath;
        }
    }
}

