/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.packageview;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.jdt.internal.ui.dnd.JdtViewerDropAdapter;
import org.eclipse.jdt.internal.ui.packageview.PackagesMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;

public class FileTransferDropAdapter
extends JdtViewerDropAdapter
implements TransferDropTargetListener {
    public FileTransferDropAdapter(StructuredViewer viewer) {
        super((Viewer)viewer);
        this.setScrollEnabled(true);
        this.setExpandEnabled(true);
        this.setFeedbackEnabled(false);
    }

    public Transfer getTransfer() {
        return FileTransfer.getInstance();
    }

    public boolean isEnabled(DropTargetEvent event) {
        Object target;
        Object object = target = event.item != null ? event.item.getData() : null;
        if (target == null) {
            return false;
        }
        return target instanceof IJavaElement || target instanceof IResource;
    }

    @Override
    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        return this.determineOperation(target, operation, transferType, 7) != 0;
    }

    @Override
    protected int determineOperation(Object target, int operation, TransferData transferType, int operations) {
        IJavaElement element;
        IContainer container;
        boolean isPackageFragment = target instanceof IPackageFragment;
        boolean isJavaProject = target instanceof IJavaProject;
        boolean isPackageFragmentRoot = target instanceof IPackageFragmentRoot;
        boolean isContainer = target instanceof IContainer;
        if (!(isPackageFragment || isJavaProject || isPackageFragmentRoot || isContainer)) {
            return 0;
        }
        if (isContainer ? (container = (IContainer)target).isAccessible() && !Resources.isReadOnly((IResource)container) : !(element = (IJavaElement)target).isReadOnly()) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean performDrop(final Object data) {
        IContainer target;
        int currentOperation;
        block5: {
            block4: {
                try {
                    currentOperation = this.getCurrentOperation();
                    if (data != null && data instanceof String[] && currentOperation == 1) break block4;
                    return false;
                }
                catch (JavaModelException e) {
                    String title = PackagesMessages.DropAdapter_errorTitle;
                    String message = PackagesMessages.DropAdapter_errorMessage;
                    ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), title, message);
                    return false;
                }
            }
            target = this.getActualTarget(this.getCurrentTarget());
            if (target != null) break block5;
            return false;
        }
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                FileTransferDropAdapter.this.getShell().forceActive();
                new CopyFilesAndFoldersOperation(FileTransferDropAdapter.this.getShell()).copyOrLinkFiles((String[])data, target, currentOperation);
            }
        });
        return true;
    }

    private IContainer getActualTarget(Object dropTarget) throws JavaModelException {
        if (dropTarget instanceof IContainer) {
            return (IContainer)dropTarget;
        }
        if (dropTarget instanceof IJavaElement) {
            return this.getActualTarget(((IJavaElement)dropTarget).getCorrespondingResource());
        }
        return null;
    }

    private Shell getShell() {
        return this.getViewer().getControl().getShell();
    }
}

