/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.DiffDocument;
import org.eclipse.egit.ui.internal.commit.DiffRegionFormatter;
import org.eclipse.egit.ui.internal.commit.DiffViewer;
import org.eclipse.egit.ui.internal.commit.NestedContentOutlinePage;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;

public class DiffEditorOutlinePage
extends NestedContentOutlinePage {
    private IDocument input;
    private CopyOnWriteArrayList<IOpenListener> openListeners = new CopyOnWriteArrayList();
    private ISelection selection;

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        viewer.setAutoExpandLevel(2);
        viewer.setContentProvider((IContentProvider)new DiffContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new DiffLabelProvider());
        viewer.addDoubleClickListener(event -> this.openFolder(event.getSelection()));
        viewer.addOpenListener(event -> this.fireOpenEvent(event));
        if (this.input != null) {
            viewer.setInput((Object)this.input);
        }
        this.createContextMenu(viewer);
        if (this.selection != null) {
            viewer.setSelection(this.selection);
        }
    }

    public void setInput(IDocument input) {
        this.input = input;
        TreeViewer viewer = this.getTreeViewerChecked();
        if (viewer != null) {
            viewer.setInput((Object)input);
        }
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
        TreeViewer viewer = this.getTreeViewerChecked();
        if (viewer != null) {
            super.setSelection(selection);
        }
    }

    private TreeViewer getTreeViewerChecked() {
        TreeViewer viewer = this.getTreeViewer();
        if (viewer == null || viewer.getControl() == null || viewer.getControl().isDisposed()) {
            return null;
        }
        return viewer;
    }

    public void addOpenListener(IOpenListener listener) {
        this.openListeners.addIfAbsent(listener);
    }

    public void removeOpenListener(IOpenListener listener) {
        this.openListeners.remove(listener);
    }

    private void openFolder(ISelection currentSelection) {
        TreeViewer viewer;
        Object currentNode;
        if (currentSelection instanceof IStructuredSelection && (currentNode = ((IStructuredSelection)currentSelection).getFirstElement()) instanceof DiffContentProvider.Folder && (viewer = this.getTreeViewerChecked()) != null) {
            viewer.setExpandedState(currentNode, !viewer.getExpandedState(currentNode));
        }
    }

    private void fireOpenEvent(final OpenEvent event) {
        for (final IOpenListener listener : this.openListeners) {
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    listener.open(event);
                }
            });
        }
    }

    private void createContextMenu(TreeViewer viewer) {
        MenuManager contextMenu = new MenuManager();
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener(menuManager -> {
            this.setFocus();
            final Collection<DiffRegionFormatter.FileDiffRegion> selected = this.getSelectedFileDiffs();
            if (selected.isEmpty()) {
                return;
            }
            final Collection haveNew = selected.stream().filter(diff -> !diff.getDiff().getChange().equals((Object)DiffEntry.ChangeType.DELETE)).collect(Collectors.toList());
            final Collection haveOld = selected.stream().filter(diff -> !diff.getDiff().getChange().equals((Object)DiffEntry.ChangeType.ADD)).collect(Collectors.toList());
            final Collection existing = haveNew.stream().filter(diff -> new Path(diff.getRepository().getWorkTree().getAbsolutePath()).append(diff.getDiff().getNewPath()).toFile().exists()).collect(Collectors.toList());
            if (!existing.isEmpty()) {
                menuManager.add((IAction)new Action(UIText.CommitFileDiffViewer_OpenWorkingTreeVersionInEditorMenuLabel){

                    public void run() {
                        for (DiffRegionFormatter.FileDiffRegion fileDiff : existing) {
                            File file = new Path(fileDiff.getRepository().getWorkTree().getAbsolutePath()).append(fileDiff.getDiff().getNewPath()).toFile();
                            DiffViewer.openFileInEditor(file, -1);
                        }
                    }
                });
            }
            if (!haveNew.isEmpty()) {
                menuManager.add((IAction)new Action(UIText.CommitFileDiffViewer_OpenInEditorMenuLabel){

                    public void run() {
                        for (DiffRegionFormatter.FileDiffRegion fileDiff : haveNew) {
                            DiffViewer.openInEditor(fileDiff.getRepository(), fileDiff.getDiff(), DiffEntry.Side.NEW, -1);
                        }
                    }
                });
            }
            if (!haveOld.isEmpty()) {
                menuManager.add((IAction)new Action(UIText.CommitFileDiffViewer_OpenPreviousInEditorMenuLabel){

                    public void run() {
                        for (DiffRegionFormatter.FileDiffRegion fileDiff : haveOld) {
                            DiffViewer.openInEditor(fileDiff.getRepository(), fileDiff.getDiff(), DiffEntry.Side.OLD, -1);
                        }
                    }
                });
            }
            if (selected.size() == 1) {
                menuManager.add((IContributionItem)new Separator());
                menuManager.add((IAction)new Action(UIText.CommitFileDiffViewer_CompareMenuLabel){

                    public void run() {
                        DiffRegionFormatter.FileDiffRegion fileDiff = (DiffRegionFormatter.FileDiffRegion)((Object)selected.iterator().next());
                        DiffViewer.showTwoWayFileDiff(fileDiff.getRepository(), fileDiff.getDiff());
                    }
                });
            }
        });
        Menu menu = contextMenu.createContextMenu((Control)viewer.getTree());
        viewer.getTree().setMenu(menu);
    }

    private Collection<DiffRegionFormatter.FileDiffRegion> getSelectedFileDiffs() {
        ISelection currentSelection = this.getSelection();
        ArrayList<DiffRegionFormatter.FileDiffRegion> result = new ArrayList<DiffRegionFormatter.FileDiffRegion>();
        if (!currentSelection.isEmpty() && currentSelection instanceof StructuredSelection) {
            for (Object selected : ((StructuredSelection)currentSelection).toList()) {
                if (!(selected instanceof DiffRegionFormatter.FileDiffRegion) || ((DiffRegionFormatter.FileDiffRegion)((Object)selected)).getDiff().isSubmodule()) continue;
                result.add((DiffRegionFormatter.FileDiffRegion)((Object)selected));
            }
        }
        return result;
    }

    private static class DiffContentProvider
    implements ITreeContentProvider {
        private static final Object[] NOTHING = new Object[0];
        private HashMap<String, Folder> folders = new LinkedHashMap<String, Folder>();
        private Map<DiffRegionFormatter.FileDiffRegion, Folder> parents = new HashMap<DiffRegionFormatter.FileDiffRegion, Folder>();

        private DiffContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.folders.clear();
            this.parents.clear();
            if (newInput instanceof DiffDocument) {
                this.computeFolders(((DiffDocument)((Object)newInput)).getFileRegions());
            }
        }

        public void dispose() {
            this.folders.clear();
            this.parents.clear();
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof DiffDocument) {
                return this.folders.values().toArray();
            }
            return NOTHING;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Folder) {
                return ((Folder)parentElement).files.toArray();
            }
            return NOTHING;
        }

        public Object getParent(Object element) {
            if (element instanceof DiffRegionFormatter.FileDiffRegion) {
                return this.parents.get(element);
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof Folder;
        }

        private void computeFolders(DiffRegionFormatter.FileDiffRegion[] ranges) {
            DiffRegionFormatter.FileDiffRegion[] fileDiffRegionArray = ranges;
            int n = ranges.length;
            int n2 = 0;
            while (n2 < n) {
                DiffRegionFormatter.FileDiffRegion range = fileDiffRegionArray[n2];
                String path = range.getDiff().getPath();
                int i = path.lastIndexOf(47);
                path = i > 0 ? path.substring(0, i) : "/";
                Folder folder = this.folders.get(path);
                if (folder == null) {
                    folder = new Folder();
                    folder.name = path;
                    folder.files = new ArrayList<DiffRegionFormatter.FileDiffRegion>();
                    this.folders.put(path, folder);
                }
                folder.files.add(range);
                this.parents.put(range, folder);
                ++n2;
            }
        }

        public static class Folder {
            public String name;
            public List<DiffRegionFormatter.FileDiffRegion> files;
        }
    }

    private static class DiffLabelProvider
    extends LabelProvider {
        private final Image FOLDER = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        private final ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());

        public Image getImage(Object element) {
            if (element instanceof DiffContentProvider.Folder) {
                return this.FOLDER;
            }
            if (element instanceof DiffRegionFormatter.FileDiffRegion) {
                FileDiff diff = ((DiffRegionFormatter.FileDiffRegion)((Object)element)).getDiff();
                return (Image)this.resourceManager.get((DeviceResourceDescriptor)diff.getImageDescriptor((Object)diff));
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof DiffContentProvider.Folder) {
                return ((DiffContentProvider.Folder)element).name;
            }
            if (element instanceof DiffRegionFormatter.FileDiffRegion) {
                FileDiff diff = ((DiffRegionFormatter.FileDiffRegion)((Object)element)).getDiff();
                String path = diff.getPath();
                int i = path.lastIndexOf(47);
                return path.substring(i + 1);
            }
            return super.getText(element);
        }

        public void dispose() {
            this.resourceManager.dispose();
            super.dispose();
        }
    }
}

