/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors.quickfix;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public abstract class QuickFixer
implements ICompletionProposal,
IMarkerResolution,
IMarkerResolution2 {
    protected String label;
    protected Image image;
    protected int start;
    protected int end;

    public QuickFixer(String label, Image image, int start, int end) {
        this.label = label;
        this.image = image;
        this.start = start;
        this.end = end;
    }

    public abstract void quickFix(IDocument var1);

    public void run(IMarker marker) {
        try {
            ITextOperationTarget target;
            IFile file = (IFile)marker.getResource();
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
            IEditorPart part = page.openEditor((IEditorInput)new FileEditorInput(file), desc.getId());
            if (part != null && (target = (ITextOperationTarget)part.getAdapter(ITextOperationTarget.class)) instanceof ITextViewer) {
                ITextViewer textViewer = (ITextViewer)target;
                this.quickFix(textViewer.getDocument());
            }
        }
        catch (Throwable e) {
            RcpttPlugin.log((Throwable)e);
        }
    }

    public void apply(IDocument document) {
        this.quickFix(document);
    }

    public String getDescription() {
        return null;
    }

    public String getLabel() {
        return this.label;
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public String getDisplayString() {
        return this.label;
    }

    public Image getImage() {
        return this.image;
    }

    public IContextInformation getContextInformation() {
        return null;
    }
}

