/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.ui.text;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.internal.core.text.PatternConstructor;
import org.eclipse.search.internal.ui.Messages;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.WorkingSetComparator;
import org.eclipse.search.internal.ui.text.BasicElementLabels;
import org.eclipse.ui.IWorkingSet;

public final class FileTextSearchScope
extends TextSearchScope {
    private static final boolean IS_CASE_SENSITIVE_FILESYSTEM = !new File("Temp").equals(new File("temp"));
    private final String fDescription;
    private final IResource[] fRootElements;
    private final String[] fFileNamePatterns;
    private final Matcher fPositiveFileNameMatcher;
    private final Matcher fNegativeFileNameMatcher;
    private boolean fVisitDerived;
    private IWorkingSet[] fWorkingSets;

    public static FileTextSearchScope newWorkspaceScope(String[] fileNamePatterns, boolean includeDerived) {
        return new FileTextSearchScope(SearchMessages.WorkspaceScope, new IResource[]{ResourcesPlugin.getWorkspace().getRoot()}, null, fileNamePatterns, includeDerived);
    }

    public static FileTextSearchScope newSearchScope(IResource[] roots, String[] fileNamePatterns, boolean includeDerived) {
        String description;
        if ((roots = FileTextSearchScope.removeRedundantEntries(roots, includeDerived)).length == 0) {
            description = SearchMessages.FileTextSearchScope_scope_empty;
        } else if (roots.length == 1) {
            String label = SearchMessages.FileTextSearchScope_scope_single;
            description = Messages.format(label, roots[0].getName());
        } else if (roots.length == 2) {
            String label = SearchMessages.FileTextSearchScope_scope_double;
            description = Messages.format(label, new String[]{roots[0].getName(), roots[1].getName()});
        } else {
            String label = SearchMessages.FileTextSearchScope_scope_multiple;
            description = Messages.format(label, new String[]{roots[0].getName(), roots[1].getName()});
        }
        return new FileTextSearchScope(description, roots, null, fileNamePatterns, includeDerived);
    }

    public static FileTextSearchScope newSearchScope(IWorkingSet[] workingSets, String[] fileNamePatterns, boolean includeDerived) {
        String label;
        String description;
        Arrays.sort(workingSets, new WorkingSetComparator());
        if (workingSets.length == 0) {
            description = SearchMessages.FileTextSearchScope_ws_scope_empty;
        } else if (workingSets.length == 1) {
            label = SearchMessages.FileTextSearchScope_ws_scope_single;
            description = Messages.format(label, workingSets[0].getLabel());
        } else if (workingSets.length == 2) {
            label = SearchMessages.FileTextSearchScope_ws_scope_double;
            description = Messages.format(label, new String[]{workingSets[0].getLabel(), workingSets[1].getLabel()});
        } else {
            label = SearchMessages.FileTextSearchScope_ws_scope_multiple;
            description = Messages.format(label, new String[]{workingSets[0].getLabel(), workingSets[1].getLabel()});
        }
        FileTextSearchScope scope = new FileTextSearchScope(description, FileTextSearchScope.convertToResources(workingSets, includeDerived), workingSets, fileNamePatterns, includeDerived);
        return scope;
    }

    private FileTextSearchScope(String description, IResource[] resources, IWorkingSet[] workingSets, String[] fileNamePatterns, boolean visitDerived) {
        this.fDescription = description;
        this.fRootElements = resources;
        this.fFileNamePatterns = fileNamePatterns;
        this.fVisitDerived = visitDerived;
        this.fWorkingSets = workingSets;
        this.fPositiveFileNameMatcher = this.createMatcher(fileNamePatterns, false);
        this.fNegativeFileNameMatcher = this.createMatcher(fileNamePatterns, true);
    }

    public String getDescription() {
        return this.fDescription;
    }

    public String[] getFileNamePatterns() {
        return this.fFileNamePatterns;
    }

    public IWorkingSet[] getWorkingSets() {
        return this.fWorkingSets;
    }

    public IContentType[] getContentTypes() {
        return null;
    }

    public String getFilterDescription() {
        Object[] ext = this.fFileNamePatterns;
        if (ext == null) {
            return BasicElementLabels.getFilePattern("*");
        }
        Arrays.sort(ext);
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < ext.length) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append((String)ext[i]);
            ++i;
        }
        return BasicElementLabels.getFilePattern(buf.toString());
    }

    public boolean includeDerived() {
        return this.fVisitDerived;
    }

    @Override
    public IResource[] getRoots() {
        return this.fRootElements;
    }

    @Override
    public boolean contains(IResourceProxy proxy) {
        if (!this.fVisitDerived && proxy.isDerived()) {
            return false;
        }
        if (proxy.getType() == 1) {
            return this.matchesFileName(proxy.getName());
        }
        return true;
    }

    private boolean matchesFileName(String fileName) {
        if (this.fPositiveFileNameMatcher != null && !this.fPositiveFileNameMatcher.reset(fileName).matches()) {
            return false;
        }
        return this.fNegativeFileNameMatcher == null || !this.fNegativeFileNameMatcher.reset(fileName).matches();
    }

    private Matcher createMatcher(String[] fileNamePatterns, boolean negativeMatcher) {
        Object pattern;
        if (fileNamePatterns == null || fileNamePatterns.length == 0) {
            return null;
        }
        ArrayList<Object> patterns = new ArrayList<Object>();
        int i = 0;
        while (i < fileNamePatterns.length) {
            pattern = this.fFileNamePatterns[i];
            if (negativeMatcher == ((String)pattern).startsWith("!")) {
                if (negativeMatcher) {
                    pattern = ((String)pattern).substring("!".length()).trim();
                }
                if (((String)pattern).length() > 0) {
                    patterns.add(pattern);
                }
            }
            ++i;
        }
        if (!patterns.isEmpty()) {
            String[] patternArray = patterns.toArray(new String[patterns.size()]);
            pattern = PatternConstructor.createPattern(patternArray, IS_CASE_SENSITIVE_FILESYSTEM);
            return ((Pattern)pattern).matcher("");
        }
        return null;
    }

    private static IResource[] removeRedundantEntries(IResource[] elements, boolean includeDerived) {
        ArrayList<IResource> res = new ArrayList<IResource>();
        IResource[] iResourceArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IResource curr = iResourceArray[n2];
            FileTextSearchScope.addToList(res, curr, includeDerived);
            ++n2;
        }
        return res.toArray(new IResource[res.size()]);
    }

    private static IResource[] convertToResources(IWorkingSet[] workingSets, boolean includeDerived) {
        ArrayList<IResource> res = new ArrayList<IResource>();
        IWorkingSet[] iWorkingSetArray = workingSets;
        int n = workingSets.length;
        int n2 = 0;
        while (n2 < n) {
            IAdaptable[] elements;
            IWorkingSet workingSet = iWorkingSetArray[n2];
            if (workingSet.isAggregateWorkingSet() && workingSet.isEmpty()) {
                return new IResource[]{ResourcesPlugin.getWorkspace().getRoot()};
            }
            IAdaptable[] iAdaptableArray = elements = workingSet.getElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IAdaptable element = iAdaptableArray[n4];
                IResource curr = (IResource)element.getAdapter(IResource.class);
                if (curr != null) {
                    FileTextSearchScope.addToList(res, curr, includeDerived);
                }
                ++n4;
            }
            ++n2;
        }
        return res.toArray(new IResource[res.size()]);
    }

    private static void addToList(ArrayList<IResource> res, IResource curr, boolean includeDerived) {
        if (!includeDerived && curr.isDerived(512)) {
            return;
        }
        IPath currPath = curr.getFullPath();
        int k = res.size() - 1;
        while (k >= 0) {
            IResource other = res.get(k);
            IPath otherPath = other.getFullPath();
            if (otherPath.isPrefixOf(currPath)) {
                return;
            }
            if (currPath.isPrefixOf(otherPath)) {
                res.remove(k);
            }
            --k;
        }
        res.add(curr);
    }
}

