/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.correction.AbstractPDEMarkerResolution;
import org.eclipse.pde.internal.ui.correction.ResolutionGenerator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;
import org.eclipse.ui.texteditor.spelling.SpellingAnnotation;

public class PDEQuickAssistAssistant
extends QuickAssistAssistant {
    private Image fCreateImage;
    private Image fRenameImage;
    private Image fRemoveImage;

    public PDEQuickAssistAssistant() {
        this.setQuickAssistProcessor(new PDEQuickAssistProcessor());
        this.fCreateImage = PDEPluginImages.DESC_ADD_ATT.createImage();
        this.fRemoveImage = PDEPluginImages.DESC_DELETE.createImage();
        this.fRenameImage = PDEPluginImages.DESC_REFRESH.createImage();
        this.setInformationControlCreator((IInformationControlCreator)new AbstractReusableInformationControlCreator(){

            public IInformationControl doCreateInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true));
            }
        });
    }

    public void dispose() {
        this.fCreateImage.dispose();
        this.fRemoveImage.dispose();
        this.fRenameImage.dispose();
    }

    class PDECompletionProposal
    implements ICompletionProposal,
    ICompletionProposalExtension3,
    ICompletionProposalExtension4,
    Comparable<Object> {
        Position fPosition;
        IMarkerResolution fResolution;
        IMarker fMarker;

        public PDECompletionProposal(IMarkerResolution resolution, Position pos, IMarker marker) {
            this.fPosition = pos;
            this.fResolution = resolution;
            this.fMarker = marker;
        }

        public IMarkerResolution getResolution() {
            return this.fResolution;
        }

        public void apply(IDocument document) {
            this.fResolution.run(this.fMarker);
        }

        public Point getSelection(IDocument document) {
            return new Point(this.fPosition.offset, 0);
        }

        public String getAdditionalProposalInfo() {
            if (this.fResolution instanceof IMarkerResolution2) {
                return ((IMarkerResolution2)this.fResolution).getDescription();
            }
            return null;
        }

        public String getDisplayString() {
            return this.fResolution.getLabel();
        }

        public Image getImage() {
            if (this.fResolution instanceof AbstractPDEMarkerResolution) {
                switch (((AbstractPDEMarkerResolution)this.fResolution).getType()) {
                    case 1: {
                        return PDEQuickAssistAssistant.this.fCreateImage;
                    }
                    case 3: {
                        return PDEQuickAssistAssistant.this.fRemoveImage;
                    }
                    case 2: {
                        return PDEQuickAssistAssistant.this.fRenameImage;
                    }
                }
            }
            if (this.fResolution instanceof IMarkerResolution2) {
                IMarkerResolution2 resolution = (IMarkerResolution2)this.fResolution;
                return resolution.getImage();
            }
            return null;
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public IInformationControlCreator getInformationControlCreator() {
            return null;
        }

        public int getPrefixCompletionStart(IDocument document, int completionOffset) {
            return 0;
        }

        public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
            return null;
        }

        public boolean isAutoInsertable() {
            return true;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PDECompletionProposal)) {
                return false;
            }
            PDECompletionProposal proposal = (PDECompletionProposal)obj;
            return proposal.fPosition.equals((Object)this.fPosition) && proposal.fResolution.equals(this.fResolution);
        }

        public int hashCode() {
            return this.fPosition.hashCode() + this.fResolution.hashCode();
        }

        @Override
        public int compareTo(Object arg0) {
            if (!(arg0 instanceof PDECompletionProposal)) {
                return -1;
            }
            PDECompletionProposal obj = (PDECompletionProposal)arg0;
            if (this.getDisplayString() != null) {
                if (obj.getDisplayString() != null) {
                    return this.getDisplayString().compareTo(obj.getDisplayString());
                }
                return 0;
            }
            return -1;
        }
    }

    class PDEQuickAssistProcessor
    implements IQuickAssistProcessor {
        ResolutionGenerator fGenerator = new ResolutionGenerator();
        HashMap<IMarker, IMarkerResolution[]> fResMap = new HashMap();

        PDEQuickAssistProcessor() {
        }

        public String getErrorMessage() {
            return null;
        }

        public boolean canFix(Annotation annotation) {
            boolean bRetVal = false;
            if (annotation instanceof SimpleMarkerAnnotation) {
                IMarkerResolution[] contributedResolutions;
                IMarker marker = ((SimpleMarkerAnnotation)annotation).getMarker();
                IMarkerResolution[] localResolutions = this.fGenerator.getResolutions(marker);
                if (localResolutions.length > 0) {
                    bRetVal = true;
                }
                if (!bRetVal && (contributedResolutions = IDE.getMarkerHelpRegistry().getResolutions(marker)).length > 0) {
                    bRetVal = true;
                }
            }
            return bRetVal;
        }

        private void populateDataModelForAnnotation(SimpleMarkerAnnotation annotation) {
            IMarker marker = annotation.getMarker();
            if (!this.fResMap.containsKey(marker)) {
                ArrayList<IMarkerResolution> resolutions = new ArrayList<IMarkerResolution>(5);
                IMarkerResolution[] localResolutions = this.fGenerator.getResolutions(marker);
                resolutions.addAll(Arrays.asList(localResolutions));
                IMarkerResolution[] contributedResolutions = IDE.getMarkerHelpRegistry().getResolutions(marker);
                int i = 0;
                while (i < contributedResolutions.length) {
                    IMarkerResolution resolution = contributedResolutions[i];
                    if (!(resolution instanceof AbstractPDEMarkerResolution) && !resolutions.contains(contributedResolutions[i])) {
                        resolutions.add(contributedResolutions[i]);
                    }
                    ++i;
                }
                if (resolutions.size() > 0) {
                    this.fResMap.put(marker, resolutions.toArray(new IMarkerResolution[resolutions.size()]));
                }
            }
        }

        public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
            return false;
        }

        public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
            IAnnotationModel amodel = invocationContext.getSourceViewer().getAnnotationModel();
            IDocument doc = invocationContext.getSourceViewer().getDocument();
            int offset = invocationContext.getOffset();
            Iterator it = amodel.getAnnotationIterator();
            TreeSet<ICompletionProposal> proposalSet = new TreeSet<ICompletionProposal>((o1, o2) -> {
                if (o1 != null && o2 != null) {
                    return o1.getDisplayString().compareToIgnoreCase(o2.getDisplayString());
                }
                return 0;
            });
            while (it.hasNext()) {
                SimpleMarkerAnnotation annotation;
                Object key = it.next();
                if (!(key instanceof SimpleMarkerAnnotation)) {
                    ICompletionProposal[] proposals;
                    if (!(key instanceof SpellingAnnotation) || !amodel.getPosition((Annotation)(annotation = (SpellingAnnotation)key)).overlapsWith(offset, 1)) continue;
                    ICompletionProposal[] iCompletionProposalArray = proposals = annotation.getSpellingProblem().getProposals();
                    int n = proposals.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICompletionProposal proposal = iCompletionProposalArray[n2];
                        proposalSet.add(proposal);
                        ++n2;
                    }
                    continue;
                }
                annotation = (SimpleMarkerAnnotation)key;
                this.populateDataModelForAnnotation(annotation);
                IMarker marker = annotation.getMarker();
                IMarkerResolution[] mapping = this.fResMap.get(marker);
                if (mapping == null) continue;
                Position pos = amodel.getPosition((Annotation)annotation);
                try {
                    int line = doc.getLineOfOffset(pos.getOffset());
                    int start = pos.getOffset();
                    String delim = doc.getLineDelimiter(line);
                    int delimLength = delim != null ? delim.length() : 0;
                    int end = doc.getLineLength(line) + start - delimLength;
                    if (offset < start || offset > end) continue;
                    IMarkerResolution[] iMarkerResolutionArray = mapping;
                    int n = mapping.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IMarkerResolution markerResolution = iMarkerResolutionArray[n3];
                        PDECompletionProposal proposal = new PDECompletionProposal(markerResolution, pos, marker);
                        if (!proposalSet.contains(proposal)) {
                            proposalSet.add(proposal);
                        }
                        ++n3;
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
            ArrayList<ICompletionProposal> arrayListCompProNegativeRelevance = new ArrayList<ICompletionProposal>();
            for (ICompletionProposal prop : proposalSet) {
                int rel;
                IMarkerResolution res;
                if (!(prop instanceof PDECompletionProposal) || !((res = ((PDECompletionProposal)prop).getResolution()) instanceof IJavaCompletionProposal) || (rel = ((IJavaCompletionProposal)res).getRelevance()) >= 0) continue;
                arrayListCompProNegativeRelevance.add(prop);
            }
            proposalSet.removeAll(arrayListCompProNegativeRelevance);
            ArrayList<ICompletionProposal> finalProposal = new ArrayList<ICompletionProposal>();
            finalProposal.addAll(proposalSet);
            finalProposal.addAll(arrayListCompProNegativeRelevance);
            return finalProposal.toArray(new ICompletionProposal[0]);
        }
    }
}

