/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.tools;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.tools.ConvertPreferencesWizardPage;
import org.eclipse.swt.widgets.Shell;

public class ConvertPreferencesWizard
extends Wizard {
    private ConvertPreferencesWizardPage page;
    private String fPreferencesFilePath;
    private String fPluginCustomizeFilePath;
    private boolean fOverwrite;

    public ConvertPreferencesWizard(String pluginCustomizationFilePath, String preferencesFilePath, boolean overwrite) {
        this.fPreferencesFilePath = preferencesFilePath;
        this.fPluginCustomizeFilePath = pluginCustomizationFilePath;
        this.fOverwrite = overwrite;
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_PRODUCT_WIZ);
        this.setWindowTitle(PDEUIMessages.ConvertPreferencesWizard_title);
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        this.fPluginCustomizeFilePath = this.page.getPluginCustomizeFile().getFullPath().toString();
        File preferencesFile = this.page.getPreferencesFile();
        if (preferencesFile == null) {
            return false;
        }
        this.fPreferencesFilePath = preferencesFile.getAbsolutePath();
        this.fOverwrite = this.page.getOverwrite();
        try {
            this.getContainer().run(false, false, this.getGenerateOperation());
        }
        catch (InvocationTargetException e) {
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)PDEUIMessages.ConvertPreferencesWizard_errorTitle, (String)e.getTargetException().getMessage());
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public void addPages() {
        this.page = new ConvertPreferencesWizardPage(this.fPluginCustomizeFilePath, this.fPreferencesFilePath, this.fOverwrite);
        this.addPage((IWizardPage)this.page);
    }

    private IRunnableWithProgress getGenerateOperation() {
        return monitor -> {
            block36: {
                monitor.beginTask(PDEUIMessages.ConvertPreferencesWizard_progress, 100);
                File prefsFile = this.page.getPreferencesFile();
                if (prefsFile != null) {
                    String sourceFilePath;
                    String errorFilePath = sourceFilePath = prefsFile.getAbsolutePath();
                    if (prefsFile.exists()) {
                        try {
                            try {
                                BufferedReader in = new BufferedReader(new FileReader(sourceFilePath));
                                LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
                                HashMap<String, String> mapKeyCommentPreference = new HashMap<String, String>();
                                try {
                                    String line1;
                                    String comment = null;
                                    while ((line1 = in.readLine()) != null) {
                                        int keyIndex;
                                        int index1;
                                        if (line1.startsWith("#")) {
                                            comment = comment == null ? line1 : comment.concat(line1);
                                            comment = comment.concat(System.lineSeparator());
                                            continue;
                                        }
                                        if (line1.equals("")) {
                                            comment = comment != null ? comment.concat(System.lineSeparator()) : "".concat(System.lineSeparator());
                                            continue;
                                        }
                                        if (line1.length() <= 0 || line1.charAt(0) != '/' || (index1 = line1.indexOf(47, 1)) <= -1 || (keyIndex = line1.indexOf(61, index1)) <= index1 + 1) continue;
                                        String key1 = line1.substring(index1 + 1, keyIndex).trim();
                                        String value1 = line1.substring(keyIndex + 1).trim();
                                        properties.put(key1, value1);
                                        mapKeyCommentPreference.put(key1, comment);
                                        comment = null;
                                    }
                                }
                                finally {
                                    in.close();
                                }
                                monitor.worked(50);
                                if (properties.size() > 0) {
                                    IFile customizationFile = this.page.getPluginCustomizeFile();
                                    errorFilePath = customizationFile.getFullPath().toString();
                                    if (!customizationFile.exists()) {
                                        byte[] bytes = "".getBytes();
                                        ByteArrayInputStream source = new ByteArrayInputStream(bytes);
                                        customizationFile.create((InputStream)source, 0, null);
                                    }
                                    StringBuilder out = new StringBuilder();
                                    if (!this.fOverwrite) {
                                        try (BufferedReader existingFile = new BufferedReader(new InputStreamReader(customizationFile.getContents()));){
                                            String line;
                                            String comment = null;
                                            while ((line = existingFile.readLine()) != null) {
                                                if (line.startsWith("#")) {
                                                    comment = comment == null ? line : comment.concat(line);
                                                    comment = comment.concat(System.lineSeparator());
                                                    continue;
                                                }
                                                if (line.equals("")) {
                                                    comment = comment != null ? comment.concat(System.lineSeparator()) : "".concat(System.lineSeparator());
                                                    continue;
                                                }
                                                int index = line.indexOf(61);
                                                if (index > 1) {
                                                    String key = line.substring(0, index).trim();
                                                    if (!properties.containsKey(key)) {
                                                        if (comment != null) {
                                                            out.append(comment);
                                                        }
                                                        out.append(line);
                                                        out.append('\n');
                                                        comment = null;
                                                        continue;
                                                    }
                                                    if (comment != null) {
                                                        out.append(comment);
                                                    }
                                                    String comment2 = null;
                                                    comment2 = (String)mapKeyCommentPreference.get(key);
                                                    if (comment2 != null) {
                                                        out.append(comment2);
                                                    }
                                                    Object value = properties.get(key);
                                                    out.append(String.valueOf(key) + "=" + value);
                                                    out.append('\n');
                                                    properties.remove(key);
                                                    comment = null;
                                                    continue;
                                                }
                                                PDEPlugin.log(NLS.bind((String)PDEUIMessages.ConvertPreferencesWizard_skippedInvalidLine, (Object)this.fPreferencesFilePath));
                                                PDEPlugin.log("    " + line);
                                            }
                                        }
                                    }
                                    monitor.worked(20);
                                    for (Map.Entry entry : properties.entrySet()) {
                                        String key = (String)entry.getKey();
                                        String comment = null;
                                        comment = (String)mapKeyCommentPreference.get(key);
                                        if (comment != null) {
                                            out.append(comment);
                                        }
                                        String value = (String)entry.getValue();
                                        out.append(String.valueOf(key) + "=" + value);
                                        out.append('\n');
                                    }
                                    ByteArrayInputStream resultStream = new ByteArrayInputStream(out.toString().getBytes());
                                    customizationFile.setContents((InputStream)resultStream, true, true, null);
                                    monitor.worked(30);
                                    break block36;
                                }
                                this.page.setMessage(PDEUIMessages.ConvertPreferencesWizard_errorNoPrefs, 2);
                                break block36;
                            }
                            catch (FileNotFoundException e1) {
                                this.page.setErrorMessage(NLS.bind((String)PDEUIMessages.ConvertPreferencesWizard_errorFile, (Object)errorFilePath));
                                PDEPlugin.logException(e1);
                                monitor.done();
                                return;
                            }
                            catch (CoreException e2) {
                                this.page.setErrorMessage(NLS.bind((String)PDEUIMessages.ConvertPreferencesWizard_errorFile, (Object)errorFilePath));
                                PDEPlugin.logException(e2);
                                monitor.done();
                                return;
                            }
                            catch (IOException e3) {
                                this.page.setErrorMessage(NLS.bind((String)PDEUIMessages.ConvertPreferencesWizard_errorFile, (Object)errorFilePath));
                                PDEPlugin.logException(e3);
                                {
                                    catch (Throwable throwable) {
                                        throw throwable;
                                    }
                                }
                                monitor.done();
                                return;
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                    this.page.setErrorMessage(PDEUIMessages.ConvertPreferencesWizard_errorFileNotFound);
                } else {
                    this.page.setErrorMessage(PDEUIMessages.ConvertPreferencesWizard_errorNoFileSpecified);
                }
            }
        };
    }

    public String getPreferencesFilePath() {
        return this.fPreferencesFilePath;
    }

    public String getPluginCustomizationFilePath() {
        return this.fPluginCustomizeFilePath;
    }

    public boolean getOverwrite() {
        return this.fOverwrite;
    }
}

